#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include "station_info_callback.h"
#include "station_info.h"
#include "support.h"
#include "global.h"


gboolean
on_station_info_window_delete_event    (GtkWidget       *widget,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
gtk_widget_destroy(station_info_window);
	gtk_widget_set_sensitive(station_info,TRUE);
  return TRUE;
}


void
on_cancel_station_info_clicked         (GtkButton       *button,
                                        gpointer         user_data)
{
	gtk_widget_destroy(station_info_window);
	gtk_widget_set_sensitive(station_info,TRUE);

}


void
on_save_station_info_clicked           (GtkButton       *button,
                                        gpointer         user_data)
{
	gchar *call_,*country_,*state_,*grid_,*county_,*latitude_,*longitude_;
	
	GtkWidget* call = lookup_widget(GTK_WIDGET(button),"call");
	GtkWidget* country = lookup_widget(GTK_WIDGET(button),"country");
	GtkWidget* state = lookup_widget(GTK_WIDGET(button),"state");
	GtkWidget* grid = lookup_widget(GTK_WIDGET(button),"grid");
	GtkWidget* county = lookup_widget(GTK_WIDGET(button),"county");
	GtkWidget* latitude = lookup_widget(GTK_WIDGET(button),"latitude");
	GtkWidget* longitude = lookup_widget(GTK_WIDGET(button),"longitude");
	
//	printf("Saving station info...\n");
	call_ = gtk_entry_get_text(GTK_ENTRY(call));
	country_ = gtk_entry_get_text(GTK_ENTRY(country));
	state_ = gtk_entry_get_text(GTK_ENTRY(state));
	grid_ = gtk_entry_get_text(GTK_ENTRY(grid));
	county_ = gtk_entry_get_text(GTK_ENTRY(county));
	latitude_ = gtk_entry_get_text(GTK_ENTRY(latitude));
	longitude_ = gtk_entry_get_text(GTK_ENTRY(longitude));
	
	call_ = uppercase(call_);
	state_ = uppercase(state_);
	grid_ = uppercase(grid_);	
	
		
	//printf("Call: %s\n%s\n%s\n%s\n%s\n%s\n%s\n",call,country,state,grid,county,latitude, longitude);
	
	xwota_settings.call = g_strdup(call_);
	xwota_settings.country = g_strdup(country_);
	xwota_settings.state = g_strdup(state_);
	xwota_settings.grid = g_strdup(grid_);
	xwota_settings.county = g_strdup(county_);
	xwota_settings.latitude = g_strdup(latitude_);
	xwota_settings.longitude = g_strdup(longitude_);
		
	save_preferences();
	
	gtk_widget_destroy(station_info_window);
	gtk_widget_set_sensitive(station_info,TRUE);

}
