/* $Id: test_hd.c 1591 2006-07-13 03:25:38Z peter $
 *
 * Simple hexidecimal dump, two hex digits per line.
 *
 *  Copyright (C) 2004  Peter Johnson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND OTHER CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR OTHER CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */
#include <stdio.h>
#include <stdlib.h>

int
main(int argc, char *argv[])
{
    FILE *bfile;
    int ch;

    if (argc != 2) {
	fprintf(stderr, "Usage: %s <file>\n", argv[0]);
	return EXIT_FAILURE;
    }

    bfile = fopen(argv[1], "rb");

    if (!bfile) {
	fprintf(stderr, "Could not open `%s'.\n", argv[1]);
	return EXIT_FAILURE;
    }

    while ((ch = fgetc(bfile)) != EOF)
	printf("%02x \n", ch);

    if (ferror(bfile)) {
	fprintf(stderr, "Error reading from `%s'.\n", argv[1]);
	return EXIT_FAILURE;
    }

    fclose(bfile);
    return EXIT_SUCCESS;
}
