/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import IceGridGUI.LiveDeployment.Editor;
import IceGridGUI.LiveDeployment.Root;
import IceGridGUI.LiveDeployment.TableField;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

class RegistryEditor
extends Editor {
    private TableField _objects = new TableField("Proxy", "Type");
    private TableField _adapters = new TableField("ID", "Endpoints", "Replica Group");
    private Root _target;

    RegistryEditor() {
        AbstractAction deleteObject = new AbstractAction("Remove selected object"){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._objects.getSelectedRow();
                if (selectedRow != -1) {
                    RegistryEditor.this._target.removeObject((String)RegistryEditor.this._objects.getValueAt(selectedRow, 0));
                }
            }
        };
        this._objects.getActionMap().put("delete", deleteObject);
        this._objects.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        AbstractAction addObject = new AbstractAction("Add a new well-known object"){

            public void actionPerformed(ActionEvent e) {
                RegistryEditor.this._target.addObject();
            }
        };
        this._objects.getActionMap().put("insert", addObject);
        this._objects.getInputMap().put(KeyStroke.getKeyStroke("INSERT"), "insert");
        this._objects.setToolTipText("<html>Well-known objects registered through the Admin interface.<br>Well-known objects registered using Adapter or Replica Group<br>definitions are not displayed here.</html>");
        AbstractAction deleteAdapter = new AbstractAction("Remove selected adapter"){

            public void actionPerformed(ActionEvent e) {
                int selectedRow = RegistryEditor.this._adapters.getSelectedRow();
                if (selectedRow != -1) {
                    RegistryEditor.this._target.removeAdapter((String)RegistryEditor.this._adapters.getValueAt(selectedRow, 0));
                }
            }
        };
        this._adapters.getActionMap().put("delete", deleteAdapter);
        this._adapters.getInputMap().put(KeyStroke.getKeyStroke("DELETE"), "delete");
        this._adapters.setToolTipText("<html>Object adapters registered at run time.</html>");
    }

    protected void appendProperties(DefaultFormBuilder builder) {
        CellConstraints cc = new CellConstraints();
        builder.appendSeparator("Dynamic Well-Known Objects");
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-14);
        JScrollPane scrollPane = new JScrollPane(this._objects);
        scrollPane.setToolTipText(this._objects.getToolTipText());
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 14));
        builder.nextRow(14);
        builder.nextLine();
        builder.appendSeparator("Dynamic Object Adapters");
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextLine();
        builder.append("");
        builder.nextRow(-14);
        scrollPane = new JScrollPane(this._adapters);
        scrollPane.setToolTipText(this._adapters.getToolTipText());
        builder.add(scrollPane, cc.xywh(builder.getColumn(), builder.getRow(), 3, 14));
        builder.nextRow(14);
        builder.nextLine();
    }

    protected void buildPropertiesPanel() {
        super.buildPropertiesPanel();
        this._propertiesPanel.setName("Registry Properties");
    }

    void show(Root root) {
        this._target = root;
        this._objects.setObjects(root.getObjects());
        this._adapters.setAdapters(root.getAdapters());
    }
}

