/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.forms.builder;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.FormFactory;
import com.jgoodies.forms.layout.ColumnSpec;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import com.jgoodies.forms.util.LayoutStyle;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public final class ButtonBarBuilder
extends PanelBuilder {
    private static final ColumnSpec[] COL_SPECS = new ColumnSpec[0];
    private static final RowSpec[] ROW_SPECS = new RowSpec[]{new RowSpec("center:pref")};
    private boolean leftToRight = LayoutStyle.getCurrent().isLeftToRightButtonOrder();

    public ButtonBarBuilder() {
        this(new JPanel(null));
    }

    public ButtonBarBuilder(JPanel panel) {
        super(new FormLayout(COL_SPECS, ROW_SPECS), panel);
    }

    public void setLeftToRightButtonOrder(boolean newButtonOrder) {
        this.leftToRight = newButtonOrder;
    }

    public void addGriddedButtons(JButton[] buttons) {
        int length = buttons.length;
        for (int i = 0; i < length; ++i) {
            int index = this.leftToRight ? i : length - 1 - i;
            this.addGridded(buttons[index]);
            if (i >= buttons.length - 1) continue;
            this.addRelatedGap();
        }
    }

    public void addGridded(JComponent component) {
        this.getLayout().appendColumn(FormFactory.BUTTON_COLSPEC);
        this.getLayout().addGroupedColumn(this.getColumn());
        component.putClientProperty("jgoodies.isNarrow", Boolean.TRUE);
        this.add(component);
        this.nextColumn();
    }

    public void addGlue() {
        this.appendGlueColumn();
        this.nextColumn();
    }

    public void addRelatedGap() {
        this.appendRelatedComponentsGapColumn();
        this.nextColumn();
    }
}

