/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.FileException;
import Ice.StringSeqHolder;
import IceUtil.StringUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Properties {
    private Hashtable _properties = new Hashtable();

    public synchronized String getProperty(String string) {
        String string2 = (String)this._properties.get(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return string2;
    }

    public synchronized String getPropertyWithDefault(String string, String string2) {
        String string3 = (String)this._properties.get(string);
        if (string3 == null) {
            string3 = System.getProperty(string);
        }
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public int getPropertyAsInt(String string) {
        return this.getPropertyAsIntWithDefault(string, 0);
    }

    public synchronized int getPropertyAsIntWithDefault(String string, int n) {
        String string2 = (String)this._properties.get(string);
        if (string2 == null) {
            string2 = System.getProperty(string);
        }
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public synchronized Hashtable getPropertiesForPrefix(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this._properties.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = (String)this._properties.get(string2);
            if (string.length() != 0 && !string2.startsWith(string)) continue;
            hashtable.put(string2, string3);
        }
        return hashtable;
    }

    public synchronized String[] getCommandLineOptions() {
        String[] stringArray = new String[this._properties.size()];
        Enumeration enumeration = this._properties.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = this._properties.get(k);
            stringArray[n++] = "--" + k + "=" + v;
        }
        return stringArray;
    }

    public synchronized String[] parseCommandLineOptions(String string, String[] stringArray) {
        String string2 = string;
        if (string.length() > 0 && string.charAt(string.length() - 1) != '.') {
            string = string + '.';
        }
        string = "--" + string;
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string3 = stringArray[i];
            if (string3.startsWith(string)) {
                if (string3.indexOf(61) == -1) {
                    string3 = string3 + "=1";
                }
                this.parseLine(string3.substring(2));
                continue;
            }
            vector.addElement(string3);
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public synchronized String[] parseIceCommandLineOptions(String[] stringArray) {
        return this.parseCommandLineOptions("Ice", stringArray);
    }

    public synchronized Properties _clone() {
        return new Properties(this);
    }

    Properties(Properties properties) {
        Enumeration enumeration = properties._properties.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Object v = properties._properties.get(k);
            this._properties.put(k, v);
        }
    }

    Properties() {
        this.loadConfig();
    }

    Properties(StringSeqHolder stringSeqHolder) {
        for (int i = 0; i < stringSeqHolder.value.length; ++i) {
            if (!stringSeqHolder.value[i].startsWith("--Ice.Config")) continue;
            String string = stringSeqHolder.value[i];
            if (string.indexOf(61) == -1) {
                string = string + "=1";
            }
            this.parseLine(string.substring(2));
            String[] stringArray = new String[stringSeqHolder.value.length - 1];
            System.arraycopy(stringSeqHolder.value, 0, stringArray, 0, i);
            if (i < stringSeqHolder.value.length - 1) {
                System.arraycopy(stringSeqHolder.value, i + 1, stringArray, i, stringSeqHolder.value.length - i - 1);
            }
            stringSeqHolder.value = stringArray;
        }
        this.loadConfig();
        stringSeqHolder.value = this.parseIceCommandLineOptions(stringSeqHolder.value);
    }

    public synchronized void setProperty(String string, String string2) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (string2 != null && string2.length() > 0) {
            this._properties.put(string, string2);
        } else {
            this._properties.remove(string);
        }
    }

    private void parseLine(String string) {
        String string2 = string;
        int n = string2.indexOf(35);
        if (n == 0) {
            return;
        }
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        string2 = string2.trim();
        char[] cArray = string2.toCharArray();
        int n2 = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != ' ' && cArray[i] != '\t' && cArray[i] != '\r' && cArray[i] != '\n' && cArray[i] != '=') continue;
            n2 = i;
            break;
        }
        if (n2 == -1) {
            return;
        }
        String string3 = string2.substring(0, n2);
        if ((n2 = string2.indexOf(61, n2)) == -1) {
            return;
        }
        String string4 = "";
        if (++n2 < string2.length()) {
            string4 = string2.substring(n2).trim();
        }
        this.setProperty(string3, string4);
    }

    private void loadConfig() {
        String string = this.getProperty("Ice.Config");
        if (string.equals("1")) {
            string = "";
        }
        if (string.length() > 0) {
            String[] stringArray = StringUtil.split(string, ",");
            for (int i = 0; i < stringArray.length; ++i) {
                this.load(stringArray[i]);
            }
        }
        this.setProperty("Ice.Config", string);
    }

    public synchronized void load(String string) {
        try {
            String string2;
            FileReader fileReader = new FileReader(string);
            BufferedReader bufferedReader = new BufferedReader(fileReader);
            while ((string2 = bufferedReader.readLine()) != null) {
                this.parseLine(string2);
            }
        }
        catch (IOException iOException) {
            FileException fileException = new FileException();
            fileException.path = string;
            fileException.initCause(iOException);
            throw fileException;
        }
    }

    public synchronized void load(InputStream inputStream) {
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            while ((string = bufferedReader.readLine()) != null) {
                this.parseLine(string);
            }
        }
        catch (IOException iOException) {
            FileException fileException = new FileException();
            fileException.path = inputStream.toString();
            fileException.initCause(iOException);
            throw fileException;
        }
    }

    public Object ice_clone() {
        return new Properties(this);
    }
}

