dnl -*- Mode: autoconf; -*-

UNIX_AUDIO_API="undefined"

AC_DEFUN(AC_ZINF_OS, [
  os_cflags=""
  os_ldflags=""
  os_libs=""
  case "$host_os" in
    windowsnt|win32*)
      ZINF_OS="win32"
      AC_DEFINE(ZINF_OS_WIN32, 1, [On Win32])
      ;;
    *-pc-cygwin)
      ZINF_OS="cygwin"
      AC_DEFINE(ZINF_OS_CYGWIN, 1, [On CygWin])
      ;;
    freebsd*)
      ZINF_OS="freebsd";
      AC_DEFINE(ZINF_OS_BSD, 1, [On the BSDs])
      os_cflags="--D_THREAD_SAFE -pthread -I/usr/local/include";
      os_ldflags="-Wl,-export-dynamic -L/usr/local/lib";
      ;;
    netbsd*)
      ZINF_OS="freebsd";
      AC_DEFINE(ZINF_OS_BSD, 1, [On the BSDs])
      os_cflags="-I/usr/pkg/include -D_THREAD_SAFE -pthread";
      os_ldflags=" -L/usr/pkg/lib -Wl,-export-dynamic";
      ;;
    irix*)
      ZINF_OS="irix"
      AC_DEFINE(ZINF_OS_IRIX, 1, [On IRIX])
      AC_DEFINE(IRIX_CDAUDIO, 1, [Use IRIX cdaudio interface])
      os_cflags="-fsquangle"
      ;;
    linux*)
      ZINF_OS="linux"
      UNIX_AUDIO_API="linux"
      AC_DEFINE(ZINF_OS_LINUX, 1, [On Linux])
      AC_DEFINE(HAVE_LINUX, 1, [Defined on Linux])
      ;;
    *qnx*)
      ZINF_OS="qnx"
      AC_DEFINE(ZINF_OS_QNX, 1, [On QNX])
      AC_DEFINE(QNX, 1, [Defined on QNX])
      CFLAGS="-Wall -O2 -gdwarf-2 -I/usr/local/include"
      os_ldflags="-Wl,-export-dynamic -L/usr/local/lib"
      os_libs="-lsocket -lasound"
      UNIX_AUDIO_API="qnx"
      ;;
    solaris*)
      AC_DEFINE(ZINF_OS_SOLARIS, 1, [On Solaris])
      AC_DEFINE(SOLARIS_GETMNTENT, 1, [Use Solaris getmntent interface])
      AC_DEFINE(BROKEN_SOLARIS_LEADOUT, 1, 
		[Work around broken leadout on Solaris])
      ZINF_OS="solaris"
      os_libs="-lsocket -lnsl"
      if test "$GCC" = yes; then
        os_cflags="-fpermissive" # XXX: do we really need that?
      fi	
      UNIX_AUDIO_API="solaris"
      ;;
    *)
      AC_MSG_ERROR([unknown platform $host_os])
      ;;
  esac

  AM_CONDITIONAL(ZINF_OS_WIN32, test "$ZINF_OS" = "win32")
  AM_CONDITIONAL(ZINF_OS_UNIX, test "$ZINF_OS" != "win32")
])

ifelse(dnl	Do not change this comment
   arch-tag: 18e0f5f8-7283-4213-b787-4bf527921aa2
)dnl
