#include <gtkmm/toolbar.h>
#include <gtkmm/image.h>
#include <gtkmm/stock.h>

using namespace std;
#include "gtktoolbar.h"
#include "gtkmusicbrowser.h"

GTKToolbar::GTKToolbar(GTKBrowserMusic *musicbrowser)
{
	m_musicbrowser = musicbrowser;
	setting_toggle = false;
	CreateButtons();
}

void GTKToolbar::CreateButtons()
{
	//Add Toolbar Buttons
	Gtk::Image *TempImage;
	Gtk::Toolbar_Helpers::ToolList& Toolbar = tools();
	
	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::NEW, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::NewPlaylist), "Create new playlist") );	
	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::OPEN, SigC::bind<std::string>(SigC::slot(*m_musicbrowser, &GTKBrowserMusic::OpenPlaylist), "") , "Open existing playlist") );
	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::SAVE, SigC::slot(*this, &GTKToolbar::on_toolbar_save), "Save playlist") );

	Toolbar.push_back( Gtk::Toolbar_Helpers::Space() );

	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::ADD, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::AddFromLibrary), "Add selected file(s) from library to playlist") );
	TempImage = Gtk::manage( new Gtk::Image(m_musicbrowser->m_add_track_pic) );
	Toolbar.push_back( Gtk::Toolbar_Helpers::ButtonElem("Add File", *TempImage, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::AddFiles), "Add external file(s) to playlist...") );
	TempImage = Gtk::manage( new Gtk::Image(m_musicbrowser->m_edit_pic) );
	Toolbar.push_back( Gtk::Toolbar_Helpers::ButtonElem("Edit Track", *TempImage, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::EditTrack), "Edit the currently selected track(s)") );
	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::REMOVE, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::RemoveFromPlaylist), "Remove selected track(s) from playlist") );
	Toolbar.push_back( Gtk::Toolbar_Helpers::StockElem(Gtk::Stock::CLEAR, SigC::bind<int>(SigC::slot(*m_musicbrowser, &GTKBrowserMusic::ClearPlaylist), -1), "Clear playlist") );
	
	Toolbar.push_back( Gtk::Toolbar_Helpers::Space() );
	
	TempImage = Gtk::manage( new Gtk::Image(m_musicbrowser->m_import_files_pic) );
	Toolbar.push_back( Gtk::Toolbar_Helpers::ButtonElem("Import Files", *TempImage, SigC::slot(*m_musicbrowser, &GTKBrowserMusic::ImportFiles), "Import files into the music library") );
	TempImage = Gtk::manage( new Gtk::Image(m_musicbrowser->m_catalog_pic) );
	Toolbar.push_back( Gtk::Toolbar_Helpers::ToggleElem("Show Library", *TempImage, SigC::slot(*this, &GTKToolbar::on_toolbar_toggle_library), "Toggle display of music library") );
	toolbar_toggle_library = (Gtk::ToggleButton *)Toolbar.back().get_widget();
	toolbar_toggle_library_label = Toolbar.back().get_label();
}

void GTKToolbar::set_layout(MusicLayout *layout)
{
	//Store Layout
	m_layout = layout;
	
	//Set Style
	set_toolbar_style(m_layout->get_toolbar_style());
	
	//Set State Of Toggle Library
	setting_toggle = true;
	if(m_layout->get_library_displayed()) {
		toolbar_toggle_library->set_active(true);
		//Set Button Text
		toolbar_toggle_library_label->set_text("Hide Library");
	} else {
		toolbar_toggle_library->set_active(false);
		//Set Button Text
		toolbar_toggle_library_label->set_text("Show Library");
	}
	setting_toggle = false;
}

void GTKToolbar::on_toolbar_save()
{
	//Has To Many Default Arguments To Be Used As Signal Handler
	m_musicbrowser->SavePlaylist();
}

void GTKToolbar::on_toolbar_toggle_library()
{
	if(!setting_toggle) {
		//Change Layout Based On Button State
		if(toolbar_toggle_library->get_active()) {
			m_layout->set_library_displayed(true);
			toolbar_toggle_library_label->set_text("Hide Library");
		} else {
			m_layout->set_library_displayed(false);
			toolbar_toggle_library_label->set_text("Show Library");
		}
		
		//Change View
		m_layout->change_layout();
	}
}
/* arch-tag: b16799eb-94bb-486e-b137-cec1b51f7730 */
