#
# Runs all tests in the current directory
#
# Execute like:
#   python runalltests.py
#
# Alternatively use the testrunner:
#   python /path/to/Zope/utilities/testrunner.py -qa
#

import os, sys
from warnings import warn 



        
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

import unittest
TestRunner = unittest.TextTestRunner


suite = unittest.TestSuite()

tests = os.listdir(os.curdir)
tests = [n[:-3] for n in tests if n.startswith('test') and n.endswith('.py')]

for test in tests:
    m = __import__(test)
    if hasattr(m, 'test_suite'):
        suite.addTest(m.test_suite())

if __name__ == '__main__':
    TestRunner().run(suite)
    """
    import profile
    profile.run('TestRunner().run(suite)','profiler')
    import pstats
    p = pstats.Stats('profiler')
    p.sort_stats('cum').print_stats(30)
    
    p2 = pstats.Stats('profiler')
    p2.sort_stats('tim').print_stats(30)
    """
