"""
 Install by adding an external method which calls 'purgePhotoCache'
 Manually purge the photo cache.

 Useful if you are playing around with dispaly size settings.

"""

from Products.CMFCore.utils import getToolByName
from cStringIO import StringIO 

def getAllPhotos(self):
    catalog = getToolByName(self, 'portal_catalog')
    results = catalog(Type = 'Photo')
    results = [r.getObject() for r in results]
    return results

def purgePhotoCache(self):
    """ To be called by an External Method"""
    out = StringIO() 
    for photo in getAllPhotos(self):
        print >> out, "deleting %s's photo cache" % photo.title_or_id()
        photo.clearCache()
    
    print >> out, "Photo Cache Purged"
    return out.getvalue() 
