# (C) Copyright 2005 Nuxeo SARL <http://nuxeo.com>
# Authors:
# Benoit Delbosc <ben@nuxeo.com>
# M.-A. Darche <madarche@nuxeo.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2 as published
# by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
# 02111-1307, USA.
#
# $Id: vocabularies.py 28980 2005-11-04 15:15:37Z madarche $
"""CPSDefault custom vocabularies."""

search_review_state_voc = {
    'type': 'CPS Method Vocabulary',
    'data': {'get_vocabulary_method': 'getVocabularySearchReviewState'
             },
    }

search_portal_type_voc = {
    'type': 'CPS Method Vocabulary',
    'data': {'get_vocabulary_method': 'getVocabularySearchPortalType'
             },
    }

accesskeys_voc = {
    'type': 'CPS Vocabulary',
    'data': {'tuples':
             (('0', '/accessibility', 'label_accesskey_accessibility_information'),
              ('1', '/', 'label_accesskey_homepage'),
              ('2', '#content', 'label_accesskey_content'),
              ('3', '#menu', 'label_accesskey_sitemap'),
              ('4', '/advanced_search_form', 'label_accesskey_search'),
              ('7', '/', 'label_accesskey_contact'),
              )
             },
    }


def getVocabularies():
    vocabularies = {
        'search_review_state': search_review_state_voc,
        'search_portal_type': search_portal_type_voc,
        'accesskeys': accesskeys_voc,
        }
    return vocabularies
