##parameters=items=[], sort_by='title', direction=None, hide_folder=0, displayed=['']
# $Id: filterContents.py 9590 2004-09-08 23:41:22Z janguenot $
"""
Filter and sort items (proxy)
"""
mtool = context.portal_membership
wtool = context.portal_workflow
ttool = context.portal_types


# filtering
filtered_items = []
now = context.ZopeTime()
display_cache = {}
all_portal_types = ttool.objectIds()

for item in items:
    if item.getId().startswith('.'):
        continue
    if not mtool.checkPermission('View', item):
        continue

    # Using a cache to optimize the retrieval of the
    # 'cps_display_as_document_in_listing' attribute.
    portal_type = getattr(item, 'portal_type', None)
    if portal_type in all_portal_types:
        if display_cache.has_key(portal_type):
            display_as_document_in_listing = display_cache[portal_type]
        else:
            display_as_document_in_listing = getattr(ttool[portal_type],
                                                     'cps_display_as_document_in_listing',
                                                     None)
            display_cache[portal_type] = display_as_document_in_listing
    else:
        display_as_document_in_listing = 0

    if hide_folder and (item.isPrincipiaFolderish and not display_as_document_in_listing):
       continue

    if displayed != [''] and item.portal_type not in displayed:
        continue
    review_state = wtool.getInfoFor(item, 'review_state', 'nostate')
    if review_state == 'published':
        if not mtool.checkPermission('Review portal content', item):
            doc = item.getContent()
            if now < doc.effective() or now > doc.expires():
                continue

    filtered_items.append(item)

# sorting
# XXX hardcoded status !
status_sort_order = {'nostate':'0',
                     'pending':'1',
                     'published':'2',
                     'work':'3',
                     }

# XXX these methods should return a tuple and not some half-baked string.
def id_sortkey(a):
    return a.getId()

def status_sortkey(a):
    return status_sort_order.get(wtool.getInfoFor(a, 'review_state', 'nostate'),
                                 '9') + a.title_or_id().lower()

def title_sortkey(a):
    return a.title_or_id().lower()

def date_sortkey(a):
    return str(a.modified()) + \
           a.getId()

def author_sortkey(a):
    author = a.Creator()
    if same_type(author, ''):
        return author + a.getId()
    return a.getId()

def cmp_desc(x, y):
    return -cmp(x, y)

make_sortkey = id_sortkey
if sort_by == 'status':
    make_sortkey = status_sortkey
elif sort_by == 'date':
    make_sortkey = date_sortkey
elif sort_by == 'title':
    make_sortkey = title_sortkey
elif sort_by == 'author':
    make_sortkey = author_sortkey

objects = [ ( make_sortkey(x), x ) for x in filtered_items ]

if direction == 'desc':
    # XXX Using a sort method is slow, better reverse at the end.
    objects.sort(cmp_desc)
elif direction == 'asc':
    objects.sort() # tuples compare "lexicographically"
else:
    pass

filtered_items = [ x[1] for x in objects ]

return filtered_items
