content_portlet_layout = {
    'widgets': {
        'link_string': {
            'type': 'String Widget',
            'data': {
                'fields': ('link_string',),
                'label_edit': 'cpsportlets_common_link_string_label',
                'is_i18n': True,
                'hidden_if_expr': 'context/render_method',
                'hidden_layout_modes': ('view',),
                'display_width': 36,
            },
        },
        'query_title': {
            'type': 'String Widget',
            'data': {
                'fields': ('query_title',),
                'label_edit': 'cpsportlets_content_query_title_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'display_width': 36,
            },
        },
        'folder_path': {
            'type': 'String Widget',
            'data': {
                'fields': ('folder_path',),
                'label_edit': 'cpsportlets_content_folder_path_label',
                'is_i18n': True,
                'hidden_if_expr': 'context/contextual',
                'hidden_layout_modes': ('view',),
                'display_width': 36,
            },
        },
        'sort_on': {
            'type': 'Select Widget',
            'data': {
                'fields': ('sort_on',),
                'label_edit': 'cpsportlets_content_sort_on_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'hidden_if_expr': "python: context.search_type in ['last_modified', 'upcoming']",
                'vocabulary': 'cpsportlets_content_sort_on_voc',
                'translated': True,
            },
        },
        'max_items': {
            'type': 'Int Widget',
            'data': {
                'fields': ('max_items',),
                'label_edit': 'cpsportlets_common_max_items_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'is_limited': True,
                'min_value': 1,
                'max_value': 20,
            },
        },
        'search_type': {
            'type': 'Select Widget',
            'data': {
                'fields': ('search_type',),
                'label_edit': 'cpsportlets_content_search_type_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'vocabulary': 'cpsportlets_content_search_voc',
                'translated': True,
            },
        },
        'render_items': {
            'type': 'Boolean Widget',
            'data': {
                'fields': ('render_items',),
                'label_edit': 'cpsportlets_content_render_items_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'label_false': 'cpsschemas_label_false',
                'label_true': 'cpsschemas_label_true',
                'render_format': 'select',
            },
        },
        'portlet': {
            'type': 'Generic Portlet Widget',
            'data': {
                'fields': ('portlet',),
                'hidden_layout_modes': ('edit',),
                'render_method': 'widget_portlet_content',
                'field_types': ('CPS String Field',),
            },
        },
        'cluster_id': {
            'type': 'String Widget',
            'data': {
                'fields': ('cluster_id',),
                'label_edit': 'cpsportlets_content_cluster_id_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'hidden_if_expr': 'not:context/render_items',
                'display_width': 20,
            },
        },
        'render_method': {
            'type': 'String Widget',
            'data': {
                'fields': ('render_method',),
                'label_edit': 'cpsportlets_common_render_method_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'hidden_if_expr': 'context/render_items',
                'display_width': 30,
            },
        },
        'show_icons': {
            'type': 'Boolean Widget',
            'data': {
                'title': '',
                'fields': ('show_icons',),
                'is_required': False,
                'label': '',
                'label_edit': 'cpsportlets_content_show_icons_label',
                'description': '',
                'help': '',
                'is_i18n': True,
                'readonly_layout_modes': (),
                'hidden_layout_modes': ('view',),
                'hidden_readonly_layout_modes': (),
                'hidden_empty': False,
                'label_false': 'cpsschemas_label_false',
                'label_true': 'cpsschemas_label_true',
                'render_format': 'select',
            },
        },
        'display_description': {
            'type': 'Boolean Widget',
            'data': {
                'fields': ('display_description',),
                'label_edit': 'cpsportlets_common_display_description_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'hidden_if_expr': 'python: context.render_items or context.render_method',
                'label_false': 'cpsschemas_label_false',
                'label_true': 'cpsschemas_label_true',
                'render_format': 'select',
            },
        },
        'sort_reverse': {
            'type': 'Boolean Widget',
            'data': {
                'fields': ('sort_reverse',),
                'label_edit': 'cpsportlets_content_sort_reverse_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'label_false': 'cpsschemas_label_false',
                'label_true': 'cpsschemas_label_true',
                'render_format': 'select',
            },
        },
        'searchable_types': {
            'type': 'MultiSelect Widget',
            'data': {
                'fields': ('searchable_types',),
                'label_edit': 'cpsportlets_content_searchable_types_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'vocabulary': 'cpsportlets_content_portal_types_voc',
                'translated': True,
                'size': 7,
            },
        },
        'max_words': {
            'type': 'Int Widget',
            'data': {
                'fields': ('max_words',),
                'label_edit': 'cpsportlets_content_max_words_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'hidden_if_expr': 'python: context.render_items or context.render_method',
                'min_value': 0,
                'max_value': 0,
            },
        },
        'syndication_formats': {
            'type': 'MultiSelect Widget',
            'data': {
                'fields': ('syndication_formats',),
                'label_edit': 'cpsportlets_common_syndication_formats_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'vocabulary': 'cpsportlets_syndication_formats_voc',
                'translated': True,
                'size': 0,
            },
        },
        'short_syndication_formats': {
            'type': 'CheckBox Widget',
            'data': {
                'fields': ('short_syndication_formats',),
                'label_edit': 'cpsportlets_common_short_syndication_formats_label',
                'is_i18n': True,
                'hidden_layout_modes': ('view',),
                'widget_mode_expr': '',
                'display_true': 'Yes',
                'display_false': 'No',
            },
        },
        'contextual': {
            'type': 'Boolean Widget',
            'data': {
                'title': '',
                'fields': ('contextual',),
                'is_required': False,
                'label': '',
                'label_edit': 'cpsportlets_content_contextual_label',
                'description': '',
                'help': '',
                'is_i18n': True,
                'readonly_layout_modes': (),
                'hidden_layout_modes': ('view',),
                'hidden_readonly_layout_modes': (),
                'hidden_empty': False,
                'label_false': 'cpsschemas_label_false',
                'label_true': 'cpsschemas_label_true',
                'render_format': 'select',
            },
        },
    },
    'layout': {
        'style_prefix': 'layout_portlet_',
        'ncols': 3,
        'rows': [
            [{'widget_id': 'portlet', 'ncols': 3},
            ],
            [{'widget_id': 'render_items', 'ncols': 1},
             {'widget_id': 'cluster_id', 'ncols': 1},
             {'widget_id': 'render_method', 'ncols': 1},
            ],
            [{'widget_id': 'max_items', 'ncols': 1},
            ],
            [{'widget_id': 'search_type', 'ncols': 1},
             {'widget_id': 'sort_on', 'ncols': 1},
             {'widget_id': 'sort_reverse', 'ncols': 1},
            ],
            [{'widget_id': 'query_title', 'ncols': 2},
            ],
            [{'widget_id': 'folder_path', 'ncols': 1},
             {'widget_id': 'contextual', 'ncols': 1},
            ],
            [{'widget_id': 'searchable_types', 'ncols': 3},
            ],
            [{'widget_id': 'show_icons', 'ncols': 1},
            ],
            [{'widget_id': 'display_description', 'ncols': 2},
             {'widget_id': 'max_words', 'ncols': 1},
            ],
            [{'widget_id': 'link_string', 'ncols': 1},
            ],
            [{'widget_id': 'syndication_formats', 'ncols': 1},
             {'widget_id': 'short_syndication_formats', 'ncols': 1},
            ],
        ],
    },
}

layouts = {'content_portlet': content_portlet_layout}
return layouts
