# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""
$Id: __init__.py,v 1.15 2006/09/18 16:53:26 glenfant Exp $
"""

__author__  = ''
__docformat__ = 'restructuredtext'

import sys

from Globals import package_home
from Products.CMFCore import utils
from Products.CMFCore import CMFCorePermissions
# from Products.Archetypes.public import *
from Products.CMFCore.DirectoryView import registerDirectory
from Products.PloneArticle.config import *
from Products.PloneArticle import Permissions

if HAS_PLONE_FILES_ZIP:
    import PloneFilesZipSupport

if HAS_LINGUA_PLONE:
    from Products.LinguaPlone.public import process_types
    from Products.LinguaPlone.public import listTypes
else:
    from Products.Archetypes.public import process_types
    from Products.Archetypes.public import listTypes

registerDirectory(SKINS_DIR, GLOBALS)

def initialize(context):
    # Import types
    from Products.PloneArticle import PloneArticle, PloneArticleMultiPage
    
    content_types, constructors, ftis = process_types(
            listTypes(PROJECTNAME),
            PROJECTNAME)
    
    utils.ContentInit(
        '%s Content' % PROJECTNAME,
        content_types      = content_types,
        permission         = Permissions.AddPloneArticle,
        extra_constructors = constructors,
        fti                = ftis,
        ).initialize(context)
    
    # Import tool
    from Products.PloneArticle.PloneArticleTool import PloneArticleTool
    
    utils.ToolInit(
        PROJECTNAME + ' Tool',
        tools=(PloneArticleTool,),
        icon='tool.gif').initialize(context)

    # try to initialize CMFEditions context if available
    try:
        from Products import CMFEditions
        from Products.PloneArticle.CMFEditionsModifier import PloneArticleV3CMFEModifier
        PloneArticleV3CMFEModifier.initialize(context)
    except ImportError:
        pass
