## Controller Python Script "plonearticle_attachment_add"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind state=state
##bind subpath=traverse_subpath
##parameters=title=None, description='', item_file=None
##title=Edit PloneArticle Attachments
##

# define the charset : useful for utf-8 sites using translate.py (see for something smarter)
from Products.CMFCore.utils import getToolByName
import string
charset = getToolByName(context, 'portal_properties')['site_properties'].default_charset
context.REQUEST.RESPONSE.setHeader('Content-Type','text/html; charset=%s'%charset)
pa = getToolByName(context, 'portal_article')

message = ""

# Custom editing method for the attachment
if item_file:
    if context.portal_article.checkAttachmentSize(item_file):
        # Upload file
        if not title:
            title = pa.getSmallFilename(item_file.filename)
            title = string.split(title, "\\")[-1]               # Dirty hack under IE

        context.addAttachment(
            title=title,
            description=description,
            file=item_file,
            )
        
        #message="Attachment added"
        message = context.translate(
            domain='plonearticle', msgid='message_attachment_added',
            mapping={},
            default = 'Attachment added.'
          )
    else:
        #message="Attachment exceeds allowed maximum size"
        message = context.translate(
                    domain='plonearticle', msgid='message_max_attachment_size',
                    mapping={},
                    default = 'Attachment exceeds allowed maximum size.'
                  )
        

message=context.REQUEST.get('portal_status_message', message)
return state.set(context=context, portal_status_message=message)
