## Script (Python) "plonearticle_get_thumb_tag"
##bind container=container
##bind context=context
##bind namespace=
##bind script=script
##bind subpath=traverse_subpath
##parameters=image_uid, alt=None, title=None, target=None, width=0, height=0
##title=Return the <img> tag of the image thumb, taking PIL into consideration if available.
##

from Products.CMFCore.utils import getToolByName

atool = getToolByName(context, 'archetype_tool')

# Get image objekt
image_objekt = atool.getObject(image_uid)

# Get image
image = image_objekt.getField('image').getAccessor(image_objekt)()

if not title:
    if image:
        title = image.Title()
    else:
        pass

if not alt:
    alt = title

# Calculate width and height
w=0
h=0
if image:
    w = image.getWidth() or width or height
    h = image.getHeight() or height or width

if width:
    width = min(w, width)
if height:
    height = min(h, height)

if not (width and height):
    if width:
        # Width used
        if w!=0:
            height = (float(width)/w) * h
    else:
        if h!=0:
            width = (float(height)/h) * w

result = None

if image:
    try:
        result = image.pil_tag(width=width, height=height, title=title, alt=alt, target=target)
    except:
        # PIL not installed with ImageTag_CorePatch
        result = image.tag(width=width, height=height, title=title, alt=alt, target=target)

return result
