# -*- coding: utf-8 -*-
## 
## Copyright (C)2005 Ingeniweb

## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.

## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.

## You should have received a copy of the GNU General Public License
## along with this program; see the file COPYING. If not, write to the
## Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

"""
$Id: ExFile.py,v 1.38 2006/05/15 14:35:34 glenfant Exp $
"""
__docformat__ = 'restructuredtext'



__author__ = ''

# Zope imports
from AccessControl import ClassSecurityInfo
from ZODB.POSException import ConflictError

# CMF imports
try:
    # The CMF 1.5  way
    from Products.CMFCore import permissions as cmf_permissions
except ImportError, e:
    # CMF 1.4 and older
    from Products.CMFCore import CMFCorePermissions as cmf_permissions
from Products.CMFCore.utils import getToolByName
from ComputedAttribute import ComputedAttribute

# Archetypes imports
from Products.Archetypes.utils import fixSchema
try:
    from Products.LinguaPlone.public import *
except ImportError:
    # No multilingual support
    from Products.Archetypes.public import *

# plone 2.1 stuff
try:
    from Products.CMFPlone.interfaces.BrowserDefault import IBrowserDefault
    _plone_2_1_implements = (IBrowserDefault,)
except ImportError:
    _plone_2_1_implements = ()

# PloneExFile imports
from Products.AttachmentField.AttachmentField import AttachmentField
from Products.AttachmentField.AttachmentWidget import AttachmentWidget
from Products.PloneExFile.config import PROJECTNAME, HAS_PLONE_2_1
from Products.PloneExFile.ATContentType import FileContent
from Products.PloneExFile import Permissions
from Products.PloneExFile.ExFileLock import ExFileLock

# Extra for Plone 2.1 support
if HAS_PLONE_2_1:
    from Products.ATContentTypes.content.base import cleanupFilename
    from Products.CMFPlone import transaction


PloneExFileSchema = FileContent.schema + ExFileLock.schema.copy() + Schema((
    AttachmentField(
        'file',
        primary=True,
        searchable=True,
        #languageIndependent=True,
        widget = AttachmentWidget(
            description = "Select the file to be added by clicking the 'Browse' button.",
            description_msgid = "help_file",
            label= "File",
            label_msgid = "label_file",
            i18n_domain = "plone",
            show_content_type = False,
            ),
        ),
    ), marshall=PrimaryFieldMarshaller())


cmf_permissions.setDefaultRoles(Permissions.EditExFile, ('Manager', 'Owner',))
cmf_permissions.setDefaultRoles(Permissions.LockExFile, ('Manager', 'Owner', Permissions.LockRole))


class PloneExFile(ExFileLock, FileContent):
    """PloneExFile class"""

    content_icon   = 'ExFile.gif'
    meta_type      = 'ExFile'
    archetype_name = 'File'
    default_view = 'ExFile_view'
    immediate_view = 'ExFile_view'
    suppl_views    = ()
    newTypeFor     = ()
    typeDescription= ''
    typeDescMsgId  = ''
    assocMimetypes = ()
    assocFileExt   = ()

    _at_rename_after_creation = True

    use_folder_tabs = 0
    filter_content_types  = 0
    allowed_content_types = ()
    include_default_actions = 0
    schema = PloneExFileSchema

    actions = (
        {
            'id'          : 'view',
            'name'        : 'View',
            'action'      : 'string:${object_url}/view',
            'permissions' : (cmf_permissions.View,),
            'visible'     : True,
            },
        {
            'id'          : 'edit',
            'name'        : 'Edit',
            'action'      : 'string:${object_url}/base_edit',
            'condition'   : 'python:not object.hasLockSupport() or object.canToggleLock()',
            'permissions' : (cmf_permissions.ModifyPortalContent,),
            'visible'     : True,
            },
        {
            'id'          : 'lock_unlock',
            'name'        : 'Unlock (Currently locked)',
            'action'      : 'string:${object_url}/unlockExFile',
            'permissions' : (cmf_permissions.View, ),
            'condition'   : 'python:object.isLocked() and object.canToggleLock()',
            'category'    : 'document_actions',
            },
        {
            'id'          : 'unlock_lock',
            'name'        : 'Lock (Currently not locked)',
            'action'      : 'string:${object_url}/lockExFile',
            'permissions' : (cmf_permissions.View, ),
            'condition'   : 'python:not object.isLocked() and object.canToggleLock()',
            'category'    : 'document_actions',
            },
        {
            'id'          : 'metadata',
            'name'        : 'Properties',
            'action'      : 'string:${object_url}/base_metadata',
            'condition'   : 'python:not object.hasLockSupport() or object.canToggleLock()',
            'permissions' : (cmf_permissions.ModifyPortalContent,),
            'visible'     : True,
            },
        {
            'id'          : 'references',
            'name'        : 'References',
            'action'      : 'string:${object_url}/reference_graph',
            'condition'   : 'object/archetype_tool/has_graphviz',
            'permissions' : (cmf_permissions.ModifyPortalContent, cmf_permissions.ReviewPortalContent,),
            'visible'     : True,
            },
        {
            'id'          : 'local_roles',
            'name'        : 'Sharing',
            'action'      : 'string:${object_url}/folder_localrole_form',
            'condition'   : 'python:not object.hasLockSupport() or object.canToggleLock()',
            'permissions' : (cmf_permissions.ManageProperties,),
            'visible'     : True,
            },
        )

    __implements__ = ( FileContent.__implements__, ) + _plone_2_1_implements

    security = ClassSecurityInfo()

    # Init method
    def __init__(self, oid, **kwargs):
        """__init__(self, oid, **kwargs)"""

        ExFileLock.__init__(self)
        FileContent.__init__(self, oid, **kwargs)

    security.declarePublic('getIcon')
    def getIcon(self, relative_to_portal=0):
        """Calculate the icon using the mime type of the file
        """

        field = self.getField('file')
        portal_url = getToolByName( self, 'portal_url' )

        # Find the proper icon
        icon = getattr(self, 'ExFile_small.gif')
        m = getattr(field, 'getSmallIcon', None)

        if m is not None:
            icon = m(self)

        # Return it
        if relative_to_portal:
            return portal_url.getRelativeContentURL(icon)

        # Relative to REQUEST['BASEPATH1']
        res = portal_url(relative=1) + '/' + icon.getId()
        while res[:1] == '/':
            res = res[1:]
        return res

    security.declarePrivate('_migrateGetValue')
    def _migrateGetValue(self, name, new_schema=None):
        """Try to get a value from an object using a variety of methods."""
        schema = self.Schema()
        # Migrate pre-AT 1.3 schemas.
        schema = fixSchema(schema)
        # First see if the new field name is managed by the current schema
        field = schema.get(getattr(new_schema.get(name,None),'old_field_name',name), None)
        if field:
            # At very first try to use the BaseUnit itself
            try:
                if IFileField.isImplementedBy(field):
                    return field.getBaseUnit(self)
            except ConflictError:
                raise
            except:
                pass

            # First try the edit accessor
            try:
                editAccessor = field.getEditAccessor(self)
                if editAccessor:
                    return editAccessor()
            except ConflictError:
                raise
            except:
                pass

            # No luck -- now try the accessor
            try:
                accessor = field.getAccessor(self)
                if accessor:
                    return accessor()
            except ConflictError:
                raise
            except:
                pass
            # No luck use standard method to get the value
            return field.get(self)

            # Still no luck -- try to get the value directly
            # this part should be remove because for some fields this will fail
            # if you get the value directly for example for FixPointField
            # stored value is (0,0) but the input value is a string.
            # at this time FixPointField fails if he got a tuple as input value
            # Because of this line value = value.replace(',','.')
            try:
                return self[field.getName()]
            except ConflictError:
                raise
            except:
                pass

        # Nope -- see if the new accessor method is present
        # in the current object.
        if new_schema:
            new_field = new_schema.get(name)
            # Try the new edit accessor
            try:
                editAccessor = new_field.getEditAccessor(self)
                if editAccessor:
                    return editAccessor()
            except ConflictError:
                raise
            except:
                pass

            # Nope -- now try the accessor
            try:
                accessor = new_field.getAccessor(self)
                if accessor:
                    return accessor()
            except ConflictError:
                raise
            except:
                pass

            # Still no luck -- try to get the value directly using the new name
            try:
                return self[new_field.getName()]
            except ConflictError:
                raise
            except:
                pass

        # Nope -- now see if the current object has an attribute
        # with the same name
        # as the new field
        if shasattr(self, name):
            return getattr(self, name)

        raise ValueError, 'name = %s' % (name)

    ##
    # Plone 2.1 style id generation
    #
    # Note that this is a dirty copy/paste
    ##

    if HAS_PLONE_2_1:

        security.declareProtected(cmf_permissions.ModifyPortalContent, 'setFile')
        def setFile(self, value, **kwargs):
            """Set id to uploaded id
            """
            self._setATCTFileContent(value, **kwargs)


        security.declareProtected(cmf_permissions.View, 'post_validate')
        def post_validate(self, REQUEST=None, errors=None):
            """Validates upload file and id
            """
            id     = REQUEST.form.get('id')
            field  = self.getPrimaryField()
            f_name = field.getName()
            upload = REQUEST.form.get('%s_file' % f_name, None)
            filename = getattr(upload, 'filename', None)
            clean_filename = self._cleanupFilename(filename)
            used_id = (id and not self._isIDAutoGenerated(id)) and id or clean_filename

            if upload:
                # the file may have already been read by a
                # former method
                upload.seek(0)

            if not used_id:
                return

            if getattr(self, 'check_id', None) is not None:
                check_id = self.check_id(used_id,required=1)
            else:
                # If check_id is not available just look for conflicting ids
                parent = aq_parent(aq_inner(self))
                check_id = used_id in parent.objectIds() and \
                           'Id %s conflicts with an existing item'% used_id or False
            if check_id and used_id == id:
                errors['id'] = check_id
                REQUEST.form['id'] = used_id
            elif check_id:
                errors[f_name] = check_id


        def _setATCTFileContent(self, value, **kwargs):
            
            """Set id to uploaded id
            """
            field = self.getPrimaryField()
            # set first then get the filename
            field.set(self, value, **kwargs) # set is ok
            if self._isIDAutoGenerated(self.getId()):
                filename = field.getFilename(self, fromBaseUnit=False)
                clean_filename = self._cleanupFilename(filename)
                request_id = self.REQUEST.form.get('id')
                if request_id and not self._isIDAutoGenerated(request_id):
                    # request contains an id
                    # skip renaming when then request id is not autogenerated which
                    # means the user has defined an id. It's autogenerated when the
                    # the user has disabled "short name editing".
                    return
                elif clean_filename == self.getId():
                    # destination id and old id are equal
                    return
                elif clean_filename:
                    # got a clean file name - rename it
                    # apply subtransaction. w/o a subtransaction renaming
                    # fails when the type is created using portal_factory
                    transaction.commit(1)
                    self.setId(clean_filename)


        def _cleanupFilename(self, filename, encoding=None):
            """Cleans the filename from unwanted or evil chars
            """
            if encoding is None:
                encoding = self.getCharset()
            return cleanupFilename(filename, context=self, encoding=encoding)

        security.declarePrivate('manage_afterPUT')
        def manage_afterPUT(self, data, marshall_data, file, context, mimetype,
                            filename, REQUEST, RESPONSE):
            """After webdav/ftp PUT method
            
            Set the title according to the uploaded filename if the title
            is empty or set it to the id if no filename is given.
            """
            title = self.Title()
            if not title:
                if filename:
                    self.setTitle(filename)
                else:
                    self.setTitle(self.getId())

    

def registerPloneExFile(klass):
    # Archetypes registering
    registerType(klass, PROJECTNAME)


registerPloneExFile(PloneExFile)
