/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: packsock.h,v 1.18 2003/11/26 12:04:35 bazsi Exp $
 *
 ***************************************************************************/

#ifndef ZORP_PACKSOCK_H_INCLUDED
#define ZORP_PACKSOCK_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/sockaddr.h>
#include <zorp/packet.h>

#define ZPS_LISTEN      0x0001
#define ZPS_ESTABLISHED 0x0002

gint z_packsock_open(guint flags, ZSockAddr *remote, ZSockAddr *local, guint32 sock_flags, gint tos, GError **error);

/* requires a connected packsock */
GIOStatus z_packsock_write(gint fd, ZPacket *packet, GError **error);
GIOStatus z_packsock_read(gint fd, ZPacket **packet, GError **error);

GIOStatus z_packsock_recv(gint fd, ZPacket **packet, ZSockAddr **from, ZSockAddr **to, gint *tos, GError **error);

gboolean z_packsock_init(gint sysdep_tproxy);

#endif
