/***************************************************************************
 *
 * Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 as published
 * by the Free Software Foundation.
 *
 * Note that this permission is granted for only version 2 of the GPL.
 *
 * As an additional exemption you are allowed to compile & link against the
 * OpenSSL libraries as published by the OpenSSL project. See the file
 * COPYING for details.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * $Id: plugsession.h,v 1.4 2003/05/28 12:18:57 bazsi Exp $
 *
 ***************************************************************************/
#ifndef ZORP_PLUGSESSION_H_INCLUDED
#define ZORP_PLUGSESSION_H_INCLUDED

#include <zorp/zorp.h>
#include <zorp/poll.h>
#include <zorp/proxy.h>

typedef struct _ZPlugSession ZPlugSession;
typedef gboolean (*ZPlugSessionStatsFunc)(ZProxy *proxy, ZSessionVars *vars, 
					  guint64 client_bytes, guint64 client_pkts, 
					  guint64 server_bytes, guint64 server_pkts);

typedef struct _ZPlugSessionData
{
  guint num_sessions;
  GList *destroy_queue;

  gint timeout;
  gboolean copy_to_server, copy_to_client;
  gboolean shutdown_soft;
  guint buffer_size;
  guint packet_stats_interval_time, packet_stats_interval_packet;
  ZPlugSessionStatsFunc packet_stats;
} ZPlugSessionData;

gboolean
z_plug_session_start(ZPlugSession *self, ZPoll *poll);

ZPlugSession *
z_plug_session_new(ZProxy *owner, 
                   ZPlugSessionData *session_data, 
                   ZStream *client_stream, 
                   ZStream *server_stream, 
                   ZStackedProxy *stacked);

void
z_plug_session_free(ZPlugSession *self);

static inline gboolean
z_plug_sessions_running(ZPlugSessionData *session_data)
{
  return session_data->num_sessions > 0;
}

void
z_plug_sessions_purge(ZPlugSessionData *session_data);

#endif
