############################################################################
##
## Copyright (c) 2000, 2001, 2002, 2003, 2004, 2005 BalaBit IT Ltd, Budapest, Hungary
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published by
## the Free Software Foundation; either version 2 of the License, or
## (at your option) any later version.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##
## You should have received a copy of the GNU General Public License
## along with this program; if not, write to the Free Software
## Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##
##
## $Id: Core.py,v 1.26 2004/07/07 15:28:51 bazsi Exp $
##
## Author  : Bazsi
## Auditor :
## Last audited version:
## Notes:
##
############################################################################

import new

from Zorp import *
import Zorp
from Zone import InetZone
from Service import Service
from SockAddr import SockAddrInet, SockAddrInetRange, SockAddrUnix


from Router import TransparentRouter, DirectedRouter, InbandRouter
from Chainer import ConnectChainer, FailoverChainer, SideStackChainer
from Domain import InetDomain
from Listener import Listener, ZoneListener, CSZoneListener
from NAT import NATPolicy, ForgeClientSourceNAT, StaticNAT, OneToOneNAT, OneToOneMultiNAT, RandomNAT, HashNAT, GeneralNAT
from Proxy import proxyLog
from Auth import InbandAuthentication, AuthCache, AuthPolicy
from Matcher import AbstractMatcher, RegexpMatcher, RegexpFileMatcher
from Resolver import DNSResolver

# conntrack support
try:
	from Receiver import Receiver, ZoneReceiver, CSZoneReceiver
except:
	pass

# ipv6 support
try:
	from SockAddr import SockAddrInet6
	from Zone import Inet6Zone
except:
	pass

config = new.module('config')

addConfigContainer(config, 'blob')
config.blob.default_tmpdir = '/var/lib/zorp/tmp/'
config.blob.default_max_disk_usage = 1024*0x100000
config.blob.default_max_mem_usage = 256*0x100000
config.blob.default_lowat = 96*0x100000
config.blob.default_hiwat = 128*0x100000
config.blob.default_noswap_max = 16384

