$! Version 1.5
$! XYP_MANAGER <function> [<config directory> [<function-specific data>]]
$! Default:	MENU	  [<config directory>
$!		VMSINSTAL [<config directory> [<load directory> [<exec directory>]]]
$!		CONFIGURE [<config directory>
$!		DISPLAY	  [<config directory> [<list of param files to examine>]]
$!
$!		-- command procedure controlling XYPLEX Parameter Server
$!
$ doMinimumFlag = "FALSE"	! implement only strict requirements of spec
$ goto DISPATCH
$
$! Subroutines
$
$! askArg = "<variable to set>\<prompt>\<default>"
$! gosub ASK 	! ask a question, providing a prompt and default
$!		! abort entire procedure if EOF (user hits ^z)
$ ASK:
$	sAvariable = f$element(0, "\", askArg)
$	'sAvariable' = f$element( 2, "\", askArg)
$	read sys$command sAresponse -
		/end_of_file = sAexit -
		/prompt="''f$element( 1, "\", askArg)' [''f$element( 2, "\", askArg)']: "
$	if sAresponse .nes. "" then -
	   'sAvariable' = sAresponse
$	'sAvariable' = f$edit( 'sAvariable', "UPCASE,COMPRESS,TRIM,UNCOMMENT")
$ sAexit:
$	return	$status .or. %x10000000
$
$! gosub readConfig	! update variables
$
$ readConfig:
$	open/read/error=rPOpenError -
		 file 'config_dir'XYP_MANAGER_CONFIG.DAT
$ rPLoop: read/end=rPLoopEnd file rPTemp
	'rPTemp'
$ 	goto rPLoop
$ rPLoopEnd:
$	if f$logical("file") .nes. "" then close file
$
$ if (file_version .ge. cmd_file_version) then goto rP20
$! if previous versions of param file could be missing things we need,
$! put them here.
$ if file_version .lt. 2 -
	.and. f$type(pserv_priority) .nes. "INTEGER" then pserv_priority = 4
$ rP20:
$ rPExit:
$	return
$
$ rPOpenError:
$	rPstatus = $status .and. %x0fffffff
$ if rPstatus .eq. fileNotFoundStatus then goto rPExit	! no prev params, that's ok.
$   	say ""				! Warn if other error opening file
$	say "WARNING -- Couldn't open server configuration file
$	say "           ''config_dir'XYP_MANAGER_CONFIG.DAT"
$	say "''f$message(rPstatus)'"
$	say ""
$ 	goto rPExit
$
$! gosub	writeConfig -- re-write config file
$
$ writeConfig:
$	! Compute here any config values that are modified each time
$	! a new config file is written.
$	pserv_host = f$logical("SYS$NODE") - "_" - "::"
$	if pserv_host .eqs. "" then pserv_host = "UNKNOWN"	! and serves them right, too
$	pserv_temp_file = "''config_dir'XYP_SERVER_TEMP.DAT"
$
$ 	open/write file 'config_dir'XYP_MANAGER_CONFIG.DAT
$	write file "$! Xyplex server config: Do NOT edit this file -- run the procedure instead"
$	write file "$! written by ''f$environment("PROCEDURE")'
$	write file "$!         at ''F$time()'"
$	write file "$ FILE_VERSION = ''cmd_file_version'"
$   	i = 1		! a funny place to start
$ wPLoop: wPTemp = f$element(i, "|", savedParams)
$	if wPTemp .eqs. "|" then goto wPLoopEnd
$	wPValue = 'f$element(0, "\", wPTemp)'
$ 	if f$type(wPValue) .eqs. "STRING" then wPValue = """" + wPValue + """"
$	write file "$ ", f$element(0, "\", wPTemp), " = ", wPValue
$	i = i + 1
$	goto wPLoop
$ wPLoopEnd:
$	close file
$	file_version = cmd_file_version
$	purge 'config_dir'XYP_MANAGER_CONFIG.DAT
$	return
$
$! gosub	getVersion
$
$ getVersion:
$	mcr 'exec_dir'XYP_SERVER version
$	return
$
$! gosub	needConfig
$
$ needConfig:
$	if file_version .ne. 0 then return
$	say ""
$    	say "ERROR -- No server configuration file available in"
$	say "         ''config_dir'XYP_MANAGER_CONFIG.DAT"
$	say "         Define it via CONFIGURE option, then retry this operation."
$	say ""
$	return 'fileNotFoundStatus' .or. %x10000000
$
$! gosub needPrivilege
$
$ needPrivilege: nPRequiredPrivileges = "WORLD,DETACH"
	if f$privilege(nPRequiredPrivileges) then return 1
$	say "ERROR -- Process does not have privileges {''nPRequiredPrivileges'}.
$	say "         Cannot perform the requested operation."
$	return %x10000024
$
$! matchKWArg = "<variable>\<description>\<value>\keyword\keyword . . ."
$! gosub matchKW	! Require <variable> to match one of <keyword>s
$! if $status .eq. 1 then goto OK
$! 			! variable wasn't one of them.
$
$ matchKW:
$	mKWvalue = f$edit(f$element(2, "\", matchKWArg), "COLLAPSE,UPCASE")
$ 	mKWi = 3
$	mKWoptions = ""
$ mKWloop: mKWkw = f$element(mKWi, "\", matchKWArg)
$	if mKWkw .eqs. "\" then goto mKWnoMatch
$	if f$locate(mKWvalue, mKWkw) .eq. 0 then goto mKWmatch
$	mKWoptions = mKWoptions + "," + mKWkw
$	mKWi = mKWi + 1
$	goto mKWloop
$ mKWnoMatch:
$	mKWoptions = f$extract(1,999, mKWoptions)
$	say "REENTER -- ''f$element(1, "\", matchKWArg)' must be one of:
$	say "           ", mKWoptions, "."
$	say ""
$	return %x11
$
$ mKWmatch:
$	'f$element(0, "\", matchKWArg)' = mKWkw
$	return 1
$
$ DISPATCH:
$
$ on warning then goto cleanupExit
$ on control_y then goto cleanupExit
$
$! Static config
$
$ return = ""
$ purge = ""
$ fileNotFoundStatus = %X18292 		! I hope they never change this...
$ say = "write sys$output"
$ debug	= "show symbol "
$ debug_say  = "write sys$output ""..."","
$ validFunctions = -
  	  "|CONFIGURE\Display and define configuration" -
	+ "|CONFIGURE_FULL\\""FALSE""" -
	+ "|VMSINSTAL\\""FALSE""" -
	+ "|STARTUP\Start parameter server operation"	-
	+ "|SHUTDOWN\Stop parameter server operation"	-
	+ "|SHOW_CONFIGURATION\Show current configuration" 	-
	+ "|RESTART\Stop then start parameter server operation"	-
	+ "|DISPLAY\Display parameter files"	-
	+ "|HELP\List these functions"	-
  	+ "|EXIT\Leave this menu"
$ cmd_file_version = 3		! param file format written by us
$ file_version = 0		! no param file read yet.
$
$! List of saved config -- the names must be upper case,
$! and FILE_VERSION must be the first one in the list.
$
$ savedParams = -
   	   "FILE_VERSION\Format of config data\""FALSE""" -	! MUST BE FIRST
  	+ "|CONFIG_DIR\Directory containing configuration data" -
	+ "|EXEC_DIR\Directory containing executables"	-
	+ "|MOP_LOAD_DIR\Directory to store parameter sets" -
	+ "|ETHERNET_CONTROLLERS\Ethernet controller(s)" -
	+ "|LOG_DEST\Destination of log information"	-
  	+ "|LOG_OPCOM_CLASS\OPCOM message class" -
  			+ "\LOG_DEST .eqs. ""OPCOM""" -
	+ "|LOG_FILE_NAME\Log file" -
			+ "\LOG_DEST .eqs. ""FILE"""
$ savedParams = savedParams -	! cmd buffer overflow unless split in two
 	+ "|PSERV_THREADS\Max simultaneous transactions\""FALSE""" -
 	+ "|PSERV_PRIORITY\Process priority for server\""FALSE""" -
	+ "|PSERV_HOST\Server host name\""FALSE""" -
	+ "|PSERV_TEMP_FILE\Server temp file\""FALSE""" -
	+ "|PSERV_WORK_EXT\Extension of intermediate param files\""FALSE"""-
	+ "|DEF_PARAM_FILE\Specification of generic param file\""FALSE"""-
  	+ ""
$ serverProcessName = "XYP_SERVER"
$
$! Run-time parameters
$
$ if p1 .eqs. "" then p1 = "HELP"
$ p1 = f$edit(p1, "UPCASE, COLLAPSE")
$ config_dir = f$parse("A.B;99", f$environment("PROCEDURE")) - "A.B;99"
$ if p2 .nes. "" then config_dir = p2
$
$! Assume defaults
$
$ mop_load_dir = "MOM$LOAD:"
$ exec_dir = "SYS$SYSTEM:"
$
$! if executing in a common-root cluster, make param and exec files
$! sharable, but not the config directory, (which can contain logs)
$
$ if f$search("sys$sysroot:[000000]syscommon.dir") .eqs. "" then goto ad10
$	mop_load_dir = f$parse("SYS$COMMON:A.B;9", "MOM$LOAD:",,,-
				"SYNTAX_ONLY") - "A.B;9"
$	exec_dir = f$parse("SYS$COMMON:A.B;9", "SYS$SYSTEM:",,,-
				"SYNTAX_ONLY") - "A.B;9"
$ ad10:
$ ethernet_controllers = ""
$ pserv_threads = 2			! arbitrary
$ pserv_priority = 4
$ pserv_work_ext = "TMP"
$ def_param_file = "XYP_DEFAULT_PARAMS.SYS"
$ vmsinstalFlag = "FALSE"
$
$! If user specified single function, do it and exit.
$! If user didn't specify a function, prompt for it, and loop until
$!    user selects 'EXIT'
$
$	gosub readConfig
$
$	menuMode = (f$locate(p1, "HELP") .eq. 0)
$
$ functionLoop:
$	if menuMode then gosub functionHELP
$	if f$length(p1) .lt. 3 then goto invalidFunction
$ 	cmdStart = f$locate( "|''p1'", validFunctions)
$ 	if cmdStart .ge. f$len(validFunctions) then goto invalidFunction
$ 	cmdLen = f$locate("\", f$extract(cmdStart+1, 999, validFunctions))
$	function = f$extract(cmdStart+1, cmdLen, validFunctions)
$ 	gosub function'function'
$ fL10:
$ 	if menuMode then goto functionLoop
$	goto cleanupExit
$
$ invalidFunction:
$	say ""
$	say "Invalid function ''p1'. Specify HELP for a list."
$      	say ""
$	goto fL10
$
$! HELP -- display function list, return selection in FUNCTION
$
$ functionHELP:
$	type sys$input:

                        Xyplex Parameter Server Manager

Available functions:

$ i = 1	       	! funny place to start
$ fMloop: fMCurItem = f$element(i, "|", validFunctions)
$	if fMCurItem .eqs. "|" then goto fMloopEnd
$	temp = f$element(2, "\", fMCurItem)
$	if temp .nes. "\" .and. .not. temp then goto fMloopBreak
$	say f$fao("   !23<!AS --!> !AS", -
		f$element(0, "\", fMCurItem), f$element(1, "\", fMCurItem))
$ fMloopBreak:	i = i + 1
$	goto fMloop
$ fMloopEnd:
$	say ""
$ 	askArg = "p1\Enter function\EXIT"
$      	gosub ask    	! sets p1
$	return
$
$ functionVMSINSTAL:			! entrypoint used by KIT INSTALL
$	file_version = 0		! abandon any old config file.
$	if p3 .nes. "" then mop_load_dir = p3
$	if p4 .nes. "" then exec_dir = p4
$	vmsinstalFlag = "TRUE"
$	goto functionCONFIGURE
$
$ functionCONFIGURE_FULL:
$	if file_version .ne. 0 then goto fCF10	! if have params, use them
$	askArg = "fCtemp\No server configuration in ''config_dir'. Create one?\NO"
$	gosub ask
$	if .not. fCtemp then return
$ fCF10:
$ fCFQ1:
$ 	askArg = "fCtemp\Directory to contain configuration data\''config_dir'"
$      	gosub ask
$      	if f$parse(fCtemp) .nes. "" then goto fCFQ1end
$	say "REENTER -- Couldn't find device/directory ''fCtemp'."
$	say ""
$	goto fCFQ1
$ fCFQ1end:
$	config_dir = fCtemp
$ fCFQ2:
$ 	askArg = "fCtemp\Directory to contain executables\''exec_dir'"
$	gosub ask
$      	if f$parse(fCtemp) .nes. "" then goto fCFQ2end
$	say "REENTER -- Couldn't find device/directory ''fCtemp'."
$	say ""
$	goto fCFQ2
$ fCFQ2end:
$	exec_dir = fCtemp
$ fCFQ3:
$	askArg = "fCtemp\Number of simultaneous STOREs to support\''pserv_threads'"
$	gosub ask
$	if f$integer(fCtemp) .gt. 0 then goto fCFQ3end
$	say "REENTER -- need an integer greater than 0."
$	say ""
$	goto fCFQ3
$ fCFQ3end:
$	pserv_threads = f$integer(fCtemp)
$ fCFQ4:
$      	askArg = "fCtemp\VMS process priority for Parameter Server\''pserv_priority'"
$	gosub ask
$	if f$integer(fCtemp) .ge. 3 -
	   .and. f$integer(fCtemp) .le. 10 then goto fCFQ4end
$	say "REENTER -- need an integer between 3 and 10."
$	say ""
$	goto fCFQ4
$ fCFQ4end:
$	pserv_priority = f$integer(fCtemp)
$
$	goto functionCONFIGURE
$
$ functionCONFIGURE:
$
$	if file_version .ne. 0 then goto fC10	! if have params, use them
$	log_dest = "OPCOM"
$ 	log_opcom_class = "NETWORK"
$	log_file_name = "''config_dir'XYP_SERVER.LOG"
$	ethernet_controllers = ""
$	i = 0
$ fC03:	fCtemp = f$element(i, "\", "XQA\ETA\ESA\XEA\XMA")
$      	if fCtemp.eqs. "\" then goto fC05
$	if f$getdvi(fCtemp, "EXISTS") then -
	   ethernet_controllers = ethernet_controllers + "," + fCtemp
$	i = i + 1
$	goto fC03
$ fC05:	ethernet_controllers = ethernet_controllers - ","
$ fC10:
$ fCQ1:	if vmsinstalFlag .or. doMinimumFlag then goto fCQ2
$	askArg = "fCtemp\Directory to store parameter sets\''mop_load_dir'"
$	gosub ask
$	if fCtemp .nes. "" .and. f$parse(fCtemp) .nes. "" then goto fCQ1end
$	say "REENTER -- Couldn't find device/directory ''fCtemp'."
$	say ""
	goto fCQ1
$ fCQ1end:
$	mop_load_dir = fCtemp
$ fCQ2:	askArg = "fCtemp\Ethernet controller(s)\''ethernet_controllers'"
$	gosub ask
$	fCtemp = f$edit(fCtemp, "collapse")
$	i = 0
$ fCQ2loop: fCedev = f$element(i, ",", fCtemp)
$	if fCedev .eqs. "," then goto fCQ2loopEnd
$ 	if fCedev .eqs. "" -
	   .or. (f$element(1, ":", fCedev) .nes. "" -
		.and. f$element(1, ":", fCedev) .nes ":") then goto fCQ2a
$	if f$getdvi(fCedev, "EXISTS") then goto fCQ2l10
$ fCQ2a:   say "REENTER -- Device ''fCedev' does not exist."
$	   say ""
$	   goto fCQ2
$ fCQ2L10: if f$getdvi(fCedev, "DEVCLASS") .eq. 32 then goto fCQ2loopBot
$ 	   say "REENTER -- Device ''fCedev' is not an Ethernet controller."
$	   say ""
$	   goto fCQ2
$ fCQ2loopBot: i = i + 1
$   	goto fCQ2loop
$ fCQ2loopEnd:
$ fCQ2end: ethernet_controllers = fCtemp
$
$ fCQ3a: askArg = "fCtemp\Destination of log information\''log_dest'
$	gosub ask
$	matchKWArg = "log_dest\Log destination\''fCtemp'\NONE\OPCOM\FILE"
$	gosub matchKW	! sets log_dest if it works
$	if $status .ne. 1 then goto FCQ3a
$
$      	if log_dest .eqs. "NONE" then goto fCQ3end
$	if log_dest .eqs. "FILE" then goto fCQ3c
$ fCQ3b: askArg = "fCtemp\OPCOM message class\''log_opcom_class'"
$	gosub ask
$	matchKWArg = "log_opcom_class\OPCOM message class\''fCtemp'" -
		+ "\CENTRAL\PRINTER\TAPES\DISKS\DEVICES\CARDS\NETWORK\CLUSTER\SECURITY"-
		+ "\OPER1\OPER2\OPER3\OPER4\OPER5\OPER6\OPER7\OPER8\OPER9\OPER10" -
	      	+ "\OPER11\OPER12"
$	gosub matchKW	! sets log_opcom_class if it works.
$	if $status .ne. 1 then goto fCQ3b
$	goto fCQ3end
$ fCQ3c: askArg = "fCtemp\Log file\''log_file_name'"
$	gosub ask
$	if f$parse(fCtemp) .nes. "" then goto fCQ3cEnd
$	say "REENTER -- Invalid file specification ''fCtemp'
$	goto fCQ3c
$ fCQ3cEnd: log_file_name = fCtemp
$ fCQ3end:
$	gosub writeConfig
$	askArg = "temp\Do you want to restart the Parameter Server now?\YES"
$	gosub ask
$	if temp then gosub functionRESTART
$ fCEnd:
$      	return
$
$ functionSTARTUP:
$	gosub needConfig
$	gosub needPrivilege
$ 	set noon
$	define sys$output nl:
$	define sys$error nl:
$	purge 'config_dir'XYP_SERVER*.*
$	purge/nolog 'mop_load_dir'XYP_0%%%%%%%%%%%.SYS -
		/modified/before="-30-"
$	delete/nolog 'mop_load_dir'XYP*.'pserv_work_ext';*
$	delete/nolog 'pserv_temp_file';*
$	delete/nolog 'config_dir'XYP_SERVER.IN;*
$	deassign sys$output
$	deassign sys$error
$	set on
$ 	open/write file 'config_dir'XYP_SERVER.IN
$	write file "$ set default ''config_dir'"
$	write file "$ mcr ''exec_dir'XYP_SERVER", -
			" START ''config_dir'XYP_MANAGER_CONFIG.DAT"
$	close file
$   	uic = f$file_attributes("''exec_dir'XYP_SERVER.EXE", "uic")
$	fSUoutFile = "NL:"
$	if log_dest .eqs. "FILE" then fSUoutFile = LOG_FILE_NAME
$	numFiles = 25 + (pserv_threads * 2)
$   	run sys$system:loginout 			-
       		/process_name='serverProcessName'	-
		/uic='uic' 				-
		/detach 				-
		/priority='pserv_priority'		-
		/privileges=(nosame,sysprv,prmmbx,tmpmbx,netmbx,oper)	-
       		/page_file=40000 			-
		/file_limit='numFiles'		-
		/input='config_dir'XYP_SERVER.IN	-
		/output='fSUoutFile'			-
		/io_direct=40	-
		/io_buffered=40	-
		/ast_limit=100	-
		/time_limit=0	-
		/ast_limit=100	-
		/buffer_limit=40000 -
		/queue_limit=100
$
$	return
$
$ functionSHUTDOWN:
$	gosub needConfig
$	gosub needPrivilege
$	pidContext = ""
$ fSDloop:	pid = f$pid(pidContext)
$	if pid .eqs. "" then gotot fSDloopEnd
$	if f$getjpi(pid, "PRCNAM") .nes. serverProcessName then goto fSDloop
$ fSDloopEnd:
$ 	waitEnd = f$cvtime("+0:0:30", "COMPARISON")
$	mcr 'exec_dir'XYP_SERVER STOP
$	if pid .eqs. "" then goto fSDexit
$ fSDkillLoop:
$	wait 0:0:1
$	set noon
$	define sys$output NL:
$	define sys$error NL:
$	t = f$getjpi(pid, "PRCNAM")
$	oldStatus = $status
$	deassign sys$output
$	deassign sys$error
$	set on
$	if oldStatus .and. -
	   f$cvtime("","COMPARISON") .les. waitEnd then goto fSDkillLoop
$	if .not. oldStatus then goto fSDexit
$	set noon
$	stop/id='pid'
$	say "TERMINATED -- Parameter server process abnormally terminated."
$	say ""
$	set on
$ fSDexit:
$	return
$
$ functionSHOW_CONFIGURATION:
$	gosub needConfig
$
$	type sys$input:

                         Xyplex Parameter Server Configuration

$	gosub getVersion
$ 	i = 0
$ fSCLoop:
$ 	temp = f$element(i, "|", savedParams)
$	if temp .eqs. "|" then goto fSCLoopEnd
$	fSCPred = f$element(2, "\", temp)
$	if fSCPred .eqs. "\" then goto fSCL10
$	if .not. 'fSCPred' then goto fSCLbottom
$ fSCL10:
$	say "   ", f$element(1, "\", temp), ":   ", 'f$element(0, "\", temp)
$ fSCLbottom:	i = i + 1
$	goto fSCLoop
$ fSCLoopEnd:
$	say ""
$ 	return
$
$ functionRESTART:
$	gosub	functionSHUTDOWN
$	gosub	functionSTARTUP
$	return
$
$ functionDISPLAY:
$      	gosub needConfig
$ 	fDspec = p3
$	if fDspec .nes. "" then goto fD10
$	   askArg = "fDspec\List of parameter files to examine" -
	   	  + "\''mop_load_dir'XYP_0%%%%%%%%%%%.SYS"
$	   gosub ask
$ fD10:
$	fDspec = f$edit(fDspec, "UPCASE,COLLAPSE,UNCOMMENT")
$	i = 0
$	fDFinalSpec = ""
$ fDLoop:
$	fDCurSpec = f$element(i, ",", fDspec)
$	if fDCurSpec .eqs. "," then goto fDLoopEnd
$	if f$search(fDCurSpec) .nes. "" then -
	   fDFinalSpec = fDFinalSpec + " " + fDCurSpec
$	temp = f$search("")			! reset stream context
$	i = i + 1
$	goto fDLoop
$ fDLoopEnd:
$	if fDFinalSpec .nes. "" then goto fD20
$	   say ""
$	   say "ERROR -- No parameter files found"
$	   say ""
$	   return
$ fD20: mcr 'exec_dir'XYP_MANAGER DISPLAY 'fDFinalSpec'
$	return
$
$ functionEXIT:
$	menuMode = "FALSE"	! no longer
$	return
$
$! cleanupExit
$
$ cleanupExit:
$	savedStatus = $status
$	set noon
$	if f$logical("FILE") .nes. "" then close file
$	set on
$	exit 'savedStatus' .or. %x10000000
$

Notes:

The configuration file has a 'file_version' and the executing command file has a
'cmd_file_version'. File_version is the cmd_file_version of the procedure that
wrote the configuration file.  Cmd_file_version must be bumped whenever a new
version of the command procedure changes the usage of one of the  existing
variables in 'savedParams' or adds or removes a variable from that  list.

The 2 _versions cooperate to provide forward and backward compatibility. A
command file can recognize that it is reading an out-of-date configuration
file (that is, a config file whose 'file_version' is less than the command
procedure's own 'cmd_file_version'),  and subroutine  'readConfig' has a
hook for correcting data read from an older config file.

There is no corresponding hook for backward compatibility. It is up to future
versions of the command file to support backward compatibility by not changing
the meaning of any existing  variable in 'savedParams', nor removing a variable
from the list.

2) Each element in 'savedParams' (delimited by "|") is a triplet of the form:

	<variable>\<title>\<predicate>

where:
	<variable>	is the name of the DCL variable itself.
	<title>		is the title for the line when showing the
			value of the variable in SHOW_CONFIGURATION.
	<predicate>	is a DCL expression to evaluate before displaying
			the line. If the expression is present and FALSE,
			the line will not be displayed.
3) Each element in validFunctions (delimited by "|") is a triplet of the
form:

	<keyword>\<description>\<visible>

Where:
	<keyword>	is the keyword that invokes this function
	<description>	is the text of the menu line
	<visible>	controls whether the item shows up in the menu.
			If there is an expression and it is "FALSE", the
			keyword is not displayed in the menu.

--Modified------By------For-------------------------------------------------
 01-Dec-88	rmh	Add device/directory to default log file spec
 13-Dec-88	rmh	DISPLAY works for single file each time, not
		 		every other time.
			-	PSERV_PRIORITY is server process priority.
			-	Choose SYS$COMMON: defaults for cluster
				installations.
			- 	Enable additional questions

  16-Dec-88	rmh	Don't always take common-root defaults
			-	Notice if comma missing in list of eth devs.

  21-Mar-89	imk	Add new keyword and value for the default param file 
			specification
			Changed com version to 3.

  03-May-89	imk	Changed default priority from 3 to 4.
  02-Jun-89	imk	Added ability to retrieve XYP_SERVER software version 
			and display it in SHOW_CONF option
