''' $Id: csportd.l,v 1.10 1993/09/15 13:58:02 bjs Exp $
'''
.TH CSPORTD l "17 June 1993"
.SH NAME
csportd \- Comm Server Port Daemon
.SH SYNOPSIS
.B csportd
[
.B \-d
.I debug-level
]
[
.B \-P
.I pipe-name
]
[
.B \-T
.I pty-name
]
[
.B \-c
.I config-file
]
[
.B \-xtgwLeDiso
]
.I CommServer
.I Port
.SH DESCRIPTION
.I csportd
is a utility which gives users connectivity between UNIX systems and
Comm Server ports.  
.I csportd
reads data from stdin, a pseudo terminal or a FIFO (named pipe) and sends
the data to the Comm Server port.
Likewise, data can be read from the Comm Server port and sent to the
pseudo terminal or FIFO.

Many options are available to control how
.I csportd
processes the data.  Refer to the OPTIONS section for details.
.SH ARGUMENTS
.TP 6n
.B \-options
Any valid set of options as described below.
.TP
.B CommServer
Name or IP address of a Comm Server.
.TP
.B Port
Physical or logical port number on the Comm Server to send (receive)
the data to (from).  Refer to the \-L option.
.SH OPTIONS
The following options control where 
.I csportd
reads (sends) data from (to) and how to process any data going to (coming from) the
Comm Server port.
.TP 6n
.B \-d debug-level
Sets the debug level to
.I debug-level.  
Increasing the 
.I debug-level
increases the verbosity of the messages displayed.  The following values are 
supported.

1 - General information and any system error messages.

2 - Buffer processing information.

3 - select() information.

Any value greater than 3 is set to 3.
.TP
.B \-P pipe-name
Creates a named pipe (FIFO) of the name
.I pipe-name.
Data written to the file will be sent to the Comm 
Server port. Data read from this file will be data read from the Comm 
Server port, unless explicitly stated otherwise by use of the \-t 
or \-w options.  Ideally, the Comm Server port should have the default session
mode defined to be TRANSPARENT.  Note that with pipes, a FIFO opened for 
for reading will pend until the other end is opened for writing, and a FIFO 
opened for writing will pend until the other end is opened for reading.
The \-P and \-T options are mutually exclusive, while the \-D and \-e options
are invalid with this option.
.TP
.B \-T pty-name
Allocates a pseudo terminal and creates a link to it named
.I pty-name.
Any data written to 
.I pty-name
is sent to the Comm Server port while data read from the Comm Server port is
written to 
.I pty-name.
Ideally, the Comm Server port should have the default session mode defined to 
be TRANSPARENT.  If the default session mode is not TRANSPARENT, the \-t 
option should be specified otherwise functionality may be unpredictable.
The \-T and \-P options are mutually exclusive.

AIX SYSTEMS

The link to the psuedo terminal must be a symbolic one.  Therefore, the \-s
option must also be specified.

.TP
.B \-c
Read pseudo terminal names from 
.I config-file
instead of using 
.I csportd's 
allocation algorithm.  Useful in 
restricting which PTYs are used or if your system has 
a unique PTY naming strategy.  This option may only appear after the
\-T option.  A sample 
.I config-file
is:
.RS
.nf
.ft B

#
#  a '#" denotes a comment line
#
/dev/ptyq0
/dev/ptyq1
.fi
.ft R
.RE
.LP
.TP 
.B \-x
converts LFs to LFCRs in data going to the Comm Server port.
.TP
.B \-t
limited TELNET mode.  TELNET IAC characters are doubled in data 
going to the Comm Server port while doubled TELNET IAC characters 
are converted to single TELNET IAC characters in data coming from the
Comm Server port.  Any TELNET option negotiations received from the 
Comm Server are negatively acknowledged.  This option should be specified 
when the default session mode on the Comm Server port is not TRANSPARENT.
.TP
.B \-g
connect through a TCPIP/LAT gateway.
.TP
.B \-w
write only mode.  Any data received from the Comm Server is ignored.
.TP
.B \-L
.I port
argument is a logical (TCP) port instead of a physical port.  This argument
needs to be specified if the default TELNET remote port was changed for the
physical port.
.TP
.B \-e
TELNET EOR reflection at the end of jobs.  This option requires that eor
reflection be enabled on the Comm Server Port.  (Comm Server command ->
DEFINE PORT x TELNET EOR REFLECTION ENABLED).  For eor reflection to work
properly, the default session mode of the Comm Server port MUST NOT be set to
TRANSPARENT.  This option is incompatible with the \-P option.
.TP
.B \-D
disconnect from the Comm Server port between jobs.  Typically, job end is 
detected when a last close occurs on the user device which causes the error
EIO to be sent to 
.I csportd.
This option may only appear after the \-T option and cannot appear with the
\-o option and \-P option.
.TP
.B \-i
.ne 7
initiate the connection with the Comm Server port.  Normally
.I csportd
will wait for input from the user before registering with the Comm Server and
waiting for the callback.  This option causes
.I csportd
to establish the connection with the Comm Server port before any data needs to be
sent.
.TP
.B \-s
create a symbolic link for
.I pty-name
This option may only appear after the \-T option.
.TP
.B \-o
toggles PTY slave processing.  This option toggles the processing done
by the slave side of the PTY.  The actions taken depend on the system type.

BSD Systems

The slave side of the PTY is opened configured for RAW mode.

System V Systems

The slave side of the PTY is opened and the terminal emulation modules
"ptem" and "ldterm" are pushed onto the stream.

Incompatible with the \-D,\-e and \-P  options.
.SH EXAMPLES
Some exammples of how to use 
.I csportd 
are:
.IP 1.
To send a file to port 5 of a Comm Server port, one might use:
.nf

    % cat file | csportd CommServer 5
.fi
.IP 2.
To send the same file, but convert LFs to LFCRs and print out all
debug information, one might use:
.nf

    % cat file | csportd -d3 -x CommServer 5
.fi
.IP 3.
To create an entry in /dev which will allow users to send data
to the Comm Server port, one could do the following:
.nf

    % csportd -T/dev/foo -D CommServer 5

.fi
Users can then send data to the port with:
.nf

    % cat file >/dev/foo
.fi
.IP 4.
.ne 8
To accomplish the same goal using a named pipe (FIFO), one
could do the following:
.nf

    % csportd -P/usr/spool/CommServerPort -x CommServer 5

.fi
Users can then send data to the port with:
.sp

    % cat file >/usr/spool/CommServerPort
.IP 5
To create a permanent connection to the port which can be used by the system
to provide a "hardwire" connection to a terminal attached to the Comm
Server port, do the following:  (BSD systems only!)

Add the following line to /etc/ttytab.
.nf

    ttyCS1  "/usr/etc/getty maxserver"  unknown on local secure

.fi
Add the following entry to /etc/gettytab
.nf

    maxserver:\\
               :p8:lm=\\r\\n\\r\\nWelcome to %h\\r\\nlogin\\72 :

.fi
Start up 
.I csportd.
.nf

    % csportd -T/dev/ttyCS1 -i CommServer 5 &

.fi
Signal the init process to read /etc/ttytab.
.nf

    % kill -HUP 1

.fi
The login prompt should now appear on the terminal connected to the Comm
Server port.
.SH FILES

.nf

/dev/file-name          Link to PTY slave.
pipe-file               Pipe file.                     

BSD

  /dev/pty[p-s][0-f]    list of PTY masters
  /dev/tty[p-s][0-f]    list of PTY slaves

System V

  /dev/ptmx             PTY master device 


.fi
.SH SEE ALSO
Supporting documentation.
