


APGEN(l)          MISC. REFERENCE MANUAL PAGES           APGEN(l)



NAME
     apgen - ASCII Parameter File Generator Utility

SYNOPSIS
     apgen _o_p_t_i_o_n_s _p_a_r_a_m_e_t_e_r-_f_i_l_e [ _o_u_t_p_u_t-_f_i_l_e ]

DESCRIPTION
     _a_p_g_e_n  converts  a  binary  parameter  file  to  its   ASCII
     equivalent.   The ASCII file generated is executable via the
     CommServer  script   command.    _a_p_g_e_n   correctly   handles
     compressed and uncompressed parameter files.  _a_p_g_e_n finds it
     necessary to comment out certain  data  (comment  lines  are
     preceded by #).  These are:

     -    Server features that were at one point enabled, but are
          now  disabled,  the  old settings will be shown in com-
          ments.  Note: server  features  that  have  never  been
          enabled, will have no data.

     -    Password information will be shown in comments.

     -    Data that would require the user to intervine  will  be
          shown   in   comments.  This  includes  certain  server
          features data, some daemon information,  and  old  menu
          information.

     -    The NVS information will also be shown in comments.

ARGUMENTS
     -options
           Switches controlling which parts of the parameter file
           are converted.  Multiple options may be specified.

     parameter-file
           Binary (compressed or uncompressed) parameter file.

     output-file
           Optional argument for results.  If  this  argument  is
           omitted, the results appear on _s_t_d_o_u_t.


OPTIONS
     -all          convert entire (all) parameter file.

     -arap         convert ARAP data.

     -daemons      convert DAEMONS data.

     -domain       convert DOMAIN data.

     -filter[:ip|ipx]
                   convert IP  or  IPX  filter  data.  The  [:ip]



Sun Release 4.1     Last change: 18 June 1993                   1






APGEN(l)          MISC. REFERENCE MANUAL PAGES           APGEN(l)



                   option  will  display  ip filters.  The [:ipx]
                   option will display ipx rip, sap, and  address
                   filters. The default is [:ip].

     -features     convert server FEATURES data.

     -ip           convert INTERNET data.

     -ipx          convert IPX data.

     -kerberos     convert KERBEROS data.

     -lineedit     convert port LINE EDIT data.

     -lpd          convert LPD data.

     -manager      convert MANAGER data.

     -menu         convert MENU, and NESTED MENU data.

     -nvs          convert NVS data.

     -parameter    convert PARAMETER SERVER data.

     -port[:<number>]
                   convert port data for port <number>.  Multiple
                   -port  options  will  display  multiple  ports
                   while -port:all, or  -port  will  display  all
                   ports.   This  option will override the -arap,
                   -kerberos, -lineedit, -menu,  -ppp,  -securid,
                   -security,   -session,   -slip,  -telnet,  and
                   -xremote options.  This means  that  the  port
                   information  to  be printed with those options
                   will now be printed with the rest of the  port
                   information.

     -ppp          convert PPP data.

     -rotary       convert ROTARY data.

     -route[:ip|ipx]
                   convert ROUTING data for :ip or :ipx.  The :ip
                   option  will display IP ROUTING data.  Issuing
                   -route will also display IP ROUTING data.  The
                   :ipx  option will display ipx routes, and ser-
                   vice data.

     -script       convert SCRIPT data.

     -securid      convert SECURID data.

     -security     convert SECURITY data.



Sun Release 4.1     Last change: 18 June 1993                   2






APGEN(l)          MISC. REFERENCE MANUAL PAGES           APGEN(l)



     -server       convert SERVER data.  This option  will  over-
                   ride  the -daemons, -features, -ip, -kerberos,
                   -menu, -parameter, -ppp, and  -snmp.  options.
                   This  means  that the server information to be
                   printed with those options will now be printed
                   with the rest of the server information.

     -service      convert LAT SERVICE data.

     -session      convert port SESSION data.

     -slip         convert port SLIP data.

     -snmp         convert internet SNMP data.

     -telnet       convert port TELNET data.

     -tn3270       convert TN3270 data.

     -verbose      display port related data for each port  indi-
                   vidually instead of using a 'port-list'.  This
                   may be used  in  conjunction  with  the  -all,
                   -kerberos,   -lineedit,  -menu,  -port,  -ppp,
                   -security,  -session,  -slip,   -telnet,   and
                   -xremote options.

     -xprinter     convert XPRINTER data.

     -xremote      convert XREMOTE data.

EXAMPLES
     Convert entire parameter file, and store it in everything_log:

          example% apgen -all param-file.prm everything_log

     Convert all port information in parameter file, and store it in port_log:

          example% apgen -port param-file.prm port_log

     Convert all port information pertaining to port 3 and port 6:

          example% apgen -port:3 -port:6 param-file.prm

     Convert all port information pertaining to port 3 and port 6, and generate a
     verbose listing:

          example% apgen -port:3 -port:6 -verbose param-file.prm

     Convert Kerberos information for both the server and all ports.

          example% apgen -kerberos param-file.prm




Sun Release 4.1     Last change: 18 June 1993                   3






APGEN(l)          MISC. REFERENCE MANUAL PAGES           APGEN(l)



     Convert port 3, port 6, and Kerberos information for server.  Note that
     entire port 3 and 6 information is shown (including kerberos port data):

          example% apgen -kerberos -port:3 -port:6 param-file.prm

FILES
     /tftpboot/parameter-file          Binary parameter file
     output-file                       Result destination
     stdout                            Result destination
                                         (if output-file omitted)
     /tmp/uncompressed_parameter-file  Parameter file, uncompressed.

SEE ALSO
     Supporting documentation.









































Sun Release 4.1     Last change: 18 June 1993                   4



