/*$Id: apgen.h,v 1.21 1997/03/20 14:26:07 pbellino Exp $*/
/*
 *****************************************************************************
 **         (C) Copyright 1993, Xyplex, Inc. All Rights Reserved.           **
 *****************************************************************************
 **                           a p g e n . h                                 **
 *****************************************************************************
 **                                                                         **
 **  Description :  This is the header file for the apgen utility.          **
 **                 It defines the necessary constants and macros.          **
 **                                                                         **
 **  History     :  Who      What                                           **
 **  06//03/93      BJS/GJG  Original                                       **
 **                                                                         **
 *****************************************************************************
 */

/* To avoid duplication, add all constants from TS tree to gen_apgen_consts */

#ifndef apgen_H
#define apgen_H

#include <sys/types.h>
#include <sys/stat.h>
#include "param_data.h"

/*
 ** Externs
 */

extern bits_clear();
extern void PrintPortCharacteristicData();
extern void PrintPortModemRelatedData();
extern void PrintPortInternetData();
extern void PrintPortSessionData();
extern void PrintPortSecurityData();
extern void PrintPortOldMenuData();
extern void PrintPortNestedMenuData();
extern void PrintPortLineData();
extern void PrintPortKerberosData();
extern void PrintPortTelnetData();
extern void PrintPortSlipData();
extern void PrintPortXRemoteData();
extern void PrintPortPPPData();
extern void PrintPortCCLData();
extern void PrintArapPortSegmentData();
extern void PrintPortSecurIdData();
extern void PrintPortControlledPortData();
extern void PrintPortIpxData();
extern void PrintPortRadiusData();
extern void PrintPortExpandedData();

/*
 ** Macros
 */

#define TST_ARRAY_BIT(bit_array, bit_number)    (bit_array[bit_number/(sizeof(bit_array[0]) * 8)] & (1 << (bit_number % (sizeof(bit_array[0]) * 8))))

#define ENA_DIS(x) ((x==DISABLED) ? "DISABLED" :       \
		    (x==ENABLED) ? "ENABLED" :         \
		    "REQUIRED")                        

#define REV_ENA_DIS(x) ((x==DISABLED) ? "ENABLED" :    \
		         "DISABLED")         

#define ENA_DIS_RADIUS(x) ((x==DISABLED) ? "DISABLED" :       \
		    (x==ENABLED) ? "ENABLED" :         \
		    (x==PPP_KERBEROS) ? "KERBEROS" :         \
		    "RADIUS")                        

#define ENA_DIS_RAD(x) ((x==DISABLED) ? "LOCAL DISABLED" :       \
			 (x==ENABLED) ? "LOCAL ENABLED" :         \
			 (x==PPP_KERBEROS) ? "KERBEROS ENABLED" :         \
			 "RADIUS ENABLED")

#define CMD_COMMENT(_cmdcmnt) ((_cmdcmnt == 0) ? "" : "# ")

#define CHAR_STR_NONE(c)                           \
    ((c == '\0') ? "NONE" : SingleCharToString((char *) &c)) 

#define RECORD(num)                                \
    ((num == 0) ? "PRIMARY" : (num == 1) ? "SECONDARY" : "TERTIARY") 

#define HANDLE_PORT_ZERO(_list)                     \
{                                                   \
    if(IsPortZeroOnlyOne(_list))                    \
       {                                            \
       break;                                       \
       }                                            \
    else                                            \
       {                                            \
       bits_clear(_list, PORT_ZERO, PORT_ZERO);    \
       }                                            \
}                                                   \

/*
 ** Misc Constants
 */

#ifndef TRUE
#define TRUE 1
#endif   

#ifndef FALSE
#define FALSE 0
#endif

#define ONE_K                  1024
#define PRINT_ALL_PORTS        99
#define IP_ADDR_SIZE           16
#define END_OPTION             ""
#define NULL_VALUE             0
#define PORT_ZERO              0
#define PORT                   0
#define GROUP                  1
#define ADD_TO_HEAD            0
#define ADD_TO_TAIL            1
#define PPP_ppp_enabled 216
#define PPP_ppp_port_addr 450
#define PPP_ppp_remote_addr 454
#define PPP_pppPapEnabled 458
#define PPP_pppBroadcastEnabled 459
#define PPP_pppActiveEnabled 460
#define PPP_pppVJCompEnabled 461
#define PPP_ppp_rtimer 462
#define PPP_ppp_maxconf 463
#define PPP_ppp_flags 464
#define PPP_ppp_maxfail 465
#define PPP_ppp_maxtries 466
#define PPP_ppp_vjslots 467
#define PPP_ppp_charmap 468
#define PPP_ppp_logging 511
#define PPP_ppp_range_start 512
#define PPP_ppp_range_end 516
#define PPP_ppp_katimeout 520
#define PPP_ppp_katimer 522
#define PPP_ppp_ip_enabled 523
#define CCL_ccl_script 472
#define CCL_modem_audible 505
#define portNumberMX1608 8

/*
 ** Misc Tables
 */

/*
 ** Option information
 **
 ** New options must be added before the END_OPTION
 */

enum optionIndices
{
    ALL_INDEX, ARAP_INDEX, DAEMONS_INDEX, DOMAIN_INDEX, FEATURES_INDEX,
    INTERNET_INDEX, IPX_INDEX, FILTER_INDEX, KERBEROS_INDEX, 
    LINE_EDIT_INDEX, LPD_INDEX, MANAGER_INDEX, MENU_INDEX, NVS_INDEX, 
    PARAMETER_INDEX, PORT_INDEX, PPP_INDEX, RADIUS_INDEX, ROTARY_INDEX, ROUTE_INDEX, 
    SCRIPT_INDEX, SECURID_INDEX, SECURITY_INDEX, SERVER_INDEX, SERVICE_INDEX, SESSION_INDEX, 
    SLIP_INDEX, SNMP_INDEX, TELNET_INDEX, TN3270_INDEX, USAGE_INDEX, 
    VERBOSE_INDEX, XPRINTER_INDEX, XREMOTE_INDEX, END_OPTION_INDEX
	};

/*
 * : means that it may have arguments immediately following the :, or no 
 * arguments for the default
 */
#define KEYWORD_ERROR  9999
#define KEYWORD_USAGE  9998

static char *options[] = 
{
    "all", "arap", "daemons", "domain", "features",
    "ip", "ipx", "filter:", "kerberos", 
    "lineedit", "lpd", "manager", "menu", "nvs", 
    "parameter", "port:", "ppp", "radius", "rotary", "route:", 
    "script", "securid", "security", "server", "service", "session", 
    "slip", "snmp", "telnet", "tn3270", "?", 
    "verbose", "xprinter", "xremote", END_OPTION
	};

/*
 ** The following is the necessary information to generate the
 ** port list information
 */

typedef struct plistnode *PLISTNODE;

struct plistnode {
    PLISTNODE   next;
    char         portList[TBITS_PORT_LIST_SIZE];
    union {
	unsigned int   iValue;
	unsigned short siValue;
	unsigned char  cValue;
	char          *pcValue;
	char          gValue[TBITS_GROUPS_SIZE];
	char          ctrlpValue[MAX_CONTROLLED_LEN + 1];
	char          chr8Value[ 9 ];  /* one byte for null */
	char          ethValue[6];     /* ethernet field */
	} type;
};

typedef struct plist {
    PLISTNODE   head;
    PLISTNODE   tail;
} PLIST;


/*
 ** Different types to help distinguish use in union.
 */

#define INTEGER_VALUE      0 
#define SHORT_INT_VALUE    1
#define CHAR_VALUE         2
#define CHAR_PTR_VALUE     3
#define GROUP_VALUE        4
#define CTRL_PORT_VALUE    5
#define CHAR_EIGHT_VALUE   9          /* One byte for null */
#define ETHERNET_VALUE     6
#define OFFSET_TABLE_END  -1

/*
 ** OFFSET TABLES
 **
 ** Offset tables are used so that a port list may be generated for port 
 ** port information.  There is a table for each grouping (option) of port
 ** information.  Within each table is the offset of the value from the port
 ** table, or arap port table, the type of value that the offset holds, and
 ** the initial version in which the field is supported.
 ** The version numbers exist for each field because while at present there
 ** are all valid starting at the same reviosn, in the future, chances are new
 ** fields will be added that are valid  only after some revision much later on.
 */

typedef struct 
{
    int offset;
    int type;
    unsigned char offsetMajorVersion;   /* Major version field is supported in */
    unsigned char offsetMinorVersion;   /* Minor version field is supported in */
    unsigned char offsetEcoVersion;     /* Eco version field is supported in */
    unsigned char offsetTypeVersion;    /* Release type field is supported in */
    unsigned char offsetPrereleaseVersion; /* Prerelease Version supported in */
    }OFFSET_TABLE;

/*
 ** Defines for version fields in OFFSET_TABLE and also used for version fields
 ** in the INDEX_TABLE.
 */

#define VERSION_DONT_CARE     -1
#define TYPE_VERSION_ALPHA     0
#define TYPE_VERSION_BETA      1
#define TYPE_VERSION_RELEASE   2
#define TYPE_VERSION_SPECIAL   3

/*
 ** LineEdit offset table
 */
static OFFSET_TABLE lineOffsetTable[] = 
{
    { PTCHAR_STR_line_edit_disabled,                            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_backspace,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_forward,       CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_delete,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_end_of_line,   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_beg_of_line,   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_delete_line,   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_delete_beg,    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_prev_line,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_next_line,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_redisplay,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_quoting_char,  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_insert_toggle, CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_rtrn,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_cancel_passwd, CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,            OFFSET_TABLE_END }
};

/*
 ** Slip offset table
 ** This contains slip related information.  New info must be added here, as well as
 ** the routine to print it.
 */

static OFFSET_TABLE slipOffsetTable[] = {
    { PTCHAR_STR_slip_enabled,      CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_slip_port_addr,    INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_slip_remote_addr,  INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_slip_mask,         INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,             OFFSET_TABLE_END }
};

/*
 ** Session offset table
 */
static OFFSET_TABLE sessionOffsetTable[] = {
    { PTCHAR_STR_backward_switch_ext,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_forward_switch_ext,      CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_local_switch_ext,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_default_session_mode,    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_session_limit,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,                   OFFSET_TABLE_END }
};

/*
 ** OLD PPP offset table  DO NOT ADD ANY MORE ITEMS TO THIS TABLE
 ** ADD TO the regular PPP Offset table.
 */
static OFFSET_TABLE oldPppOffsetTable[] = {
    { PPP_ppp_enabled,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_pppActiveEnabled,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_pppPapEnabled,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_pppBroadcastEnabled,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_charmap,             INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_rtimer,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_maxconf,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_maxfail,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_port_addr,           INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_remote_addr,         INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_pppVJCompEnabled,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_vjslots,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_logging,             CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_range_start,         INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_range_end,           INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_katimeout,           SHORT_INT_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_katimer,             CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_ppp_ip_enabled,          CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,                   OFFSET_TABLE_END }
};

/*
 ** PPP offset table
 */
static OFFSET_TABLE pppOffsetTable[] = {
    { PPP_PTCHAR_STR_ppp_enabled,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppActiveEnabled,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppPapEnabled,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppBroadcastEnabled,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_charmap,             INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_rtimer,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_maxconf,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_maxfail,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_port_addr,           INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_remote_addr,         INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppIpMask,         INTEGER_VALUE,
	  6, 0, 0, TYPE_VERSION_SPECIAL, 47 },
    { PPP_PTCHAR_STR_pppVJCompEnabled,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_vjslots,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_logging,             CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_range_start,         INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_range_end,           INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_localrange_start,         INTEGER_VALUE,
	  6, 0, 0, TYPE_VERSION_SPECIAL, 41 },
    { PPP_PTCHAR_STR_ppp_localrange_end,           INTEGER_VALUE,
	  6, 0, 0, TYPE_VERSION_SPECIAL, 41 },
    { PPP_PTCHAR_STR_ppp_katimeout,           SHORT_INT_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_katimer,             CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_ppp_ip_enabled,          CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppMagicNumDisabled,     CHAR_VALUE,
	  6, 0, 0, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PPP_PTCHAR_STR_pppChapEnabled,     CHAR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE }, 
    { PPP_PTCHAR_STR_pppChapChallengeTimer,     CHAR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,                   OFFSET_TABLE_END }
};

/*
 ** Telnet offset table
 */
static OFFSET_TABLE telnetOffsetTable[] = {
    { PTCHAR_STR_telnet_abort_output,         CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_attention,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_binary_mode,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_csi_escape,                  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_default_port,         SHORT_INT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_echo_mode,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_erase_character,      CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_erase_line,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_eor_reflection,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_utTn3270ErrLock,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_interrupt,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_location,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_newline,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_newline_filter,       CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_option_display,       CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_query,                CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_remote,               SHORT_INT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_synchronize,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_TermType,                    CHAR_PTR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_tn3270_device,               CHAR_EIGHT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_tn3270_eor,                  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_tn3270printerport,    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_tn3270_xlat,                 CHAR_EIGHT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_tn3270_xtdattrs,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_transmit,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_idle_time,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_urgentbreak,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnetRs491,                 CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_buff_time,               SHORT_INT_VALUE,
	  5, 3, 1, TYPE_VERSION_SPECIAL, 33 },
    { PTCHAR_STR_tn3270_default_port,               SHORT_INT_VALUE,
	  5, 3, 1, TYPE_VERSION_SPECIAL, 33 },
    { PTCHAR_STR_tn3270_space_insert,               SHORT_INT_VALUE,
      6, 0, 1, TYPE_VERSION_SPECIAL, 11 },
    { PTCHAR_STR_tn3270_type_ahead,                 SHORT_INT_VALUE,
      6, 0, 1, TYPE_VERSION_SPECIAL, 11 },
    { PTCHAR_STR_tn3270_prefixkeymap,               SHORT_INT_VALUE,
	  6, 0, 1, TYPE_VERSION_SPECIAL, 11 },
    { OFFSET_TABLE_END,                       OFFSET_TABLE_END }
};

/*
 ** NestedMenu offset table
 */
static OFFSET_TABLE nestedMenuOffsetTable[] = {
    { PTCHAR_STR_nestedMenus,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE},
    { PTCHAR_STR_nestedMenusTopLevel,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_privilegedNestedMenus,   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,                   OFFSET_TABLE_END }
};

/*
 ** Menu offset table
 */
static OFFSET_TABLE menuOffsetTable[] = {
    { PTCHAR_STR_menu,                CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_privileged_menu,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,               OFFSET_TABLE_END }
};

/*
 ** Xremote offset table
 ** The xdm_host offset must come after the xdm_ip_addr offset
 */
static OFFSET_TABLE xremoteOffsetTable[] = {
    { PTCHAR_STR_xremote,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_xdm_ip_addr,        INTEGER_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_xdm_host,           CHAR_PTR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_xdm_query_type,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,              OFFSET_TABLE_END }
};

/*
 ** Kerberos offset table
 */
static OFFSET_TABLE kerberosOffsetTable[] = {
    { PTCHAR_STR_krb,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** Security offset table
 */
static OFFSET_TABLE securityOffsetTable[] = {
    { PTCHAR_STR_clr_inter_sec_tbl,     CHAR_VALUE,
	  5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_outboundsecurity,     CHAR_VALUE,
	  5, 3, 1, TYPE_VERSION_SPECIAL, 38 },
    { PTCHAR_STR_security,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** Internet offset table
 */
static OFFSET_TABLE internetOffsetTable[] = {
    { PTCHAR_STR_internet_connect,       CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_TCPKeepalive,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_telnet_window_size,     SHORT_INT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,                  OFFSET_TABLE_END }
};

/*
 ** Modem related ioffset table
 */
static OFFSET_TABLE modemRelatedOffsetTable[] = {
    { PTCHAR_STR_access,                    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_input_speed,               CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_character_size,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_parity,                    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_stop_bits,                 CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_autobaud,                  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_flow_control,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_input_flow_enabled,        CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_output_flow_enabled,       CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_modem_control,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dialback_timeout,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dcd_timeout,               CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dialback_enabled,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dialup,                    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dsrlogout,                 CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dsrwait,                   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dtrwait,                   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_password,                  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_idle_timeout,              SHORT_INT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_type_ahead,                SHORT_INT_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_username,                  CHAR_PTR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_local_prompt,              CHAR_PTR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_type,                      CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_port_name,                 CHAR_PTR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_username_filtering,        CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_apd,                       SHORT_INT_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_apd_default_protocol,      SHORT_INT_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_apd_timeout,               CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_apd_noprompt,               CHAR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE }, 

    /* PJB 3/20/97 For "APD AUTHENTICATION INTERACTIVE" parameter. */
    { PTCHAR_STR_apd_security_last,               CHAR_VALUE,
	  6, 0, 2, VERSION_DONT_CARE, VERSION_DONT_CARE },    
   
    { PTCHAR_STR_dialoutProtocol,               CHAR_VALUE,
	  5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_xonTimer,                  CHAR_VALUE,
	  5, 3, 1, TYPE_VERSION_SPECIAL, 38 },    
    { OFFSET_TABLE_END,                     OFFSET_TABLE_END }

};

/*
 ** Characteristics offset table
 */
static OFFSET_TABLE characteristicOffsetTable[] = {
    { PTCHAR_STR_multisessions,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_authorized_groups,       GROUP_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_break_type,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_dedicated_preferred_service + LOCATION_STR_service_name,  
	  CHAR_PTR_VALUE,	  
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_autoconnect,             CHAR_VALUE, 
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_autodedicated,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_autoprompt,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_broadcast,               CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_connect_resume,          CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_cmd_size,                SHORT_INT_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_inactivity,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_interrupts,              CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_limited_view,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_login_duration,          SHORT_INT_VALUE,
	  5, 3, 1, TYPE_VERSION_SPECIAL, 39 },    
    { PTCHAR_STR_loss,                    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_message_codes,           CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_noloss,                  CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_pause,                   CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_queuing,                 CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_resolve_service,         CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_remote_modification,     CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_ring,                    CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_rlogin_transparent_mode, CHAR_VALUE,
	  5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_script_echo,             CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_script_login,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_signal_check,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_verification,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_unix_enabled,            CHAR_VALUE,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { PTCHAR_STR_autoHangup,              CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },    
    { OFFSET_TABLE_END,                   OFFSET_TABLE_END }
};

/*
 ** ARAP offset table
 ** This is added as part of Comm Server 5.2 code
 */
static OFFSET_TABLE arapOffsetTable[] = {
    { ARAP_P_INFO_arap_allowed,              CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { ARAP_P_INFO_arap_zone_access,          CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { ARAP_P_INFO_arap_zone,                 CHAR_PTR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { ARAP_P_INFO_arap_max_connect_time,     INTEGER_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { ARAP_P_INFO_arap_guest_logins_ok,      CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** OLD CCL offset table
 ** This is added as part of Comm Server 5.2 code
 ** DO NOT ADD TO THIS TABLE, ADD TO THE NORMAL CCL OFFSET TABLE
 */
static OFFSET_TABLE oldCclOffsetTable[] = {
    { CCL_ccl_script,       CHAR_PTR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { CCL_modem_audible,    CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** CCL offset table
 ** This is added as part of Comm Server 5.2 code
 */
static OFFSET_TABLE cclOffsetTable[] = {
    { CCL_PTCHAR_STR_ccl_script,       CHAR_PTR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { CCL_PTCHAR_STR_modem_audible,    CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** Securid offset table
 ** This is added as part of Comm Server 5.2 code
 */
static OFFSET_TABLE securidOffsetTable[] = {
    { PTCHAR_STR_SecurID,          CHAR_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** CONTROLLED PORT offset table
 ** This is added as part of Comm Server 5.2 code
 */
static OFFSET_TABLE controlledPortOffsetTable[] = {
    { CONTROLLED_P_INFO_initPort,                 CTRL_PORT_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { CONTROLLED_P_INFO_termPort,                 CTRL_PORT_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { CONTROLLED_P_INFO_initSession,              CTRL_PORT_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { CONTROLLED_P_INFO_termSession,              CTRL_PORT_VALUE,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** RADIUS offset table
 ** This is added as part of Comm Server 6.0.1 code
 */
static OFFSET_TABLE radiusOffsetTable[] = {
    { PTCHAR_STR_UseRadius,          CHAR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PTCHAR_STR_UseRadiusSolicit,          CHAR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
    };

/*
 ** Expanded Port offset table
 ** This is added as part of Comm Server 6.0.1 code
 */
static OFFSET_TABLE expandedPortOffsetTable[] = {
    { PORT_EXPANDED_PTCHR_STR_username_prompt,          CHAR_PTR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { PORT_EXPANDED_PTCHR_STR_password_prompt,          CHAR_PTR_VALUE,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
    };

/*
 ** IPX INTERFACE offset table
 ** This is added as part of Comm Server 5.3 code
 */
static OFFSET_TABLE ipxInterfaceOffsetTable[] = {
    { IPX_IF_STR_Network,                          INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_ConfigState,                      CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_RemoteNode,                       ETHERNET_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_RIPBroadcast,                     CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_SAPBroadcast,                     CHAR_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_RIPTimer,                         INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_SAPTimer,                         INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_RIPDiscardTimeout,                INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { IPX_IF_STR_SAPDiscardTimeout,                INTEGER_VALUE,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { OFFSET_TABLE_END,        OFFSET_TABLE_END }
};

/*
 ** These are the necessary indexes used by the INDEX_TABLE.  These correspond
 ** directly to groupings of port information, and almost always to apgen options
 **/

#define INDEX_END            -1
#define INDEX_ALL            -1
#define INDEX_CHARACTERISTIC  0
#define INDEX_MODEM_RELATED   1
#define INDEX_INTERNET        2
#define INDEX_SESSION         3
#define INDEX_SECURITY        4
#define INDEX_MENU            5
#define INDEX_NESTED_MENU     6
#define INDEX_LINE            7
#define INDEX_KERBEROS        8
#define INDEX_TELNET          9
#define INDEX_SLIP            10
#define INDEX_XREMOTE         11
#define INDEX_PPP             12
#define INDEX_ARAP            13
#define INDEX_CCL             14
#define INDEX_SECURID         15
#define INDEX_CONTROLLED_PORT 16
#define INDEX_IPX_INTERFACE   17
#define INDEX_RADIUS          18
#define INDEX_EXPANDED_CHARACTERISTIC  19
/*
 ** Headers to be printed when port data is.
 */
#define CHARACTERISTIC_HEADER  "Port Characteristic    Information"
#define MODEM_HEADER           "Port Modem and Related Information"
#define INTERNET_HEADER        "Port Internet          Information"
#define SESSION_HEADER         "Port Session           Information"
#define SECURITY_HEADER        "Port Security          Information"
#define OLD_MENU_HEADER        "Port Menu              Information"
#define NESTED_MENU_HEADER     "Port Nested Menu       Information"
#define LINE_HEADER            "Port Line              Information"
#define KERBEROS_HEADER        "Port Kerberos          Information"
#define TELNET_HEADER          "Port Telnet            Information"
#define SLIP_HEADER            "Port Slip              Information"
#define XREMOTE_HEADER         "Port XRemote           Information"
#define PPP_HEADER             "Port PPP               Information"
#define ARAP_HEADER            "Port ARAP              Information"
#define CCL_HEADER             "Port CCL               Information"
#define SECURID_HEADER         "Port Secure ID         Information"
#define CONTROLLED_PORT_HEADER "Port ControlledPort    Information"
#define IPX_INTERFACE_HEADER   "Port IPX               Information"
#define RADIUS_HEADER          "Port Radius            Information"
#define EXPANDED_CHARACTERISTIC_HEADER  "Additional Port Characteristic Information"
/*
 ** portIndexOffsetTable
 **
 ** This table contains information necessary for generating and displaying the
 ** port information.  It conatains all the OFFSET tables, the routine to call
 ** for printing the information after a portlist is generated.  It also
 ** has version information for each offset table.
 ** Yes, Yes there is also version information associated with each field
 ** in the OFFSET_TABLE, but since just about every offset table corresponds 
 ** to an apgen option, we want to be able to tell when a complete new option
 ** is added.  ie. We don't want to have to scan the entire offset table to 
 ** determine that each field should not be printed because they all correspond
 ** to an option that was added after this revision of parameter file.
 */

typedef struct {
    int            index;
    OFFSET_TABLE  *offsetTable;
    void          (*routine)();
    char          *header;
    unsigned char indexMajorVersion;   /* Major version field is supported in */
    unsigned char indexMinorVersion;   /* Minor version field is supported in */
    unsigned char indexEcoVersion;     /* Eco version field is supported in */
    unsigned char indexPrereleaseVersion; /* Prerelease Version supported in */
    unsigned char indexTypeVersion;    /* Release type field is supported in */
    } INDEX_TABLE;
    
static INDEX_TABLE allPortIndexOffsetTable[] = {
    { INDEX_CHARACTERISTIC, characteristicOffsetTable, 
	  PrintPortCharacteristicData, CHARACTERISTIC_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_MODEM_RELATED,  modemRelatedOffsetTable, 
	  PrintPortModemRelatedData, MODEM_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_INTERNET,       internetOffsetTable, 
	  PrintPortInternetData, INTERNET_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_SESSION,        sessionOffsetTable, PrintPortSessionData, 
	  SESSION_HEADER, 
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_SECURITY,       securityOffsetTable,       
     PrintPortSecurityData, SECURITY_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_MENU,           menuOffsetTable,           
     PrintPortOldMenuData, OLD_MENU_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_NESTED_MENU,    nestedMenuOffsetTable,     
     PrintPortNestedMenuData, NESTED_MENU_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_LINE,           lineOffsetTable,           
     PrintPortLineData, LINE_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_KERBEROS,       kerberosOffsetTable,       
     PrintPortKerberosData, KERBEROS_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_TELNET,         telnetOffsetTable,         
     PrintPortTelnetData, TELNET_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_SLIP,           slipOffsetTable,           
     PrintPortSlipData, SLIP_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_XREMOTE,        xremoteOffsetTable,        
     PrintPortXRemoteData, XREMOTE_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_PPP,            pppOffsetTable,            
     PrintPortPPPData, PPP_HEADER,
	  5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_ARAP,            arapOffsetTable,
     PrintArapPortSegmentData, ARAP_HEADER,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_CCL,            cclOffsetTable,
     PrintPortCCLData, CCL_HEADER,
	  5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_SECURID,            securidOffsetTable,
     PrintPortSecurIdData, SECURID_HEADER,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_CONTROLLED_PORT,            controlledPortOffsetTable,
     PrintPortControlledPortData, CONTROLLED_PORT_HEADER,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_IPX_INTERFACE,            ipxInterfaceOffsetTable,
     PrintPortIpxData, IPX_INTERFACE_HEADER,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_RADIUS,                   radiusOffsetTable,
     PrintPortRadiusData, RADIUS_HEADER,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_EXPANDED_CHARACTERISTIC,   expandedPortOffsetTable,
     PrintPortExpandedData, EXPANDED_CHARACTERISTIC_HEADER,
	  6, 0, 1, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_END}
    };

static INDEX_TABLE arapPortIndexOffsetTable[] = {
    { INDEX_ARAP,            arapOffsetTable,
     PrintArapPortSegmentData, ARAP_HEADER,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_CCL,            cclOffsetTable,
     PrintPortCCLData, CCL_HEADER,
	  5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_END}
    };

static INDEX_TABLE ipxIndexOffsetTable[] = {
    { INDEX_IPX_INTERFACE,            ipxInterfaceOffsetTable,
     PrintPortIpxData, IPX_INTERFACE_HEADER,
	  5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_END}
    };

static INDEX_TABLE menuPortIndexOffsetTable[] = {
    { INDEX_MENU,           menuOffsetTable,           
     PrintPortOldMenuData, OLD_MENU_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_NESTED_MENU,    nestedMenuOffsetTable,     
     PrintPortNestedMenuData, NESTED_MENU_HEADER,
	  5, 1, VERSION_DONT_CARE, VERSION_DONT_CARE, VERSION_DONT_CARE },
    { INDEX_END}
    };


/*
 ** These are Some necessary defines that can't be generated by our wonderful 
 ** Shell scripts.  These are necessary to keep forward compatibility 
 ** Through different revisions of the parameter files.
 */

#define ARAP_ZONE_ALL          1
#define ARAP_ZONE_LOCAL        2
#define ARAP_ZONE_NONE         3
#define ARAP_ZONE_NAMED        4

#define MOP_HEADER_SIZE        512
/*
 ** Structure : OLD_SCRIPT_BLOCK
 **    Length : 92
 */
#define OLD_SCRIPT_BLOCK_sizelen 92
#define OLD_SCRIPT_BLOCK_host 0
#define OLD_SCRIPT_BLOCK_path 51


#endif    /* ifdef apgen_H */


