/*$Id: print_param.c,v 1.44 1998/02/19 19:13:06 pbellino Exp $*/
/*
 *****************************************************************************
 **         (C) Copyright 1993, Xyplex, Inc. All Rights Reserved.           **
 *****************************************************************************
 **                     p r i n t _ p a r a m . c                           **
 *****************************************************************************
 **                                                                         **
 **  Description :  This file contains the routines necessary to print the  **
 **                 various parameter file segments.                        **
 **                                                                         **
 **  History     :  Who       When     What                                 **
 **                 BJS/GJG   6/03/93  Original                             **
 **                                                                         **
 *****************************************************************************
 */

#include "apgen.h"

/*
 ** Some necessary routines and variables
 */

extern       void  ClockDate2Text();
extern       void  ClockTime2Text();
extern       void  IpToString();
extern       void  PortListToString();
extern       void  ListToString();
extern       int   ArapSupported();
extern       int   SupportedVersion_5_2();
extern       int   OneMegProduct();
extern       char *PListToString();
extern       char *AlignAndConvertIpAddr();
extern       char *ConvertIpxNodeAddr();
extern       int   GetWord();
extern       unsigned char GetByte();
extern       int   GetDoubleWord();
extern       void  PlistInit();
extern       void  PlistFree();
extern       void  AddPortToPlist();
extern       char *ipxRipFilter[];
extern       char *ipxSapFilter[];
extern       char *ipxAddressFilter[];
extern       char *ipFilter[];
extern       accountingEnabled;
extern       securityEnabled;
extern       snmpEnabled;
extern       pppEnabled;
extern       telnetEnabled;
extern       kerberosEnabled;
extern       kerberos5Enabled;
extern       securIdEnabled;
extern       multiSessionsEnabled;
extern       unixEnabled;
extern       lpdEnabled;
extern       menuEnabled;
extern       nestedMenuEnabled;
extern       tn3270Enabled;
extern       scriptEnabled;
extern       xremoteEnabled;
extern       xprinterEnabled;
extern       arapEnabled;
extern       controlledPortsEnabled;
extern       ipxEnabled;
extern       apdEnabled;
extern       ipxFilteringEnabled;
extern       ipxInterfaceParamsSeen;
extern       ipFilteringEnabled;
extern       radiusEnabled;
extern       latEnabled;
extern    char      portXmitBuff[TBITS_PORT_LIST_SIZE];
extern    char      portXmitIdle[TBITS_PORT_LIST_SIZE];		
extern       initPortArrays;	
extern       char *SingleCharToString();
extern       int portNumber;
extern       loadTable[];
extern       portTable[];
extern       char *softwareVersion;
extern unsigned char    SoftwareVersionMajor;
extern unsigned char    SoftwareVersionMinor;
extern unsigned char    SoftwareVersionEco;
extern unsigned char    SoftwareVersionType;
extern unsigned char    SoftwareVersionPrerelease;
extern unsigned char    SoftwareProduct;
extern unsigned int     HardwareType;
void         PrintPortNestedMenuData();
void         PrintPortXRemoteData();
void         PrintPortPPPData();
void         PrintPortOldPPPData();
void         PrintPortTelnetData();
void         PrintPortLineData();
void         PrintPortSlipData();
void         PrintPortSessionData();
void         PrintPortPreferredServiceData();
void         PrintPortControlledPortData();
void         PrintPortRadiusData();
void         PrintPortExpandedData();
		
void         PrintServerIpxData();
void         PrintServerIpxStaticRouteData();
void         PrintServerIpxStaticServiceData();


/*
 ** EchoHeader ()
 */

void EchoHeader( header )
     char *header;
{
    printf( "#\n#echo     %s\n#\n", header );
}

/*
 ** PrintHeader()
 */

void PrintHeader( header )
     char *header;
{
    printf( "#\n#         %s\n#\n", header );
}

/*
 ** PrintCommentHeader()
 */

void PrintCommentHeader( yes, header)
     int   yes;
     char *header;
{
    if(yes)
	{
	printf("#  %s is not enabled, commands are commented out\n#\n", header);
	}
}

/*
 ** PrintParamHeader()
 */
    
void  PrintParamHeader( data )
     unsigned char     *data;
     
{
    static char    version_char[5] = "AB.S";
    char           dateString[12], timeString[12];
    int            softwareType, temp, version;
    short int      storedFormat, oldestFormat;

    /*
     ** copy any data element > 1 byte into aligned memory.
     */

    temp = GetDoubleWord( (char *)&data[PARAM_LOAD_STR_date] );
    ClockDate2Text( temp, dateString );

    temp = GetDoubleWord( (char *)&data[PARAM_LOAD_STR_time] );
    ClockTime2Text( temp>>8, timeString );

    softwareType = GetDoubleWord((char *)&data[PARAM_LOAD_STR_software_type]);

    version = GetDoubleWord( (char *)&data[PARAM_LOAD_STR_version]);

    storedFormat = GetWord( (char *)&data[PARAM_LOAD_STR_stored_format]); 

    oldestFormat = GetWord( (char *)&data[PARAM_LOAD_STR_oldest_format]);
    
    /*
     ** Print out what we know.
     */

    printf( "#control_script\n\n" );
    printf( "#privileged\n\n" );
    printf( "#\n" );
    printf( "#   APGEN %s\n", softwareVersion);
    printf( "#\n" );    
    printf( "#   Parameter File Header\n" );
    printf( "#\n" );
    printf( "#  Version              : 0x%0X\n", version );
    printf( "#  Date                 : %s\n", dateString );
    printf( "#  Time                 : %s\n", timeString );
    printf( "#  Parameter Load Type  : %d\n", 
	   data[PARAM_LOAD_STR_differential_hours] );
    printf( "#  Compressed           : %s\n", 
	   data[PARAM_LOAD_STR_differential_minutes] ? "Yes" : "No" );
    printf( "#  Software Type        : %d\n", softwareType );
    printf( "#  Stored Format        : %u\n", storedFormat );
    printf( "#  Oldest Format        : %u\n", oldestFormat );

    HardwareType = GetWord((char *) &data[PARAM_LOAD_STR_hardware_type]);
    printf( "#  Hardware Type        : %d\n", HardwareType);

    printf( "#  Software Version     : ");

    SoftwareVersionMajor = data[PARAM_LOAD_STR_software_version_major];
    SoftwareVersionMinor = data[PARAM_LOAD_STR_software_version_minor];
    SoftwareVersionEco = data[PARAM_LOAD_STR_software_version_eco];
    SoftwareVersionType = data[PARAM_LOAD_STR_software_version_type];
    SoftwareVersionPrerelease = data[PARAM_LOAD_STR_software_version_prerelease];
    SoftwareProduct = data[PARAM_LOAD_STR_software_product];

    if (data[PARAM_LOAD_STR_software_version_eco])
        {
        printf( "V%1u.%1u.%1u",
               data[PARAM_LOAD_STR_software_version_major],
               data[PARAM_LOAD_STR_software_version_minor],
               data[PARAM_LOAD_STR_software_version_eco] );
        }
    else
        {
        printf( "V%1u.%1u",
               data[PARAM_LOAD_STR_software_version_major],
               data[PARAM_LOAD_STR_software_version_minor] );
        }
    if (data[PARAM_LOAD_STR_software_version_type]
        != SOFTWARE_VERSION_TYPE_RELEASED )
        {
        printf( "%1c%1u",
               version_char[data[PARAM_LOAD_STR_software_version_type]],
               data[PARAM_LOAD_STR_software_version_prerelease] );
        }
    printf( "\n");
    printf( "#  Product              : %s\n",
           (data[PARAM_LOAD_STR_software_product] == PRODUCT_COMM_SERVER) ?
	   "Comm Server" : 
       (data[PARAM_LOAD_STR_software_product] == PRODUCT_COMM_SERVER_ONE_MEG) ?
	   "Comm Server - One Megabyte" : "");

    if (VersionLater(6, 0,3, TYPE_VERSION_SPECIAL, 1))
	{
	printf( "#\n#  WARNING: This version of parameter file is newer than the version\n");
	printf( "#  that APGEN supports.  The results generated may not be valid.\n#\n");
	}
    
    printf( "#\n#############################################################\n");
    }

/*
 ** PrintLpdParams()
 ** 
 ** LPD is not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintLpdParams( data )
     unsigned char    *data;
{
    static unsigned int  header = TRUE;
    char          portList[60];
    
    /*
     ** LPD is not supported on one meg Comm server products.
     */

    if (OneMegProduct())
	{
	return;
	}
    
    if (data[LPD_PARAM_STR_name] != '\0')
	{
	if (header)
	    {
	    header = FALSE;
	    EchoHeader( "LPD Data" );
	    if (!unixEnabled)
		{
		PrintCommentHeader(!unixEnabled, "ULI");
		}
	    else if (!lpdEnabled)
		{
		PrintCommentHeader(!lpdEnabled, "LPD");		
		}
	    }

	PortListToString( &data[LPD_PARAM_STR_ports], portList );
	if (strlen(portList) > 0)
	    {
	    /*
	     ** There is a port list to print.
	     */
	    if (VersionLaterOrEqual( 6, 0, 3, TYPE_VERSION_SPECIAL, 9))
		{
		  printf("%sDEFINE SERVER LPD QUEUE \"%s\" PORT %s %s LFCR %s FF %s BYPASS %s\n", 
			 CMD_COMMENT((!unixEnabled || !lpdEnabled)),
			 (char *)&data[LPD_PARAM_STR_name], 
			 portList,
			 ENA_DIS( data[LPD_PARAM_STR_enabled] ),
			 ENA_DIS( data[LPD_PARAM_STR_lfFilter] ),
			 (data[LPD_PARAM_STR_formfeed] == FORMFEED_BEFORE) ? "BEFORE" :
			 (data[LPD_PARAM_STR_formfeed] == FORMFEED_AFTER) ? "AFTER" :
			 "NONE",
			 ENA_DIS( data[LPD_PARAM_STR_bypass]));
		}
	    else
	        {
		  printf("%sDEFINE SERVER LPD QUEUE \"%s\" PORT %s %s LFCR %s FF %s\n", 
			 CMD_COMMENT((!unixEnabled || !lpdEnabled)),
			 (char *)&data[LPD_PARAM_STR_name], 
			 portList,
			 ENA_DIS( data[LPD_PARAM_STR_enabled] ),
			 ENA_DIS( data[LPD_PARAM_STR_lfFilter] ),
			 (data[LPD_PARAM_STR_formfeed] == FORMFEED_BEFORE) ? "BEFORE" :
			 (data[LPD_PARAM_STR_formfeed] == FORMFEED_AFTER) ? "AFTER" :
			 "NONE");
	       }
	   }
	else
	    {
	    /*
	     ** There is no port info to print, let's print out the
	     ** Queue and the LFCR
	     */
	    printf("%sDEFINE SERVER LPD QUEUE \"%s\" %s\n", 
		   CMD_COMMENT((!unixEnabled || !lpdEnabled)),
		   (char *)&data[LPD_PARAM_STR_name],
		   ENA_DIS( data[LPD_PARAM_STR_enabled]) );
	    printf("%sDEFINE SERVER LPD QUEUE \"%s\" LFCR %s\n", 
		   CMD_COMMENT((!unixEnabled || !lpdEnabled)),
		   (char *)&data[LPD_PARAM_STR_name], 
		   ENA_DIS( data[LPD_PARAM_STR_lfFilter]));
	    if (VersionLaterOrEqual( 5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
				    VERSION_DONT_CARE))
		{
		printf("%sDEFINE SERVER LPD QUEUE \"%s\" FF %s\n",
		       CMD_COMMENT((!unixEnabled || !lpdEnabled)),
		       (char *)&data[LPD_PARAM_STR_name],
		       (data[LPD_PARAM_STR_formfeed] == FORMFEED_BEFORE) ? "BEFORE" :
		       (data[LPD_PARAM_STR_formfeed] == FORMFEED_AFTER) ? "AFTER" :
		       "NONE");
		}	
	    if (VersionLaterOrEqual( 6, 0, 3, TYPE_VERSION_SPECIAL, 9))
		{
		printf("%sDEFINE SERVER LPD QUEUE \"%s\" BYPASS %s\n",
		       CMD_COMMENT((!unixEnabled || !lpdEnabled)),
		       (char *)&data[LPD_PARAM_STR_name],
		       ENA_DIS(data[LPD_PARAM_STR_bypass]));
		}			
	    }
	}
    }

/*
 ** PrintDomainParams()
 */

void PrintDomainParams( domain )
     unsigned char  *domain;
{
    static int headerPrinted = FALSE;
    char       ipString[IP_ADDR_SIZE];
    int        ipAddr;
    
    ipAddr = GetDoubleWord((char *)&domain[DOMAIN_PARAM_STR_ip_addr]);
	
    if(ipAddr != 0)            /* this means there is a valid entry */
	{
	if(headerPrinted == FALSE)
	    {
	    headerPrinted = TRUE;
	    EchoHeader("Domain Data");
	    PrintCommentHeader(!telnetEnabled, "Telnet");
	    }

	IpToString( ipAddr, ipString );
	printf("%sDEFINE SERVER INTERNET DOMAIN %s %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       (char *)&domain[DOMAIN_PARAM_STR_name], ipString );
	}
}

/*
 ** SetServerEnableFlags()
 **
 ** These are the server server flags that reside in the SRCHARtr_STR and
 ** tell us what protocols are enabled on the server.
 */

void SetServerEnableFlags( data )
     unsigned char *data;
{
    scriptEnabled = TRUE;
    
    if (data[SRCHAR_STR_tn3270_on] == ENABLED)
	{
	tn3270Enabled = TRUE;
	}
    if (data[SRCHAR_STR_snmp_enabled] == ENABLED)
	{
	snmpEnabled = TRUE;
	}
    if (!data[SRCHAR_STR_internet_security_disabled] == ENABLED)
	{
	securityEnabled = TRUE;
	}
    if (!data[SRCHAR_STR_menu_disabled] == ENABLED)
	{
	menuEnabled = TRUE;
	}
    if (!data[SRCHAR_STR_telnet_disabled])
	{
	telnetEnabled = TRUE;
	}
    if (GetWord((char *) &data[SRCHAR_STR_acct_size]) > 0)
	{
	accountingEnabled = TRUE;
	}
    if (!data[SRCHAR_STR_multisessions_disabled])
	{
	multiSessionsEnabled = TRUE;
	}
    if (data[SRCHAR_STR_kerberos_enabled] == ENABLED)
	{
	kerberosEnabled = TRUE;
	}
    if (data[SRCHAR_STR_kerberos5_enabled] == ENABLED)
	{
	kerberos5Enabled = TRUE;
	}
    if (data[SRCHAR_STR_lat_disabled] == DISABLED)
	{
	latEnabled = TRUE;
	}

    /* 
     ** There are certain features that are not supported on the ONE MB 
     ** Comm Server code these are.
     */
    if (!OneMegProduct())
	{
	if (data[SRCHAR_STR_xprinter_enabled] == ENABLED)
	    {
	    xprinterEnabled = TRUE;
	    }
	if (GetDoubleWord((char *) &data[SRCHAR_STR_nestedMenusSize]) != 0)
	    {
	    nestedMenuEnabled = TRUE;
	    }
	if (data[SRCHAR_STR_ppp_enabled])
	    {
	    pppEnabled = TRUE;
	    }
	if (data[SRCHAR_STR_xremote_enabled] == ENABLED)
	    {
	    xremoteEnabled = TRUE;
	    }
	if (data[SRCHAR_STR_unix_enabled] == ENABLED)
	    {
	    unixEnabled = TRUE;
	    }
	if (data[SRCHAR_STR_lpd_enabled] == ENABLED)
	    {
	    lpdEnabled = TRUE;
	    }
	if (ArapSupported())
	    {
	    /*
	     ** Arap must be supported before we set any associated fields
	     */
	    if (data[SRCHAR_STR_arap_enabled] == ENABLED)
		{
		arapEnabled = TRUE;
		}
	    } /* End if Arap is supported */
	if (VersionLaterOrEqual( 5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE))
	    {
	    if (data[SRCHAR_STR_SecurID_enabled] == ENABLED)
		{
		securIdEnabled = TRUE;
		}
	    }
	if (VersionLaterOrEqual( 5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE))
	    {
	    if (data[SRCHAR_STR_controlledPorts] == ENABLED)
		{
		controlledPortsEnabled = TRUE;
		}
	    }
	if (VersionLaterOrEqual( 5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE))
	    {
	    if (data[SRCHAR_STR_ipxRouting_enabled] == ENABLED)
		{
		ipxEnabled = TRUE;
		}
	    if (data[SRCHAR_STR_ipxFiltering_enabled] == ENABLED)
		{
		ipxFilteringEnabled = TRUE;
		}
	    if (data[SRCHAR_STR_ipFiltering_enabled] == ENABLED)
		{
		ipFilteringEnabled = TRUE;
		}
	    if (data[SRCHAR_STR_apd_enabled] == ENABLED)
		{
		apdEnabled = TRUE;
		}

	    }

        if (VersionLaterOrEqual( 6, 0, 1, VERSION_DONT_CARE,
		                VERSION_DONT_CARE))
	    {
	    if (data[SRCHAR_STR_RadiusEnabled] == ENABLED)
		{
		radiusEnabled = TRUE;
		}
	    }

	} /* End if not a One megabyte product() */
	
}

/*
 ** PrintServerParams()
 */

void PrintServerParams( data )
     unsigned char *data;
{
    int     ipAddr;
    char    ipString[IP_ADDR_SIZE], dateString[12], 
            groupList[TBITS_GROUPS_SIZE*8*5];
    int     doubleWord,singleWord, loop;
    char    oneByte;
    
    EchoHeader( "Server Data" );

/************* E n a b l e d   C h a r a c t e r i s t i c s  *************/    
    /* PJB 3/19/97 Added rotary RoundRobin param. */ 
    printf( "DEFINE SERVER ROTARY ROUNDROBIN %s\n", 
	   ENA_DIS( !data[SRCHAR_STR_RotaryRoundRobin]));

    printf( "DEFINE SERVER ANNOUNCEMENTS %s\n", 
	   ENA_DIS( data[SRCHAR_STR_announcements]));

    printf( "DEFINE SERVER BROADCAST %s\n", 
	   ENA_DIS( data[SRCHAR_STR_broadcast] ));

    printf( "DEFINE SERVER CIRCUIT %d\n", data[SRCHAR_STR_circuit_timer] );

    printf( "DEFINE SERVER CONSOLE %d\n", data[SRCHAR_STR_console_port] );

    if (!OneMegProduct())
	{
	/*
	 ** The VERBOSE command is not supported in one megabyte code.
	 */
	printf( "%sDEFINE SERVER VERBOSE ACCOUNTING %s\n",
		CMD_COMMENT(!accountingEnabled),
	       ENA_DIS( data[SRCHAR_STR_verbose_accounting] ));
    
	printf( "%sDEFINE SERVER VERBOSE PRIORITY %d LOG FACILITY %s", 
		CMD_COMMENT(!accountingEnabled),
	       data[SRCHAR_STR_priority_level],
	       data[SRCHAR_STR_syslogd_facility_mask] == 8 ? "USER" : "LOCAL");
	/*
	 ** If we're LOCAL, then we need to show the log facility.
	 */
	if (data[SRCHAR_STR_syslogd_facility_mask] != 8)
	    {
	    printf(" %d", data[SRCHAR_STR_syslogd_facility_mask]);
	    }
	printf("\n");

	/*
	 ** The RELIABLE ACCOUNTING command is not supported in one megabyte code.
	 */

    	if (VersionLaterOrEqual(5, 3, 1, TYPE_VERSION_SPECIAL, 28))
    		printf( "%sDEFINE SERVER RELIABLE ACCOUNTING %s\n", 
			CMD_COMMENT(!accountingEnabled),
	   		ENA_DIS( data[SRCHAR_STR_reliableAcct] ));
	}
    

    printf( "DEFINE SERVER TEXTPOOL %d\n", 
	   GetDoubleWord( (char *)&data[SRCHAR_STR_new_txtpool_size] ));

    printf( "DEFINE SERVER LOCK %s\n", ENA_DIS( data[SRCHAR_STR_lock] ));

    printf( "DEFINE SERVER IDENTIFICATION \"%s\"\n", 
	   (char *)&data[SRCHAR_STR_identification] );
    
    printf( "DEFINE SERVER IDENTIFICATION SIZE %d\n", 
	   data[SRCHAR_STR_ident_size] );

    printf( "DEFINE SERVER DUMP %s\n", ENA_DIS( data[SRCHAR_STR_dump] ));

    printf( "DEFINE SERVER SOFTWARE %s\n", (char *)&data[SRCHAR_STR_software] );

    printf( "DEFINE SERVER WELCOME \"%s\"\n", (char *)&data[SRCHAR_STR_welcome] );
    
    printf( "DEFINE SERVER PACKET COUNT %d\n", 
	   GetWord( (char *)&data[SRCHAR_STR_packet_count] ));

    printf( "DEFINE SERVER NAME %s\n", (char *)&data[SRCHAR_STR_name] );
    
    printf( "DEFINE SERVER NUMBER %d\n", 
	   GetWord( (char *)&data[SRCHAR_STR_number] ));

    if ((!OneMegProduct()) && (VersionLaterOrEqual(6, 0, 0, 
	TYPE_VERSION_SPECIAL, 48)))
    {
        printf( "DEFINE SERVER OVERRIDE INTERNAL ADDRESS %s\n", 
	   ENA_DIS( data[SRCHAR_STR_overrideDefinedAddress]));
    }

    printf( "# DEFINE SERVER PRIVILEGED PASSWORD <secret>\n" );

    printf( "# DEFINE SERVER LOGIN PASSWORD <secret>\n");
    
    printf( "# DEFINE SERVER MAINTENANCE PASSWORD <secret>\n");
    
    GroupListToString((char *) &data[SRCHAR_STR_service_groups], groupList);
    if (groupList[0] != '\0')
	{
	printf("DEFINE SERVER SERVICE GROUPS %s ENABLED\n", groupList);
	}
    
    printf("DEFINE SERVER LAT SOLICITS %s\n",
	   ENA_DIS( data[SRCHAR_STR_latSolicits]));

    if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE))
    {
    	printf("DEFINE SERVER LAT IMMEDIATE ACK %s\n",
		ENA_DIS( data[SRCHAR_STR_lat_immediate_ack]));
    }

    singleWord = GetWord((char *)&data[SRCHAR_STR_timezone]);
    printf("DEFINE SERVER TIMEZONE %02u:%02u\n",
	   (singleWord >> 8) & 0xFF, 
	   singleWord & 0xFF);

    if ((!OneMegProduct()) && (VersionLaterOrEqual(6, 0, 0, 
	TYPE_VERSION_SPECIAL, 27)))
    {
    printf("%sDEFINE SERVER TIME SERVER %s %s\n",
	CMD_COMMENT(!telnetEnabled),
	ENA_DIS( data[SRCHAR_STR_timeServerStatus]),
	   data[SRCHAR_STR_timeServerStatus] ? 
	AlignAndConvertIpAddr( &data[SRCHAR_STR_timeServer] ) : "" );        
    }
	
    /* Eventlog is not supported
     * printf("DEFINE SERVER EVENTLOG %s\n",
     * ENA_DIS( data[SRCHAR_STR_eventlog_disabled]));
     */
/*
    doubleWord = GetDoubleWord((char *) &data[SRCHAR_STR_date]);
    ClockDate2Text( doubleWord, dateString);
EchoHeader("Date can't be modified by a define");
    printf("DEFINE SERVER DATE %s\n", dateString);
*/
    printf("DEFINE SERVER REPORT ERRORS %s\n",
	   ENA_DIS( data[SRCHAR_STR_report_errors]));

    printf("DEFINE SERVER PURGE GROUP %s\n",
	   ENA_DIS( data[SRCHAR_STR_purge_group]));

    printf("DEFINE SERVER PURGE NODE  %s\n",
	   ENA_DIS( !data[SRCHAR_STR_purge_node]));

    printf("DEFINE SERVER CONSOLE LOGOUT %s\n",
	   ENA_DIS( data[SRCHAR_STR_console_logout]));

    printf("DEFINE SERVER CHANGE %s\n",
	   ENA_DIS( data[SRCHAR_STR_change]));

    printf("DEFINE SERVER LOGIN PROMPT \"%s\"\n",
	   (char *) &data[SRCHAR_STR_login_prompt]);

    printf("%sDEFINE SERVER TN3270 PORT KEYMAPS %s\n",
	   CMD_COMMENT(!tn3270Enabled),
	   ENA_DIS( data[SRCHAR_STR_tn3270_keymaps]));

    printf("DEFINE SERVER HEARTBEAT %s\n",
	   ENA_DIS( data[SRCHAR_STR_heartbeat]));

    if (!OneMegProduct())
	{
	if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("%sDEFINE SERVER XPRINTER DATA TIMEOUT %d\n",
		   CMD_COMMENT(!xprinterEnabled),
		   GetWord((char *) &data[SRCHAR_STR_ipx_xprinter_timeout]));
	    }
	if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    oneByte = GetByte((char *) &data[SRCHAR_STR_data_send_delay]);
	    if (oneByte == 0)
		printf("DEFINE SERVER USERDATA DELAY NONE\n");
	    else 
		printf("DEFINE SERVER USERDATA DELAY %d\n",
		       oneByte);

	    }	    
	}


/***********************  L i m i t s         *****************************/    
    EchoHeader( " Limits");
    
    printf( "DEFINE SERVER QUEUE   %d\n", data[SRCHAR_STR_queue_limit] );
    printf( "DEFINE SERVER SESSION %d\n", data[SRCHAR_STR_session_limit] );
    printf( "DEFINE SERVER NODE    %d\n", 
	   GetWord((char *) &data[SRCHAR_STR_node_limit]));
    printf( "DEFINE SERVER PASSWORD LIMIT %d\n",data[SRCHAR_STR_password_limit] );
    printf( "DEFINE SERVER RETRANSMIT %d\n", data[SRCHAR_STR_retransmition_limit]);
    printf( "DEFINE SERVER ACCOUNTING ENTRIES %d\n",
	   GetWord( (char *)&data[SRCHAR_STR_acct_size] ));
    
    
/***********************  T i m e r s         *****************************/    

    EchoHeader( " Timers" );
    
    printf( "DEFINE SERVER KEEPALIVE  %d\n", data[SRCHAR_STR_keepalive_timer] );
    printf( "DEFINE SERVER INACTIVITY %d\n", 
	    GetWord( (char *)&data[SRCHAR_STR_inactivity_timer]) );
    printf( "DEFINE SERVER MULTICAST  %d\n", data[SRCHAR_STR_multicast_timer] );
    }

/*
 ** PrintServerMenuData()
 */

void PrintServerMenuData( data )
     char *data;
{
    EchoHeader("Server Menu Information");
    printf( "DEFINE SERVER MENU %s\n", ENA_DIS( !data[SRCHAR_STR_menu_disabled] ));

    if (!OneMegProduct())
	{
	/*
	 ** Nested Menus is not supported in the one megabyte space.
	 */
	printf( "DEFINE SERVER NESTED MENU SIZE %d\n", 
	       GetDoubleWord( (char *)&data[SRCHAR_STR_nestedMenusSize] ));
    
	printf( "%sDEFINE SERVER NESTED MENU NAME \"%s\"\n", 
		   CMD_COMMENT(!nestedMenuEnabled),
	       (char *)&data[SRCHAR_STR_nestedMenusName] );
	}
    
}

/*
 ** PrintServerPPPData()
 ** PPP is not supported by One meg products.
 */

void PrintServerPPPData( data )
     char *data;
{
    if (OneMegProduct())
	{
	/*
	 ** No PPP information is supported in the One Meg code
	 */
	return;
	}
    
    EchoHeader("Server PPP Information");
    printf( "# DEFINE SERVER PPP PAP REMOTE PASSWORD <secret>\n");
    if (VersionLaterOrEqual(6, 0, 1, VERSION_DONT_CARE,
			    VERSION_DONT_CARE))
        printf( "# DEFINE SERVER PPP CHAP REMOTE PASSWORD <secret>\n");
}

/*
 ** PrintServerKerberosData()
 */

void PrintServerKerberosData( data )
     char *data;
{
    EchoHeader("Server Kerberos Information");
    printf("%sDEFINE SERVER KERBEROS SECURITY %s\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   (data[SRCHAR_STR_kerberos_security]) ? "LOGIN" : "NONE");

}

/*
 ** PrintServerFeaturesData()
 */

void PrintServerFeaturesData( data )
     char *data;
{
/***********************  P r o t o c o l s   *****************************/

    EchoHeader( "Server Features" );

    printf("# DEFINE SERVER PROTOCOL TELNET   %s LAT %s\n",
	   ENA_DIS( !data[SRCHAR_STR_telnet_disabled] ),
	   ENA_DIS( !data[SRCHAR_STR_lat_disabled] ));	   

    if (!OneMegProduct())
	{
	/*
	 ** This protocol feature is not supported in One meg images.
	 */
	printf("# DEFINE SERVER PROTOCOL MX800    %s\n",
	       ENA_DIS( data[SRCHAR_STR_mx800Unlocked] ));
	}

    if (!OneMegProduct())
	{
	/*
	 ** This protocol feature is not supported in One meg images.
	 */
	printf("DEFINE SERVER PROTOCOL PPP      %s\n",
	       ENA_DIS( data[SRCHAR_STR_ppp_enabled] ));
	}
    
    printf("# DEFINE SERVER PROTOCOL SNMP     %s\n",
	   ENA_DIS( data[SRCHAR_STR_snmp_enabled] ));
    
    printf("# DEFINE SERVER PROTOCOL TN3270   %s\n",
	   ENA_DIS( data[SRCHAR_STR_tn3270_on] ));

    if (!OneMegProduct())
	{
	/*
	 ** XREMOTE and PPP are not supported in One meg images.
	 */
	printf("# DEFINE SERVER PROTOCOL XPRINTER %s\n",
	       ENA_DIS( data[SRCHAR_STR_xprinter_enabled] ));    

	printf("# DEFINE SERVER PROTOCOL XREMOTE  %s\n",
	       ENA_DIS( data[SRCHAR_STR_xremote_enabled] ));
	}

    if (!OneMegProduct())
	{
	/*
	 ** ARAP is not supported in One meg images.
	 */

	if (ArapSupported())
	    {
	    /*
	     ** Arap must be supported before we set any associated fields
	     */
	    printf("# DEFINE SERVER PROTOCOL ARAP %s\n",
		   ENA_DIS( data[SRCHAR_STR_arap_enabled]));
	    }
	}
    if (VersionLaterOrEqual(5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
			    VERSION_DONT_CARE) && !OneMegProduct())
	{
	printf("# DEFINE SERVER PROTOCOL IPX %s\n",
	       ENA_DIS(data[SRCHAR_STR_ipxRouting_enabled]));
	}
    printf("DEFINE SERVER RLOGIN            %s\n",
	   ENA_DIS( !data[SRCHAR_STR_rlogin_enabled] ));  /* Reversed enabled! */
    if (!OneMegProduct())
	{
	/*
	 ** This protocol feature is not supported in One meg images.
	 */
	if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("%sDEFINE SERVER IPX PROTOCOL %s\n",
		   CMD_COMMENT(!(ipxEnabled || xprinterEnabled)),
		   (data[SRCHAR_STR_ipx_ethernet]) ? "ETHERNET" :
		   (data[SRCHAR_STR_ipx_mac]) ? "MAC" :
		   (data[SRCHAR_STR_ipx_mac_802_2]) ? "IEEE802_2" :
		   (data[SRCHAR_STR_ipx_mac_802_2_snap]) ? "IEEESNAP" : 
		   "ETHERNET");
	    }
	else
	    {
	    /*
	     ** Pre V5-3-1
	     */
	    if (data[SRCHAR_STR_ipx_ethernet])
		{
		printf("%sDEFINE SERVER IPX PROTOCOL ETHERNET %s\n",
		       CMD_COMMENT(!(ipxEnabled || xprinterEnabled)),
		       ENA_DIS( data[SRCHAR_STR_ipx_ethernet] ));
		}
	    if (data[SRCHAR_STR_ipx_mac])
		{
		printf( "%sDEFINE SERVER IPX PROTOCOL MAC  %s\n",
		       CMD_COMMENT(!(ipxEnabled || xprinterEnabled)),
		       ENA_DIS( data[SRCHAR_STR_ipx_mac] ));
		}
	    }
	}

    if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
			    VERSION_DONT_CARE) && !OneMegProduct())
	{
	if (kerberosEnabled)
	    {
	    printf("DEFINE SERVER KERBEROS %s\n",
		   ENA_DIS( data[SRCHAR_STR_kerberos_enabled]));
	    }
	if (kerberos5Enabled)
	    {
	    printf("DEFINE SERVER KERBEROS FIVE %s\n",
		   ENA_DIS( data[SRCHAR_STR_kerberos5_enabled]));
	    }
	}
    else
	{
	printf("DEFINE SERVER KERBEROS %s\n",
	       ENA_DIS( data[SRCHAR_STR_kerberos_enabled]));
	}

/***********************  F e a t u r e s     *****************************/
    
    EchoHeader( " Features" );

    if (!OneMegProduct())
	{
	/*
	 ** This protocol feature is not supported in One meg images.
	 */
	printf( "DEFINE SERVER ULI %s\n", ENA_DIS( data[SRCHAR_STR_unix_enabled] ));
	}

    printf( "DEFINE SERVER HELP %s\n", ENA_DIS( !data[SRCHAR_STR_help_disabled] ));
    printf( "# DEFINE SERVER MULTISESSIONS %s\n", 
	   ENA_DIS( !data[SRCHAR_STR_multisessions_disabled] ));
    
    printf("DEFINE SERVER INTERNET SECURITY %s\n",
	   ENA_DIS(!data[SRCHAR_STR_internet_security_disabled]));

    if (!OneMegProduct())
	{
	if (VersionLaterOrEqual(5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("DEFINE SERVER SECURID %s\n",
		   ENA_DIS(data[SRCHAR_STR_SecurID_enabled]));
	    }

	if (VersionLaterOrEqual(5, 2, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("DEFINE SERVER CONTROLLED PORTS %s\n",
		   ENA_DIS(data[SRCHAR_STR_controlledPorts]));
	    }
	if (VersionLaterOrEqual(5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("%sDEFINE SERVER IPX FILTERING %s\n",
		   CMD_COMMENT(!ipxEnabled),
		   ENA_DIS(data[SRCHAR_STR_ipxFiltering_enabled]));
	    printf("DEFINE SERVER IP FILTERING %s\n",
		   ENA_DIS(data[SRCHAR_STR_ipFiltering_enabled]));
	    printf("DEFINE SERVER APD %s\n",
		   ENA_DIS(data[SRCHAR_STR_apd_enabled]));
	    }
	if (VersionLaterOrEqual(6, 0, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE) && !OneMegProduct())
	    {
	    printf("DEFINE SERVER RADIUS %s\n",
		   ENA_DIS(data[SRCHAR_STR_RadiusEnabled]));
	    }

	} /* End if not a one meg product */
}

/*
 ** PrintServerInternetData()
 */

void PrintServerInternetData( data )
     char *data;
{
/***********************  I P   D a t a       *****************************/

    EchoHeader( "IP Data" );

    printf( "%sDEFINE SERVER INTERNET ADDRESS                   %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_addr] ) );

    printf( "%sDEFINE SERVER INTERNET BROADCAST ADDRESS         %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_broadcast_addr] ));

    printf( "%sDEFINE SERVER INTERNET PRIMARY   DOMAIN  ADDRESS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_pdomain_addr] ));

    printf( "%sDEFINE SERVER INTERNET SECONDARY DOMAIN  ADDRESS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_sdomain_addr] ));

    printf( "%sDEFINE SERVER INTERNET PRIMARY   GATEWAY ADDRESS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_pgateway_addr] ));

    printf( "%sDEFINE SERVER INTERNET SECONDARY GATEWAY ADDRESS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_sgateway_addr] ));

    if ((VersionLaterOrEqual(5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
			    VERSION_DONT_CARE)) && !OneMegProduct())
	{
	printf("%sDEFINE SERVER INTERNET GATEWAY TIMEOUT %u\n",
	       CMD_COMMENT(!telnetEnabled),
	       GetWord((char *) &data[SRCHAR_STR_gateway_timeout]));
	}

    printf( "%sDEFINE SERVER INTERNET SUBNET MASK               %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   AlignAndConvertIpAddr( &data[SRCHAR_STR_ip_subnet_mask] ));

    printf( "%sDEFINE SERVER INTERNET SUBNET MASK AUTOCONFIGURE %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	   ENA_DIS( data[SRCHAR_STR_auto_ip_mask] ) );

    printf( "%sDEFINE SERVER INTERNET NAME %s\n",
	       CMD_COMMENT(!telnetEnabled),
	   data[SRCHAR_STR_ip_name] ? (char *)&data[SRCHAR_STR_ip_name] : "NONE" );

    printf( "%sDEFINE SERVER INTERNET DEFAULT DOMAIN SUFFIX %s",
	       CMD_COMMENT(!telnetEnabled),
	   data[SRCHAR_STR_ip_domain_suffix] ? 
	   (char *)&data[SRCHAR_STR_ip_domain_suffix] : "NONE" );
    printf("%s\n", (data[SRCHAR_STR_ip_domain_extension] == '\0') ? "" : 
	   (char *) &data[SRCHAR_STR_ip_domain_extension]);
    
    /*
     ** The structure for the one meg, and the multimeg are different .
     ** for this field only.  We'll handle it, maybe not neatly, but we will
     */
    if (!OneMegProduct())
	{
	printf( "%sDEFINE SERVER INTERNET TCP CONNECT TIMER %u\n", 
	       CMD_COMMENT(!telnetEnabled),
	       data[SRCHAR_STR_tcpConnectTimer] );    
	}
    else
	{
	printf( "%sDEFINE SERVER INTERNET TCP CONNECT TIMER %u\n", 
	       CMD_COMMENT(!telnetEnabled),
	       data[SRCHAR_STR_tcpConnectTimer+2] );    
	}	

    if ((VersionLaterOrEqual(5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
			    VERSION_DONT_CARE)) && !OneMegProduct())
	{
	printf("%sDEFINE SERVER TCP ACK DELAYED %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       ENA_DIS(data[SRCHAR_STR_TcpAckDelay]));
	
	}

    printf( "%sDEFINE SERVER INTERNET TTL %d\n", 
	        CMD_COMMENT(!telnetEnabled),
		(unsigned char)data[SRCHAR_STR_ip_ttl] );

    if (!OneMegProduct())
    	printf( "%sDEFINE SERVER INTERNET TRANSLATION TABLE TTL %d\n", 
	       CMD_COMMENT(!telnetEnabled),
	(unsigned char)data[SRCHAR_STR_ARP_TTL] );

    printf( "%sDEFINE SERVER INTERNET DOMAIN TTL %d\n", 
	       CMD_COMMENT(!telnetEnabled),
	   (unsigned char)data[SRCHAR_STR_domain_ttl] );

    printf( "%sDEFINE SERVER INTERNET TCP RESEQUENCING %s\n",
	       CMD_COMMENT(!telnetEnabled),
	    ENA_DIS( data[SRCHAR_STR_tcp_resequencing] ) );

    printf( "%sDEFINE SERVER INTERNET IP  REASSEMBLY   %s\n",
	       CMD_COMMENT(!telnetEnabled),
	    ENA_DIS( data[SRCHAR_STR_ip_reassembly] ) );

    if (!OneMegProduct())
        printf( "%sDEFINE SERVER INTERNET LOCAL BASE %u INCREMENT %d\n",
	       CMD_COMMENT(!telnetEnabled),
	    GetWord((char *) &data[SRCHAR_STR_tcp_local_port_base]),
	    GetWord((char *) &data[SRCHAR_STR_tcp_local_increment]));

    if ((!OneMegProduct()) &&
	(VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE,
				VERSION_DONT_CARE)))
	{
	printf( "%sDEFINE SERVER INTERNET ROUTING TABLE SIZE %d\n", 
	       CMD_COMMENT(!telnetEnabled),
	       GetWord((char *) &data[SRCHAR_STR_tcpRoutingTblSz] ));
	}

    if ((!OneMegProduct()) &&
	(VersionLaterOrEqual(5, 3, 1, TYPE_VERSION_SPECIAL, 10)))
	{
	printf( "%sDEFINE SERVER INTERNET TCP RETRANSMIT %u\n", 
	       CMD_COMMENT(!telnetEnabled),
	       GetWord((char *) &data[SRCHAR_STR_tcpRetranMin] ));
	}

    }

/*
 ** PrintServerInternetSnmpData()
 */

void PrintServerInternetSnmpData( data, data1 )
     char *data;
     char *data1;
{
    int loop = 0;
/***********************  Internet  SNMP  *******************************/

    EchoHeader("Internet SNMP ");
    PrintCommentHeader(!snmpEnabled, "SNMP");

    printf("%sDEFINE SERVER INTERNET SNMP SYSTEM CONTACT  \"%s\"\n",
	   CMD_COMMENT(!snmpEnabled),
	   (char *) &data[SRCHAR_STR_system_contact]);
    printf("%sDEFINE SERVER INTERNET SNMP SYSTEM LOCATION \"%s\"\n",
	   CMD_COMMENT(!snmpEnabled),
	   (char *) &data[SRCHAR_STR_system_location]);

    printf("%sDEFINE SERVER INTERNET SNMP AUTHENTICATION TRAPS %s\n",
	   CMD_COMMENT(!snmpEnabled),
	   ENA_DIS(!data[SRCHAR_STR_snmp_auth_traps]));

    if (data[SRCHAR_STR_snmp_set + SNMP_COMMUNITY_STR_community] == '\0') 
	{
	printf("%sDEFINE SERVER INTERNET SNMP SET  COMMUNITY NONE\n",
	   CMD_COMMENT(!snmpEnabled));
	}
    else
	{
	printf("%sDEFINE SERVER INTERNET SNMP SET  COMMUNITY \"%s\"\n",
	   CMD_COMMENT(!snmpEnabled),
	    (char *) &data[SRCHAR_STR_snmp_set + SNMP_COMMUNITY_STR_community]);
	}
    

    for (loop = 0; loop < SERVER_MAX_SNMP_CLIENTS; loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP SET  CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+1,
	       AlignAndConvertIpAddr((char *)&data[SRCHAR_STR_snmp_set + 
		SNMP_COMMUNITY_STR_clients + (NLINK_ADDR_STR_sizelen * loop) + 
						   NLINK_ADDR_STR_middle]));
	}
    /* PJB Added new loop in support of the 8 extra 
     * SNMP gets, sets and traps- V6-0-3 release. 
     */
    if (VersionLaterOrEqual( 6, 0, 2, TYPE_VERSION_SPECIAL, 17))
      {
      for (loop = 0; loop < (SERVER_MAX_SNMP_CLIENTS*2); loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP SET  CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+5,
	       AlignAndConvertIpAddr((char *)&data1[SERVER_SNMP_EXP_SRCHAR_STR_snmp_set2 + 
		SNMP_COMMUNITY_STR2_clients + (NLINK_ADDR_STR_sizelen * loop) + 
						   NLINK_ADDR_STR_middle]));
	}
      }	

    if(data[SRCHAR_STR_snmp_get + SNMP_COMMUNITY_STR_community] == '\0') 
	{
	printf("%sDEFINE SERVER INTERNET SNMP GET  COMMUNITY NONE\n",
	       CMD_COMMENT(!snmpEnabled));
	}
    else
	{
	printf("%sDEFINE SERVER INTERNET SNMP GET  COMMUNITY \"%s\"\n",
	   CMD_COMMENT(!snmpEnabled),
	   (char *) &data[SRCHAR_STR_snmp_get + SNMP_COMMUNITY_STR_community]);
	}
    
    for (loop = 0; loop < SERVER_MAX_SNMP_CLIENTS; loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP GET  CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+1,
	       AlignAndConvertIpAddr((char *)&data[SRCHAR_STR_snmp_get + 
		SNMP_COMMUNITY_STR_clients + (NLINK_ADDR_STR_sizelen * loop) + 
					      NLINK_ADDR_STR_middle]));

	}
    /* PJB Added new loop in support of the 8 extra 
     * SNMP gets, sets and traps- V6-0-3 release. 
     */
    if (VersionLaterOrEqual( 6, 0, 2, TYPE_VERSION_SPECIAL, 17))
      {
      for (loop = 0; loop < (SERVER_MAX_SNMP_CLIENTS*2); loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP GET  CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+5,
	       AlignAndConvertIpAddr((char *)&data1[SERVER_SNMP_EXP_SRCHAR_STR_snmp_get2 + 
		SNMP_COMMUNITY_STR2_clients + (NLINK_ADDR_STR_sizelen * loop) + 
					      NLINK_ADDR_STR_middle]));
	}
      }
    printf("%sDEFINE SERVER INTERNET SNMP TRAP COMMUNITY \"%s\"\n",
	   CMD_COMMENT(!snmpEnabled),
	   (char *) &data[SRCHAR_STR_snmp_trap + SNMP_COMMUNITY_STR_community]);

    for (loop = 0; loop < SERVER_MAX_SNMP_CLIENTS; loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP TRAP CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+1,
	       AlignAndConvertIpAddr((char *)&data[SRCHAR_STR_snmp_trap + 
		SNMP_COMMUNITY_STR_clients + (NLINK_ADDR_STR_sizelen * loop) + 
						   NLINK_ADDR_STR_middle]));
	} 
    /* PJB Added new loop in support of the 8 extra 
     * SNMP gets, sets and traps- V6-0-3 release. 
     */	
    if (VersionLaterOrEqual( 6, 0, 2, TYPE_VERSION_SPECIAL, 17))
      {
      for (loop = 0; loop < (SERVER_MAX_SNMP_CLIENTS*2); loop++)
	{
	printf("%sDEFINE SERVER INTERNET SNMP TRAP  CLIENT %d %s\n",
	       CMD_COMMENT(!snmpEnabled),
	       loop+5,
	       AlignAndConvertIpAddr((char *)&data1[SERVER_SNMP_EXP_SRCHAR_STR_snmp_trap2 + 
		SNMP_COMMUNITY_STR2_clients + (NLINK_ADDR_STR_sizelen * loop) + 
						   NLINK_ADDR_STR_middle]));
	}
      }
}

/*
 ** PrintServerIpxData()
 */
void PrintServerIpxData( data, interfacePtr )
     char *data;
     char *interfacePtr;
{
    EchoHeader("IPX Server Information ");    
    
    if (ipxInterfaceParamsSeen == TRUE)
	{
	printf("%sDEFINE SERVER IPX RIP TABLE SIZE %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetWord((char *) &data[SRCHAR_STR_ipxRipTableSize]));
	printf("%sDEFINE SERVER IPX SAP TABLE SIZE %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetWord((char *) &data[SRCHAR_STR_ipxSapTableSize]));
	}

    if ((ipxInterfaceParamsSeen == TRUE) || xprinterEnabled)
	{
	printf("%sDEFINE SERVER IPX INTERNAL NETWORK %X\n",
	       CMD_COMMENT(!(ipxEnabled && xprinterEnabled)),
	       GetDoubleWord((char *) &data[SRCHAR_STR_ipxInternalNetwork]));
	}
	
    if (ipxInterfaceParamsSeen == TRUE)    
	{
	printf("%sDEFINE SERVER IPX NETWORK %X\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetDoubleWord((char *) &interfacePtr[IPX_IF_STR_Network]));
	printf("%sDEFINE SERVER IPX RIP BROADCAST %s\n",
	       CMD_COMMENT(!ipxEnabled),
	       (interfacePtr[IPX_IF_STR_RIPBroadcast] == BROADCAST_NONE) ? "NONE" :
	       (interfacePtr[IPX_IF_STR_RIPBroadcast] == BROADCAST_CHANGE) ? "CHANGE" : "FULL");
	printf("%sDEFINE SERVER IPX SAP BROADCAST %s\n",
	       CMD_COMMENT(!ipxEnabled),
	       (interfacePtr[IPX_IF_STR_SAPBroadcast] == BROADCAST_NONE) ? "NONE" :
	       (interfacePtr[IPX_IF_STR_SAPBroadcast] == BROADCAST_CHANGE) ? "CHANGE" : "FULL");
	printf("%sDEFINE SERVER IPX RIP TIMER %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetDoubleWord((char *) &interfacePtr[IPX_IF_STR_RIPTimer]));
	printf("%sDEFINE SERVER IPX SAP TIMER %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetDoubleWord((char *) &interfacePtr[IPX_IF_STR_SAPTimer]));
	printf("%sDEFINE SERVER IPX RIP DISCARD TIMEOUT %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetDoubleWord((char *) &interfacePtr[IPX_IF_STR_RIPDiscardTimeout]));
	printf("%sDEFINE SERVER IPX SAP DISCARD TIMEOUT %d\n",
	       CMD_COMMENT(!ipxEnabled),
	       GetDoubleWord((char *) &interfacePtr[IPX_IF_STR_SAPDiscardTimeout]));
	}
    
    } /* End of PrintServerIpxData() */

/*
 ** PrintServerIpxStaticRouteData()
 */
void PrintServerIpxStaticRouteData( table )
     char *table;
{
    int loop = 0;
    char *route;
    
    route = table;
    EchoHeader("IPX Static Route Data");
    
    for (loop = 0; loop < IPX_MAX_STATIC_ROUTES; loop++)
	{
	if (GetByte((char *) &route[IPX_STATIC_ROUTE_TAG_interface]) != 0)
	    {
	    if (GetByte((char *) &route[IPX_STATIC_ROUTE_TAG_interface]) == 1)
		{
		printf("%sDEFINE SERVER IPX RIP ETHERNET ",
		       CMD_COMMENT(!ipxEnabled));
		}
	    else
		{		
		printf("%sDEFINE SERVER IPX RIP %d ",
		       CMD_COMMENT(!ipxEnabled),
		       (GetByte((char *) &route[IPX_STATIC_ROUTE_TAG_interface]) - 1));
		}
	    printf("NETWORK %8X HOPS %d TIME %d FORWARDING ROUTER %s\n",
		   GetDoubleWord((char *) &route[IPX_STATIC_ROUTE_TAG_network]),
		   route[IPX_STATIC_ROUTE_TAG_hops],
		   GetWord((char *) &route[IPX_STATIC_ROUTE_TAG_time]),
		   AlignAndConvertEthAddr((char *) &route[IPX_STATIC_ROUTE_TAG_forwardingRouter]));
	    }
	route += IPX_STATIC_ROUTE_TAG_sizelen;
	} /* End of loop through static routes. */
    } /* End of PrintServerIpxStaticRouteData() */

/*
 ** PrintServerIpxStaticServiceData()
 */
void PrintServerIpxStaticServiceData( table )
     char *table;
{
    int loop = 0, name = 0;
    char *service;
    
    service = table;
    EchoHeader("IPX Static Service Data");
    
    for (loop = 0; loop < IPX_MAX_STATIC_SERVICES; loop++)
	{
	if ( service[IPX_STATIC_SERVICE_TAG_name] != '\0')
	    {
	    printf("%sDEFINE SERVER IPX SAP \"",
		   CMD_COMMENT(!ipxEnabled));
	    for (name = 0; name < 47; name ++)
		{
		if (service[IPX_STATIC_SERVICE_TAG_name + name] == '\0')
		    {
		    break;
		    }
		printf("%c", service[IPX_STATIC_SERVICE_TAG_name + name]);
		}
	    printf("\" TYPE %4X NETWORK %8X NODE %s SOCKET %4X HOPS %d\n",
		   GetWord((char *) &service[IPX_STATIC_SERVICE_TAG_type]),
		   GetDoubleWord((char *) &service[IPX_STATIC_SERVICE_TAG_network]),
		   AlignAndConvertEthAddr((char *) &service[IPX_STATIC_SERVICE_TAG_node]),
		   GetWord((char *) &service[IPX_STATIC_SERVICE_TAG_socket]),
		   GetWord((char *) &service[IPX_STATIC_SERVICE_TAG_hops]));
	    }
	service += IPX_STATIC_SERVICE_TAG_sizelen;
	} /* End of loop through static routes. */
    } /* End of PrintServerIpxStaticRouteData() */

/*
 ** PrintServerIpxRipFilterData()
 */
void PrintServerIpxRipFilterData()
{
    int loop = 0;
    char *filter;
    
    EchoHeader("IPX RIP Filter Data");
    
    for (loop = 0; loop < IPX_MAX_RIP_FILTERS; loop++)
	{
	filter = (char *) ipxRipFilter[loop];
	if (filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_importExport] != 0)
	    {

	    if (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_interface]) == 0)
		{
		printf("%sDEFINE SERVER IPX RIP ",
		       CMD_COMMENT(!ipxEnabled));
		
		}
	    else
		{
		printf("%sDEFINE PORT %d IPX RIP ",
		       CMD_COMMENT(!ipxEnabled),
		       GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_interface]));
		}
	    
	    if (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_importExport]) == IPX_FILTER_IMPORT)
		{
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_networkAll]))
		    {
		    printf("IMPORT NETWORK ALL ");
		    }
		else
		    {
		    printf("IMPORT NETWORK %8X ",
			   GetDoubleWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_network]));
		    }
		printf("%s\n",
		       (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_allowDeny]) == IPX_FILTER_FORWARD) ? 
		       "ACCEPT" : "DISCARD");
		}
	    else
		{
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_networkAll]))
		    {
		    printf("EXPORT NETWORK ALL ");
		    }
		else
		    {
		    printf("EXPORT NETWORK %8X ",
			   GetDoubleWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_network]));
		    }
		printf("%s\n",
		       (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_RIP_TAG_allowDeny]) == IPX_FILTER_FORWARD) ? 
		       "ADVERTISE" : "HIDE");
		}		
	    }
	} /* End of loop through static routes. */
    } /* End of PrintServerIpxRipFilterData() */

/*
 ** PrintServerIpxSapFilterData()
 */
void PrintServerIpxSapFilterData()
{
    int loop = 0;
    char *filter;
    
    EchoHeader("IPX SAP Filter Data");
    
    for (loop = 0; loop < IPX_MAX_SAP_FILTERS; loop++)
	{
	filter = (char *) ipxSapFilter[loop];
	if (filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_importExport] != 0)
	    {

	    if (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_interface]) == 0)
		{
		printf("%sDEFINE SERVER IPX SAP ",
		       CMD_COMMENT(!ipxEnabled));
		
		}
	    else
		{
		printf("%sDEFINE PORT %d IPX SAP ",
		       CMD_COMMENT(!ipxEnabled),
		       GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_interface]));
		}
	    
	    if (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_importExport]) == IPX_FILTER_IMPORT)
		{
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_networkAll]))
		    {
		    printf("IMPORT NETWORK ALL ");
		    }
		else
		    {
		    printf("IMPORT NETWORK %8X ",
			   GetDoubleWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_network]));
		    }
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceTypeAll]))
		    {
		    printf("TYPE ALL ");
		    }
		else
		    {
		    printf("TYPE %4X ",
			   GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceType]));
		    }

		printf("%s\n",
		       (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_allowDeny]) == IPX_FILTER_FORWARD) ? 
		       "ACCEPT" : "DISCARD");
		}
	    else
		{
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_networkAll]))
		    {
		    printf("EXPORT NETWORK ALL ");
		    }
		else
		    {
		    printf("EXPORT NETWORK %8X ",
			   GetDoubleWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_network]));
		    }
		if (GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceTypeAll]))
		    {
		    printf("TYPE ALL ");
		    }
		else
		    {
		    printf("TYPE %4X ",
			   GetWord((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_serviceType]));
		    }

		printf("%s\n",
		       (GetByte((char *) &filter[IPX_PRM_IMPORT_EXPORT_FILTER_SAP_TAG_allowDeny]) == IPX_FILTER_FORWARD) ? 
		       "ADVERTISE" : "HIDE");
		}		
	    }
	} /* End of loop through static routes. */
    } /* End of PrintServerIpxSapFilterData() */

/*
 ** PrintServerIpxAddressFilterData()
 */
void PrintServerIpxAddressFilterData()
{
    int loop = 0;
    char *filter;
    
    EchoHeader("IPX Address Filter Data");
    
    for (loop = 0; loop < IPX_MAX_SRC_DEST_FILTERS; loop++)
	{
	filter = (char *) ipxAddressFilter[loop];
	if (filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_forwardDiscard] != 0)
	    {

	    if (GetByte((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_interface]) == 0)
		{
		printf("%sDEFINE SERVER IPX FILTER SOURCE ",
		       CMD_COMMENT(!ipxEnabled));
		
		}
	    else
		{
		printf("%sDEFINE PORT %d IPX FILTER SOURCE ",
		       CMD_COMMENT(!ipxEnabled),
		       GetByte((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_interface]));
		}
	    
	    if (GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNetworkAll]))
		{
		printf("NETWORK ALL ");
		}
	    else
		{
		printf("NETWORK %8X ",
		       GetDoubleWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNetwork]));
		}

	    if (GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNodeAll]))
		{
		printf("NODE ALL ");
		}
	    else
		{
		printf("NODE %s ",
		       ConvertIpxNodeAddr((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_sourceNode]));
		}

	    printf("DESTINATION ");
	    if (GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_destNetworkAll]))
		{
		printf("NETWORK ALL ");
		}
	    else
		{
		printf("NETWORK %8X ",
		       GetDoubleWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_destNetwork]));
		}

	    if (GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_destNodeAll]))
		{
		printf("NODE ALL ");
		}
	    else
		{
		printf("NODE %s ",
		       ConvertIpxNodeAddr((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_destNode]));
		}

	    if (GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_packetTypeAll]))
		{
		printf("PACKET TYPE ALL ");
		}
	    else
		{
		printf("PACKET TYPE %u ",
		       GetWord((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_packetType]));
		}

	    printf("%s\n",
		   (GetByte((char *) &filter[IPX_PRM_SOURCE_DEST_FILTER_TAG_forwardDiscard]) == IPX_FILTER_FORWARD) ? 
		   "FORWARD" : "DISCARD");
	    }
	} /* End of loop through static routes. */
    } /* End of PrintServerIpxSapFilterData() */

/*
 ** PrintServerIpFilterData()
 */
void PrintServerIpFilterData()
{
    int loop = 0;
    char *filter;
    unsigned short protocol;
    unsigned char tcpSyn;
    
    EchoHeader("IP Filter Data");
    printf("#  IP Filter Data is abbreviated so it can be executed in a script\n#\n");
    
    for (loop = 0; loop < IP_MAX_FILTERS; loop++)
	{
	filter = (char *) ipFilter[loop];
	if (filter[IP_FILTER_CHAR_STR_TAG_inUse] != 0)
	    {
	    /*
	     ** We have a filter to display 
	     */
	    if (GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_intf]) == 0)
		{
		printf("%sDEF SER IP FI ",
		       CMD_COMMENT(!ipFilteringEnabled));
		
		}
	    else
		{
		printf("%sDEF PO %d IP FI ",
		       CMD_COMMENT(!ipFilteringEnabled),
		       GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_intf]));
		}
	    
	    printf("DE %s M ",
		   AlignAndConvertIpAddr((char *) &filter[IP_FILTER_CHAR_STR_TAG_dstAddr]));
	    printf("%s ",
		   AlignAndConvertIpAddr((char *) &filter[IP_FILTER_CHAR_STR_TAG_dstMask]));

	    printf("DE PO %u-%u ",
		   GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_dstPortStart]),
		   GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_dstPortEnd]));

	    printf("SO %s M ",
		   AlignAndConvertIpAddr((char *) &filter[IP_FILTER_CHAR_STR_TAG_srcAddr]));
	    printf("%s ",
		   AlignAndConvertIpAddr((char *) &filter[IP_FILTER_CHAR_STR_TAG_srcMask]));

	    printf("SO PO %u-%u ",
		   GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_srcPortStart]),
		   GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_srcPortEnd]));
	    
	    protocol = GetWord((char *) &filter[IP_FILTER_CHAR_STR_TAG_protocol]);
	    switch (protocol)
		{
	    case UDP_ID:
		printf("PR UDP ");
		break;
	    case TCP_ID:
		printf("PR TCP ");
		break;
	    case IP_PROTOCOL_ALL:
		printf("PR ALL ");
		break;
	    default:
		printf("%d ",protocol);
		break;
		}

	    tcpSyn = GetByte((char *) &filter[IP_FILTER_CHAR_STR_TAG_tcpSyn]);
	    switch(tcpSyn)
		{
	    case IP_TCP_SYN_OFF:
		printf("SYN OF ");
		break;
	    case IP_TCP_SYN_ON:
		printf("SYN ON ");
		break;
	    case IP_TCP_SYN_ALL:
		printf("SYN AL ");
		break;
		}
	    printf("%s\n", 
		   (GetByte((char *) &filter[IP_FILTER_CHAR_STR_TAG_action]) ==
		    1) ? "FO" : "DI");
	    }
	} /* end loop through IP filters */
    } /* End of PrintServerIpFilterData() */

/*
 ** PrintServerParameterData()
 */

void PrintServerParameterData( data )
     char *data;
{
    /*
     * Parameter server information
     */

    EchoHeader("Parameter Server Information");
    if (!(data[SRCHAR_STR_ps_polling] & PARAM_POLLING_TFTP)  &&
	!(data[SRCHAR_STR_ps_polling] & PARAM_POLLING_PROP))
	{
	printf("DEFINE SERVER PARAMETER SERVER CHECK DISABLED\n");
	}
    else if((data[SRCHAR_STR_ps_polling] & PARAM_POLLING_TFTP)  &&
	    (data[SRCHAR_STR_ps_polling] & PARAM_POLLING_PROP))
	{
	printf("DEFINE SERVER PARAMETER SERVER CHECK ENABLED\n");
	}	
    else if (data[SRCHAR_STR_ps_polling] & PARAM_POLLING_TFTP)
	{
	printf("DEFINE SERVER PARAMETER SERVER CHECK DISABLED\n");
	printf("DEFINE SERVER PARAMETER SERVER CHECK TFTP ENABLED\n");
	}
    else if (data[SRCHAR_STR_ps_polling] & PARAM_POLLING_PROP)
	{
	printf("DEFINE SERVER PARAMETER SERVER CHECK DISABLED\n");
	printf("DEFINE SERVER PARAMETER SERVER CHECK PROPRIETARY ENABLED\n");
	}
    printf("DEFINE SERVER PARAMETER SERVER CHECK TIMER %d\n", 
	   data[SRCHAR_STR_ps_poll_timer]);
    printf("DEFINE SERVER PARAMETER SERVER RETRANSMIT LIMIT %d\n",
	   data[SRCHAR_STR_ps_retry_limit]);
    printf("DEFINE SERVER PARAMETER SERVER RETRANSMIT TIMER %d\n",    
	   data[SRCHAR_STR_ps_retry_timer]);
    printf("DEFINE SERVER PARAMETER SERVER LIMIT %d\n",
	   data[SRCHAR_STR_ps_limit]);
    printf("DEFINE SERVER PARAMETER SERVER PATH \"%s\"\n",
	   (char *) &data[SRCHAR_STR_load_dir]);
    if (VersionLaterOrEqual(5, 3, VERSION_DONT_CARE, VERSION_DONT_CARE,
			    VERSION_DONT_CARE) && !OneMegProduct())
	{
	printf("DEFINE SERVER PARAMETER SERVER TFTP READ BROADCAST %s\n",
	       ENA_DIS(data[SRCHAR_STR_ps_tftp_no_readbroadcast]));
	
	}
}
/*
 ** PrintServerArapData()
 **
 ** ARAP is not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintServerArapData( arap )
     char *arap;
{
    if ((!ArapSupported()) || (OneMegProduct()))
	{
	/*
	 ** Arap must be supported before we set any associated fields
	 */
	return;
	}
    
    EchoHeader ("ARAP Server Information");
    if (arap[ARAP_S_INFO_arap_node] != '\0')
	{
	printf("%sDEFINE SERVER ARAP NODE NAME \"%s\"\n",
	       CMD_COMMENT(!arapEnabled),
	       (char *) &arap[ARAP_S_INFO_arap_node]);
	}
    else
	{
	printf("%sDEFINE SERVER ARAP NODE NAME NONE\n",
	       CMD_COMMENT(!arapEnabled));
	}

    if (arap[ARAP_S_INFO_arap_zone] != '\0')
	{
	printf("%sDEFINE SERVER ARAP DEFAULT ZONE \"%s\"\n",
	       CMD_COMMENT(!arapEnabled),
	       (char *) &arap[ARAP_S_INFO_arap_zone]);
	}
    else
	{
	printf("%sDEFINE SERVER ARAP DEFAULT ZONE NONE\n",
	       CMD_COMMENT(!arapEnabled));
	}
    printf("# DEFINE SERVER ARAP PASSWORD <SECRET>\n");

    }

/*
 ** PrintServerDaemonsData()
 */

void PrintServerDaemonsData( data )
     char *data;
{
    if (OneMegProduct())
	{
	/*
	 ** One meg products do not support DAEMONS.
	 */
	return;
	}

    /***********************  D a e m o n s     *****************************/

    EchoHeader( "Daemons" );
    printf( "DEFINE SERVER DAEMON LPD     %s\n", 
	   ENA_DIS( data[SRCHAR_STR_lpd_enabled] ));
    printf( "DEFINE SERVER DAEMON FINGERD %s\n", 
	   ENA_DIS( data[SRCHAR_STR_fingerd_enabled] ));
    printf( "DEFINE SERVER DAEMON RWHOD   %s\n", 
	   ENA_DIS( data[SRCHAR_STR_rwhod_enabled] ));
    printf( "DEFINE SERVER DAEMON ROUTED  %s\n", 
	   ENA_DIS( data[SRCHAR_STR_routed_enabled] ));

    /* PJB 2/4/97 added/changed code here for the use of 2 syslogd hosts. */
    if ( (data[SRCHAR_STR_host_log_type] == LOG_UNIX) && 
	(GetWord((char *) &data[SRCHAR_STR_acct_size]) > 0))
	{
	printf( "DEFINE SERVER DAEMON SYSLOGD ENABLED HOST1 %s\n", 
	       AlignAndConvertIpAddr( &data[SRCHAR_STR_unix_syslog_addr] ));
	}
    else
	{
	printf( "# DEFINE SERVER DAEMON SYSLOGD DISABLED HOST1\n");
	}

    if ( (data[SRCHAR_STR_host_log_type2] == LOG_UNIX) && 
	(GetWord((char *) &data[SRCHAR_STR_acct_size]) > 0))
	{
	printf( "DEFINE SERVER DAEMON SYSLOGD ENABLED HOST2 %s\n", 
	       AlignAndConvertIpAddr( &data[SRCHAR_STR_unix_syslog_addr2] ));
	}
    else
	{
	printf( "# DEFINE SERVER DAEMON SYSLOGD DISABLED HOST2\n");
	}

}

/*
 ** PrintScriptServerParams()
 */
void PrintScriptParams( data )
     unsigned char *data;
{
    static unsigned int   header = TRUE;
    unsigned char       *currentEntry;
    int                  i;
    
  
    if (header)
	{
	header = FALSE;
	EchoHeader( "Script Server(s)" );
	}

    currentEntry = data;
    
    for (i = 0; i < MAX_SCRIPT_SERVERS; i++)
	{
	if (currentEntry[SCRIPT_BLOCK_host] != '\0')
	    {
	    printf( "DEFINE SERVER SCRIPT SERVER %s \"%s\"",
		   (char *)&currentEntry[SCRIPT_BLOCK_host],
		   (char *)&currentEntry[SCRIPT_BLOCK_path] );
	    if ((SupportedVersion_5_2()) && (!OneMegProduct()))
		{
		/*
		 ** The Seperator char went in to 5.2 for ARAP, and is not
		 ** supported in one meg.
		 */
		if (currentEntry[SCRIPT_BLOCK_separator] != 0)
		    {
		    printf(" \"%s\"", (char *) 
			   &currentEntry[SCRIPT_BLOCK_separator]);
		    } /* End if there is a separator */
		} /* End if this is supported in version 5.2 */

	    printf("\n"); 
	    }

	/*
	 ** The script block structure has changed from version 5.1 to version
	 ** 5.2 for the addition of the separator character.  We need to 
	 ** handle this by incrementing to the next script server properly
	 */
	if ((SupportedVersion_5_2()) && (!OneMegProduct()))
	    {
	    currentEntry += SCRIPT_BLOCK_sizelen;	    
	    }
	else
	    {
	    currentEntry += OLD_SCRIPT_BLOCK_sizelen;
	    }
	
	}
    }

/* PrintServerExpandedParams */
void PrintServerExpandedParams ( apdMess )
     unsigned char *apdMess;
{
	if (VersionLaterOrEqual(6, 0, 1, TYPE_VERSION_SPECIAL, 11))
		printf( "%sDEFINE SERVER APD MESSAGE \"%s\"\n",
		CMD_COMMENT(!apdEnabled),
		(char *)&apdMess[SERVER_EXPANDED_SRCHAR_STR_apdMessage]);
}	   

/*
 ** PrintSecurityParams()
 */

void PrintSecurityParams( security )
     unsigned char *security;
{
    static    int headerPrinted = FALSE;
    int       ipAddr, netMask, loop;
    char      ipString[IP_ADDR_SIZE], netString[IP_ADDR_SIZE];
    char      portList[60];
    
    ipAddr = GetDoubleWord((char *)&security[IP_SECURITY_ENTRY_STR_ip_addr]);
    if(ipAddr != 0)
	{
	if(headerPrinted == FALSE)
	    {
	    EchoHeader("Security Information");
	    PrintCommentHeader( !securityEnabled, "IP Security");
	    headerPrinted = TRUE;
	    }
	IpToString( ipAddr, ipString);
	netMask = GetDoubleWord((char *)
				&security[IP_SECURITY_ENTRY_STR_network_mask]);
	IpToString( netMask, netString);
	PortListToString((char *) &security[IP_SECURITY_ENTRY_STR_port_list],
			 portList);
	printf("%sDEFINE PORT %s INTERNET SECURITY %s %s %s %s %s\n",
	       CMD_COMMENT(!securityEnabled),
	       portList,
	       (security[IP_SECURITY_ENTRY_STR_direction] == 
		SECURITY_INBOUND) ? "INBOUND" : "OUTBOUND",
	       (security[IP_SECURITY_ENTRY_STR_access_type] == 
		SECURITY_ALLOW) ? "ALLOW" : "DENY",
	       ipString,
	       (netMask != 0) ? "MASK" : "",
	       (netMask != 0) ? netString : "");
	}
}


/*
 ** PrintDefSecurityParams()
 */

void PrintDefSecurityParams( security )
     unsigned char *security;
{
    static    int headerPrinted = FALSE;
    int       ipAddr, netMask, loop;
    char      ipString[IP_ADDR_SIZE], netString[IP_ADDR_SIZE];
    char      portList[60];
    TBITS     allow[TBITS_PORT_LIST_SIZE];
    

    /*
     * Handle default inbound
     * header will either be printed with inbound allow, or deny.  one or the
     * other has to print.
     */
    bits_clear(allow, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));   /* fbs 012495 SC45938 */
    for (loop = 0; loop < MAX_DEFAULT_SECURITY; loop++)
	{
	if (security[loop] == SECURITY_ALLOW)
	    {
	    bits_set(allow, loop, loop);
	    }
	}
    PortListToString( allow, portList);
    if(strcmp(portList,"") !=0)
	{
	if(headerPrinted == FALSE)
	    {
	    EchoHeader("Default Security Information");
	    PrintCommentHeader( !securityEnabled, "IP Security");
	    headerPrinted = TRUE;
	    }

	printf("%sDEFINE PORT %s INTERNET SECURITY DEFAULT INBOUND ALLOW\n",
	       CMD_COMMENT(!securityEnabled),	       
	       portList);
	}
    
    for (loop = 0; loop < TBITS_PORT_LIST_SIZE; loop++)
	allow[loop] = ~allow[loop];
    bits_clear( allow, 0, 0 );
    PortListToString( allow, portList);    
    if(strcmp(portList,"") !=0)
	{
	if(headerPrinted == FALSE)
	    {
	    EchoHeader("Default Security Information");
	    PrintCommentHeader( !securityEnabled,"IP Security");
	    headerPrinted = TRUE;
	    }
	printf("%sDEFINE PORT %s INTERNET SECURITY DEFAULT INBOUND DENY\n",
	       CMD_COMMENT(!securityEnabled),
	       portList);
	}
    
    /*
     * Handle default outbound
     */

    bits_clear(allow, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));   /* fbs 012495 SC45938 */
    for (loop = 0; loop < MAX_DEFAULT_SECURITY; loop++)
	{
	if (security[MAX_DEFAULT_SECURITY + loop] == SECURITY_ALLOW)
	    {
	    bits_set(allow, loop, loop);
	    }
	}
    PortListToString( allow, portList);
    if(strcmp(portList,"") !=0)
	{
	printf("%sDEFINE PORT %s INTERNET SECURITY DEFAULT OUTBOUND ALLOW\n",
	       CMD_COMMENT(!securityEnabled),
	       portList);
	}
    
    for (loop = 0; loop < TBITS_PORT_LIST_SIZE; loop++)
	allow[loop] = ~allow[loop];
    bits_clear( allow, 0, 0 );
    
    PortListToString( allow, portList);    
    if(strcmp(portList,"") !=0)
	{
	printf("%sDEFINE PORT %s INTERNET SECURITY DEFAULT OUTBOUND DENY\n",
	       CMD_COMMENT(!securityEnabled),
	       portList);
	}
}

/*
 ** PrintKerberosParams()
 */

void PrintKerberosParams( krb )
     unsigned char *krb;
{
    static int headerPrinted = FALSE;
    int        ipMAddr, ipS1Addr, ipS2Addr;
    short int  krbQueries;
    char       ipMaster[IP_ADDR_SIZE], ipServer1[IP_ADDR_SIZE], 
               ipServer2[IP_ADDR_SIZE];
    
    ipMAddr = GetDoubleWord((char *)&krb[KRB_P_INFO_krb_master_ipaddr]);
    ipS1Addr = GetDoubleWord((char *)&krb[KRB_P_INFO_krb_server_ipaddr]);
    ipS2Addr = GetDoubleWord((char *)&krb[KRB_P_INFO_krb_server2_ipaddr]);
    krbQueries = GetWord((char *)&krb[KRB_P_INFO_krb_passes]);

    IpToString( ipMAddr, ipMaster);
    IpToString( ipS1Addr, ipServer1);
    IpToString( ipS2Addr, ipServer2);

    if (headerPrinted == FALSE)
	{
	EchoHeader("Kerberos Information");
	PrintCommentHeader( (!(kerberosEnabled || kerberos5Enabled)), "Kerberos");
	headerPrinted = TRUE;
	}

    printf("%sDEFINE SERVER KERBEROS REALM %s\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   (krb[KRB_P_INFO_krb_realm] == '\0') ? "\"\"" :
	   (char *) &krb[KRB_P_INFO_krb_realm]);

    /*
     * Kerberos Master
     */

    printf("%sDEFINE SERVER KERBEROS MASTER %s\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   (krb[KRB_P_INFO_krb_master_name] == '\0') 
	   ? "NONE" : (char *) &krb[KRB_P_INFO_krb_master_name]);

    /*
     * Kerberos Primary server
     */
    
    printf("%sDEFINE SERVER KERBEROS PRIMARY SERVER %s\n", 
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   (krb[KRB_P_INFO_krb_server_name] == '\0') 
	   ? "NONE" : (char *) &krb[KRB_P_INFO_krb_server_name]);


    /*
     * Kerberos Secondary server
     */

    printf("%sDEFINE SERVER KERBEROS SECONDARY SERVER %s\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   (krb[KRB_P_INFO_krb_server2_name] == '\0') 
	   ? "NONE" : (char *) &krb[KRB_P_INFO_krb_server2_name]);

    printf("%sDEFINE SERVER KERBEROS QUERY LIMIT %hd\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	   krbQueries);
    
    if (!OneMegProduct())
	{
	/*
	 ** The kerberos port option is not supported on the one megs.
	 */
	printf("%sDEFINE SERVER KERBEROS PORT %d\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)),
	       GetWord((char *) &krb[KRB_P_INFO_krb_port]));

        if (VersionLaterOrEqual( 5, 3, 1, TYPE_VERSION_SPECIAL, 65))
	{
		printf("%sDEFINE SERVER KERBEROS PASSWORD PORT %d\n",
	        CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)), 
		GetWord((char *) &krb[KRB_P_INFO_krbPwdPort]));
	}
	}
}

/*
 ** PrintKerberosExtraParams()
 ** This routine prints extra Kerberos param information.  It was added to
 ** a V5-3-1 special and  V6-0-0, and is not found on the one megabyte images.
 */

void PrintKerberosExtraParams( krb739 )
     unsigned char *krb739;
{
    EchoHeader("Additional Kerberos Information");

    /*
     * Kerberos 739 Error Message
     */

    printf("%sDEFINE SERVER KERBEROS ERROR MESSAGE \"%s\"\n",
	   CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)), 
           (char *) &krb739[KRB_PARAM_739MSG_text]);

    /*
     * Kerberos Service 
     */

    printf("%sDEFINE SERVER KERBEROS PASSWORD SERVICE \"%s\"\n",
           CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)), 
	   (char *) &krb739[KRB_PARAM_739MSG_service]);
}

/*
 ** PrintRadiusServerParams()
 ** This routine prints parameter info for radius and radius servers.
 ** Added to V6-0-1, and is not found on the one megabyte images.
 */

void PrintRadiusServerParams( radius )
     unsigned char *radius;
{
    if (OneMegProduct() || 
	!VersionLaterOrEqual( 6, 0, 1,
						 VERSION_DONT_CARE, VERSION_DONT_CARE))
	{
	/*
	 ** Radius data is not supported in the one megabyte images
	 */
	return;
	}

    EchoHeader("Radius Server Information");

    printf("%sDEFINE SERVER RADIUS PRIMARY SERVER %s\n",
	   CMD_COMMENT(!radiusEnabled),
	   (radius[RADIUS_P_INFO_server] == '\0') 
	   ? "NONE" : (char *) &radius[RADIUS_P_INFO_server]);

    printf("%sDEFINE SERVER RADIUS SECONDARY SERVER %s\n",
	   CMD_COMMENT(!radiusEnabled),
	   (radius[RADIUS_P_INFO_server + RADIUS_S_INFO_sizelen] == '\0') 
	   ? "NONE" : (char *) &radius[RADIUS_P_INFO_server + RADIUS_S_INFO_sizelen]);

    printf( "# DEFINE SERVER RADIUS PRIMARY SECRET <secret>\n" );

    printf( "# DEFINE SERVER RADIUS SECONDARY SECRET <secret>\n" );

    printf("%sDEFINE SERVER RADIUS PORT %d\n",
	   CMD_COMMENT(!radiusEnabled),
	   GetWord((char *) &radius[RADIUS_P_INFO_AuthPort]));

    printf("%sDEFINE SERVER RADIUS LOGGING %s\n",
	   CMD_COMMENT(!radiusEnabled),
	   ENA_DIS(radius[RADIUS_P_INFO_bLogging]));

    printf("%sDEFINE SERVER RADIUS TIMEOUT %d\n",
	   CMD_COMMENT(!radiusEnabled),
	   radius[RADIUS_P_INFO_ReqTimeout]);

    printf("%sDEFINE SERVER RADIUS CHAP CHALLENGE SIZE %d\n",
	   CMD_COMMENT((!radiusEnabled) || (!pppEnabled)),
	   radius[RADIUS_P_INFO_ChapChalSize]);

    printf("%sDEFINE SERVER RADIUS ACCOUNTING PORT %d\n",
		   CMD_COMMENT(!radiusEnabled) ,
		   radius[RADIUS_P_INFO_AcctPort]);

    printf("%sDEFINE SERVER RADIUS ACCOUNTING ATTEMPTS %d\n",
		   CMD_COMMENT(!radiusEnabled),
		   radius[RADIUS_P_INFO_AcctAttempts]);
}


/*
 ** PrintSecurIdParams()
 **
 ** This routine prints the securid information.  This is not supported on 
 ** one the one megabyte images, and was initially put in for 5.2.
 */
void PrintSecurIdParams( securId )
     unsigned char *securId;
{
    int loop = 0;
    
    if (OneMegProduct() || 
	!VersionLaterOrEqual( 5, 2, VERSION_DONT_CARE,
			     VERSION_DONT_CARE, VERSION_DONT_CARE))
	{
	/*
	 ** Secure ID data is not supported in the one megabyte images
	 */
	return;
	}
    
    EchoHeader("Secure Id Data");

    for (loop = 0; loop < ACMMAXSERVERS; loop++)
	{
	if (securId[ SD_INFO_sd_servers + (loop * SD_SERVER_sizelen) +
		    SD_SERVER_name] != '\0')
	    {
	    printf("%sDEFINE SERVER SECURID SERVER%d %s\n",
		   CMD_COMMENT(!securIdEnabled),
		   loop,
		   (securId[ SD_INFO_sd_servers + (loop * SD_SERVER_sizelen) +
			   SD_SERVER_name] == '\0') ? "NONE" :
		   (char *) &securId[ SD_INFO_sd_servers + (loop * SD_SERVER_sizelen) +
			   SD_SERVER_name]);
	    }
	else
	    {
	    if (GetWord((char *) &securId[ SD_INFO_sd_servers + 
		  (loop * SD_SERVER_sizelen) + SD_SERVER_ip_addr]) == 0)
		{
		printf("%sDEFINE SERVER SECURID SERVER%d NONE\n",
		       CMD_COMMENT(!securIdEnabled),		       
		       loop);
		}
	    else
		{
		printf("%sDEFINE SERVER SECURID SERVER%d %s\n",
		       CMD_COMMENT(!securIdEnabled),
		       loop,
		       AlignAndConvertIpAddr((char *) 
		    &securId[ SD_INFO_sd_servers + (loop * SD_SERVER_sizelen) +
			     SD_SERVER_ip_addr]));
		}
	    }
	}

    printf("%sDEFINE SERVER SECURID ACMMAXRETRIES %u\n",
	   CMD_COMMENT(!securIdEnabled),
	   securId[SD_INFO_acmmaxretries]);

    printf("%sDEFINE SERVER SECURID ACMBASETIMEOUT %u\n",
	   CMD_COMMENT(!securIdEnabled),
	   securId[SD_INFO_acmbasetimeout]);

    printf("%sDEFINE SERVER SECURID ACM_PORT %u\n",
	   CMD_COMMENT(!securIdEnabled),
	   GetWord((char *) &securId[SD_INFO_acm_port]));
    
    printf("%sDEFINE SERVER SECURID QUERY LIMIT %d\n",
	   CMD_COMMENT(!securIdEnabled),
	   GetWord((char *) &securId[SD_INFO_query_limit]));

    printf("%sDEFINE SERVER SECURID ENCRYPTION MODE %s\n",
	   CMD_COMMENT(!securIdEnabled),
	   securId[SD_INFO_encryption_mode] == DES ? "DES" : "SDI BLOCK CIPHER");
        
    } /* End of PrintSecurIdParams() */

/*
 ** PrintLoadParams()
 **
 ** The Load params are not supported by One meg products, We should not see a
 ** parameter segment, but the check is here to be complete.
 */

void PrintLoadParams( load )
     unsigned char *load;
{
    static int      headerPrinted = FALSE;
    unsigned short  loadType;
    unsigned short  ethAddr[3];
    char            printLine[160];
    char            nodeName[100];

    if (OneMegProduct())
	{
	/*
	 ** Manager LOAD data is not supported under one megabyte images
	 */
	return;
	}
    
    if (headerPrinted == FALSE)
	{
	EchoHeader("Manager Load Data");
	printf("#         MAXman cards:  GLOBAL, LOCAL, NODE\n");
	printf("#         MAXserver 1800/1820 Terminal Servers:  GLOBAL, NODE\n");
	printf("#         Products that use version 1 flash or ROM cards:  GLOBAL, NODE\n");
	printf("#         Products that use version 2 flash or ROM cards:  NODE\n");
	printf("#         Products that use version 3 flash or ROM cards:  NODE\n#\n");

	headerPrinted = TRUE;
	}

    ethAddr[0] = GetWord((char *) &load[NETWORK_DEVICE_STR_dla]);
    ethAddr[1] = GetWord((char *) &load[NETWORK_DEVICE_STR_dla+2]);
    ethAddr[2] = GetWord((char *) &load[NETWORK_DEVICE_STR_dla+4]);

    if(((ethAddr[0] != 0xFFFF) && (ethAddr[1] != 0xFFFF)) &&
       ((ethAddr[0] != 0) && (ethAddr[1] != 0) && (ethAddr[2] != 0)))
	{
	sprintf(printLine,"# DEFINE SERVER MANAGER NODE HARDWARE ADDRESS %s ",
		AlignAndConvertEthAddr(&load[NETWORK_DEVICE_STR_dla]));
	
	strncpy(nodeName, (char *) &load[NETWORK_DEVICE_STR_node_name],
		NODENAME_SIZE);
	nodeName[NODENAME_SIZE] = '\0';
	
	printf("%s NAME %s\n",printLine,
	       (nodeName[0] != '\0') ? (char *) &nodeName[0] : "");
	
	printf("%s LOAD %s\n", printLine,
	       ENA_DIS(load[NETWORK_DEVICE_STR_load_enabled]));
	
	printf("%s DUMP %s\n", printLine,
	       ENA_DIS(load[NETWORK_DEVICE_STR_dump_enabled]));
	
	if (load[NETWORK_DEVICE_STR_load_filename] != '\0')
	    {
	    printf("%s LOAD FILE \"%s\"\n", printLine,
		   (char *) &load[NETWORK_DEVICE_STR_load_filename]);
	    }
	
	if (load[NETWORK_DEVICE_STR_diag_filename] != '\0')
	    {
	    printf("%s DIAGNOSTIC FILE \"%s\"\n", printLine,
		   (char *) &load[NETWORK_DEVICE_STR_diag_filename]);
	    }
	printf("\n");
	}
    else
	{
	loadType = GetWord((char *) &load[NETWORK_DEVICE_STR_type]);
	
	if(loadType != 0)
	    {
	    if((ethAddr[0] == 0xFFFF) && (ethAddr[1] == 0xFFFF) && 
	       (ethAddr[2] == 0xFFFF))
		{
		sprintf(printLine,"# DEFINE SERVER MANAGER GLOBAL TYPE %d ", 
			loadType);
		}	    
	    else
		{
		sprintf(printLine,"# DEFINE SERVER MANAGER LOCAL TYPE %d ", 
			loadType);
		}	    
	    
	    printf("%s LOAD %s\n", printLine,
		   ENA_DIS(load[NETWORK_DEVICE_STR_load_enabled]));
	    
	    printf("%s DUMP %s\n", printLine,
		   ENA_DIS(load[NETWORK_DEVICE_STR_dump_enabled]));
	    
	    if (load[NETWORK_DEVICE_STR_load_filename] != '\0')
		{
		printf("%s LOAD FILE \"%s\"\n", printLine,
		       (char *) &load[NETWORK_DEVICE_STR_load_filename]);
		}
	    
	    if (load[NETWORK_DEVICE_STR_diag_filename] != '\0')
		{
		printf("%s DIAGNOSTIC FILE \"%s\"\n", printLine,
		       (char *) &load[NETWORK_DEVICE_STR_diag_filename]);
		}
	    printf("\n");
	    }
	}
}

/*
 ** PrintManagerParams()
 **
 ** Manager data is not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintManagerParams( manager )
     unsigned char *manager;
{
    static int headerPrinted = FALSE;
    int        loop;
    short int  logSize, dumpDrive;
    
    if (OneMegProduct())
	{
	/*
	 ** Manager data is not supported under one megabyte images
	 */
	return;
	}
        
    /*
     * If manager load data is enabled, print all of it, else just print 
     * manager load disabled
     */


    if(headerPrinted == FALSE)
	{
	EchoHeader("Manager Data");
	headerPrinted = TRUE;
	}

    printf("#\n#         The Following are valid only for:\n");
    printf("#              MAXman cards\n");
    printf("#              MAXserver 1800/1820 Terminal Servers\n");
    printf("#              Products that use version 1, 2, or 3 flash or ROM cards\n#\n");
    
    /* Use filler1 byte from manager.h which used to be manager load enabled. ***fbs 082395 */	
    printf("# DEFINE SERVER MANAGER LOAD %s\n",
	   ENA_DIS(manager[MANAGER_DATA_STR_filler1]));    

    printf("# DEFINE SERVER MANAGER LOAD MERIT %d\n",
	   manager[MANAGER_DATA_STR_load_merit]);

    printf("# DEFINE SERVER MANAGER SIMULTANEOUS %d\n",
	   manager[MANAGER_DATA_STR_max_threads]);
    
    printf("#\n#         The Following are valid only for:\n");
    printf("#              MAXman cards\n");
    printf("#              MAXserver 1800/1820 Terminal Servers\n#\n");

    printf("# DEFINE SERVER MANAGER DUMP %s\n",
	   ENA_DIS(manager[MANAGER_DATA_STR_dump_enabled]));
    
    printf("# DEFINE SERVER MANAGER DUMP MERIT %d\n",    
	   manager[MANAGER_DATA_STR_dump_merit]);
    
    printf("# DEFINE SERVER MANAGER DUMP SIZE %s\n",
	   (!manager[MANAGER_DATA_STR_dump_size]) ? "SMALL" : "FULL");
    
    logSize = GetWord((char *)&manager[MANAGER_DATA_STR_log_size]);
    printf("# DEFINE SERVER MANAGER LOG FILE %d\n",
	   logSize);
        
    printf("#\n#         The Following are valid only for:\n");
    printf("#              MAXman cards\n");
    printf("#              Products that use version 2 or 3 flash or ROM cards\n#\n");

    /* Use filler2 byte from manager.h which used to be parameter enabled. ***fbs 082395 */	
    printf("# DEFINE SERVER MANAGER PARAMETER SERVICE %s\n",
	   ENA_DIS(manager[MANAGER_DATA_STR_filler2]));
    
    printf("# DEFINE SERVER MANAGER PARAMETER DEFAULT SERVICE %s\n",
	   ENA_DIS(manager[MANAGER_DATA_STR_parameter_default]));
    
    printf("#\n#         The Following are valid only for:\n");
    printf("#              MAXman cards\n#\n");

    dumpDrive = GetWord((char *)&manager[MANAGER_DATA_STR_dump_drive]);
    printf("# DEFINE SERVER MANAGER DUMP DRIVE %d\n", 
	   dumpDrive+1);

    printf("# DEFINE SERVER MANAGER PARAMETER DRIVE %d\n",
	   manager[MANAGER_DATA_STR_parameter_drive]+1);
    
    /*
     * Now that we have set up the manager enabled flag, we can now print
     * the load data.  This is in the loadTable, and loadTableIndex is the
     * number of entries.
     */
    loop = 0;
    while (loop < MAX_NETWORK_DEVICES)
	{
	PrintLoadParams((char *)loadTable[loop]);
	loop++;
	}
}

/*
 ** PrintMenuDataParams()
 */

void PrintMenuDataParams( menu )
     unsigned char *menu;
{
    static int menuDataCount = 1;
    static int headerPrinted = FALSE;
    
    /* 
     * Do not print menu entries that are non nulls, we do want to increase
     * menuData count though.  This is because it can be a blank menu entry.
     */

    if((menu[MENU_STR_menu_display] !='\0') && 
       (menu[MENU_STR_menu_command] != '\0'))
	{

	if(headerPrinted == FALSE)
	    {
	    headerPrinted = TRUE;
	    PrintCommentHeader( !menuEnabled, "The Menu feature");
	    EchoHeader("Menu Entry Information");
	    printf("#\n# The menu entries are not executable.  It is a limitation\n");
	    printf("# that the user be prompted for the command.  Thus, commands\n");
	    printf("# are commented out.  The executable portion of the command\n");
	    printf("# is displayed on the first line, followed on the next line\n");
	    printf("# by the executable text.  This is what needs to be entered\n");
	    printf("# when prompted. \n#\n");
	    }
	/* printf("#echo DEFINE SERVER MENU %d \"%s\"\n",menuDataCount,
	       (char *) &menu[MENU_STR_menu_display]); */

	printf("# DEFINE SERVER MENU %d \"%s\"\n",menuDataCount,
	       (char *) &menu[MENU_STR_menu_display]);
	
	printf("# %s\n", (char *) &menu[MENU_STR_menu_command]);
	}
    menuDataCount++;    
}

/*
 ** PrintMenuTextParams()
 */

void PrintMenuTextParams( menu )
     unsigned char *menu;
{
	EchoHeader("Menu Prompt Information");
	printf("%sDEFINE SERVER MENU PROMPT \"%s\"\n",
	       CMD_COMMENT(!(menuEnabled || nestedMenuEnabled)),
	       (char *) &menu[MENU_TEXT_STR_menu_prompt]);
	printf("%sDEFINE SERVER MENU CONTINUE PROMPT \"%s\"\n",
	       CMD_COMMENT(!(menuEnabled || nestedMenuEnabled)),
	       (char *) &menu[MENU_TEXT_STR_continue_prompt]);
}

/*
 ** PrintNVSParams()
 **
 ** NVS params are not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintNVSParams( nvs )
     unsigned char *nvs;
{
    static int nvsCount = 1;            /* used to count NVS parameter segment */
    int loop;                           /* a loop variable */
    int doubleWord;                     /* double words */
    char loadDumpString[120];           /* used to store the string to print */

    /*
     * This structure is bit aligned so....
     */
    typedef struct n_str	{
	unsigned int ctlrType    : (NET_SELECT_ctlrNumber - NET_SELECT_ctlrType);
	unsigned int ctlrNumber  : (NET_SELECT_destClass - NET_SELECT_ctlrNumber);
	unsigned int destClass   : (NET_SELECT_dest - NET_SELECT_destClass);
	unsigned int dest        : (NET_SELECT_portType - NET_SELECT_dest);
	unsigned int portType    : (NET_SELECT_portNum - NET_SELECT_portType);
	unsigned int portNum     : (NET_SELECT_connector - NET_SELECT_portNum);
	unsigned int connector   : ((NET_SELECT_sizelen *8) - 
				    NET_SELECT_connector);
	} N_STR;

    N_STR   *netFake;
    unsigned int netStr;        /* the N_STR is smaller than this */
    
    static char unknown[] = "";
    static char *ctlrString[] = 
	{
	"ETHERNET", "ETHERNET", "TOKEN RING", "FDDI", "WAN", 
	"ETHERNET REPEATER", "TOKENRING CONCENTRATOR", "FDDI CONCENTRATOR"
	};
    static char *destString[] = 
	{
	"DISABLED", "SEGMENT", "EXTERNAL", "EXTERNAL",
	unknown, "ETHERNET REPEATER", "TOKENRING CONCENTRATOR",
	"FDDI CONCENTRATOR"
	};

    if (OneMegProduct())
	{
	/*
	 ** NVS parameters are not supported under one megabyte images
	 */
	return;
	}

    if(nvsCount ==1)
	{
	EchoHeader("Chassis Boot Parameters");
	PrintHeader("Chassis information is intentionally commented out");
	}	

    /*
     * Need to step through the PRIMARY, SECONDARY, and TERTIARY boot
     * records.
     */
    
    for(loop = 0 ; loop < 3; loop ++)
	{

	/* 
	 * lets only print this stuff if the boot parameter is enabled 
	 *
	 * if(nvs[LB2_SLOT_NVS_STR_boot +
	 *    (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_flags] & 
	 *    BOOT_RECORD_ENABLED)
	 * Currently we'll print out all the boot records, wether enabled or not
	 * should this change use the above if instead of TRUE
	 */

	if (TRUE)
	    {
	    if (loop == 0)
		{
		printf("#\n#echo          Chassis Slot %d\n", 
		       nvsCount);
		}
	    
	    printf("#\n#         The following Boot Record is %senabled\n#\n",
	    (nvs[LB2_SLOT_NVS_STR_boot + 
		  (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_flags] & 
	     BOOT_RECORD_ENABLED) ? "" : "NOT ");

	    printf("# DEFINE SERVER CHASSIS SLOT %d LOADDUMP %s %s\n",
		   nvsCount,
		   RECORD(loop),
		   (nvs[LB2_SLOT_NVS_STR_boot + 
			(loop * BOOT_RECORD_sizelen) + BOOT_RECORD_flags] & 
		    BOOT_RECORD_ENABLED) ? "ENABLED" : "DISABLED");

	    sprintf(loadDumpString, "# DEFINE SERVER CHASSIS SLOT %d LOAD %s IMAGE PROTOCOL ", 
		   nvsCount,
		    RECORD(loop));
	    PrintLoadDumpProtocols( loadDumpString, (char *) &nvs[LB2_SLOT_NVS_STR_boot +
		       (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_controlFlags]);
	    
	    sprintf(loadDumpString, "# DEFINE SERVER CHASSIS SLOT %d DUMP %s PROTOCOL ", 
		    nvsCount,
		    RECORD(loop));
	    PrintLoadDumpProtocols(loadDumpString, (char *) &nvs[LB2_SLOT_NVS_STR_boot +
			   (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_controlFlags + 
			   (LP_DUMP * sizeof(int))]);
	    
	    sprintf(loadDumpString, "# DEFINE SERVER CHASSIS SLOT %d LOAD %s PARAMETER PROTOCOL ", 
		   nvsCount,
		    RECORD(loop));
	    PrintLoadDumpProtocols( loadDumpString, (char *) &nvs[LB2_SLOT_NVS_STR_boot +
		       (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_controlFlags + 
		       (LP_PARAM * sizeof(int))]);

	    if(nvs[LB2_SLOT_NVS_STR_boot + (loop * BOOT_RECORD_sizelen) +
		   BOOT_RECORD_mopFileName] != '\0')
		{
		printf("# DEFINE SERVER CHASSIS SLOT %d LOAD %s SOFTWARE %s\n", 
		       nvsCount,
		       RECORD(loop),
		       (char *) &nvs[LB2_SLOT_NVS_STR_boot +
		       (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_mopFileName]);
		}
	    
	    
	    /* 
	     * Network selection
	     * copy the NET_SELECT structure into our integer array,
	     * then use our fake N_STR to get the correct offsets.
	     */
	    netStr = GetDoubleWord((char *) &nvs[LB2_SLOT_NVS_STR_boot + 
				(loop * BOOT_RECORD_sizelen) +
				BOOT_RECORD_net_select + NET_SELECT_ctlrType]);
	    
	    netFake = (N_STR *) ((char *) &netStr);
	    
	    if(ctlrString[netFake->ctlrType] != unknown)
		{
		
		printf("# DEFINE SERVER CHASSIS SLOT %d LOADDUMP %s %s %d %s", 
		       nvsCount,
		       RECORD(loop),
		       ctlrString[netFake->ctlrType],
		       netFake->ctlrNumber +1,
		       destString[netFake->destClass]);
		
		if((strcmp(destString[netFake->destClass],"DISABLED")) != 0)
		    {
		    printf(" %c",('A' +netFake->dest));
		    }
		printf("\n");
		}
	    
	    
	    /*
	     * Chassis load information
	     */
	    
	    if((doubleWord = GetDoubleWord((char *) &nvs[LB2_SLOT_NVS_STR_boot +
		 (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_unitIpAddr])) != 0)
		{
		printf("# DEFINE SERVER CHASSIS SLOT %d LOAD %s INTERNET ADDRESS %s\n", 
		       nvsCount,
		       RECORD(loop),
		       AlignAndConvertIpAddr((char *) &nvs[LB2_SLOT_NVS_STR_boot +
		         (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_unitIpAddr]));
		}
	    
	    if((doubleWord = GetDoubleWord((char *) &nvs[LB2_SLOT_NVS_STR_boot +
		 (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_hostIpAddr])) != 0)
		{
		printf("# DEFINE SERVER CHASSIS SLOT %d LOAD %s INTERNET LOAD HOST %s\n", 
		       nvsCount,
		       RECORD(loop),
		       AlignAndConvertIpAddr((char *) &nvs[LB2_SLOT_NVS_STR_boot +
			 (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_hostIpAddr]));
		}
	    
	    if((doubleWord = GetDoubleWord((char *) &nvs[LB2_SLOT_NVS_STR_boot +
		 (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_gatewayIpAddr])) != 0)
		{
		printf("# DEFINE SERVER CHASSIS SLOT %d LOAD %s INTERNET LOAD GATEWAY %s\n",
		    nvsCount,
		    RECORD(loop),
		    AlignAndConvertIpAddr((char *) &nvs[LB2_SLOT_NVS_STR_boot +
		      (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_gatewayIpAddr]));
		}
	    
	    if(nvs[LB2_SLOT_NVS_STR_boot + (loop * BOOT_RECORD_sizelen) 
		   + BOOT_RECORD_tftpFileName] != '\0')
		{
		printf("# DEFINE SERVER CHASSIS SLOT %d LOAD %s INTERNET LOAD FILE %s\n", 
		    nvsCount,
		    RECORD(loop),
		    (char *) &nvs[LB2_SLOT_NVS_STR_boot + 
		     (loop * BOOT_RECORD_sizelen) + BOOT_RECORD_tftpFileName]);
		}
	    }
	}
    nvsCount++;
}

/*
 ** PrintPortParams()
 */

void PrintPortCharacteristicData( node, offset )
     PLISTNODE node;
     int       offset;
{
    short singleWord;
    int   ipAddr;
    char  ipString[IP_ADDR_SIZE];
    char  groupList[TBITS_GROUPS_SIZE*8*5];
    
    /*
     * Port Characteristics
     */

    switch (offset)
	{
    case PTCHAR_STR_multisessions:
	{
	HANDLE_PORT_ZERO( node->portList);
	PrintCommentHeader(!multiSessionsEnabled, "Multi-Sessions Feature");
	printf("%sDEFINE PORT %s MULTISESSIONS %s\n", 
	       CMD_COMMENT(!multiSessionsEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_authorized_groups:
	{
	GroupListToString(node->type.gValue, 
			  groupList);
	printf("%sDEFINE PORT %s AUTHORIZED GROUPS %s ENABLED\n", 
	       CMD_COMMENT(!latEnabled), 
	       PListToString(node->portList),
	       groupList);
	break;
	}
    case PTCHAR_STR_break_type:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s BREAK           %s\n",
	       PListToString(node->portList),
	       (node->type.cValue == PORT_BREAK_DISABLED) ? "DISABLED":
	       (node->type.cValue == PORT_BREAK_LOCAL) ? "LOCAL" :
	       "REMOTE");
	break;
	}

    case PTCHAR_STR_dedicated_preferred_service + LOCATION_STR_service_name:
	{
	HANDLE_PORT_ZERO( node->portList);
	PrintPortPreferredServiceData( node, offset);
	break;
	}
    case PTCHAR_STR_autoconnect:
	{
	printf("DEFINE PORT %s AUTOCONNECT     %s\n", 
	       PListToString(node->portList),
	   ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_autodedicated:
	{
	printf("DEFINE PORT %s AUTODEDICATED   %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_autoprompt:
	{
	printf("%sDEFINE PORT %s AUTOPROMPT      %s\n", 
	       CMD_COMMENT(!latEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_broadcast:
	{
	printf("DEFINE PORT %s BROADCAST       %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_connect_resume:
	{
	printf("DEFINE PORT %s CONNECTRESUME   %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_cmd_size:
	{
        if (!OneMegProduct())
	{
	    HANDLE_PORT_ZERO( node->portList);
	    printf("DEFINE PORT %s COMMAND SIZE %d\n", 
	       PListToString(node->portList),
	       node->type.siValue);
	}
	break;
	}
    case PTCHAR_STR_inactivity:
	{    
	printf("DEFINE PORT %s INACTIVITY LOGOUT %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_interrupts:
	{    
	printf("DEFINE PORT %s INTERRUPTS %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_limited_view:
	{    
	printf("DEFINE PORT %s LIMITED VIEW %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_login_duration:
	{
        if (!OneMegProduct())
	{
	    printf("DEFINE PORT %s LOGIN DURATION %d\n", 
	       PListToString(node->portList),
	       node->type.siValue);
	}
	break;
	}
    case PTCHAR_STR_loss:
	{    
	printf("DEFINE PORT %s LOSS NOTIFICATION %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_message_codes:
	{    
	printf("DEFINE PORT %s MESSAGE CODES %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_noloss:
	{    
	printf("DEFINE PORT %s NOLOSS %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_pause:
	{    
	printf("DEFINE PORT %s PAUSE %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_queuing:
	{    
	printf("DEFINE PORT %s QUEUING %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_resolve_service:
	{    
	printf("DEFINE PORT %s RESOLVE SERVICE %s\n", 
	       PListToString(node->portList),
	       (node->type.cValue == SESSION_LAT) ? "LAT" :
	       (node->type.cValue == SESSION_TELNET) ? "TELNET" :
	       ((node->type.cValue == SESSION_TELNETLAT) && (!OneMegProduct())) ? "ANY_TELNET" :
	       ((node->type.cValue == SESSION_LATTELNET) && (!OneMegProduct())) ? "ANY_LAT" :
	       "ANY");
	break;
	}
    case PTCHAR_STR_remote_modification:
	{    
	printf("%sDEFINE PORT %s REMOTE MODIFICATION %s\n", 
	       CMD_COMMENT(!latEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
/* The following command was removed since it does nothing (PID #14372) */
/* The snmp Objid_basicPortRing is still used. */
    case PTCHAR_STR_ring:
	{    
	printf("# DEFINE PORT %s RING %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_rlogin_transparent_mode:
	{    
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s RLOGIN TRANSPARENT MODE %s\n",
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
    }
	break;
	}
    case PTCHAR_STR_script_echo:
	{    
	printf("DEFINE PORT %s SCRIPT ECHO %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_script_login:
	{    
	printf("DEFINE PORT %s SCRIPT LOGIN %s\n",
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_signal_check:
	{    
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s SIGNAL CHECK %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_verification:
	{    
	printf("DEFINE PORT %s VERIFICATION %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_unix_enabled:
	{    
	if (!OneMegProduct())
	    {
	    printf("DEFINE PORT %s ULI %s\n", 
		   PListToString(node->portList),
		   ENA_DIS(node->type.cValue));
	    }
	break;
	}
    case PTCHAR_STR_autoHangup:
	{    
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s AUTOHANGUP %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
    }
	break;
	}
	}
}

/*
 ** PrintPortPreferredServiceData()
 */

void PrintPortPreferredServiceData( node, offset)
     PLISTNODE node;
     int       offset;
{
    int    loop;
    int    tDedicated = FALSE;
    int    tPreferred = FALSE;    
    int    lDedicated = FALSE;
    int    lPreferred = FALSE;    
	int    rPreferred = FALSE;
	int    rDedicated = FALSE;
    char   telnetDedicated[TBITS_PORT_LIST_SIZE];
    char   telnetPreferred[TBITS_PORT_LIST_SIZE];
    char   latDedicated[TBITS_PORT_LIST_SIZE];
    char   latPreferred[TBITS_PORT_LIST_SIZE];
	char   rloginDedicated[TBITS_PORT_LIST_SIZE];
	char   rloginPreferred[TBITS_PORT_LIST_SIZE];
    char   servType;
    char   dedPfd;
    PLIST  nodeList, destinationList;
    PLISTNODE nodeListPtr, destListPtr;

    PlistInit( &nodeList);
    PlistInit( &destinationList);

    switch (offset)
	{
    case PTCHAR_STR_dedicated_preferred_service + LOCATION_STR_service_name:
	{
	for (loop = 0; loop < portNumber; loop++)
	    {
	    if (TST_ARRAY_BIT(node->portList, loop))
		{
		/*
		 ** We have ports to check and see if they're LAT or TELNET
		 */
		servType = GetByte((char *)(portTable[loop] + 
			    PTCHAR_STR_dedicated_preferred_service_type));
		
		dedPfd =  GetByte((char *)(portTable[loop] + 
			    PTCHAR_STR_dedicated_preferred_service_flag));
		if (servType == SESSION_LAT)
		{
		    if (dedPfd)
			{
				bits_set( latDedicated, loop, loop);
				lDedicated = TRUE;
			}
		    else
			{
				bits_set( latPreferred, loop, loop);
				lPreferred = TRUE;
			}			
		}
		else if (servType == SESSION_TELNET)
		{
		    if (dedPfd)
			{
				bits_set( telnetDedicated, loop, loop);
				tDedicated = TRUE;
			}
		    else
			{
				bits_set( telnetPreferred, loop, loop);
				tPreferred = TRUE;
			}			
		}		    
		else 
		{
			if (dedPfd)
			{
				bits_set( rloginDedicated, loop, loop);
				rDedicated = TRUE;
			}
			else
			{
				bits_set( rloginPreferred, loop, loop);
				rPreferred = TRUE;
			}
		}

		/*
		 ** Now we have to work on the node and destionation information
		 ** for Lat
		 */
		AddPortToPlist( &nodeList, (char *)portTable[loop], loop, 
			       PTCHAR_STR_dedicated_preferred_service + 
			       LOCATION_STR_node_name,
			       CHAR_PTR_VALUE, ADD_TO_TAIL);

		AddPortToPlist( &destinationList, (char *)portTable[loop], loop,
			       PTCHAR_STR_dedicated_preferred_service + 
			       LOCATION_STR_destination_name,
			       CHAR_PTR_VALUE, ADD_TO_TAIL);

		} /* End port bit is set */
	    }

	/*
	 ** We now have enough information to print the telnet data
	 */

	if (*node->type.pcValue != '\0')
	{
		if ( tDedicated)
		{
		    printf("DEFINE PORT %s TELNET DEDICATED SERVICE %s\n", 
				   PListToString(node->portList),
				   node->type.pcValue);
		}
		
		if( tPreferred)
		{
		    printf("DEFINE PORT %s TELNET PREFERRED SERVICE %s\n", 
				   PListToString(node->portList),
				   node->type.pcValue);
		}
	}
	else
	{
		if ( tDedicated)
		{
		    printf("DEFINE PORT %s TELNET DEDICATED SERVICE NONE\n", 
				   PListToString(node->portList));
		}
		
		if( tPreferred)
		{
		    printf("DEFINE PORT %s TELNET PREFERRED SERVICE NONE\n", 
				   PListToString(node->portList));
		}
	}
	
	/* print RLogin info */
	
	if (*node->type.pcValue != '\0')
	{
		if ( rDedicated)
		{
			printf("DEFINE PORT %s RLOGIN DEDICATED SERVICE %s\n",
				   PListToString(node->portList),
				   node->type.pcValue);
		}
		
		if( rPreferred)
		{
			printf("DEFINE PORT %s RLOGIN PREFERRED SERVICE %s\n",
				   PListToString(node->portList),
				   node->type.pcValue);
		}
	}
	else
	{
		if ( rDedicated)
		{
			printf("DEFINE PORT %s RLOGIN DEDICATED SERVICE NONE\n",
				   PListToString(node->portList));
		}
		
		if( rPreferred)
		{
			printf("DEFINE PORT %s RLOGIN PREFERRED SERVICE NONE\n",
				   PListToString(node->portList));
		}
	}

	/* 
	 ** Now lets process the Lat information
	 */

	if (*node->type.pcValue != '\0')
	    {
	    if( lDedicated)
		{
		printf("DEFINE PORT %s LAT DEDICATED SERVICE %s\n", 
		       PListToString(latDedicated),
		       node->type.pcValue);
		lDedicated = FALSE;
		}
	    if( lPreferred)
		{
		printf("DEFINE PORT %s LAT PREFERRED SERVICE %s\n", 
		       PListToString(node->portList),
		       node->type.pcValue);
		lPreferred = FALSE;
		}
	    bits_clear(latDedicated, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
	    bits_clear(latPreferred, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));	    

	    nodeListPtr = nodeList.head;     /* we will always have a value here */
	    while( nodeListPtr != NULL_VALUE)
		{
		for (loop = 0; loop < portNumber; loop++)
		    {
		    if (TST_ARRAY_BIT(nodeListPtr->portList, loop))
			{
			servType = GetByte((char *)(portTable[loop] + 
				    PTCHAR_STR_dedicated_preferred_service_type));
			dedPfd =  GetByte((char *)(portTable[loop] + 
				   PTCHAR_STR_dedicated_preferred_service_flag));
			if (servType == SESSION_LAT)
			    {
			    if (dedPfd)
				{
				bits_set( latDedicated, loop, loop);
				lDedicated = TRUE;
				}
			    else 
				{
				bits_set( latPreferred, loop, loop);
				lPreferred = TRUE;
				}			
			    }
			}
		    }
		if( lDedicated)
		    {
		    if ( *nodeListPtr->type.pcValue != '\0')
			{
			printf("DEFINE PORT %s LAT DEDICATED SERVICE %s NODE %s\n", 
			       PListToString(latDedicated),
			       node->type.pcValue,
			       nodeListPtr->type.pcValue);
			}
		    
		    lDedicated = FALSE;
		    }
		if( lPreferred)
		    {
		    if ( *nodeListPtr->type.pcValue != '\0')
			{
			printf("DEFINE PORT %s LAT PREFERRED SERVICE %s NODE %s\n", 
			       PListToString(node->portList),
			       node->type.pcValue,
			       nodeListPtr->type.pcValue);
			}
		    
		    lPreferred = FALSE;
		    }
		nodeListPtr = nodeListPtr->next;
		} /* end nodeList loop */
	    PlistFree( &nodeList);
	    bits_clear(latDedicated, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
	    bits_clear(latPreferred, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));	    
	    
	    destListPtr = destinationList.head;
	    while ( destListPtr != NULL_VALUE)
		{
		for (loop = 0; loop < portNumber; loop++)
		    {
		    if (TST_ARRAY_BIT(destListPtr->portList, loop))
			{
			servType = GetByte((char *)(portTable[loop] + 
				        PTCHAR_STR_dedicated_preferred_service_type));
			
			dedPfd =  GetByte((char *)(portTable[loop] + 
					PTCHAR_STR_dedicated_preferred_service_flag));
			
			if (servType == SESSION_LAT)
			    {
			    if (dedPfd)
				{
				bits_set( latDedicated, loop, loop);
				lDedicated = TRUE;
				}
			    else
				{
				bits_set( latPreferred, loop, loop);
				lPreferred = TRUE;
				}			
			    }
			}
		    }
		if( lDedicated)
		    {
		    if ( *destListPtr->type.pcValue != '\0')
			{
			printf("DEFINE PORT %s LAT DEDICATED SERVICE %s DESTINATION %s\n", 
			       PListToString(latDedicated),
			       node->type.pcValue,
			       destListPtr->type.pcValue);
			}
		    }
		if( lPreferred)
		    {
		    if ( *destListPtr->type.pcValue != '\0')
			{
			printf("DEFINE PORT %s LAT PREFERRED SERVICE %s DESTINATION %s\n", 
			       PListToString(node->portList),
			       node->type.pcValue,
			       destListPtr->type.pcValue);
			}
		    }
		destListPtr = destListPtr->next;
		} /* end destination list loop */
	    PlistFree( &destinationList);
	    } /* end service != NULL_VALUE */
	else
	    {
	    if ( lDedicated)
		{
		printf("DEFINE PORT %s LAT DEDICATED SERVICE NONE\n", 
		       PListToString(node->portList));
		}
	    
	    if( lPreferred)
		{
		printf("DEFINE PORT %s LAT PREFERRED SERVICE NONE\n", 
		       PListToString(node->portList));
		}
	    }
	} /* End Case */
	} /* end switch */
}

/*
 ** PrintPortModemRelatedData()
 */

void PrintPortModemRelatedData( node, offset)
     PLISTNODE node;
     int offset;
{
    switch (offset)
	{
    case PTCHAR_STR_access:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s ACCESS %s\n",
	       PListToString(node->portList),
	       (node->type.cValue == PORT_ACCESS_NONE) ? "NONE" :
	       (node->type.cValue == PORT_ACCESS_DYNAMIC) ? "DYNAMIC" :
	       (node->type.cValue == PORT_ACCESS_LOCAL) ? "LOCAL" :
	       (node->type.cValue == PORT_ACCESS_REMOTE) ? "REMOTE" :
	       "PRT3270");
	break;
	}
    case PTCHAR_STR_input_speed:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s SPEED  %s\n",
	       PListToString(node->portList),
	       (node->type.cValue == PORT_SPEED_75) ? "75" :
	       (node->type.cValue == PORT_SPEED_110) ? "110" :
	       (node->type.cValue == PORT_SPEED_134) ? "134" :
	       (node->type.cValue == PORT_SPEED_150) ? "150" :
	       (node->type.cValue == PORT_SPEED_300) ? "300" :
	       (node->type.cValue == PORT_SPEED_600) ? "600" :
	       (node->type.cValue == PORT_SPEED_1200) ? "1200" :
	       (node->type.cValue == PORT_SPEED_1800) ? "1800" :
	       (node->type.cValue == PORT_SPEED_2000) ? "2000" :
	       (node->type.cValue == PORT_SPEED_2400) ? "2400" :
	       (node->type.cValue == PORT_SPEED_4800) ? "4800" :
	       (node->type.cValue == PORT_SPEED_9600) ? "9600" :
	       (node->type.cValue == PORT_SPEED_19200) ? "19200" :
	       (node->type.cValue == PORT_SPEED_38400) ? "38400" :
	       (node->type.cValue == PORT_SPEED_56000) ? "56000" :
	       (node->type.cValue == PORT_SPEED_57600) ? "57600" :
	       (node->type.cValue == PORT_SPEED_64000) ? "64000" :
	       (node->type.cValue == PORT_SPEED_76800) ? "76800" :
	       (node->type.cValue == PORT_SPEED_115000) ? "115200" :
	       (node->type.cValue == PORT_SPEED_50) ? "50" :
	       (node->type.cValue == PORT_SPEED_7200) ? "7200" :
	       (node->type.cValue == PORT_SPEED_12000) ? "12000" :
	       (node->type.cValue == PORT_SPEED_14400) ? "14400" :
	       (node->type.cValue == PORT_SPEED_16800) ? "16800" :
	       (node->type.cValue == PORT_SPEED_24000) ? "24000" :
	       (node->type.cValue == PORT_SPEED_21600) ? "21600" :
	       (node->type.cValue == PORT_SPEED_26400) ? "26400" :
	       "28800" );
	break;
	}
    case PTCHAR_STR_character_size:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s CHARACTER SIZE %d\n",
	       PListToString(node->portList),
	       node->type.cValue); 
	break;
	}
    case PTCHAR_STR_parity:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s PARITY    %s\n", 
	       PListToString(node->portList),
	       (node->type.cValue == PORT_PARITY_NONE) ? "NONE" :
	       (node->type.cValue == PORT_PARITY_EVEN) ? "EVEN" :
	       (node->type.cValue == PORT_PARITY_MARK) ? "MARK" :
	       "ODD");
	break;
	}
    case PTCHAR_STR_stop_bits:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s STOP BITS %d\n", 
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PTCHAR_STR_autobaud:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s AUTOBAUD  %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
   
    case PTCHAR_STR_flow_control:
	{
	HANDLE_PORT_ZERO( node->portList);
        /* Flow control for UBI product 91 (ASY160) differs from the norm ***fbs 082195 SC62370 */
	printf("DEFINE PORT %s FLOW CONTROL %s\n",
	       PListToString(node->portList),
	       (node->type.cValue == PORT_FLOW_DISABLED) ? "DISABLED" :

	       ((node->type.cValue == PORT_FLOW_CTS) && 
                   (HardwareType != ROM_CRATE_HW_OSPREY)) ? "CTS" : 
	       ((node->type.cValue == PORT_FLOW_CTS) && 
                   (HardwareType  == ROM_CRATE_HW_OSPREY)) ? "Undefined" : 

	       ((node->type.cValue == PORT_FLOW_DSR) && 
                   (HardwareType != ROM_CRATE_HW_OSPREY)) ? "DSR" : 
	       ((node->type.cValue == PORT_FLOW_DSR) && 
                   (HardwareType == ROM_CRATE_HW_OSPREY)) ? "DCD" : 

	       (node->type.cValue == PORT_FLOW_XON) ? "XON" :
	       (node->type.cValue == PORT_FLOW_ENQH) ? "ENQ_HOST" :
	       (node->type.cValue == PORT_FLOW_ENQT) ? "ENQ_TERM" :
	       "XON_ALT") ;
	break;
	}
    case PTCHAR_STR_input_flow_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s INPUT  FLOW CONTROL %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_output_flow_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s OUTPUT FLOW CONTROL %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}

    case PTCHAR_STR_xonTimer:
	{
	HANDLE_PORT_ZERO( node->portList);	
	printf("DEFINE PORT %s XON SEND TIMER %d\n", 
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PTCHAR_STR_modem_control:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s MODEM CONTROL %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_dialback_timeout:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DIALBACK TIMEOUT %d\n", 
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PTCHAR_STR_dcd_timeout:
	{
	HANDLE_PORT_ZERO( node->portList);
	/*
	 * DCD timeout - values need to be multiplied by 100 for command.
	 * also -1 means timeout of 0, and 0 means default of 2000.
	 */
	if(node->type.cValue == 0)
	    {
	    printf("DEFINE PORT %s DCD TIMEOUT 2000\n",
		   PListToString(node->portList));
	    }
	else 
	    {
	    printf("DEFINE PORT %s DCD TIMEOUT %d\n", 
	       PListToString(node->portList),
		   (node->type.cValue == 0xFF) ? 0 : 
		   (100 * node->type.cValue));
	    }
	break;
	}
    case PTCHAR_STR_dialback_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DIALBACK  %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_dialup:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DIALUP    %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_dsrlogout:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DSRLOGOUT %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_dsrwait:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DSRWAIT   %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_dtrwait:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DTRWAIT   %s\n", 
	       PListToString(node->portList),
	       (node->type.cValue == PORT_DTRWAIT_DISABLED) ? "DISABLED" :
	       (node->type.cValue == PORT_DTRWAIT_ENABLED) ? "ENABLED" :
	       (node->type.cValue == PORT_DTRWAIT_FORCONNECTION) ? 
	       "FORCONNECTION" : "FORRING");
	break;
	}
    case PTCHAR_STR_password:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s PASSWORD %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_idle_timeout:
	{
	printf("DEFINE PORT %s IDLE TIMEOUT %d\n", 
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PTCHAR_STR_type_ahead:
	{
	printf("DEFINE PORT %s TYPEAHEAD SIZE %d\n", 
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PTCHAR_STR_username:
	{
	printf("DEFINE PORT %s USERNAME \"%s\"\n", 
	       PListToString(node->portList),
	       node->type.pcValue);
	break;
	}
    case PTCHAR_STR_local_prompt:
	{
	printf("DEFINE PORT %s PROMPT   \"%s\"\n", 
	       PListToString(node->portList),
	       node->type.pcValue);
	break;
	}
    case PTCHAR_STR_type:
	{
	printf("DEFINE PORT %s TYPE     %s\n", 
	       PListToString(node->portList),
	       (node->type.cValue == PORT_TYPE_ANSI) ? "ANSI" :
	       (node->type.cValue == PORT_TYPE_HARDCOPY) ? "HARDCOPY" :
	       "SOFTCOPY");
	break;
	}
    case PTCHAR_STR_port_name:
	{
	if(*node->type.pcValue != '\0')
	    {
	    printf("DEFINE PORT %s NAME      %s\n", 
		   PListToString(node->portList),
		   node->type.pcValue);
	    }
	break;
	}
    case PTCHAR_STR_username_filtering:
	{
    if (!OneMegProduct())
    {
	printf("DEFINE PORT %s USERNAME FILTERING %s\n", 
	       PListToString(node->portList),
	       (node->type.cValue == PORT_USERNAME_FILTER_NONE) ? "NONE" 
	       : "SEVEN_BIT");
    }
	break;
	}

    case PTCHAR_STR_apd:
	{
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s APD ", 
	       CMD_COMMENT(!apdEnabled), 
	       PListToString(node->portList));
	if (node->type.siValue == APD_ALL)
	    {
	    printf("ALL");
	    }
	else
	    {
	    if (((node->type.siValue & APD_ARAP) == 0) &&
		((node->type.siValue & APD_INTERACTIVE) == 0) &&
		((node->type.siValue & APD_PPP) == 0) &&
		((node->type.siValue & APD_SLIP) == 0))
		{
		printf("DISABLED");
		}
	    else
		{
		printf("%s",
		       ((node->type.siValue & APD_ARAP) != 0) ? "ARAP " 
		       : "");
		printf("%s",
		       ((node->type.siValue & APD_INTERACTIVE) != 0) ? "INTERACTIVE " 
		       : "");
		printf("%s",
		       ((node->type.siValue & APD_PPP) != 0) ? "PPP " 
		       : "");
		printf("%s",
		       ((node->type.siValue & APD_SLIP) != 0) ? "SLIP " 
		       : "");
		}
	    }
	printf("\n");
    }	
	break;
	}
    case PTCHAR_STR_apd_default_protocol:
	{
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s APD DEFAULT ", 
	       CMD_COMMENT(!apdEnabled), 
	       PListToString(node->portList));
	if (node->type.siValue == 0)
	    {
	    printf("LOGOUT");
	    }
	else
	    {
	    printf("%s",
		   ((node->type.siValue & APD_ARAP) != 0) ? "ARAP " 
		   : "");
	    printf("%s",
		   ((node->type.siValue & APD_INTERACTIVE) != 0) ? "INTERACTIVE " 
		   : "");
	    printf("%s",
		   ((node->type.siValue & APD_PPP) != 0) ? "PPP " 
		   : "");
	    printf("%s",
		   ((node->type.siValue & APD_SLIP) != 0) ? "SLIP " 
		   : "");
	    }
	printf("\n");
    }
	break;
	}
    case PTCHAR_STR_apd_timeout:
	{
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s APD TIMEOUT ", 
	       CMD_COMMENT(!apdEnabled), 
	       PListToString(node->portList));
	if (node->type.cValue == 0)
	    {
	    printf("UNLIMITED");
	    }
	else
	    {
	    printf("%u", 
		   node->type.cValue);
	    }
	printf("\n");
    }
	break;
	}

    case PTCHAR_STR_apd_noprompt:
    {
        if (!OneMegProduct())
	{
	    HANDLE_PORT_ZERO( node->portList);
	    printf("%sDEFINE PORT %s APD PROMPT %s\n", 
	       CMD_COMMENT(!apdEnabled), 
	       PListToString(node->portList),
	       REV_ENA_DIS(node->type.cValue));
	}
	break;
    }
    /* PJB 3/20/97 Added "APD AUTHENTICATION INTERACTIVE" parameter. */
    case PTCHAR_STR_apd_security_last:
    {
        if (!OneMegProduct())
	{
	    HANDLE_PORT_ZERO( node->portList);
	    printf("%sDEFINE PORT %s APD AUTHENTICATION INTERACTIVE %s\n", 
	       CMD_COMMENT(!apdEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	}
	break;
    }


    case PTCHAR_STR_dialoutProtocol:
	{
    if (!OneMegProduct())
    {
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s DIALOUT ACTION %s\n",
	       PListToString(node->portList),
	       ((node->type.cValue == DIALOUT_PROTOCOL_NONE) ? "LOGOUT" :
		(node->type.cValue == DIALOUT_PROTOCOL_QUERY) ? "QUERY" :
		(node->type.cValue == DIALOUT_PROTOCOL_SLIP) ? "SLIP" :
		"PPP"));
    }
	break;
    }

  }
}

/*
 ** PrintPortSessionData()
 */

void PrintPortSessionData( node, offset)
     PLISTNODE node;
     int offset;
{
    switch (offset)
	{
    case PTCHAR_STR_backward_switch_ext:
	{
	printf("DEFINE PORT %s BACKWARD SWITCH %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       
	break;
	}
    case PTCHAR_STR_forward_switch_ext:
	{
	printf("DEFINE PORT %s FORWARD  SWITCH %s\n",
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       	       
	break;
	}
    case PTCHAR_STR_local_switch_ext:
	{
	printf("DEFINE PORT %s LOCAL    SWITCH %s\n",
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       	       
	break;
	}

    case PTCHAR_STR_default_session_mode:
	{
	printf("DEFINE PORT %s DEFAULT  SESSION MODE %s\n",
	       PListToString(node->portList),
	       (node->type.cValue == SESSION_FLOW_INTERACTIVE) ? "INTERACTIVE" :
	       (node->type.cValue == SESSION_FLOW_PASSALL) ? "PASSALL" :
	       (node->type.cValue == SESSION_FLOW_PASTHRU) ? "PASTHRU" :
	       (node->type.cValue == SESSION_FLOW_TRANSPARENT) ? "TRANSPARENT" :
	       "INTERACTIVE_NOIAC");
	break;
	}
    case PTCHAR_STR_session_limit:
	{
	printf("DEFINE PORT %s SESSION  LIMIT %d\n",
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
	}
}

/*
 ** PrintPortTelnetData()
 */

void PrintPortTelnetData( node, offset)
     PLISTNODE node;
     int       offset;
{
     int       found, loop;
     char      tempPortList[TBITS_PORT_LIST_SIZE];
    
    switch (offset)
	{
    case PTCHAR_STR_telnet_abort_output:
	{
	printf("%sDEFINE PORT %s TELNET ABORT OUTPUT %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       	       
	break;
	}
    case PTCHAR_STR_telnet_attention:
	{
	printf("%sDEFINE PORT %s TELNET ATTENTION %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       	       
	break;
	}
    case PTCHAR_STR_telnet_binary_mode:
	{
	printf("%sDEFINE PORT %s TELNET BINARY SESSION MODE %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == TELNET_FLOW_PASTHRU) ? "PASTHRU" :
	       (node->type.cValue == TELNET_FLOW_PASSALL) ? "PASSALL" : 
	       "INTERACTIVE");
	break;
	}
    case PTCHAR_STR_csi_escape:
	{
	printf("%sDEFINE PORT %s TELNET CSI ESCAPE %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_default_port:	
	{
	printf("%sDEFINE PORT %s TELNET DEFAULT PORT %d\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PTCHAR_STR_tn3270_default_port:	
	{
        if (!OneMegProduct())
	{
	    printf("%sDEFINE PORT %s TELNET TN3270 DEFAULT PORT %d\n",
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       node->type.siValue);
	}
	break;
	}

    case PTCHAR_STR_telnet_echo_mode:	
	{
	printf("%sDEFINE PORT %s TELNET ECHO MODE %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == PORT_TELNET_ECHO_LOCAL) ? "LOCAL" :
	       (node->type.cValue == PORT_TELNET_ECHO_REMOTE) ? "REMOTE" :
	       "DISABLED");
	break;
	}
    case PTCHAR_STR_telnet_erase_character:		
	{
	printf("%sDEFINE PORT %s TELNET ERASE CHARACTER %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));	       	       
	break;
	}
    case PTCHAR_STR_telnet_erase_line:		
	{	
	printf("%sDEFINE PORT %s TELNET ERASE LINE %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_eor_reflection:
	{
	printf("%sDEFINE PORT %s TELNET EOR REFLECTION %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_utTn3270ErrLock:
	{
	printf("%sDEFINE PORT %s TELNET TN3270 ERRORLOCK %s\n",
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_interrupt:
	{
	printf("%sDEFINE PORT %s TELNET INTERRUPT %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_location:
	{    
	if (!OneMegProduct())
	    {
	    printf("%sDEFINE PORT %s TELNET LOCATION %s\n", 
	       CMD_COMMENT(!telnetEnabled),
		   PListToString(node->portList),
		   ENA_DIS(node->type.cValue));
	    }
	break;
	}
    case PTCHAR_STR_telnet_newline:
	{
	printf("%sDEFINE PORT %s TELNET NEWLINE %s\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	   (node->type.cValue == PORT_TELNET_NEWLINE_NULL) ? "NULL" :
	   (node->type.cValue == PORT_TELNET_NEWLINE_LF) ? "LINEFEED" :
	   "NOTHING");
	break;
	}
    case PTCHAR_STR_telnet_newline_filter:
	{
	printf("%sDEFINE PORT %s TELNET NEWLINE FILTERING %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	(node->type.cValue == PORT_TELNET_NEWLINE_FILTER_NONE) ? "NONE" :
	(node->type.cValue == PORT_TELNET_NEWLINE_FILTER_CR) ? "CR" :
	(node->type.cValue == PORT_TELNET_NEWLINE_FILTER_LF) ? "LINEFEED" :
	(node->type.cValue  == PORT_TELNET_NEWLINE_FILTER_NULL)	? "NULL" :
	"STANDARD");
	break;
	}
    case PTCHAR_STR_telnet_option_display:	
	{    
	printf("%sDEFINE PORT %s TELNET OPTION DISPLAY %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_query:
        {
	printf("%sDEFINE PORT %s TELNET QUERY %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_remote:
	{
	printf("%sDEFINE PORT %s TELNET REMOTE %d\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PTCHAR_STR_telnet_synchronize:	
	{
	printf("%sDEFINE PORT %s TELNET SYNCHRONIZE %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_TermType:	
	{
	if (*node->type.pcValue != '\0')
	    {
	    printf("%sDEFINE PORT %s TELNET TERMINALTYPE \"%s\"\n", 
	       CMD_COMMENT(!telnetEnabled),
		   PListToString(node->portList),
		   node->type.pcValue);
	    }
	else
	    {
	    printf("%sDEFINE PORT %s TELNET TERMINALTYPE NONE\n",
	       CMD_COMMENT(!telnetEnabled),
		   PListToString(node->portList));
	    }
	break;
	}
    case PTCHAR_STR_tn3270_device:
	{
	printf("%sDEFINE PORT %s TELNET TN3270 DEVICE %s\n", 
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       (*node->type.chr8Value == '\0') ? "NONE" :
	       node->type.chr8Value);
	break;
	}
    case PTCHAR_STR_tn3270_eor:
	{
	printf("%sDEFINE PORT %s TELNET TN3270 EOR %s\n", 
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnet_tn3270printerport:
	{
	if (!OneMegProduct())
	    {
	    if (node->type.cValue)
		{
		printf("%sDEFINE PORT %s TELNET TN3270 PRINTERPORT %u\n", 
		       CMD_COMMENT(!tn3270Enabled),
		       PListToString(node->portList),
		       node->type.cValue);
		}
	    else
		{
		/* 
		 * 0 means any
		 */
		printf("%sDEFINE PORT %s TELNET TN3270 PRINTERPORT ANY\n",
		       CMD_COMMENT(!tn3270Enabled),
		       PListToString(node->portList));
		}
	    }
	break;
	}
    case PTCHAR_STR_tn3270_xlat:
	{	
	printf("%sDEFINE PORT %s TELNET TN3270 TRANSLATIONTABLE %s\n", 
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       (*node->type.chr8Value == '\0') ? "NONE" :
	       node->type.chr8Value);
	break;
	}
    case PTCHAR_STR_tn3270_xtdattrs:
	{
	printf("%sDEFINE PORT %s TELNET TN3270 XTDATTRS %s\n", 
	       CMD_COMMENT(!tn3270Enabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    /*
     * Telnet transmit
     */
    case PTCHAR_STR_telnet_transmit:
	{
	printf("%sDEFINE PORT %s TELNET TRANSMIT %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == PORT_TELNET_TRANSMIT_IMMEDIATE) 
	       ? "IMMEDIATE" :
	       (node->type.cValue == PORT_TELNET_TRANSMIT_BUFFERED)
	       ? "BUFFERED" :
	       "IDLETIME");

        if (initPortArrays)
	{
    		bits_clear(portXmitBuff, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
    		bits_clear(portXmitIdle, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
		initPortArrays = FALSE;
	}
        for (loop = 0; loop < portNumber; loop++)
        {
           if (TST_ARRAY_BIT(node->portList, loop))
           {
		if (node->type.cValue == PORT_TELNET_TRANSMIT_BUFFERED)
		    bits_set(portXmitBuff, loop, loop);
		else if (node->type.cValue == PORT_TELNET_TRANSMIT_IDLE)
		    bits_set(portXmitIdle, loop, loop);
	   }
	}
	break;
	}

    case PTCHAR_STR_telnet_idle_time:	
	{
    	bits_clear(tempPortList, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
	found = FALSE;
        for (loop = 0; loop < portNumber; loop++)
        {
           if ((TST_ARRAY_BIT(portXmitIdle, loop)) && (TST_ARRAY_BIT(node->portList, loop)))
           {
		bits_set (tempPortList, loop, loop);
		found = TRUE;
	   }
	}
	if (found)
	{
    	    printf("%sDEFINE PORT %s TELNET TRANSMIT IDLETIME %d\n",
	       CMD_COMMENT(!telnetEnabled),
	    PListToString(tempPortList),
       	    node->type.cValue);
	}
	break;
        }

    case PTCHAR_STR_telnet_buff_time:	
	{
    	bits_clear(tempPortList, 0, ((TBITS_PORT_LIST_SIZE * 8) - 1));
	found = FALSE;
        for (loop = 0; loop < portNumber; loop++)
        {
           if ((TST_ARRAY_BIT(portXmitBuff, loop)) && (TST_ARRAY_BIT(node->portList, loop)))
           {
		bits_set (tempPortList, loop, loop);
		found = TRUE;
	   }
	}
	if ((found) &&  (!OneMegProduct()))
	{
    	    printf("%sDEFINE PORT %s TELNET TRANSMIT BUFFERED %d\n",
	       CMD_COMMENT(!telnetEnabled),
	    PListToString(tempPortList),
       	    node->type.siValue);
	}
	break;
	}

    case PTCHAR_STR_telnet_urgentbreak:
	{
	printf("%sDEFINE PORT %s TELNET URGENT BREAK %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_telnetRs491:
	{
	if ((!OneMegProduct()) || 
	    (VersionLaterOrEqual( 6, 0, 0, TYPE_VERSION_SPECIAL, 2 )))

	printf("%sDEFINE PORT %s TELNET RS491 %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	case PTCHAR_STR_tn3270_prefixkeymap:
    {
	if (VersionLaterOrEqual( 6, 0, 1, TYPE_VERSION_SPECIAL, 11 ))	
		printf("%sDEFINE PORT %s TELNET TN3270 PREFIXKEYMAP %s\n",
			   CMD_COMMENT(!tn3270Enabled),
			   PListToString(node->portList),
			   ENA_DIS(node->type.cValue));
		break;
	}
	case PTCHAR_STR_tn3270_space_insert:
    {
    if (VersionLaterOrEqual( 6, 0, 1, TYPE_VERSION_SPECIAL, 11 ))		
		printf("%sDEFINE PORT %s TELNET TN3270 SPACE_INSERT %s\n",
			   CMD_COMMENT(!tn3270Enabled),
			   PListToString(node->portList),
			   ENA_DIS(node->type.cValue));
		break;
	}
	case PTCHAR_STR_tn3270_type_ahead:
    {
    if (VersionLaterOrEqual( 6, 0, 1, TYPE_VERSION_SPECIAL, 11 ))
		printf("%sDEFINE PORT %s TELNET TN3270 TYPE_AHEAD %s\n",
			   CMD_COMMENT(!tn3270Enabled),
			   PListToString(node->portList),
			   REV_ENA_DIS(node->type.cValue));
		break;
	}
  }
    
}

/*
 ** PrintPortLineData()
 */

void PrintPortLineData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_line_edit_disabled:
	{
	printf("DEFINE PORT %s LINE EDITOR %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(!node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_backspace:
	{	
	printf("DEFINE PORT %s LINE EDITOR BACKSPACE         %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_beg_of_line:
	{
	printf("DEFINE PORT %s LINE EDITOR BEGINNING         %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_cancel_passwd:
	{
	printf("DEFINE PORT %s LINE EDITOR CANCEL            %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_delete_beg:
	{
	printf("DEFINE PORT %s LINE EDITOR DELETE BEGINNING  %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_delete_line:
	{	
	printf("DEFINE PORT %s LINE EDITOR DELETE LINE       %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_end_of_line:
	{	
	printf("DEFINE PORT %s LINE EDITOR END               %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_forward:
	{	
	printf("DEFINE PORT %s LINE EDITOR FORWARDS          %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_insert_toggle:
	{
	printf("DEFINE PORT %s LINE EDITOR INSERT TOGGLE     %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_next_line:
	{
	printf("DEFINE PORT %s LINE EDITOR NEXT LINE         %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_prev_line:
	{	
	printf("DEFINE PORT %s LINE EDITOR PREVIOUS LINE     %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_quoting_char:
	{	
	printf("DEFINE PORT %s LINE EDITOR QUOTING CHARACTER %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
    case PTCHAR_STR_line_edit_chars + LINE_EDIT_STR_redisplay:
	{	
	printf("DEFINE PORT %s LINE EDITOR REDISPLAY         %s\n", 
	       PListToString(node->portList),
	       CHAR_STR_NONE(node->type.cValue));
	break;
	}
	}
}

/*
 ** PrintPortSlipData()
 */

void PrintPortSlipData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    switch (offset)
	{
    case PTCHAR_STR_slip_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	/*
	 ** One megabyte products do not support CSLIP, but that's OK
	 ** We should never see the field set to say that from a one megabyte
	 ** parameter file.
	 */
	printf("%sDEFINE PORT %s INTERNET %s %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       ((char)node->type.cValue == REQUIRED) ? "CSLIP" : "SLIP",
	       ((char)node->type.cValue == DISABLED) ? "DISABLED" : "ENABLED");
	break;
	}
    case PTCHAR_STR_slip_port_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s INTERNET SLIP ADDRESS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PTCHAR_STR_slip_remote_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
        printf("%sDEFINE PORT %s INTERNET SLIP REMOTE  %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PTCHAR_STR_slip_mask:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s INTERNET SLIP MASK    %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PTCHAR_STR_slip_autosend:
    {
		HANDLE_PORT_ZERO(node->portList);
		printf("%sDEFINE PORT %s INTERNET SLIP AUTOSEND %s\n",
			   CMD_COMMENT(!telnetEnabled),
			   PListToString(node->portList),
			   ENA_DIS(node->type.cValue));
		
		break;
	}

  } /* End Switch offset */
}


/*
 ** PrintPortRadiusData()
 */

void PrintPortRadiusData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    switch (offset)
    {
		case PTCHAR_STR_UseRadius:
	    {
			printf("%sDEFINE PORT %s RADIUS %s\n", 
				   CMD_COMMENT(!radiusEnabled),
				   PListToString(node->portList),
				   ((char)node->type.cValue == DISABLED) ? "DISABLED" : "ENABLED");
			break;
		}
		case PTCHAR_STR_UseRadiusSolicit:
	    {
			printf("%sDEFINE PORT %s RADIUS SOLICITS %s\n", 
				   CMD_COMMENT(!radiusEnabled),
				   PListToString(node->portList),
				   ((char)node->type.cValue == DISABLED) ? "DISABLED" : "ENABLED");
			break;
		}
		case PTCHAR_STR_UseRadiusAcct:
	    {
			printf("%sDEFINE PORT %s RADIUS ACCOUNTING %s\n",
				   CMD_COMMENT(!radiusEnabled),
				   PListToString(node->portList),
				   ((char)node->type.cValue == DISABLED) ? "DISABLED" : "ENABLED");
			break;
		}
	}   /* End Switch offset */
}

/*
 ** PrintPortExpandedData()
 */

void PrintPortExpandedData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    switch (offset)
    {
    case PORT_EXPANDED_PTCHR_STR_username_prompt:
	{
	printf("DEFINE PORT %s USERNAME PROMPT \"%s\"\n", 
	    PListToString(node->portList),
	    node->type.pcValue);
	break;
	}
    case PORT_EXPANDED_PTCHR_STR_password_prompt:
	{
	printf("DEFINE PORT %s PASSWORD PROMPT \"%s\"\n", 
	    PListToString(node->portList),
	    node->type.pcValue);
	break;
	}
    }
}


/*
 ** PrintPortOldCCLData()
 ** DO NOT ADD TO THIS ROUTINE, ADD TO THE REGULAR ONE BELOW.
 **
 ** CCL data is not supported in ONE megabyte images.
 ** The ProductSupportsIndex will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortOldCCLData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    if (!SupportedVersion_5_2())
	{
	/*
	 ** This functionality is only supported in 5.2 or later.
	 */
	return;
	}
    
    switch (offset)
	{
    case CCL_ccl_script:
	{
	HANDLE_PORT_ZERO( node->portList);
	if ( *node->type.pcValue != '\0')
	    {
	    printf("DEFINE PORT %s CCL NAME \"%s\"\n",
		   PListToString( node->portList ),
		   node->type.pcValue);
	    }
	else
	    {
	    printf("DEFINE PORT %s CCL NAME NONE\n",
		   PListToString( node->portList ));
	    }
	break;
	}
    case CCL_modem_audible:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s CCL MODEM %s\n",
	       PListToString( node->portList ),
	       (node->type.cValue == 1) ? "AUDIBLE" : "INAUDIBLE");
	break;
	}
	} /* End of switch offset */
    }

/*
 ** PrintPortCCLData()
 **
 ** CCL data is not supported in ONE megabyte images.
 ** The ProductSupportsIndex will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortCCLData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    if (!SupportedVersion_5_2())
	{
	/*
	 ** This functionality is only supported in 5.2 or later.
	 */
	return;
	}
    
    switch (offset)
	{
    case CCL_PTCHAR_STR_ccl_script:
	{
	HANDLE_PORT_ZERO( node->portList);
	if ( *node->type.pcValue != '\0')
	    {
	    printf("DEFINE PORT %s CCL NAME \"%s\"\n",
		   PListToString( node->portList ),
		   node->type.pcValue);
	    }
	else
	    {
	    printf("DEFINE PORT %s CCL NAME NONE\n",
		   PListToString( node->portList ));
	    }
	break;
	}
    case CCL_PTCHAR_STR_modem_audible:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("DEFINE PORT %s CCL MODEM %s\n",
	       PListToString( node->portList ),
	       (node->type.cValue == 1) ? "AUDIBLE" : "INAUDIBLE");
	break;
	}
	} /* End of switch offset */
    }

/*
 ** PrintArapPortSegmentData()
 **
 ** ARAP data is not supported in One Megabyte images.
 ** The ProductSupportsIndex will keep this data from printing when the
 ** port information is be processed.
 */

void PrintArapPortSegmentData( node, offset)
     PLISTNODE  node;
     int        offset;
{
    switch (offset)
	{
    case ARAP_P_INFO_arap_allowed:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s ARAP %s\n",
	       CMD_COMMENT(!arapEnabled),
	       PListToString( node->portList ),
	       ENA_DIS((char)node->type.cValue));	       
	break;
	}
    case ARAP_P_INFO_arap_zone_access:
	{
	/*
	 ** If the zone is named, then it must be printed when the
	 ** arap_zone field is given.
	 */
	HANDLE_PORT_ZERO( node->portList);
	if (node->type.cValue != ARAP_ZONE_NAMED)
	    {
	    printf("%sDEFINE PORT %s ARAP ZONE ACCESS %s\n",
		   CMD_COMMENT(!arapEnabled),
		   PListToString( node->portList ),
		   (node->type.cValue == ARAP_ZONE_ALL) ? "ALL"  :
		   (node->type.cValue == ARAP_ZONE_LOCAL) ? "LOCAL"  :
		   "NONE");
	    }
	break;
	}
    case ARAP_P_INFO_arap_zone:
	{
	HANDLE_PORT_ZERO( node->portList);
	if ( *node->type.pcValue != '\0')
	    {
	    printf("%sDEFINE PORT %s ARAP ZONE ACCESS \"%s\"\n",
		   CMD_COMMENT(!arapEnabled),
		   PListToString( node->portList ),
		   node->type.pcValue);
	    }
	break;
	}
    case ARAP_P_INFO_arap_max_connect_time:
	{
	HANDLE_PORT_ZERO( node->portList);
	if (node->type.iValue != -1)
	    {
	    printf("%sDEFINE PORT %s ARAP MAXIMUM CONNECT TIME %u\n",
		   CMD_COMMENT(!arapEnabled),
		   PListToString( node->portList ),
		   node->type.iValue);
	    }
	else
	    {
	    printf("%sDEFINE PORT %s ARAP MAXIMUM CONNECT TIME UNLIMITED\n",
		   CMD_COMMENT(!arapEnabled),
		   PListToString( node->portList ));
	    }
	break;
	}
    case ARAP_P_INFO_arap_guest_logins_ok:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s ARAP GUEST LOGINS %s\n",
	       CMD_COMMENT(!arapEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	} /* End Switch offset */
    }
/*
 ** PrintPortControlledPortData()
 */

void PrintPortControlledPortData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case CONTROLLED_P_INFO_initPort:
	{
	printf("%sDEFINE PORT %s CONTROLLED PORT LOGIN \"%s\"\n",
	       CMD_COMMENT(!controlledPortsEnabled),
	       PListToString(node->portList),
	       AsciiToHex( node->type.ctrlpValue));
	break;
	}
    case CONTROLLED_P_INFO_termPort:
	{
	printf("%sDEFINE PORT %s CONTROLLED PORT LOGOUT \"%s\"\n",
	       CMD_COMMENT(!controlledPortsEnabled),
	       PListToString(node->portList),
	       AsciiToHex( node->type.ctrlpValue));
	break;
	}
    case CONTROLLED_P_INFO_initSession:
	{
	printf("%sDEFINE PORT %s CONTROLLED SESSION INITIALIZE \"%s\"\n",
	       CMD_COMMENT(!controlledPortsEnabled),
	       PListToString(node->portList),
	       AsciiToHex( node->type.ctrlpValue));
	break;
	}
    case CONTROLLED_P_INFO_termSession:
	{
	printf("%sDEFINE PORT %s CONTROLLED SESSION TERMINATE \"%s\"\n",
	       CMD_COMMENT(!controlledPortsEnabled),
	       PListToString(node->portList),
	       AsciiToHex( node->type.ctrlpValue));
	break;
	}

	} /* End of switchoffset() */
    
    } /* End of PrintPortControlledPortData() */

/*
 ** PrintPortIpxData()
 */
void PrintPortIpxData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch(offset)
	{
    case IPX_IF_STR_Network:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX NETWORK %X\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       node->type.iValue);
	break;
	}
    case IPX_IF_STR_ConfigState:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX %s\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case IPX_IF_STR_RemoteNode:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX REMOTE NODE %s\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       ConvertIpxNodeAddr((char *) node->type.ethValue));
	break;
	}
    case IPX_IF_STR_RIPBroadcast:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX RIP BROADCAST %s\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == BROADCAST_NONE) ? "NONE" :
	       (node->type.cValue == BROADCAST_CHANGE) ? "CHANGE" : "FULL");
	break;
	}
    case IPX_IF_STR_SAPBroadcast:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX SAP BROADCAST %s\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == BROADCAST_NONE) ? "NONE" :
	       (node->type.cValue == BROADCAST_CHANGE) ? "CHANGE" : "FULL");
	break;
	}
    case IPX_IF_STR_RIPTimer:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX RIP TIMER %d\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       node->type.iValue);
	break;
	}
    case IPX_IF_STR_SAPTimer:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX SAP TIMER %d\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       node->type.iValue);
	break;
	}
    case IPX_IF_STR_RIPDiscardTimeout:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX RIP DISCARD TIMEOUT %d\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       node->type.iValue);
	break;
	}
    case IPX_IF_STR_SAPDiscardTimeout:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s IPX SAP DISCARD TIMEOUT %d\n",
	       CMD_COMMENT(!ipxEnabled || !pppEnabled),
	       PListToString(node->portList),
	       node->type.iValue);
	break;
	}
	} /* End switch on offset */
    } /* End of PrintPortIpxData() */

/*
 ** PrintPortKerberosData()
 */

void PrintPortKerberosData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_krb:
	{
	printf("%sDEFINE PORT %s KERBEROS %s\n", 
               CMD_COMMENT(!(kerberosEnabled || kerberos5Enabled)), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));

	printf("# DEFINE PORT %s USER KERBEROS PASSWORD \n", 
	       PListToString(node->portList));
	break;
	}
	}
}
/*
 ** PrintPortSecurIdData()
 */

void PrintPortSecurIdData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_SecurID:
	{
	printf("%sDEFINE PORT %s SECURID %s\n", 
	       CMD_COMMENT(!securIdEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	}
}

/*
 ** PrintPortInternetData()
 */

void PrintPortInternetData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_internet_connect:
	{
	printf("%sDEFINE PORT %s INTERNET CONNECTIONS %s\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),	       
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_TCPKeepalive:
	{
	printf("%sDEFINE PORT %s INTERNET TCP KEEPALIVE %u\n",
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PTCHAR_STR_telnet_window_size:
	{
	printf("%sDEFINE PORT %s INTERNET TCP WINDOW SIZE %d\n", 
	       CMD_COMMENT(!telnetEnabled),
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
	case PTCHAR_STR_tcp_outbound_addr:
    {
		printf("%sDEFINE PORT %s INTERNET TCP OUTBOUND ADDRESS %s\n",
           CMD_COMMENT(!telnetEnabled),
			  PListToString(node->portList),
			  AlignAndConvertIpAddr((char *) &node->type.iValue));
    break;
    }
	}
}

/*
 ** PrintPortSecurityData()
 */

void PrintPortSecurityData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
   /*
    ** secure command set 
    */
    case PTCHAR_STR_clr_inter_sec_tbl:
	{
	printf("%sDEFINE PORT %s CLEAR INTERNET SECURITY ENTRIES %s\n",
	       CMD_COMMENT(!securityEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_outboundsecurity:
	{
        if (!OneMegProduct())
	{
	    printf("DEFINE PORT %s OUTBOUNDSECURITY %s\n",
	       PListToString(node->portList),
	       REV_ENA_DIS(node->type.cValue));
		
	}
		break;
	}
    case PTCHAR_STR_security:
	{
	printf("%sDEFINE PORT %s SECURITY %s\n",
	       CMD_COMMENT(!securityEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));    
	break;
	}

	}
}

/*
 ** PrintPortOldMenuData()
 */

void PrintPortOldMenuData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_menu:
	{
	printf("%sDEFINE PORT %s MENU %s\n",
	       CMD_COMMENT(!menuEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_privileged_menu:	
	{
	if (menuEnabled && (!node->type.cValue))
	    printf("#\n# The following command can exit privileged mode so it is commented out.\n");
	printf("# DEFINE PORT %s PRIVILEGED MENU %s\n", 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	}
}

/*
 ** PrintPortNestedMenuData()
 **
 ** Nested Menus are not supported in One Megabyte images.
 ** The ProductSupportsIndex() will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortNestedMenuData( node, offset)
     PLISTNODE node;
     int       offset;
{
    static int headerPrinted = FALSE;
    /* 
     * NESTED MENUS
     * We need to make sure that the nested menu required, and privileged 
     * nested menu enabled sequence will work.
     */

    switch (offset)
	{
    case PTCHAR_STR_nestedMenus:
	{
	if (!headerPrinted)
	{
		PrintCommentHeader(!nestedMenuEnabled, "Nested Menu Feature");
		headerPrinted = TRUE;
	}

	printf("%sDEFINE PORT %s NESTED MENU %s\n", 
	       CMD_COMMENT(!nestedMenuEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_nestedMenusTopLevel:	
	{
	printf("%sDEFINE PORT %s NESTED MENU TOP LEVEL %d\n", 
	       CMD_COMMENT(!nestedMenuEnabled), 
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}	
    case PTCHAR_STR_privilegedNestedMenus:
	{
	if (nestedMenuEnabled)
            printf("#\n# The following command can exit privileged mode so it is commented out.\n");
	printf("# DEFINE PORT %s PRIVILEGED NESTED MENU %s\n",
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	}
}

/*
 ** PrintPortXRemoteData()
 **
 ** XREMOTE is not supported in One Megabyte images.
 ** The ProductSupportsIndex() will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortXRemoteData( node, offset)
     PLISTNODE node;
     int       offset;
{
    switch (offset)
	{
    case PTCHAR_STR_xremote:
	{
	HANDLE_PORT_ZERO( node->portList);
	PrintCommentHeader( !xremoteEnabled, "XRemote");
	printf("%sDEFINE PORT %s XREMOTE %s\n", 
	       CMD_COMMENT(!xremoteEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PTCHAR_STR_xdm_ip_addr:    
	{
	HANDLE_PORT_ZERO( node->portList);
	if (node->type.iValue != 0)
	    {
	    printf("%sDEFINE PORT %s XDM HOST %s\n", 
		   CMD_COMMENT(!xremoteEnabled),
		   PListToString(node->portList),	       
		   AlignAndConvertIpAddr( (char *) &node->type.iValue));
	    }
	break;
	}
    case PTCHAR_STR_xdm_host:    
	{
	HANDLE_PORT_ZERO( node->portList);

	printf("%sDEFINE PORT %s XDM HOST %s\n", 
	       CMD_COMMENT(!xremoteEnabled),
	       PListToString(node->portList),	       
	       ( *node->type.pcValue == '\0') ? "NONE" : 
	       node->type.pcValue);
	break;
	}
    case PTCHAR_STR_xdm_query_type:    
	{    
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s XDM QUERY %s\n", 
	       CMD_COMMENT(!xremoteEnabled), 
	       PListToString(node->portList),
	       (node->type.cValue == XDMCP_QUERY_SPECIFIC) ? "SPECIFIC" :
	       (node->type.cValue == XDMCP_QUERY_BROADCAST) ? "BROADCAST" :
	       "INDIRECT");
	break;
	}
	}
}

/*
 ** PrintPortOldPPPData()
 ** DO NOT ADD ANY MORE TO THIS ROUTINE, ADD TO the REGULAR ROUTINE BELOW
 **
 ** PPP is not supported in One Megabyte images.
 ** The ProductSupportsIndex() will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortOldPPPData( node, offset, explicit)
     PLISTNODE node;
     int       offset;
     int       explicit;
{
    switch (offset)
	{
    case PPP_ppp_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	PrintCommentHeader(!pppEnabled, "PPP");
	printf("%sDEFINE PORT %s PPP %s\n", 	   
	       CMD_COMMENT(!pppEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_pppActiveEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP ACTIVE %s\n", 
	       CMD_COMMENT(!pppEnabled), 
	       PListToString(node->portList),	       
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_pppPapEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP PAP %s\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
    }
    case PPP_pppBroadcastEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET BROADCAST %s\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_ppp_charmap:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP CHARMAP %x\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
               node->type.iValue);
	break;
	}    
    case PPP_ppp_rtimer:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP RESTART %d\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_ppp_maxconf:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP CONFIGURE LIMIT %u\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_ppp_maxfail:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP FAILURE   LIMIT %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_ppp_port_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  LOCAL  ADDRESS %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PPP_ppp_remote_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  REMOTE ADDRESS %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PPP_pppVJCompEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  VJ COMPRESSION %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_ppp_vjslots:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP INTERNET  VJ COMPRESSION SLOTS %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_ppp_logging:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP LOGGING %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == PPP_LOG_NONE) ? "NONE" :
	       (node->type.cValue == PPP_LOG_RAW) ? "RAW" : "INTERPRETED");
	break;
	}
    case PPP_ppp_katimeout:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP KEEPALIVE TIMEOUT %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PPP_ppp_katimer:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP KEEPALIVE TIMER %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_ppp_ip_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP INTERNET %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
	}	
}

/*
 ** PrintPortPPPData()
 **
 ** PPP is not supported in One Megabyte images.
 ** The ProductSupportsIndex() will keep this data from printing when the
 ** port information is be processed.
 */

void PrintPortPPPData( node, offset, explicit)
     PLISTNODE node;
     int       offset;
     int       explicit;
{
    switch (offset)
	{
    case PPP_PTCHAR_STR_ppp_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	PrintCommentHeader(!pppEnabled, "PPP");
	printf("%sDEFINE PORT %s PPP %s\n", 	   
	       CMD_COMMENT(!pppEnabled), 
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_PTCHAR_STR_pppActiveEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP ACTIVE %s\n", 
	       CMD_COMMENT(!pppEnabled), 
	       PListToString(node->portList),	       
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_PTCHAR_STR_pppPapEnabled:
	{
	if (VersionLaterOrEqual( 6, 0, 1, TYPE_VERSION_SPECIAL, 11 ))
    {
		HANDLE_PORT_ZERO( node->portList);
		printf("%sDEFINE PORT %s PPP PAP %s\n",
		CMD_COMMENT(!pppEnabled),
		PListToString(node->portList),
	    ENA_DIS_RAD(node->type.cValue));
	}
	else
	{
		HANDLE_PORT_ZERO( node->portList);
		printf("%sDEFINE PORT %s PPP PAP %s\n", 
		CMD_COMMENT(!pppEnabled),
	    PListToString(node->portList),
	    ENA_DIS(node->type.cValue));
    }
	break;
	}
    case PPP_PTCHAR_STR_pppChapEnabled:
	{
	if (VersionLaterOrEqual( 6, 0, 1, TYPE_VERSION_SPECIAL, 11 ))
    {
		HANDLE_PORT_ZERO( node->portList);
		printf("%sDEFINE PORT %s PPP CHAP RADIUS %s\n", 
		CMD_COMMENT(!pppEnabled),
	    PListToString(node->portList),
	    ENA_DIS(node->type.cValue));
	}
	else
	{
		HANDLE_PORT_ZERO( node->portList);
		printf("%sDEFINE PORT %s PPP CHAP %s\n",
		CMD_COMMENT(!pppEnabled),
		PListToString(node->portList),
		ENA_DIS_RADIUS(node->type.cValue));
	}
	break;
	}
    case PPP_PTCHAR_STR_pppChapChallengeTimer:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP CHAP CHALLENGE TIMER %d\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_pppBroadcastEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET BROADCAST %s\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_PTCHAR_STR_ppp_charmap:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP CHARMAP %x\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
               node->type.iValue);
	break;
	}    
    case PPP_PTCHAR_STR_ppp_rtimer:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP RESTART %d\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_maxconf:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP CONFIGURE LIMIT %u\n", 
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_maxfail:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP FAILURE   LIMIT %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_port_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  LOCAL  ADDRESS %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PPP_PTCHAR_STR_ppp_remote_addr:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  REMOTE ADDRESS %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PPP_PTCHAR_STR_pppIpMask:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET MASK %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	break;
	}
    case PPP_PTCHAR_STR_ppp_range_start:
    {
	HANDLE_PORT_ZERO( node->portList);
	if (explicit)
	{
	    printf("%sDEFINE PORT %s PPP INTERNET REMOTE ADDRESS RANGE %s -",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
 	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	}
	else
	{
	    printf("# DEFINE PORT %s PPP INTERNET REMOTE ADDRESS RANGE <address-address>\n",		
	       PListToString(node->portList));
	    if (pppEnabled)	
               	printf("# Use 'apgen -verbose' to get exact range.\n");
	}
	break;
    }
    case PPP_PTCHAR_STR_ppp_range_end:
    { 
	HANDLE_PORT_ZERO( node->portList);
	if (explicit)
        {
	    printf(" %s\n",
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
        }
	break;
    }
    case PPP_PTCHAR_STR_ppp_localrange_start:
    {
	HANDLE_PORT_ZERO( node->portList);
	if (explicit)
	{
	    printf("%sDEFINE PORT %s PPP INTERNET LOCAL ADDRESS RANGE %s -",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
 	       AlignAndConvertIpAddr((char *) &node->type.iValue));
	}
	else
	{
	    printf("# DEFINE PORT %s PPP INTERNET LOCAL ADDRESS RANGE <address-address>\n",		
	       PListToString(node->portList));
	    if (pppEnabled)	
               	printf("# Use 'apgen -verbose -ppp' to get exact range.\n");
	}
	break;
    }
    case PPP_PTCHAR_STR_ppp_localrange_end:
    { 
	HANDLE_PORT_ZERO( node->portList);
	if (explicit)
        {
	    printf(" %s\n",
	       AlignAndConvertIpAddr((char *) &node->type.iValue));
        }
	break;
    }
    case PPP_PTCHAR_STR_pppVJCompEnabled:
	{
	HANDLE_PORT_ZERO( node->portList);
	printf("%sDEFINE PORT %s PPP INTERNET  VJ COMPRESSION %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_PTCHAR_STR_ppp_vjslots:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP INTERNET  VJ COMPRESSION SLOTS %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_logging:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP LOGGING %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       (node->type.cValue == PPP_LOG_NONE) ? "NONE" :
	       (node->type.cValue == PPP_LOG_RAW) ? "RAW" : "INTERPRETED");
	break;
	}
    case PPP_PTCHAR_STR_ppp_katimeout:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP KEEPALIVE TIMEOUT %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.siValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_katimer:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP KEEPALIVE TIMER %u\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       node->type.cValue);
	break;
	}
    case PPP_PTCHAR_STR_ppp_ip_enabled:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP INTERNET %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       ENA_DIS(node->type.cValue));
	break;
	}
    case PPP_PTCHAR_STR_pppMagicNumDisabled:
	{
	HANDLE_PORT_ZERO( node->portList);
    	printf("%sDEFINE PORT %s PPP MAGIC NUMBER %s\n",
	       CMD_COMMENT(!pppEnabled),
	       PListToString(node->portList),
	       REV_ENA_DIS(node->type.cValue));
	break;
	}
	}	
}

/*
 ** PrintRotaryParams()
 */

void PrintRotaryParams( rotary )
     unsigned char *rotary;
{
    static int headerPrinted = FALSE;
    int        ipAddr, loop, maxRot;
    char       ipString[IP_ADDR_SIZE];
    char       portList[60];

    /* Beginning with V5-3-1, the first rotary entry is the server IP address,
     * which maps to all ports. This can be changed by the customer. 
     * This first rotary entry is commented out. ***fbs 060595 SC56849
     */

    if (VersionLaterOrEqual(5, 3, 1, VERSION_DONT_CARE, VERSION_DONT_CARE))
    {
        maxRot = MAX_ROTARY_SERVICES + 1;
    }
    else
    {
        maxRot = MAX_ROTARY_SERVICES;
    }

    for(loop = 0; loop < maxRot ; loop++)
	{
	ipAddr = GetDoubleWord((char *)&rotary[(ROTARY_STR_sizelen * loop) + 
					       ROTARY_STR_ip_address]);
	if(ipAddr != 0)
	    {
	    if(headerPrinted == FALSE)
		{
		EchoHeader("Rotary Information");
		PrintCommentHeader( !telnetEnabled, "Telnet");
		headerPrinted = TRUE;
		}

	    IpToString( ipAddr, ipString);
	    PortListToString( (char *)&rotary[(ROTARY_STR_sizelen * loop) + 
					      ROTARY_STR_port_map], portList);

            if ((maxRot == MAX_ROTARY_SERVICES + 1) && (loop == 0))
                printf ("# ");	/* for V5-3-1+, entry 0, comment out *fbs 060595 */
	    printf("%sDEFINE SERVER INTERNET ROTARY %s %s\n", 
		   CMD_COMMENT(!telnetEnabled), ipString, portList);
	    }
	}
}

/*
 ** PrintRouteParams()
 */

void PrintRouteParams( route )
     unsigned char *route;
{
    static int headerPrinted = FALSE;
    char       ipDest[IP_ADDR_SIZE], ipGateway[IP_ADDR_SIZE],ipMask[IP_ADDR_SIZE];
    int        ipDAddr, ipGAddr, ipMAddr;

    ipDAddr = GetDoubleWord((char *)&route[ROUTE_PARAM_STR_route_dest]);
    ipGAddr = GetDoubleWord((char *)&route[ROUTE_PARAM_STR_route_gate]);
    ipMAddr = GetDoubleWord((char *)&route[ROUTE_PARAM_STR_route_mask]);

    if(ipDAddr != 0)
        {
	if(headerPrinted == FALSE)
	    {
	    EchoHeader("Route Entrie(s)");
	    PrintCommentHeader( !telnetEnabled, "Telnet");
	    headerPrinted = TRUE;
	    }

	IpToString( ipDAddr, ipDest);
	IpToString( ipGAddr, ipGateway);
	IpToString( ipMAddr, ipMask);
	
        printf("%sDEFINE SERVER INTERNET ROUTE %s GATEWAY %s ", 
	       CMD_COMMENT( !telnetEnabled), ipDest, ipGateway);
        if(route[ROUTE_PARAM_STR_route_flags] & ROUTE_NETWORK)
            {
            printf("NETWORK");
	    printf(" MASK %s ", ipMask);   /* mask is only valid with nework */
            }
        else if(route[ROUTE_PARAM_STR_route_flags] & ROUTE_HOST)
            {
            printf("HOST");
            }
	if(route[ROUTE_PARAM_STR_route_flags] & ROUTE_FIXED)
	    {
	    printf(" FIXED");
	    }
	else if(route[ROUTE_PARAM_STR_route_flags] & ROUTE_VARIABLE)
	    {
	    printf(" VARIABLE");
	    }
	printf("\n");
	}
}

/*
 ** PrintTN3270DeviceParams()
 */

void PrintTN3270DeviceParams( device )
     unsigned char *device;
{
    static int deviceCount = 1;
    int loop, loop2;
    char keySequence[100];

    static char tn3270NullString[] ="";
    static char *tn3270KeymapString [] = {
        "NEWLINE", "TAB","BACKTAB", "CURSORUP","CURSORLEFT","CURSORRIGHT",
	"CURSORDOWN","HOME","DELETE","ERASEEOF","ERASEINPUT","INSERT",
	"FLUSHINPUT","REFRESH","CENTSIGN","DUPLICATE","FIELDMARK","SCROLL",
	"STATUS","RESET","FASTLEFT","FASTRIGHT","SHOWKEYS","PRINT",
	"BACKSPACE","BREAK","IP","AYT","AO",tn3270NullString,tn3270NullString,
        tn3270NullString,tn3270NullString,tn3270NullString,tn3270NullString,
        tn3270NullString,tn3270NullString, "ALTMAP", "PF1","PF2","PF3",
        "PF4","PF5","PF6","PF7","PF8","PF9","PF10","PF11","PF12","PF13","PF14",
	"PF15","PF16","PF17","PF18","PF19","PF20","PF21","PF22","PF23","PF24",
	"PA1","PA2","PA3","SYSREQ","ENTER","CLEAR","CURSORSEL","TEST"
	    };

    static char *tn3270SmapString [SCREEN_CMDS] =
        {
        "ERASEEOL","CLEARSCR","MOVECURSOR","COL132","COL80","BEEP","CHARSET",
	"BOLDON","BOLDOFF","BLINKON","BLINKOFF","UNDERSCOREON","UNDERSCOREOFF",
	"REVERSEON","REVERSEOFF","COLORBLUE","COLORRED","COLORPINK",
	"COLORGREEN","COLORTURQUOISE","COLORYELLOW","COLORWHITE",
	tn3270NullString,tn3270NullString
        };
 
    static char*tn3270SlineString [SLINE_CMDS] =
        {
        "STATUS1", "STATUS2"
        };
 
    static char *tn3270ResetString [RESET_CMDS] =
        {
        "RESET1", "RESET2", "RESET3", "RESET4"
        };


	/*
	 * If there is NO DEVICE, we DON'T want to print anything
	 */

    if (device[DCB_name] == '\0')
	{
	return;
	}
    
    printf("#\n#echo     TN3270 Device Information    - %s\n#\n", 
	   (char *) &device[DCB_name]);

    PrintCommentHeader(!tn3270Enabled, "TN3270 Feature");
    
    /* 
     * If this is one of our devices, we don't want to create it.
     */

    if (!TN3270DeviceIsOurDevice( (char *) &device[DCB_name]))
	{
	printf("%sDEFINE SERVER TN3270 DEVICE %s CREATE ANSI\n",
	       CMD_COMMENT(!tn3270Enabled),
	       (char *) &device[DCB_name]);
	}

    printf("%sDEFINE SERVER TN3270 DEVICE %s TERMINALTYPE \"%s\"\n",
           CMD_COMMENT(!tn3270Enabled),
	   (char *) &device[DCB_name], (char *) & device[DCB_ttyp]);

    printf("%sDEFINE SERVER TN3270 DEVICE %s TN3278TYPE %s\n",
           CMD_COMMENT(!tn3270Enabled),
	   (char *) &device[DCB_name], 
	   (device[DCB_model] == TN3278TYPE_MODEL2) ? "MODEL2" : "MODEL5");

    printf("#\n#echo     TN3270 KeyMap Information    - %s\n#\n", 
	   (char *) &device[DCB_name]);
    
    for(loop = 0; loop < KEY_CMDS; loop++)
	{
	Tn3270KeyToHex((char *) &device[DCB_kcb + (KMAP_sizelen * loop)], 
		       keySequence, KMAP_CODE_LEN );

	if(tn3270KeymapString[loop] != tn3270NullString)
	    {
	    if ((!OneMegProduct()) && (strcmp(tn3270KeymapString[loop], "ALTMAP") == 0))
	    {
		if ((device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_len] > 0) &&
		    (device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_desc] == TN3270_ALTMAP_IND1) &&
		    (device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_desc+1] == TN3270_ALTMAP_IND2))
		{
		    printf("%sDEFINE SERVER TN3270 DEVICE %s KEYMAP ALTMAP ",
		       CMD_COMMENT(!tn3270Enabled),
		       (char *) &device[DCB_name]);
		
		    for(loop2 = 0 ; loop2 < KMAP_CODE_LEN; loop2++)
		    {
             	        if (device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_code+loop2] < 0x20)
				break;
		        printf("%c",
			   device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_code+loop2]);
		    }
		    printf("\n");	
		}
	    }
	    else if ((!OneMegProduct()) ||
		((OneMegProduct()) &&
		(strcmp(tn3270KeymapString[loop], "BREAK") != 0) &&
		(strcmp(tn3270KeymapString[loop], "BACKSPACE") != 0) &&
		(strcmp(tn3270KeymapString[loop], "IP") != 0) &&
		(strcmp(tn3270KeymapString[loop], "AYT") != 0) &&
		(strcmp(tn3270KeymapString[loop], "ALTMAP") != 0) &&
		(strcmp(tn3270KeymapString[loop], "AO") != 0)))
		{
		printf("%sDEFINE SERVER TN3270 DEVICE %s KEYMAP %s \"%s\" \"",
		       CMD_COMMENT(!tn3270Enabled),
		       (char *) &device[DCB_name], 
		       tn3270KeymapString[loop], keySequence);
		for(loop2 = 0 ; loop2 < KMAP_DESC_LEN; loop2++)
		    {
          	    if (device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_code+loop2] < 0x20)
			break;
		    printf("%c",
			   device[DCB_kcb+(KMAP_sizelen*loop)+KMAP_desc+loop2]);
		    }
		printf("\"\n"); 
		} /* End we One megs don't support BREAK,BACKSPACE,IP,AYT,AO */
	    }
	}

    printf("#\n#echo     TN3270 ScreenMap Information - %s\n#\n", 
	   (char *) &device[DCB_name]);

    printf("%sDEFINE SERVER TN3270 DEVICE %s SCREENMAP SGR %s\n",
           CMD_COMMENT(!tn3270Enabled),
	   (char *) &device[DCB_name], 
	   ENA_DIS(device[DCB_scb + SCB_sgr]));
    
    for(loop = 0; loop < SCREEN_CMDS; loop ++)
	{
	Tn3270KeyToHex((char *) 
		       &device[DCB_scb + SCB_smap + (SMAP_sizelen * loop)], 
		       keySequence, SMAP_CODE_LEN );

	if((tn3270SmapString[loop] != tn3270NullString) && 
	   (strcmp(tn3270SmapString[loop], "MOVECURSOR") != 0))
	    {
	    if((!OneMegProduct()) || 
	       ((OneMegProduct()) &&
		(strcmp(tn3270SmapString[loop], "COLORBLUE") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORGREEN") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORRED") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORPINK") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORTURQUOISE") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORYELLOW") != 0) &&
		 (strcmp(tn3270SmapString[loop], "COLORWHITE") != 0)))
		{
		printf("%sDEFINE SERVER TN3270 DEVICE %s SCREENMAP %s \"%s\"\n",
		       CMD_COMMENT(!tn3270Enabled),
		       (char *) &device[DCB_name], tn3270SmapString[loop], 
		       keySequence);
		} /* end one megs don't support COLOR... */
	    }
	else if (tn3270SmapString[loop] != tn3270NullString)
	    {
	    printf("%sDEFINE SERVER TN3270 DEVICE %s SCREENMAP %s \"%s\" BASE %u\n",
              CMD_COMMENT(!tn3270Enabled),
	      (char *) &device[DCB_name], tn3270SmapString[loop], keySequence,
		   device[DCB_scb + SCB_base]);
	    }
	}

    for(loop = 0; loop < SLINE_CMDS; loop ++)
	{
	Tn3270KeyToHex((char *) 
		       &device[DCB_scb + SCB_sline +(LSMAP_sizelen * loop)], 
		       keySequence, LSMAP_CODE_LEN );

	if(tn3270SlineString[loop] != tn3270NullString)
	    {	    
	    printf("%sDEFINE SERVER TN3270 DEVICE %s SCREENMAP %s \"%s\"\n",
	     CMD_COMMENT(!tn3270Enabled),
	     (char *) &device[DCB_name], tn3270SlineString[loop], keySequence);
	    }
	
	}

    for(loop = 0; loop < RESET_CMDS; loop ++)
	{
	Tn3270KeyToHex((char *) 
		       &device[DCB_scb + SCB_reset + (LSMAP_sizelen * loop)], 
		       keySequence, LSMAP_CODE_LEN );

	if(tn3270ResetString[loop] != tn3270NullString)
	    {	    
	    printf("%sDEFINE SERVER TN3270 DEVICE %s SCREENMAP %s \"%s\"\n",
             CMD_COMMENT(!tn3270Enabled),
	     (char *) &device[DCB_name], tn3270ResetString[loop], keySequence);
	    }
	
	}
}

/*
 ** PrintTN3270XlatParams()
 */

void PrintTN3270XlatParams( xlat )
     unsigned char *xlat;
{
    static int xlatCount = 1;
    int loop;
    

	/*
	 * If there is NO TABLE, we DON'T want to print anything
	 */

    if (xlat[XCB_name] == '\0')
	{
	return;
	}

    printf("#\n# TN3270 Translation Table - %s\n#\n", (char *) &xlat[XCB_name]);
    
    /*
     * first we need to create the table from an existing on.
     */
    EchoHeader("TN3270 Create Translation Table from existing one.");
    PrintCommentHeader( !tn3270Enabled, "TN3270 Feature");
    printf("%sDEFINE SERVER TN3270 TRANSLATIONTABLE %s CREATE USENGLSH\n",
           CMD_COMMENT(!tn3270Enabled),
	   (char *) &xlat[XCB_name]);
    
    printf("#\n#echo     EBCDICTOASCII Translation - %s\n", (char *) &xlat[XCB_name]);
    printf("# Valid Offsets:  40 - FF Hexadecimal\n");
    printf("# Valid Values:   20 - FF Hexadecimal\n"); 
    printf("# Lines with valid offsets, but values that are default(ie. 00) are commented out\n");
    
    /*
     * Valid values are from 40 - FF hex
     */
    for(loop = 0x40; loop <= 0xFF; loop++)
	{
	if(((xlat[XCB_e2a +loop] & 0xFF) < 0x20) && tn3270Enabled)
	    {
	    printf("# ");
	    }
	printf("%sDEFINE SERVER TN3270 TRANSLATIONTABLE %s EBCDICTOASCII %02X %02X\n",
	       CMD_COMMENT(!tn3270Enabled),
	       (char *) &xlat[XCB_name], loop, (xlat[XCB_e2a + loop] & 0XFF));
	}

    printf("#\n#echo     ASCIITOEBCDIC Translation - %s\n#\n", (char *) &xlat[XCB_name]);
    printf("# Valid Offsets:  20 - FF Hexadecimal\n");
    printf("# Valid Values:   40 - FF Hexadecimal\n"); 
    printf("# Lines with valid offsets, but values that are default(ie. 00) are commented out\n");
    /*
     * Valid values are from 20 - FF hex
     */
    for(loop = 0x20; loop <= 0xFF ; loop++)
	{
	if(((xlat[XCB_a2e +loop] & 0XFF) < 0X40) && tn3270Enabled)
	    {
	    printf("# ");
	    }
	printf("%sDEFINE SERVER TN3270 TRANSLATIONTABLE %s ASCIITOEBCDIC %02X %02X\n",
	       CMD_COMMENT(!tn3270Enabled),
	       (char *) &xlat[XCB_name], loop, (xlat[XCB_a2e + loop] & 0XFF));
	}
}

/*
 ** PrintParamServerParams()
 */

void PrintParamServerParams( prm )
     unsigned char *prm;
{
    static int headerPrinted = FALSE;
    unsigned short singleWord[3];

    singleWord[0] = GetWord((char *) &prm[PARAM_STR_node_addr]);
    singleWord[1] = GetWord((char *) &prm[PARAM_STR_node_addr + 2]);
    singleWord[2] = GetWord((char *) &prm[PARAM_STR_node_addr + 4]);

    if((singleWord[0] == 0) &&
       (singleWord[1] == 0) &&
       (singleWord[2] == 0))
	{
	return;
	}
    if(headerPrinted == FALSE)
	{
	EchoHeader("Parameter Server Information");
	headerPrinted = TRUE;
	}

    if(singleWord[0] != NLINK_IPADDR_FLAG)
	{
	printf("DEFINE SERVER PARAMETER SERVER %s ADDRESS %s\n",
	       (char *) &prm[PARAM_STR_name],
	       AlignAndConvertEthAddr((char *) &prm[PARAM_STR_node_addr]));
	}
    else 
	{
	printf("DEFINE SERVER PARAMETER SERVER %s INTERNET ADDRESS %s\n",
	       (char *) &prm[PARAM_STR_name],
	       AlignAndConvertEthAddr((char *) &prm[PARAM_STR_node_addr]));
	}
}

/*
 ** PrintXRemoteParams()
 ** 
 ** XREMOTE is not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintXRemoteParams( xremote )
     unsigned char *xremote;
{
    if (OneMegProduct())
	{
	/*
	 ** XREMOTE is not supported in the one megabyte products.
	 */
	return;
	}

    EchoHeader("XRemote Information");    
    PrintCommentHeader( !xremoteEnabled,"XRemote");
       
    printf("%sDEFINE SERVER XREMOTE PRIMARY FONT SERVER %s\n",
	   CMD_COMMENT(!xremoteEnabled),
	   (xremote[XR_P_INFO_xr_server_name] == '\0') ? "NONE" :
	   (char *) &xremote[XR_P_INFO_xr_server_name]);

    printf("%sDEFINE SERVER XREMOTE PRIMARY FONT SERVER %s\n",
	   CMD_COMMENT(!xremoteEnabled),
	   AlignAndConvertIpAddr(
		  (char *) &xremote[XR_P_INFO_xr_server_ipaddr]));

    printf("%sDEFINE SERVER XREMOTE SECONDARY FONT SERVER %s\n",
	   CMD_COMMENT(!xremoteEnabled),
	   (xremote[XR_P_INFO_xr_server2_name] == '\0') ? "NONE" :
	   (char *) &xremote[XR_P_INFO_xr_server2_name]);

    printf("%sDEFINE SERVER XREMOTE SECONDARY FONT SERVER %s\n",
	   CMD_COMMENT(!xremoteEnabled),
	   AlignAndConvertIpAddr(
		  (char *) &xremote[XR_P_INFO_xr_server2_ipaddr]));
}

/*
 ** PrintXPrinterParams()
 ** 
 ** XPRINTER is not supported by One meg products, We should not see the
 ** parameter segment, but the check is here to be complete.
 */

void PrintXPrinterParams( xprinter )
     unsigned char *xprinter;
{
    static int headerPrinted = FALSE;
    
    if (OneMegProduct())
	{
	/*
	 ** XPRINTER is not supported in the one megabyte products.
	 */
	return;
	}

    if( xprinter[PARAM_PSERVER_STR_pserver] != '\0')
	{
	if (headerPrinted == FALSE)
	    {
	    headerPrinted = TRUE;
	    EchoHeader("XPrinter Information");
	    PrintCommentHeader( !xprinterEnabled, "XPrinter");
	    }

	printf("%sDEFINE SERVER XPRINTER %s %d PORT %d\n",
	       CMD_COMMENT(!xprinterEnabled),	       
	       (char *) &xprinter[PARAM_PSERVER_STR_pserver],
	       xprinter[PARAM_PSERVER_STR_pnumber],
	       xprinter[PARAM_PSERVER_STR_this_port]);
	}
}

/*
 ** PrintServiceParams()
 */

void PrintServiceParams( service )
     unsigned char *service;
{
    char portList[60];
    
    if(service[SCCHAR_STR_name] !='\0')
	{
	printf("#\n#echo     Service Information - %s\n#\n",
	       (char *) &service[SCCHAR_STR_name]);

	printf("DEFINE SERVICE %s\n",
	       (char *) &service[SCCHAR_STR_name]);
	
	printf("DEFINE SERVICE %s CONNECTIONS %s\n",
	       (char *) &service[SCCHAR_STR_name],
	       ENA_DIS(service[SCCHAR_STR_connections]));
	
	printf("DEFINE SERVICE %s IDENTIFICATION \"%s\"\n",
	       (char *) &service[SCCHAR_STR_name],
	       (char *) &service[SCCHAR_STR_identification]);
	
	printf("# DEFINE SERVICE %s PASSWORD <secret>\n",
	       (char *) &service[SCCHAR_STR_name]);    
	
	ListToString( &service[SCCHAR_STR_port_list], portList, (TBITS_PORT_LIST_SIZE* sizeof(unsigned char)) , PORT);
	if(portList[0] != '\0')
	    {
	    printf("DEFINE SERVICE %s PORTS %s ENABLED\n",
		   (char *) &service[SCCHAR_STR_name],
		   portList);
	    }
	
	printf("DEFINE SERVICE %s QUEUE %s\n",
	       (char *) &service[SCCHAR_STR_name],
	       ENA_DIS(service[SCCHAR_STR_queue]));
	}
    
}




    
	   

