/*$Id: uncompress_param.c,v 1.3 1993/10/29 21:15:29 bjs Exp $*/
/* LZW data expansion 
 *   March 4, 1991 M. Merhar
 * 
 * Enhancements added for extended codes, optional code range limit,
 * dynamic table rebuild based on current compression ratio, packed
 * code streams, and support of "huge" arrays in MS-DOS Microsoft C (ugh!)
 */


#include <stdio.h>
#include "apgen.h"

extern void LogSysError();
extern unsigned int mop;

#define UNCOMPRESS_RTN "uncompress_param"
#define FAILED         -1

#define msc 0                                   /* NOT microsoft C */
#define DEBUG 0
#define BITS                    10

/* define code used for end-of-file */
#define MAX_VALUE               (1 << BITS) - 1
        
/* define code used to mark table rebuilds      */
#define REBUILD_TABLE   (MAX_VALUE - 1)
        
/* define upper limit for regular codes */
#define MAX_CODE                (MAX_VALUE - 2)

/* for expansion, tables need only be size of MAX_VALUE+1 */
/* total memory usage is  TABLE_SIZE * 3  bytes, plus  sizeof( decode_stack)  */
#define TABLE_SIZE      (MAX_VALUE + 1) 


/* "tokenized" strings get restored in reverse order; use a stack to reverse them */
unsigned char decode_stack[4000];

int pack = 0;
unsigned char data[10];
int spilled_bits;

long in_count;
long out_count;

#if msc
void huge *halloc();
#else
void *malloc();
#endif

#if msc
unsigned int huge *prefix_code;
unsigned char huge *append_character;
#else
unsigned short *prefix_code;
unsigned char *append_character;
#endif
/* Decode a string from the string table, storing it in a buffer */
unsigned char *
decode_string(buffer, code)
     unsigned char *buffer;
     unsigned short code;
     
{
        int i;
        
        i = 0;
        while ( code > 255)
        {
                *buffer++ = append_character[code];
                code = prefix_code[code];       

                if ( i++ >= 4000)
                {
                        printf("Fatal error during code expansion.\n");
                        exit(1);
                }
        }
        *buffer = code;
        return(buffer);
}

/*******************************************************************************
 **
 ** uncompress:  
 **    Open first filename and decompress it into second filename
 **
 **
 *******************************************************************************
 */
uncompress(input_file_name, output_file_name)
        char input_file_name[];
        char output_file_name[];
{
        FILE *output_file;
        FILE *lzw_file;

        /* buffers needed for the compression phase */
#if msc
        prefix_code = (unsigned int huge *) halloc(TABLE_SIZE, sizeof(unsigned int));
        append_character = (unsigned char huge *) halloc(TABLE_SIZE, sizeof(unsigned char));
#else
        prefix_code = (unsigned short *) malloc(TABLE_SIZE * sizeof(unsigned short));
        append_character = (unsigned char *) malloc(TABLE_SIZE * sizeof(unsigned char));
#endif  
        
        if (prefix_code == NULL || append_character == NULL)
        {
                return(FAILED);
        }

        /* open the files for the expansion */
        lzw_file        = fopen(input_file_name, "r");
        output_file     = fopen( output_file_name, "w");

        if (lzw_file == NULL || output_file == NULL)
        {
                return(FAILED);
        }
        
        /* expand the file */
        expand( lzw_file, output_file);
        fclose( lzw_file);
        fclose( output_file);
#if msc
        hfree( prefix_code);
        hfree( append_character);
#else
        free( prefix_code);
        free( append_character);
#endif

}


/* This is the expansion routine.       */

expand( input, output)
     FILE *input, *output;
{
        unsigned short next_code;
        unsigned short new_code;
        unsigned short old_code;
        int character, i,result;
	int oldOrNewParamLoadHeader;
        unsigned char *string;
	char c;
	
/* note that some param files have mop headers, others don't */
        /* skip MOP header */
	if (mop == TRUE)
	    {
	    for (i= 0; i < MOP_HEADER_SIZE; i++)
		{
		c = fgetc(input);
		}
	    }

#if 1
        /* skip fixed portion of params  This is the old portion in all files*/
        for (i= 0; i < PARAM_LOAD_STR_sizelen; i++)
	    {
	    c = fgetc(input);
	    if (( i == PARAM_LOAD_STR_differential_hours ) && ( c == 0 ))
		{
		/*
		 ** We don't handle these types of parameter files
		 **/
		LogSysError("Parameter file version not supported by APGEN");
		fclose(input);
		fclose(output);
		exit (0);
		}

	    fputc( c, output ); 
	    /* fputc(fgetc(input),output); */
	    
	    }
	
#endif

        in_count = out_count = 0L;
        pack = 0;
#if DEBUG
        printf("Expanding....\n");
#endif  
        next_code = 256;
        character = old_code = input_code(input);       /* read in the first code       */
        
        fputc(old_code, output);                /* send the first code to the output */
        out_count++;
        
        /* this is the main expansion loop      */
        while (( new_code = input_code(input)) != MAX_VALUE)
        {
                if (new_code == REBUILD_TABLE)
                {
#if DEBUG
                        printf("\nRebuilding table at %ld in, %ld out  ", in_count, out_count);
#endif
                        next_code = 256;

                        /* read in the first code for the new table     */
                        if ((character = old_code = input_code(input)) == MAX_VALUE)
                        {
                                printf("\nGot EOF after table reset.");
                                break;
                        }
                }
                else
                {                       
                        /* check for the special STRING+CHARACTER+STRING+CHARACTER+STRING
                         * case which generates an undefined code. Handle it by decoding
                         * the last code and adding a single character to the end of the
                         * decoded string.       */

                        if (new_code >= next_code)
                        {
                                *decode_stack = character;
                                string = decode_string(decode_stack+1, old_code);
                        }
                        
                        /* otherwise, do a straight decode of the new code              */
                        else
                                string = decode_string(decode_stack, new_code);
                        
                        /* output the decoded string in reverse order                   */
                        character = *string;
                        while (string >= decode_stack)
                        {
                                fputc( *string--, output);
                                out_count++;
                        }
                        
                        /* finally, if possible, add a new code to the string table */
                        if (next_code <= MAX_CODE)
                        {
                                prefix_code[next_code] = old_code;
                                append_character[next_code] = character;
                                next_code++;
                        }
                        old_code = new_code;                    
                }
        }
}


/* routines to input and output variable-bitlength codes                */
/*   special optimizations for certain code sizes                               */

input_code(input)
     FILE *input;
     
{
        unsigned int return_value;

#if (BITS == 10)
        int i;

        /* eight codes packed into ten bytes */
        if (pack == 0)
        {
#if DEBUG
                printf("\n");
#endif
                /* read data into the array */
                for (i = 0; i < 10; i++)
                        data[i] = fgetc(input);

                /* move packed extra bits into a longword register */
                i = data[9];
                i <<= 8;
                i |= data[8];
                spilled_bits = i;
                in_count += 10;
        }

        i = spilled_bits;

        return_value = data[pack] | (( i & 0xC000) >> 6);
        spilled_bits =  i << 2;

        if (++pack == 8)
                pack = 0;

#if DEBUG
        printf(" %x", return_value);
#endif
        return(return_value);
#else
        
#if (BITS == 12)
        static int pack_flag = 0;
        static int spilled_bits;

        /* pack two codes into three bytes */
        if (pack_flag == 0)
        {
                return_value = fgetc(input);
                spilled_bits = fgetc(input);
                in_count += 2L;

                pack_flag = 1;
                return_value |= ((spilled_bits & 0x0F) << 8); /* assemble token */
        }
        else
        {
                return_value = fgetc(input);
                in_count++;

                pack_flag = 0;
                return_value |= ((spilled_bits & 0xF0) << 4); /* assemble token */
        }

        return( return_value);

#else
#if (BITS == 16)
        /* pack one code into two bytes */
        in_count += 2L;
        return_value = fgetc(input) << 8;
        return_value |= fgetc(input);
        return( return_value);

#else
        /* any other bit count */
        static int input_bit_count = 0;
        static unsigned long input_bit_buffer = 0L;

        while (input_bit_count <= 24)
        {
                input_bit_buffer |= (unsigned long) fgetc(input) << (24 - input_bit_count);
                in_count++;
                input_bit_count += 8;
        }
        return_value = input_bit_buffer >> (32 - BITS);
        input_bit_buffer <<= BITS;
        input_bit_count -= BITS;
        
        
        return( return_value);

#endif
#endif
#endif
}





