/*
 * ASCEND: @(#)cache.h	1.0 (95/10/05 00:55:30)
 *
 *      Copyright (c) 1994 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *	Permission to copy all or part of this material for any purpose is
 *	granted provided that the above copyright notice and this paragraph
 *	are duplicated in all copies.  THIS SOFTWARE IS PROVIDED ``AS IS''
 *	AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE.
 */

/* $Id: cache.h,v 1.3 1997/01/01 05:08:48 gkm Exp $ */

#ifndef _cache_h_
#define _cache_h_

#include "conf.h"

#if !defined(TRUE)
#	define TRUE	1
#endif
#if !defined(FALSE)
#	define FALSE	0
#endif

#if !defined(MIN)
#	define MIN(x, y)	(((x) < (y)) ? (x) : (y))
#endif

#if !defined(MAX)
#	define MAX(x, y)	(((x) > (y)) ? (x) : (y))
#endif

#define MAX_KEY_LEN	16
#define MAX_VAL_LEN	16

	/*
	 * BUCKETS should be prime; try 1021, 2039, 4093, 8191, 16381.
	 * More buckets use more statically allocated memory but decrease
	 * the length of the hash lists, which will improve performance.
	 */
#define BUCKETS	4093

typedef char HASHKEY;
typedef char HASHVAL;

#define ELEM_DELETED	((HASHVAL *)(-1))
#define LIST_DELETED	((HASHLIST *)(-1))

typedef struct HASHLIST {
	struct HASHLIST	*next;
	HASHKEY		key[MAX_KEY_LEN + 1];
	HASHVAL		val[MAX_VAL_LEN + 1];
	time_t		time;
	int		idling;		/* Boolean: use idle time */
	time_t		idle;
} HASHLIST;

typedef struct CACHE {
	int		buckets;
	HASHLIST	*table[BUCKETS];
} CACHE;

typedef enum CacheMsgType {
	CACHE_INSERT	= 1,
	CACHE_DELETE,
	CACHE_IDLE_UPDATE
} CacheMsgType;

typedef struct CacheMsg {
	CacheMsgType	type;
	HASHKEY		key[MAX_KEY_LEN + 1];
	HASHVAL		val[MAX_VAL_LEN + 1];
	time_t		time;
	time_t		idle;
} CacheMsg;

	/***********************/
	/* function prototypes */
	/***********************/

void cache_init P__((CACHE *dict, int buckets));
CONST HASHVAL *cache_search P__((CACHE *dict, CONST HASHKEY *key, int len));
int cache_insert P__((CACHE *dict, CONST HASHKEY *key, int key_len,
		      CONST HASHVAL *val, int val_len, time_t duration,
		      time_t idle_seconds));
int cache_delete P__((CACHE *dict, CONST HASHKEY *key, int len));
void cache_expire P__((CACHE *dict));
int cache_idle_update P__((CACHE *cache, CONST HASHKEY *key, int len,
			   time_t idle_seconds));

#endif /* _cache_h_ */
