/*
 *      Copyright (c) 1996 Ascend Communications, Inc.
 *      All rights reserved.
 *
 *	Permission to copy all or part of this material for any purpose is
 *	granted provided that the above copyright notice and this paragraph
 *	are duplicated in all copies.  THIS SOFTWARE IS PROVIDED ``AS IS''
 *	AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT
 *	LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 *	FOR A PARTICULAR PURPOSE.
 *
 *	Written by Greg McGary <gkm@cstone.net>, August 1996
 */

/* $Id: radipa.h,v 1.2 1996/12/12 00:04:51 baskar Exp $ */

#ifndef _radipa_h_
#define _radipa_h_

#include "conf.h"

/******************************************************************************/
/* Client interface definitions for radipa services: */

typedef UINT4 ipaddr_t;

struct address_chunk 
{
  ipaddr_t base_address;
  long count;			/* # of contiguous addresses from base */
};

int radipa_init P__((void));
int radipa_connect P__((ipaddr_t radipad_address));
int radipa_request_allocate_ip_address P__((int sock, void *handle, ipaddr_t router_address,
					    struct address_chunk *chunks, int count));
int radipa_request_release_ip_address P__((int sock, void *handle, ipaddr_t router_address,
					   ipaddr_t ip_address));
int radipa_parse_hosts P__((ipaddr_t **hosts_buf_ptr));     
int radipa_parse_pool P__((char *pool_name, struct address_chunk *chunk_0));
int radipa_parse_users_pool P__((char *user_name, struct address_chunk **chunks_ptr));
struct radipa_packet *radipa_packet_reorder_integers P__((char *buf));

#define RADIPA_HOSTS_USER "radipa-hosts"
#define RADIPA_POOL_INDEX ((unsigned short) 0xffff)

/******************************************************************************/
/* Data structures common between radipa.c (client access library)
   and radipad.c (server) */

#define MAX_CLIENT_ADDRESSES 256
#define MAX_ADDRESS_CHUNKS 128

struct radipa_packet
{
  char rp_code;
#define RADIPA_ALLOCATE		1
#define RADIPA_RELEASE		2
#define RADIPA_POLL_ROUTERS	3
#define RADIPA_ROUTER_ADDRESSES 4
  char rp_pad;
  short rp_count;
  void *rp_handle;
  ipaddr_t rp_router_address;
  ipaddr_t rp_ip_address;
  union
  {
    struct address_chunk u_chunks[MAX_ADDRESS_CHUNKS];
#define rp_chunks rp_u.u_chunks
    ipaddr_t u_client_addresses[MAX_CLIENT_ADDRESSES];
#define rp_client_addresses rp_u.u_client_addresses
  } rp_u;
};

#define RADIPA_BUFFER_SIZE (sizeof (struct radipa_packet))
#define sizeof_RADIPA (sizeof (struct radipa_packet) \
		       - sizeof ((struct radipa_packet *)0)->rp_chunks)
#define sizeof_RADIPA_ALLOCATE(count) (sizeof_RADIPA \
				       + sizeof (struct address_chunk) * (count))
#define sizeof_RADIPA_RELEASE (sizeof_RADIPA_REQUEST)

/* For use with getservbyname(3n) */

#define RADIPA_SERVICE_PORT 9992
#define RADIPA_SERVICE_PROTO "udp"
#define RADIPA_SERVICE_NAME "radipa"

#define RADIPA_STATE_FILE_NAME "radipad.state"

/******************************************************************************/
/* Miscellany */

#ifndef INADDR_ANY
#define INADDR_ANY ((unsigned long) 0)
#endif
#ifndef INADDR_NONE
#define INADDR_NONE ((unsigned long) 0xffffffff)
#endif
#ifndef INADDR_BROADCAST
#define INADDR_BROADCAST ((unsigned long) 0xffffffff)
#endif

#define	CALLOC(t, n) ((t *) calloc (sizeof (t), (n)))
#define MALLOC(t, n) ((t *) malloc (sizeof (t) * (n)))
#define REALLOC(o, t, n) ((t *) realloc ((o), sizeof (t) * (n)))

extern char *xstrerror P__((int));

#endif /* _radipa_h_ */
