#! /usr/bin/python3


import time, sys, json, os

from datetime import datetime

from libs.ApiClass import ApiClass

from libs.configfile import ConfigFile

from libs.RemoveAppClass import RemoveAppClass

from libs.LoggingClass import SystemLogger

from libs.CommandLine import CommandLine

from libs.StatusJsonUpdaterClass import StatusJsonUpdaterClass

import json


###############################################
# BT - Credential to log into the gateway.
###############################################

login_info = {
    
    "ip_address": "127.0.0.1",
        
}


# BT - Update this text and "AppDescription" text in manifest.json to remove the custom app

text_to_remove_app = "Multitech Sample Custom App - test"


if __name__ == "__main__":
    
    #######################################################
    # BT - Setting to write log to /var/log/messages.
    #######################################################
    logger = SystemLogger('/var/log/messages')


    api = ApiClass(logger)
    
    ra = RemoveAppClass(logger)
    
    sj = StatusJsonUpdaterClass(logger)
    
    c = CommandLine(logger)

    cfg = ConfigFile('config/config.json',logger)

    config_data = cfg.openFile('json')


    ################################################################################
    # BT - Removing app section
    # BT - Remove app
    # 1. ra.do_remove_app(login_info,api,text_to_remove_app)
    # 2. res = c.do_command("cat /home/admin/dummy.txt")
    #    logger.log_message("BT - Command line returning code: {}".format(res))
    # if "remove-me" in str(res):
    #     logger.log_message("BT - Removing file: {}".format("/home/admin/dummy.txt"))
    #     c.do_command("rm /home/admin/dummy.txt")
    #     logger.log_message("BT - Removing custom app...")
    ################################################################################



    
    
    ################################################################################
    # BT - Coding section - You will need to write to the /home/admin/dummy.txt
    #                       if you want to remove the app after a reboot.
    #                       Otherwise, code your stuff here.
    ################################################################################
    
    ##################################################################
    #BT - Require an array to pass into the update_status_file_with
    ##################################################################
    
    messages = ['test']
    
    res = c.do_command("cat /home/admin/dummy.txt")
    logger.log_message("BT - Command line returning code: {}".format(res))
    

    result = c.do_command("unzip RBS_Decoders.zip -o -d /etc/scada/sensors/lora/radiobridge/")

    logger.log_message("BT - Command line returning code: {}".format(result))
    
    ra.do_remove_app(login_info,api,text_to_remove_app)
     
    # reboot = c.do_command("reboot")



        

        
              




    
    

        
