#!/usr/bin/python3

import sys

import requests, json, urllib3
import datetime
import calendar
# from libs.configfile import ConfigFile

#BT - Must run this command before any request command would work.
urllib3.disable_warnings()


class ApiClass:

    headers = {'Content-Type': 'application/json'}
    
    def __init__(self,logger):
        self.logger = logger

    #####################################################################################################################
    # PUBLIC PYTHON METHODS
    # ###################################################################################################################   
    
    ##########################################################
    #BT - This function will accept either json or files.
    ##########################################################
    
    def do_post_command(self,url,api_command,data):

        if 'file' in data:
            #BT - Use keyword files = data for posting a file to the server
            # print('BT - Posting files...')
            do_post_command = requests.post("http://" + url + '/api' + api_command,files=data,verify=False)
        else:
            #BT - Use keyword json = data for sening just json data.
            do_post_command = requests.post("http://" + url + '/api' + api_command,headers=ApiClass.headers, json=data,verify=False)

        print(do_post_command.url)
        tmp_dict = ApiClass.__convert_to_dict(do_post_command)
        return tmp_dict

    def do_put_command(self,url,api_command,data):
    
        do_put_command = requests.put("http://" + url + '/api' + api_command, headers=ApiClass.headers, json=data,verify=False)
        print(do_put_command.url)
        tmp_dict = ApiClass.__convert_to_dict(do_put_command)
        return tmp_dict

    def do_delete_command(self,url,api_command,data):
        
        do_delete_command = requests.delete("http://" + url + '/api' + api_command, headers=ApiClass.headers, json=data,verify=False)
        print(do_delete_command.url)
        tmp_dict = ApiClass.__convert_to_dict(do_delete_command)
        return tmp_dict

    def do_get_command(self,url,api_command):

        # if token == 0:
        do_get_command = requests.get("http://" + url + '/api' + api_command,headers=ApiClass.headers, verify=False)
        # else:
        #     do_get_command = requests.get("http://" + url + '/api' + api_command,params={'token':token}, headers=ApiClass.headers, verify=False)
        # print(do_get_command.url)
        tmp_dict = ApiClass.__convert_to_dict(do_get_command)
        return tmp_dict
    
    ##################################################################
    #BT - Call this function to print it out nicely in json format.
    ##################################################################
    
    def do_print_pretty_json(self,data):
        return json.dumps(data, indent=4)

    #####################################################################################################################
    # STATIC PRIVATE PYTHON METHOD
    # ###################################################################################################################    

    #BT - The firt two underscore to tell this is a Private Python function.
    @staticmethod
    def __convert_to_dict(data):
        tmp_str = json.dumps(data.json())
        tmp_dict = json.loads(tmp_str)
        return tmp_dict





