#! /usr/bin/python3


import time, sys, json, os

#BT - From <your_folder> import <your_class_name>


from libs.ApiClass import ApiClass

from libs.configfile import ConfigFile

import requests, json, urllib3

from libs.LoggingClass import SystemLogger

import logging

import subprocess

##########################################################################
# BT - This class allows you to send the Linux command to the Gateway.
##########################################################################

class CommandLine:
    
    def __init__(self,logger):
        self.logger = logger
    
    def do_command(self,command,text=True):

        try:
        
            # BT - For python3, you must pass in the last param with text=True
            result = subprocess.check_output(command,shell=True)
            
            #####################################################################
            # BT - It will always return bytes so we will have to str(return)
            #      to get it in string.
            #####################################################################
            return result
        
        ################################################################
        # BT - Any error, it will return the string "Error: xxxx"
        #      We only need to search for "Error"
        ################################################################
        except subprocess.CalledProcessError as e:        
            return "Error: " + str(e)


        
                  
        
    def do_command_deleting_wild_card_file(self,directory, prefix):
        # Get a list of all files in the directory
        files = os.listdir(directory)
        
        print(files)

        # Iterate over the files
        for file_name in files:
            if file_name.startswith(prefix):
                # Construct the full file path
                file_path = os.path.join(directory, file_name)
                print(file_path)
                # Delete the file
                os.remove(file_path)
                #print(f"Deleted file: {file_path}")
                # logging.info(f"Deleted file: {file_path}")
        


