#! /usr/bin/python3


import time, sys, json, os

#BT - From <your_folder> import <your_class_name>


from libs.ApiClass import ApiClass

from libs.configfile import ConfigFile

import requests, json, urllib3

import logging

import logging

class SystemLogger:
    ###########################################
    # BT - Point to /var/log/messages
    ###########################################
    def __init__(self, log_file):
        self.log_file = log_file
        self.logger = self._configure_logger()

    def _configure_logger(self):
        logger = logging.getLogger(__name__)
        logger.setLevel(logging.INFO)

        formatter = logging.Formatter('%(asctime)s - %(levelname)s - %(message)s')

        file_handler = logging.FileHandler(self.log_file)
        file_handler.setLevel(logging.INFO)
        file_handler.setFormatter(formatter)

        logger.addHandler(file_handler)

        return logger

    def log_message(self, message):
        self.logger.info(message)

# Create an instance of SystemLogger
# logger = SystemLogger('/path/to/logfile.log')

# Log a message
# logger.log_message("This is an informational message.")

