#! /usr/bin/python3


import time, sys, json, os

#BT - From <your_folder> import <your_class_name>


from libs.ApiClass import ApiClass

from libs.configfile import ConfigFile

import requests, json, urllib3

from libs.LoggingClass import SystemLogger

import logging

class RemoveAppClass:
    
    def __init__(self,logger):
        self.logger = logger
    
    def do_remove_app(self,login_info, api, text_to_remove):
        
        ######################################################################
        # BT - Need to remove the app. Otherwise, it will kept rebooting.
        ######################################################################
        get_custom_app_id = api.do_get_command(login_info['ip_address'],"/customApps")
        
        self.logger.log_message(json.dumps(get_custom_app_id,indent=4))
        
        for app in get_custom_app_id['result']:
            
            self.logger.log_message(json.dumps(app, indent=4))
            
            if text_to_remove in app['description']:       
                remove_app = "app-manager --command remove --appid {}".format(app['_id'])       
                os.system(remove_app)
                self.logger.log_message("BT - Removed App successfully: {}".format(app['name']))
                return True
        return False

