#!/usr/bin/python3

from datetime import datetime
import json
import os
from libs.LoggingClass import SystemLogger

#####################################################################################
# BT - Response
# {
#     "code": 200,
#     "result": [
#         {
#             "_id": "6579c0fe7e571a0bd95422f6",
#             "description": "Multitech Sample Custom App - ping-reboot",
#             "info": "Not Available",
#             "name": "ping-reboot",
#             "status": "STOPPED",
#             "version": "2.8",
#             "versionNotes": "Third Version"
#         }
#     ],
#     "status": "success"
# }
######################################################################################

class StatusJsonUpdaterClass:
    
    def __init__(self, logger):
        
        #######################################################
        # BT - Setting to write log to /var/log/messages.
        #######################################################
        self.logger = logger
        
    # BT - Pass in your message that you want to display in the Apps -> info column.
    
    def update_status_file_with(self, login_info,api,messages):
        
        ######################################################################
        # BT - Get AppManager info
        ######################################################################
        get_app_manager_info = api.do_get_command(login_info['ip_address'],"/customApps")
        
        #self.logger.log_message(json.dumps(get_app_manager_info,indent=4))
        
        if len(get_app_manager_info['result']) == 1:
            # BT - Path to the custom app
            STATUS_FILE = '/var/persistent/' + get_app_manager_info['result'][0]['name'] + '/' + 'status.json'
            # VERSION = get_app_manager_info['result'][0]['version']
        elif len(get_app_manager_info['result']) > 1:     
            # BT - Path to the custom app
            STATUS_FILE = '/var/persistent/' + get_app_manager_info['result'][-1]['name'] + '/' + 'status.json'
            # VERSION = get_app_manager_info['result'][-1]['version']
        else:
            return
        
        displaying_messages = "Custom app: "
        
        for item in messages:
            displaying_messages += item + ", "
                 
        clean_up_messages = displaying_messages.rstrip(", ")             
        
        status = {'pid': os.getpid(), 'AppInfo': clean_up_messages}
        
        #self.logger.log_message(f'Updating status file with pid [{os.getpid()}] and message [{clean_up_messages}]')

        # BT - Write to the /var/config/your_app/status.json with the message.
        
        with open(STATUS_FILE, 'w') as file:
            json.dump(status, file, indent=2)

