#! /usr/bin/python3

import json

import threading

class ConfigFile(threading.Thread):
    #BT - Init with the file name pass in.
    def __init__(self, fn, logger):
        
        threading.Thread.__init__(self)
        
        self.fileName = fn
        self.data = {}
        self.config_string = ""
        self.logger = logger
        
    #######################################################
    #BT - Only writeFile() will be running a thread.
    #######################################################
       
    def run(self):
        writeFile(self)

    ####################################################################################################################################
    #BT - Call openFile() to have the file loads in json format and return back with Python dict so that you can access it very easily
    ####################################################################################################################################
    def openFile(self,filetype):

        ################################################################################
        #BT - Read file using Context Manager, the advandge of this technique is that
        #     it will automatically handle the error and close the file once you are
        #     out of the block.
        ################################################################################
        
        with open(self.fileName, 'r') as f:
            for line in f:
                self.config_string += line

        if filetype == 'json':
            #BT - Convert json file to Python dict
            self.data = json.loads(self.config_string)
            return self.data

        return self.config_string
    
def writeFile(self):
    
    with open(self.fileName, 'w', encoding='utf-8') as f:
        json.dump(self.data, f, ensure_ascii=False, indent=4)
