set bootstrapFile	C:\\RomBOOT-AEP-6.0.4-SAMBA\\mtcdt-nandflashboot-uboot-3.8.12.m8.bin
set ubootFile	C:\\RomBOOT-AEP-6.0.4-SAMBA\\u-boot-mtcdt-2016.09.01-m5.bin
set uimageFile	C:\\RomBOOT-AEP-6.0.4-SAMBA\\uImage--5.4.81-r2.0-mtcdt-20230119164331.bin
set rootfsFile	C:\\RomBOOT-AEP-6.0.4-SAMBA\\aep-image-rs9113-mtcdt-20230119164331.rootfs.jffs2
## NandFlash Mapping
set ubootAddr		0x00040000
set ubootEnv1Addr	0x000C0000
set ubootEnv2Addr	0x00160000
set uimageAddr		0x00200000
set rootfsAddr		0x01800000

puts "-I- === Initialize the NAND access ==="
NANDFLASH::Init

puts "-I- === Enable PMECC OS Parameters ==="
# 4-bit ECC
NANDFLASH::NandHeaderValue HEADER 0xc0902405

puts "-I- === Erase entire NAND flash==="
NANDFLASH::EraseAll

puts "-I- === Load the bootstrap in the first sector ==="
NANDFLASH::SendBootFilePmeccCmd $bootstrapFile

puts "-I- === Load the u-boot image ==="
send_file {NandFlash} "$ubootFile" $ubootAddr 0

# jjg - no longer needed since U-boot reads eeprom for ethernet mac addr
#puts "-I- === Load u-boot env1 ==="
#send_file {NandFlash} "$ubootEnv1File" $ubootEnv1Addr 0
#puts "-I- === Load u-boot env2 ==="
#send_file {NandFlash} "$ubootEnv2File" $ubootEnv2Addr 0

puts "-I- === Loading uImage ==="
send_file {NandFlash} "$uimageFile" $uimageAddr 0

# Need to enable Trimffs before writing rootfs or PMECC errors will
# result.
NANDFLASH::NandSetTrimffs 1

puts "-I- === Loading rootfs ==="
send_file {NandFlash} "$rootfsFile" $rootfsAddr 0

puts "-I- === DONE. ==="
