<?php
/******************************************************************************/
/* Copyright (C) 2001 - 2002 Multi-Tech Systems, Inc., USA              */
/* All Rights Reserved                                                  */
/* Multi-Tech Systems, Inc., 2205 Woodale Dr, Mounds View MN USA        */
/******************************************************************************/

/*  ModName: Web GUI - Interface*/
/*  Version: 3.25*/
/*  Date: 2005-10-05*/
/*  Modification History - Begin*/
/*  Modification History - End*/

/*	Name 			: httpproxy.php
	Description		: This file contains the http proxy settings
*/
session_start();
include("includes/functions.php");

if (is_denied()) {
	$location = get_page("index.php");
	header($location);
	return;
}

$timeout_location = get_timeout_page();
header($timeout_location);


switch($op)
{
case "bypassform":
	// Aide should not be running, when we are updating configuration files.
        lock_aide();

	if(strcmp($buttonval, "bypass_del") == 0)
	{
		exec("sudo /etc/multiconf/scripts/netname $select_bypass", $OUT,$ret);
		$ipaddress = $OUT[0];
		$mask = $OUT[1];
		chop($ipaddress);
		exec("sudo /etc/multiconf/scripts/http bypass_url delete $ipaddress $mask", $Out, $ret);
	}

	else if(strcmp($buttonval, "bypass_add") == 0)
	{
		exec("sudo /etc/multiconf/scripts/netname $select_available", $ADD,$ret);
		$addip = $ADD[0];
		$addmask = $ADD[1];
		chop($addip);
		exec("sudo /etc/multiconf/scripts/http bypass_url add $addip $addmask", $Out, $ret);
	}
	else if(strcmp($buttonval, "back") == 0)
	{
		$location = get_page("httpproxy.php");
	}
	if ($location == '')
		$location = get_page("httpproxy.php?op=bypass");
	unlock_aide();
	header($location);
	return;
	break;
case "bypass":

	include("includes/get_network_list.php");
	include("includes/get_bypass_list.php");
	$java_script = "<script language = \"javascript\" >
	
	function submitbypassadd()
	{
		document.bypassform.buttonval.value = 'bypass_add';
		if(document.bypassform.select_available.selectedIndex < 0 )
		{
			alert('Select a Network to Add');
		}
		else
		{
			document.bypassform.addbp.disabled = true;
			document.bypassform.deletebp.disabled = true;
			document.bypassform.submit();
		}
	}
	function submitbypassdel()
	{
		document.bypassform.buttonval.value = 'bypass_del';
		if(document.bypassform.select_bypass.selectedIndex < 0 )
		{
			alert('Select a Network to Delete');
		}
		else
		{
			document.bypassform.addbp.disabled = true;
			document.bypassform.deletebp.disabled = true;
			document.bypassform.submit();
		}
	}
	function submitback()
	{
		document.bypassform.buttonval.value = 'back';
		document.bypassform.submit();
	}
	</script>";

//--------------------------

	print_head_with_form("Networks / Hosts to bypass URL Filtering","bypassform","httpproxy.php?&op=bypassform",'',$java_script,2,0,"html/bypass.html");

begin_table("100%");
print_heading("Networks / Hosts to bypass","40%");
print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");
	
	start_blank_line();
	
	print_label_bold("Available Networks / Hosts","33%","center");
	print_label_bold("","34%","center");
	print_label_bold("Networks / Hosts to bypass<BR>URL Filtering","33%","center");

	close_open_tr();
	print "<TD width=\"33%\" align=\"center\"> \n";
	print "<select class=\"selectinput\" name=\"select_available\" size=10>";
	$mm = 1;
	for($i = 0; $i < $total_networks; $i++)
	{
		for($ll = 0; $ll < $total_networks; $ll++)
		{
			if(strcmp($name[$i],$bypass[$ll])==0)
			{
				$mm =1;
				break;
			}
			else
				$mm =0;
		}
		if($mm == 0)
		{
			print("<OPTION VALUE=\"$name[$i]\" ");
			print(">{$name[$i]}\n");
			$mm =1;
		}
	}
	print "</select>";
        print "</TD>";
	print "<TD width=\"33%\" align=\"center\" valign=\"middle\"> \n";
	print "<input type=button class=\"button1\" name=addbp value=\"   Add  >> \" onClick=\"submitbypassadd();\">";

	print "<BR> <BR>";
	print "<input type=button class=\"button1\" name=deletebp value=\"<< Delete\" onClick=\"submitbypassdel();\">";
        print "</TD>";
	print "<TD width=\"33%\" align=\"center\" valign=\"middle\"> \n";
	print "<select class=\"selectinput\" name=\"select_bypass\" size=10>";
	for($i = 0; $i < $total_bypass; $i++)
	{
		print("<OPTION VALUE=\"$bypass[$i]\" ");
		print(">{$bypass[$i]}\n");
	}
	print "</select>";
        print "</TD>";

	end_blank_line();
	close_table_with_tr();
        print "</TD>";
	close_table_with_tr();
        print "</TD>";

	close_open_tr(5);
	print "<TD width=\"100%\" align=\"right\" colspan=3>\n";
	print "<input type=button class=\"button1\" value=\"  Back   \"  name=register onClick=\"submitback();\">";
        print "</TD>";

end_table();
print_foot_with_form();
	break;



case "httpnontrans":
	$java_script = "<script language = \"javascript\" >
	
	function submitnonpolicy()
	{
		document.nontransnetform.buttonval.value = 'nontransnet';
		document.nontransnetform.submit();
	}
	function submitback()
	{
		document.nontransnetform.buttonval.value = 'back';
		document.nontransnetform.submit();
	}
// Vardhaman
	function submitback_edit()
	{
		document.nontransnetform.buttonval.value = 'back_edit';
		document.nontransnetform.submit();
	}

	</script>";

	if (!isset($Value))
	{
		$Value = array(1=>"Allowed","Denied","Available");
	}

	include("includes/get_all_category_list.php");
	include("includes/get_nontrans_list.php");

	print_head_with_form("HTTP Networks","nontransnetform","httpproxy.php?&op=httpnontranschange",'',$java_script,2,0,"html/httpnontrans.html");

begin_table("100%");

if (strcmp($action,"change") == 0)
        print_heading("Change Status for $network","40%");
else
        print_heading("HTTP Non-Transparent Networks","40%");

print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");


	if ($action == change)
	{
        	start_blank_line();

		$label = array("Network Name"," Policy"," ");
		$width = array("34%","33%","33%");
                for ($i=0 ; $i < count($label) ; $i++)
                {
                        print_label_bold($label[$i],$width[$i],"center");
                }

	        close_open_tr();

		print_selected_label("$network","34%","center");
		print "<input type=hidden name=network value=\"$network\" >";
		print "<TD align=\"center\" width=\"33%\">";
		print "<select class=\"selectinput\" name=\"policy\" >\n";
		for ($m =1;$m <=3;$m++)
		{
			print("<OPTION VALUE=\"$Value[$m]\"   ");
			if (strcmp($Value[$m],$ppolicy) == 0)
			print("selected");
			print(">{$Value[$m]}\n");
		}
		print "</select>\n";
		print "</TD>";
		print "<TD width=\"33%\">";
		print "<input type=button class=\"button1\" name=Changepolicy value=\"  Change  \"onClick=\"submitnonpolicy();\"> \n";
		print "</TD>";
		close_open_tr();
	}


        print "<TD class=\"normal\" colspan=3>\n";

        open_display_table_with_tr();

        $label = array("Network/Host","Status","Options");
	$width = array("34%","33%","33%");

        for ($i=0 ; $i < count($label); $i++)
        {
                print_table_label($label[$i],$width[$i],"center");
        }

	for( $j = 0; $j <= $total_nontrans; $j++)
	{
		if($nonname[$j] == "")
			continue;
		if ($j % 2 == 0) {
			$bcolor = 'ecolor';
		}
		else {
			$bcolor = 'ocolor';
		}
		print_tr_with_hover($bcolor);

                print_table_values($nonname[$j],$width[0]);
                print_table_values($nonact[$j],$width[1]);

		print "<TD width=\"33%\" align=\"center\"> <a class=\"action\" href=httpproxy.php?&op=httpnontranschange&action=change&net=$nonname[$j]&pol=$nonact[$j]> Change Status </a> </TD>";
	}


	close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";

	close_open_tr(5);
	print "<TD align=\"right\" width=\"100%\" colspan=3>";	
	if($action == "change")
	{
		print "<input type=button class=\"button1\" name=back_nontrans value=\"  Back  \" onclick=\"submitback_edit();\" > ";
	}
	else
	{
		print "<input type=button class=\"button1\" name=back_nontrans value=\"  Back  \" onclick=\"submitback();\" > ";
	}
        print "</TD>";

end_table();
print_foot_with_form();

session_unregister("network");
session_unregister("ppolicy");
session_unregister("action");
	
break;


case "httpnontranschange":
	// Aide should not be running, when we are updating coniguration files.
        lock_aide();

	include("includes/get_nontrans_list.php");
	if ($action == "change")
	{
		$network = $net;
		$ppolicy = $pol;
		session_start();
		session_register("network");
		session_register("ppolicy");
		session_register("action");
	}
	if (strcmp($buttonval, "nontransnet") == 0)
	{

		chop($ppolicy);
	        for ($m = 0; $m < $total_nontrans; $m++)
                {
        	        if (strcmp($nonname[$m], $network) == 0)
                        {
				$newact = $policy;
				$oldact = $nonact[$m];
				break;
			}
		}
		exec("sudo /etc/multiconf/scripts/http changenetaction nontransparent $network $oldact $newact", $Output, $return);

		$filename = "/etc/multiconf/nontransnet";
		$myfile = fopen($filename,r);

		while(!feof($myfile))
		{
			$myline = fgets($myfile,255);
                       	$get_net = sscanf($myline, "%s %s", $str1, $str2 );
			if (strcmp ($str1, $network) == 0)
			{
				$search_string = $myline;
				break;
			}
		}
		$filearray = file($filename);
		$file = fread($fp=fopen($filename,'r'),filesize($filename));
		fclose($fp);
		$file = str_replace($search_string,$network." ".$newact."\n", $file);
		$fp = @fopen($filename,'w');
		fwrite($fp,$file);
		fclose($fp);
	} 	//  vardhaman 19-11-2003 to provide back button
	else if(strcmp($buttonval, "back") == 0)
	{
		$location = get_page("httpproxy.php");
	}
	else if(strcmp($buttonval, "back_edit") == 0)
	{
		$location = get_page("httpproxy.php?&op=httpnontrans");
	}
	if ($location == '')
		$location = get_page("httpproxy.php?&op=httpnontrans");

        unlock_aide();
	header($location);
	return;
	break;

case "httptrans":
	$java_script = "<script language = \"javascript\" >
	
	function submitpolicy()
	{
		document.transnetform.buttonval.value = 'transnet';
		document.transnetform.submit();
	}
	function submitback()
	{
		document.transnetform.buttonval.value = 'back';
		document.transnetform.submit();
	}
	function submitback_edit()
	{
		document.transnetform.buttonval.value = 'back_edit';
		document.transnetform.submit();
	}

	</script>";
	if (!isset($Value))
	{
			$Value = array(1=>"Allowed","Denied","Available");
	}
	include("includes/get_all_category_list.php");
	include("includes/get_trans_list.php");

//--------------------------

	print_head_with_form("HTTP Networks","transnetform","httpproxy.php?&op=httptranschange",'',$java_script,2,0,"html/httptrans.html");

begin_table("100%");

if (strcmp($action,"change") == 0)
        print_heading("Change Status for $network","40%");
else
        print_heading("HTTP Transparent Networks","40%");

print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        if ($action == change)
        {
                start_blank_line();

                $label = array("Network Name"," Policy"," ");
                $width = array("34%","33%","33%");
                for ($i=0 ; $i < count($label) ; $i++)
                {
                        print_label_bold($label[$i],$width[$i],"center");
                }

                close_open_tr();

                print_selected_label("$network","34%","center");
		print "<input type=hidden name=network value=\"$network\" >";
		print "<TD width=\"33%\" align=\"center\">";
		print "<select class=\"selectinput\" name=\"policy\" >\n";
		for ($m =1;$m <=3;$m++)
		{
			print("<OPTION VALUE=\"$Value[$m]\"   ");
			if (strcmp($Value[$m],$ppolicy) == 0)
			print("selected");
			print(">{$Value[$m]}\n");
		}
		print "</select>\n";
                print "</TD>";
                print "<TD width=\"33%\">";
		print "<input type=button class=\"button1\" name=Changepolicy value=\"  Change  \"onClick=\"submitpolicy();\"> \n";
                print "</TD>";
                close_open_tr();

	}

        print "<TD class=\"normal\" colspan=3>\n";

        open_display_table_with_tr();

        $label = array("Network/Host","Status","Options");
        $width = array("34%","33%","33%");

        for ($i=0 ; $i < count($label); $i++)
        {
                print_table_label($label[$i],$width[$i],"center");
        }


	for( $j = 0; $j <= $total_trans; $j++)
	{
		if($transname[$j] == "")
			continue;
		if ($j % 2 == 0) {
			$bcolor = 'ecolor';
		}
		else {
			$bcolor = 'ocolor';
		}	

		print_tr_with_hover($bcolor);

                print_table_values($transname[$j],$width[0]);
                print_table_values($transact[$j],$width[1]);

		print "<TD width=\"33%\" align=\"center\"> <a class=\"action\" href=httpproxy.php?&op=httptranschange&action=change&net=$transname[$j]&pol=$transact[$j]> Change Status </a> </TD>";
        }

        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";

        close_open_tr(5);
        print "<TD align=\"right\" width=\"100%\" colspan=3>";
	if ($action == "change")
	{
		print "<input type=button class=\"button1\" name=back_urlcat value=\"  Back  \" onclick=\"submitback_edit();\">";
	}
	else
	{
		print "<input type=button class=\"button1\" name=back_urlcat value=\"  Back  \" onclick=\"submitback();\">";
	}
        print "</TD>";
	
end_table();	
print_foot_with_form();
	session_unregister("network");
	session_unregister("ppolicy");
	session_unregister("action");
	break;
case "httptranschange":
	// Aide should not be running, when we are updating coniguration files.
	lock_aide();

	include("includes/get_trans_list.php");
	if ($action == "change")
	{
		$network = $net;
		$ppolicy = $pol;
		session_start();
		session_register("network");
		session_register("ppolicy");
		session_register("action");
	}

	if (strcmp($buttonval, "transnet") == 0)
	{

		chop($ppolicy);
		for ($m = 0; $m < $total_trans; $m++)
		{
			if (strcmp($transname[$m], $network) == 0)
			{
				$newact = $policy;
				$oldact = $transact[$m];
				break;
			}
		}
		exec("sudo /etc/multiconf/scripts/http changenetaction transparent $network $oldact $newact", $Output, $return);
		$filename = "/etc/multiconf/transnet";
		$myfile = fopen($filename,r);
		while(!feof($myfile))
		{
			$myline = fgets($myfile,255);
			$get_net = sscanf($myline, "%s %s", $str1, $str2 );
			if (strcmp ($str1, $network) == 0)
			{
				$search_string = $myline;
				break;
			}
		}
		$filearray = file($filename);
		$file = fread($fp=fopen($filename,'r'),filesize($filename));
		fclose($fp);
		$file = str_replace($search_string,$network." ".$newact."\n", $file);
		$fp = @fopen($filename,'w');
		fwrite($fp,$file);
		fclose($fp);
	} 	//  vardhaman 19-11-2003 to provide back button
	else if(strcmp($buttonval, "back") == 0)
	{
		$location = get_page("httpproxy.php");
	}
	else if(strcmp($buttonval, "back_edit") == 0)
	{
		$location = get_page("httpproxy.php?&op=httptrans");
	}
	if ($location == '')
		$location = get_page("httpproxy.php?&op=httptrans");
        
	unlock_aide();
	header($location);
	return;
	break;


case "urlcat":
	$java_script = "<script language = \"javascript\" >
	
	function submiturlcat(name)
	{
		document.surfform.buttonval.value = name;
		document.surfform.submit();
	}
	function submitsearch()
	{
		var searchurl = document.surfform.search_url.value;
		var domainPat = /^(([hH][tT][tT][pP]|[fF][tT][pP]|[hH][tT][tT][pP][sS])\:\/\/)?(([0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.)|(([a-zA-Z0-9\-\_]+\.)+))([a-zA-Z]{2,4}|[0-9]{1,3})(\/([A-Za-z0-9\-\._\?\,%\$#\=&~]*))*$/

		var retval = searchurl.match(domainPat);
		if (retval === null)
		{
			alert('Invalid URL');
		}
		else
		{
			document.surfform.buttonval.value = 'searchurl';
			document.surfform.submit();
		}
	}
	function submitcatadd()
	{
		document.surfform.buttonval.value = 'catadd';
		document.surfform.deletecat.disabled = true;
		document.surfform.addcat.disable = true;
//		document.surfform.restore.disabled = true;
//                document.surfform.backup.disabled = true;
		document.surfform.submit();
	}
	function submitcatdel()
	{
		document.surfform.buttonval.value = 'catdel';
		document.surfform.deletecat.disabled = true;
		document.surfform.addcat.disabled = true;
//		document.surfform.restore.disabled = true;
//                document.surfform.backup.disabled = true;
		document.surfform.submit();
	}
	function submitback()
	{
		document.surfform.buttonval.value = 'back';
		document.surfform.submit();
	}
	
	// Begin: Submit Backup and Restore
//	function submitbackup()
//	{
//		document.surfform.buttonval.value = 'backup';

//		if (confirm('Backup will take few minutes to complete.\\nDo you want to backup URL category database files?'))
//                {
//			document.surfform.restore.disabled = true;
//                	document.surfform.backup.disabled = true;
//			document.surfform.addcat.disable = true;
//			document.surfform.deletecat.disable = true;
//			document.surfform.back_urlcat.disable = true;
//			document.surfform.display.disable = true;
//                	document.surfform.submit();
//		}
//	}

//	function submitrestore()
//        {
//                document.surfform.buttonval.value = 'restore';
//		if (confirm('Restore will take few minutes to complete.\\nDo you want to restore URL category database files?'))
//                {
//			document.surfform.restore.disabled = true;
//			document.surfform.backup.disabled = true;
//			document.surfform.addcat.disable = true;
//                        document.surfform.deletecat.disable = true;
//			document.surfform.back_urlcat.disable = true;
//                        document.surfform.display.disable = true;	
//                        document.surfform.submit();
//		}
//        }
	// End: Submit Backup and Restore
	
        function OpenLogWindow(page)
        {
            var cWindow = window.open(page,'log','scrollbars=yes,resizable=yes,width=500,height=350, screenX=1,screenY=1,top=0,left=0,toolbar,menubar,location');
	    if (!cWindow.opener) cWindow.opener = self;
	    if (cWindow.focus != null) cWindow.focus();
	}
	</script>";

	include("includes/get_all_category_list.php");

	print_head_with_form("URL Categories","surfform","httpproxy.php?op=surfcontrol",'',$java_script,2,0,"html/urlcat.html");
	
//----------------------------

begin_table("100%");
print_heading("URL Categories","40%");
print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

        print_label_bold("URL Categories allowed","33%","center");
        print "<TD width=\"34%\" align=\"center\"> &nbsp; </TD>\n";
        print_label_bold("URL Categories filtered","33%","center");

        close_open_tr();
        print "<TD width=\"33%\" align=\"center\" valign=\"middle\"> \n";	
	print("<select class=\"selectinput\" name=\"select_allowed_categories[]\" multiple size=10>");
	for($i = 0; $i < $total_allowed_categories; $i++)
	{
		print("<OPTION VALUE=\"$allowed_categ[$i]\" ");
		print(">{$allowed_categ[$i]}\n");

	}
	print "</select>";
        print "</TD>";
        print "<TD width=\"34%\" align=\"center\" valign=\"middle\"> \n";	
	print "<input type=button class=\"button1\" name=deletecat value=\"  Filter >> \" onClick=\"submitcatdel();\"> \n";
	print "<BR> <BR>";
	print "<input type=button class=\"button1\" name=addcat value=\" << Allow  \" onClick=\"submitcatadd();\">";
        print "</TD>";
	
        print "<TD width=\"33%\" align=\"center\"> \n";	
	print "<select class=\"selectinput\" name=\"select_filtered_categories[]\" multiple size=10>\n";
	for($i = 0; $i < $total_denied_categories; $i++)
	{
		print("<OPTION VALUE=\"$denied_categ[$i]\" ");
		print(">{$denied_categ[$i]}\n");

	}
	print "</select>";
        print "</TD>";

	end_blank_line();
	close_table_with_tr();
	print "</TD>";
	close_table_with_tr();
	print "</TD>";

close_open_tr();

	print_heading("Get URL Category");
	print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

	print_label("URL","34%");
        print "<TD width=\"46%\" > \n";	
	print "<font class=normalhbold>http://&nbsp;&nbsp;&nbsp; </font> ";
	print "<input type=text class=\"logininput\" size=25 name=search_url value=\"$search_url\"> ";
	print "</TD>";
        print "<TD width=\"20%\" > \n";	
	print "<input type=button class=\"button1\" name=display value=\"    Go    \" onClick=\"submitsearch();\">\n";
	print "</TD>";

	if($category)
	{
		close_open_tr();
        	print "<TD width=\"100%\" align=\"center\" colspan=3 > \n";	
		print "<font class=heading> Category: </font> <font class=normalboldred> $category</font>";
		print "</TD>";
		session_unregister("category");
	}
	if ($search_url)
	{
		session_unregister("search_url");
	}

	end_blank_line();
	close_table_with_tr();
        print "</TD>";
	close_table_with_tr();
        print "</TD>";
/*
	// Start: Backup and Restore Stuffs

	exec("sudo /etc/multiconf/scripts/http dispbackup",$outcat,$retval);
                                                                                                                             
close_open_tr();
	
	if (strcmp($outcat[0], "enable") == 0)        
        {                                                                                                             
        	print_heading("Backup / Restore URL Category");
	}
	else
	{
		print_heading("Backup URL Category");
	}
        print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");
                                                                                                                             
        start_blank_line();

	print_label("Backup URL category database files","60%");
        print "<TD width=\"20%\">";
        print "</TD>";
        print "<TD width=\"20%\">";
        print "<input type=button class=\"button1\" name=backup value=\"  Backup  \" onClick=\"submitbackup();\">\n";
        print "</TD>";

	if (strcmp($outcat[0], "enable") == 0)
        {
		close_open_tr();
		print_label("Restore URL category database files","60%");
        	print "<TD width=\"20%\">";
        	print "</TD>";
        	print "<TD width=\"20%\">";
        	print "<input type=button class=\"button1\" name=restore value=\"  Restore \" onClick=\"submitrestore();\">\n";
        	print "</TD>";
		
		close_open_tr();
                print "<TD width=\"100%\" colspan=2>";
                print "<font class=\"normalblue\">&nbsp;&nbsp; URL Categorization database backup taken on </font> <font class=\"normalred\"> $outcat[1] </font>";
                print "</TD>";
        }
	else
	{
		print "<input type=hidden class=\"button1\" name=restore value=\"  Restore \"> \n";
	}                                                                                                                     
	end_blank_line();
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";
*/
	// End: Backup and Restore Stuffs

close_open_tr();

        print_heading("Submit A Site");
        print "<TD class=normal colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=\"center\" valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

       	print "<TD width=\"100%\" > \n";	
	print "<font class=normalblue> &nbsp;&nbsp;&nbsp; To submit sites to be blocked/unblocked, </font> <a class=\"action\" onClick=\"OpenLogWindow('http://mtas.surfcontrol.com/mtas/MTAS.asp')\" href=\"#\"> Click Here </a>";
        print "</TD>";

	end_blank_line();
	close_table_with_tr();
        print "</TD>";
	close_table_with_tr();
        print "</TD>";
       	
	close_open_tr(5);
	print "<TD width=\"100%\" align=\"right\" colspan=2> \n";	
	print "<input type=button class=\"button1\" name=back_urlcat value=\"  Back  \" onclick=\"submitback()\">\n";
        print "</TD>";
end_table();
	print_foot_with_form();
	break;
	
case "surfcontrol":
	// Aide should not be running, when we are updating coniguration files.
        lock_aide();

	if(strcmp($buttonval, "catdel") == 0)
	{
		for ($n=0; $select_allowed_categories[$n] ; $n++)
		{
		$fileadd = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/DeniedCategories", a);

		fputs($fileadd, $select_allowed_categories[$n]."\n");
		fclose($fileadd);
		$filename = "/var/chroot-squid/usr/local/squid/surfcontrol/AllowedCategories";
		$filearray = file($filename);
		$file = fread($fp=fopen($filename,'r'),filesize($filename));
		fclose($fp);

//		$select_allowed_categories[$n] = chop($select_allowed_categories[$n]);
//		$file = str_replace($select_allowed_categories[$n],"\0", $file);

		$pattern = "^".$select_allowed_categories[$n];
		$file = ereg_replace($pattern,"\0", $file);

		$pattern = "\n".$select_allowed_categories[$n];
		$file = ereg_replace($pattern,"\n", $file);

		$temp_file = "/etc/multiconf/temp";
		$fp = @fopen($temp_file,'w');
		fwrite($fp,$file);
		fclose($fp);

		$myfile = fopen($temp_file, r);
		$fp = fopen($filename,w);
		while(!feof($myfile))
		{
			$myline = fgets($myfile, 255);
			$myline = rtrim($myline);
                        if ((strcmp($myline, " ") == 0) OR (strcmp($myline, "\0") == 0) OR (strcmp($myline, "") == 0))
				continue;
			fputs($fp, $myline."\n");
		}
		fclose($myfile);
		fclose($fp);
		}
//--------------- Added to sort elements
		$myfile = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/DeniedCategories", r);
		$temp_array=array();
		$i=0;
		while(!feof($myfile))
		{
			$myline = fgets($myfile, 255);
			$myline = rtrim($myline);
                        if ((strcmp($myline, " ") == 0) OR (strcmp($myline, "\0") == 0) OR (strcmp($myline, "") == 0))
				continue;
			else
			{
				$temp_array[$i] = $myline;
				$i++; 
			}
		}
		sort($temp_array);	
		fclose($myfile);	

		$myfile = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/DeniedCategories", w);
		for ($i=0; $temp_array[$i]; $i++)
		{
			fputs($myfile,$temp_array[$i]."\n");
		}
		fclose($myfile);
//----------

		exec("sudo /etc/multiconf/scripts/urlfiltering reread",$outval,$retval);
		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
	}

	else if(strcmp($buttonval, "catadd") == 0)
	{
		for ($n=0; $select_filtered_categories[$n]; $n++)
		{
		$select_filtered_categories[$n] = chop($select_filtered_categories[$n]);
		$fileadd = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/AllowedCategories", a);
		fputs($fileadd, $select_filtered_categories[$n]."\n");
		fclose($fileadd);
		$filename = "/var/chroot-squid/usr/local/squid/surfcontrol/DeniedCategories";
		$filearray = file($filename);
		$file = fread($fp=fopen($filename,'r'),filesize($filename));
		fclose($fp);

//		$file = str_replace($select_filtered_categories[$n],"\0", $file);

		$pattern = "^".$select_filtered_categories[$n];
		$file = ereg_replace($pattern,"\0", $file);

		$pattern = "\n".$select_filtered_categories[$n];
		$file = ereg_replace($pattern,"\n", $file);

		$temp_file = "/etc/multiconf/temp";
		$fp = @fopen($temp_file,'w');
		fwrite($fp,$file);
		fclose($fp);

		$myfile = fopen($temp_file, r);
		$fp = fopen($filename,w);
		while(!feof($myfile))
		{
			$myline = fgets($myfile, 255);
			$myline = rtrim($myline);
                        if ((strcmp($myline, " ") == 0) OR (strcmp($myline, "\0") == 0) OR (strcmp($myline, "") == 0))
				continue;
                        fputs($fp, $myline."\n");
		}
		fclose($myfile);
		fclose($fp);
		}

//------------- Added to sort elements
		$myfile = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/AllowedCategories", r);
		$temp_array=array();
		$i=0;
		while(!feof($myfile))
		{
			$myline = fgets($myfile, 255);
			$myline = rtrim($myline);
                        if ((strcmp($myline, " ") == 0) OR (strcmp($myline, "\0") == 0) OR (strcmp($myline, "") == 0))
				continue;
			else
			{
				$temp_array[$i] = $myline;
				$i++; 
			}
		}
		sort($temp_array);	
		fclose($myfile);	

		$myfile = fopen("/var/chroot-squid/usr/local/squid/surfcontrol/AllowedCategories", w);
		for ($i=0; $temp_array[$i]; $i++)
		{
			fputs($myfile,$temp_array[$i]."\n");
		}
		fclose($myfile);
//----------
		exec("sudo /etc/multiconf/scripts/urlfiltering reread",$outval,$retval);
		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
	}
	else if(strcmp($buttonval, "searchurl") == 0)
	{
	// Strange behaviour search url was not getting recognized so added this
		$search_url = $HTTP_POST_VARS['search_url'];
		$substr = "://";
		$substrlen = strpos($search_url,$substr) + strlen($substr);

		if (substr_count($search_url,$substr) >= 1)
		{
			$search_url = substr_replace($search_url,"",0,$substrlen);
		}

		exec("sudo /etc/multiconf/scripts/http get_urlcategory $search_url",$outcat,$retval);
		if ($outcat[0])
		{
			$category = $outcat[0];
		}
		else
		{
			$category = "none";
		}
		session_register("category");
		session_register("search_url");
	}
	else if(strcmp($buttonval, "back") == 0)
	{
		$location = get_page("httpproxy.php");
	}

	// Begin: Backup and Restore Button Status
//	else if(strcmp($buttonval, "backup") == 0)
//	{       
//		exec("sudo /etc/multiconf/scripts/http backup",$backup,$retval);
//	}
//	else if(strcmp($buttonval, "restore") == 0)
//	{
//		exec("sudo /etc/multiconf/scripts/http restore",$restore,$retval);
//	}	
	// End: Backup and Restore Button Status

	if ($location == '')
		$location = get_page("httpproxy.php?&op=urlcat");
	unlock_aide();
	header($location);
	break;
case "proxyform":
	// Aide should not be running, when we are updating configuration files.
        lock_aide();

	include("includes/get_network_list.php");

	/*To configure httpproxy status*/

	if (strcmp($buttonval, "stdis") == 0)
	{
		if (strcmp($httpstatchbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http squid enable", $StatusOutput, $statusreturn);
			/*Calling Intrusion Script*/
			if($statusreturn ==0)
			{
				exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
			}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http squid disable", $StatusOutput, $statusreturn);
			/*Calling Intrusion Script*/
			if($statusreturn ==0)
			{
				exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
			}
		}
	}

	/*To configure transparent status*/

	else if (strcmp($buttonval, "transdis") == 0)
	{
		if (strcmp($transchbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http transparent enable", $TransOutput, $transreturn);
			/*Calling Intrusion Script*/
			if($transreturn ==0)
			{
				exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
			}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http transparent disable", $TransOutput, $transreturn);
			/*Calling Intrusion Script*/
			if($transreturn ==0)
			{
				exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
			}
		}
	}

	else if (strcmp($buttonval, "urlen") == 0)
	{
		session_register("url_error");
		$url_error = 0;
		if (strcmp($urlchkbox,"on") == 0)
		{
			
			exec("sudo /etc/multiconf/scripts/http checkactivate", $URLSTATOutput1, $urlreturn1);
			if (strcmp($URLSTATOutput1[0], "yes") == 0)
			{
				$url_error = 0;
				exec("sudo /etc/multiconf/scripts/http url enable", $URLSTATOutput, $urlreturn);
				/*Calling Intrusion Script*/
				if($urlreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
			}
			else if (strcmp($URLSTATOutput1[0], "no") == 0)
			{
				$url_error = 1;
			}
			
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http url disable", $URLSTATOutput, $urlreturn);
				/*Calling Intrusion Script*/
				if($urlreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
	}

	/*To configure authentication status*/

	else if (strcmp($buttonval, "authen") == 0)
	{
		if (strcmp($authchbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http auth enable", $AuthOutput, $authreturn);
				/*Calling Intrusion Script*/
				if($authreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http auth disable", $AuthOutput, $authreturn);
				/*Calling Intrusion Script*/
				if($authreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
	}

	/*To enable/disable javascript filtering*/

	else if (strcmp($buttonval, "jsdis") == 0)
	{
		if (strcmp($javachbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http javascript enable", $JsOutput, $jsreturn);
				/*Calling Intrusion Script*/
				if($jsreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http javascript disable", $JsOutput, $jsreturn);
				/*Calling Intrusion Script*/
				if($jsreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
	}

	/*To enable/disable cookie filetring*/

	else if (strcmp($buttonval, "codis") == 0)
	{
		if (strcmp($cookchbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http cookie enable", $CoOutput, $coreturn);
				/*Calling Intrusion Script*/
				if($coreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http cookie disable", $CoOutput, $coreturn);
				/*Calling Intrusion Script*/
				if($coreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
	}

	/*To enable/disable banner filtering*/

	else if (strcmp($buttonval, "bndis") == 0)
	{
		if (strcmp($bannerchbox,"on") == 0)
		{
			exec("sudo /etc/multiconf/scripts/http banner enable", $BannerOutput, $bnreturn);
				/*Calling Intrusion Script*/
				if($bnreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
		else
		{
			exec("sudo /etc/multiconf/scripts/http banner disable", $BannerOutput, $bnreturn);
				/*Calling Intrusion Script*/
				if($bnreturn ==0)
				{
					exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
				}
		}
	}

	/*Adding allowed networks*/

	else if (strcmp($buttonval, "transadd") == 0)
	{

		for ($i = 0; $i < $total_networks; $i++)
		{
			if (strcmp($name[$i], $select_http_trans_not_allowed_networks ) == 0)
			{
				$ip_address_to_pass = $ip_address[$i];
				$ip_mask = $subnet_mask[$i];

				break;
			}

		}
		/*Call the script to add the network*/

		exec("sudo /etc/multiconf/scripts/http allowednetworks transparent $ip_address_to_pass $ip_mask", $AddtransOutput, $addtransreturn);

		/*If the script is successful add it to the networks file*/

		if ($addtransreturn == 0)
		{
			$filename = "/etc/multiconf/networks";
			$filearray = file($filename);
			$file = fread($fp=fopen($filename,'r'),filesize($filename));
			fclose($fp);
			$file = str_replace("[Groups]","httptrans ".$select_http_trans_not_allowed_networks."\n"."[Groups]", $file);
			$fp = @fopen($filename,'w');
			fwrite($fp,$file);
			fclose($fp);

			exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		}
	}
	else if (strcmp($buttonval, "nontransadd") == 0)
	{
		for ($i = 0; $i < $total_networks; $i++)
		{
			if (strcmp($name[$i], $select_http_nontrans_not_allowed_networks ) == 0)
			{
				$ip_address_to_pass = $ip_address[$i];
				$ip_mask = $subnet_mask[$i];
				break;	
			}
		}
		/*Call the script to add the network*/
		exec("sudo /etc/multiconf/scripts/http allowednetworks $ip_address_to_pass $ip_mask", $AddnontransOutput, $addnontransreturn);

		/*If the script is successful add it to the networks file*/
		if ($addnontransreturn == 0)
		{
			$filename = "/etc/multiconf/networks";
			$filearray = file($filename);
			$file = fread($fp=fopen($filename,'r'),filesize($filename));
			fclose($fp);
			$file = str_replace("[Groups]","httpnontrans ".$select_http_nontrans_not_allowed_networks."\n"."[Groups]", $file);
			$fp = @fopen($filename,'w');
			fwrite($fp,$file);
			fclose($fp);

			exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		}
	}

	/*Deleting allowed networks*/

	else if (strcmp($buttonval, "transdel") == 0)
	{
		for ($i = 0; $i < $total_networks; $i++)
		{
			if (strcmp($name[$i], $select_http_trans_allowed_networks ) == 0)
			{
				$ip_address_to_pass = $ip_address[$i];
				$ip_mask = $subnet_mask[$i];
				break;
			}

		}
		exec("sudo /etc/multiconf/scripts/http delallowednetworks transparent $ip_address_to_pass $ip_mask", $DelOutput, $delreturn);

		if ($delreturn == 0)
		{
			/*Delete network from the network file*/
			$filename = "/etc/multiconf/networks";
			$filearray = file($filename);
			$file = fread($fp=fopen($filename,'r'),filesize($filename));
			fclose($fp);
			$file = str_replace("httptrans ".$select_http_trans_allowed_networks,"\0", $file);
			$temp_file = "/etc/multiconf/temp";
			$fp = @fopen($temp_file,'w');
			fwrite($fp,$file);
			fclose($fp);
			$myfile = fopen($temp_file, r);
			$fp = fopen($filename,w);
			while(!feof($myfile))
			{
				$myline = fgets($myfile, 255);
				if (strcmp($myline, " ") != 0)
					fputs($fp, $myline);
			}
			fclose($myfile);
			fclose($fp);

		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		}	
	}
	else if (strcmp($buttonval, "nontransdel") == 0)
	{
		for ($i = 0; $i < $total_networks; $i++)
		{
			if (strcmp($name[$i], $select_http_nontrans_allowed_networks ) == 0)
			{
				$ip_address_to_pass = $ip_address[$i];
				$ip_mask = $subnet_mask[$i];
				break;
			}

		}
		exec("sudo /etc/multiconf/scripts/http delallowednetworks $ip_address_to_pass $ip_mask", $DelOutput, $delreturn);
		if ($delreturn == 0)
		{
			/*Delete network from the network file*/
			$filename = "/etc/multiconf/networks";
			$filearray = file($filename);
			$file = fread($fp=fopen($filename,'r'),filesize($filename));
			fclose($fp);
			$file = str_replace("httpnontrans ".$select_http_nontrans_allowed_networks,"\0", $file);
			$temp_file = "/etc/multiconf/temp";
			$fp = @fopen($temp_file,'w');
			fwrite($fp,$file);
			fclose($fp);
			$myfile = fopen($temp_file, r);
			$fp = fopen($filename,w);
			while(!feof($myfile))
			{
				$myline = fgets($myfile, 255);
				if (strcmp($myline, " ") != 0)
				fputs($fp, $myline);
			}
			fclose($myfile);
			fclose($fp);
		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);

		}
	}
	else if (strcmp($buttonval, "authadd") == 0)
	{
		exec("sudo /etc/multiconf/scripts/pamsuppp squid $http_not_used_auth enable", $Add, $return);
		/*Calling Intrusion Script*/
		if($return ==0)
		{
			exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		}
		$http_port_access = get_http_access();
		if (strcmp($http_port_access, "yes") == 0)
        	{
                	if (strcmp($HTTPS, "on") == 0)
		        	header("Location:https://$HTTP_HOST/httpproxy.php");
                	else
                        	header("Location:http://$HTTP_HOST/httpproxy.php");
        	}
		else
			header("Location:https://$HTTP_HOST/httpproxy.php");
	}
	else if (strcmp($buttonval, "authdel") == 0)
	{
		exec("sudo /etc/multiconf/scripts/pamsuppp squid $used_authentications disable", $Delete, $return);
		/*Calling Intrusion Script*/
		if($return ==0)
		{
			exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		}
	}
	else if (strcmp($buttonval, "usradd") == 0)
	{

		$filename = "/var/chroot-squid/etc/multiconf/httpusers";
		$myfile = fopen($filename, a);
		fputs($myfile, $http_not_allowed_users."\n");
		fclose($myfile);

		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		exec("sudo /etc/multiconf/scripts/http squid restart", $StatusOutput, $statusreturn);
	}
	else if (strcmp($buttonval, "urlcat") == 0)
	{
		$location = get_page("httpproxy.php?&op=urlcat");
		unlock_aide();
		header($location);
		return;
	}
	else if (strcmp($buttonval, "bypass") == 0)
	{
		$location = get_page("httpproxy.php?&op=bypass");
		unlock_aide();
		header($location);
		return;
	}

	else if (strcmp($buttonval, "usrdel") == 0)
	{
		$filename = "/var/chroot-squid/etc/multiconf/httpusers";
		$temp_file = "/etc/multiconf/temp";
		$tempfp = @fopen($temp_file,'w');
		$fp = fopen($filename,r);
		while(!feof($fp))
		{
			$myline = fgets($fp,255);

			if (strcmp($myline," ") == 0)
				continue;
			else
			{
				sscanf($myline, "%s",$username);
			}
			if (strcmp($username, $http_users) != 0)
				fputs($tempfp, $myline);
		}
		fclose($fp);
		fclose($tempfp);
		$buftowrite = fread($tempfp=fopen($temp_file,'r'),filesize($temp_file));
		fclose($tempfp);
		$fp = @fopen($filename,'w');
		fwrite($fp,$buftowrite);
		fclose($fp);

		exec("sudo /etc/multiconf/scripts/CheckIntrusion update", $Out, $ret);
		exec("sudo /etc/multiconf/scripts/http squid restart", $StatusOutput, $statusreturn);
	}
	else if (strcmp($buttonval, "transpage") == 0)
	{
		$location = get_page("httpproxy.php?&op=httptrans");
		unlock_aide();
		header($location);
		return;
	}
	else if (strcmp($buttonval, "nontranspage") == 0)
	{
		$location = get_page("httpproxy.php?&op=httpnontrans");
		unlock_aide();
		header($location);
		return;
	}
	else if (strcmp($buttonval, "addgroup") == 0)
	{
		$location = get_page("groups.php");
		unlock_aide();
		header($location);
		return;
	}

	unlock_aide();
	$location = get_page("httpproxy.php");
	header($location);

default:

	$AuthenticationName = array(1=>"local", "sam","radius");

	include_once("includes/get_network_list.php");
	include_once("includes/get_all_user_list.php");
	include("includes/get_appl_list.php");

	$java_script = "<script language = \"javascript\" type=\"text/javascript\">

	function addurlfilter()
	{
		var Checkurl =0;
		var Checkurl2 =0;
		var Checkurl3 =0;
		var Checkurl4 =0;
		var urlStr = document.httpdoc.url.value;
		var reurl =/^.+\..+\..+$/

	/*	Checking the pattern of url-Character should be present before a dot and after a dot-there can be as many dots as possible and special characters are allowed like /,~ . */
		if(!( reurl.test(urlStr)))
		{
			Checkurl2 =1;
			alert('URL seems to be invalid');
		}
		var i =0;
		var length =urlStr.length;

	/* Checking for empty spaces in name -no space should be given */

		while(i<length)
		{
			if(urlStr.charAt(i)==\" \")
			{
				Checkurl3 =1;
			}
			if(urlStr.charAt(i)==\"@\")
			{
				Checkurl4 =1;
			}
			i++;
		}
		if(Checkurl3==1)
		{
			Checkurl=1;
			alert('Spaces not allowed in url');
		}
		if(Checkurl4==1)
		{
			Checkurl=1;
			alert('URL seems to be invalid contains @');
		}
		var j=1;
		while((j<length)&&(urlStr.charAt(i)!=\".\"))
		{
			j++;
		}
		if(j>=64)
		{
			Checkurl =1;
			alert('Only 64 characters between dots');
		}
		if((Checkurl==0)&&(Checkurl2==0))
		{
			document.httpdoc.buttonval.value = 'addurl';
			document.httpdoc.submit();
		}
	}

	function submiturlcat()
	{
		document.httpdoc.buttonval.value = 'urlcat';
		document.httpdoc.submit();
	}

	function submitbypass()
	{
		document.httpdoc.buttonval.value = 'bypass';
		document.httpdoc.submit();
	}
	
	function submitstdis()
	{
		document.httpdoc.buttonval.value = 'stdis';
		document.httpdoc.submit();
	}
	function submitauthen()
	{
		document.httpdoc.buttonval.value = 'authen';
		document.httpdoc.submit();
	}
	function submitauthdis()
	{
		document.httpdoc.buttonval.value = 'authdis';
		document.httpdoc.submit();
	}
	function submittransen()
	{
		document.httpdoc.buttonval.value = 'transen';
		document.httpdoc.submit();
	}	
	function submittransdis()
	{
		document.httpdoc.buttonval.value = 'transdis';
		document.httpdoc.submit();
	}
	function submiturlen()
	{
		document.httpdoc.buttonval.value = 'urlen';
		document.httpdoc.submit();
	}
	
	function submitjsdis()
	{
		document.httpdoc.buttonval.value = 'jsdis';
		document.httpdoc.submit();
	}
	
	function submitcodis()
	{
		document.httpdoc.buttonval.value = 'codis';
		document.httpdoc.submit();
	}
	
	function submitbndis()
	{
		document.httpdoc.buttonval.value = 'bndis';
		document.httpdoc.submit();
	}
	function submittransadd()
	{
		document.httpdoc.buttonval.value = 'transadd';
		document.httpdoc.submit();
	}
	function submittransdel()
	{
		document.httpdoc.buttonval.value = 'transdel';
		if(document.httpdoc.select_http_trans_allowed_networks.selectedIndex < 0 )
		{
			alert('select a network to delete');
		}
		else
		{
			document.httpdoc.submit();
		}
	}
	function submitnontransadd()
	{
		document.httpdoc.buttonval.value = 'nontransadd';
		document.httpdoc.submit();
	}
	function submitnontransdel()
	{
		document.httpdoc.buttonval.value = 'nontransdel';
		if(document.httpdoc.select_http_nontrans_allowed_networks.selectedIndex < 0 )
		{
			alert('select a network to delete');
		}
		else
		{
			document.httpdoc.submit();
		}
	}
	function submitusradd()
	{
		document.httpdoc.buttonval.value = 'usradd';
		if(document.httpdoc.http_not_allowed_users.selectedIndex < 0 )
		{
			alert('Select a user to Add');
		}
		else
		{
			document.httpdoc.adduser.disabled = true;
			document.httpdoc.deleteuser.disabled = true;
			document.httpdoc.submit();
		}
	}
	function submitusrdel()
	{
		document.httpdoc.buttonval.value = 'usrdel';
		if(document.httpdoc.http_users.selectedIndex < 0 )
		{
			alert('select a user to delete');
		}
		else
		{
			document.httpdoc.adduser.disabled = true;
			document.httpdoc.deleteuser.disabled = true;
			document.httpdoc.submit();
		}
	}
	function submitauthadd()
	{
		document.httpdoc.buttonval.value = 'authadd';
		document.httpdoc.submit();
	}
	function submitauthdel()
	{
		document.httpdoc.buttonval.value = 'authdel';
		document.httpdoc.submit();
	}
	function submitaddgroup()
	{
		document.httpdoc.buttonval.value = 'addgroup';
		document.httpdoc.submit();
	}
	function transpage()
	{
		document.httpdoc.buttonval.value = 'transpage';
		document.httpdoc.submit();
	}
	function nontranspage()
	{
		document.httpdoc.buttonval.value = 'nontranspage';
		document.httpdoc.submit();
	}
	</script>";

	if ($url_error == 0)
		print("<!--");
	print("<SCRIPT = \"javascript\">\n ");
	print("javascript:alert('Activate url categorization with a valid serial number to enable url filtering')");
	print("</SCRIPT>\n");

	if ($url_error == 0)
		print("-->");


	/*Calling script to get the values of the config parmeters and assigning the values obtained in the array to the variables*/

	exec("sudo /etc/multiconf/scripts/http httpdisplay", $DisplayOutput, $displayreturn);
	if ($displayreturn == 0)
	{
		$status = $DisplayOutput[0];
		$trans_status = $DisplayOutput[1];
		$auth_status = $DisplayOutput[2];
		$js_status = $DisplayOutput[3];
		$cookie_status = $DisplayOutput[4];
		$banner_status = $DisplayOutput[5];
	}



print_head_with_form("HTTP Proxy","httpdoc","httpproxy.php?op=proxyform",'',$java_script,2,0,"html/httpprox.html");



begin_table("100%");

	/*If status is apllowed display disable option else display enable option*/

if (strcmp($status, "ON") == 0)
{
	print_heading("HTTP Proxy","50%");
        print "<TD class=\"normal\" colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=center valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

	print_label("Status","40%");
	print "<TD width=\"40%\"> ";
	print "<input type=\"checkbox\" class=\"check\" name=httpstatchbox checked> ";
	print "</TD>";
	print "<TD width=\"20%\"> ";
	print "<input type=button class=\"button1\" name=http_status value=\" Save  \" onClick=\"submitstdis();\" > \n";
	print "</TD>";

	//	If auth is off,  display trans status
	if (strcmp($auth_status, "ON" ) != 0)
	{
		//	If trans is ON display disable option else display enable option
		close_open_tr();
		print_label("Transparent","40%");
		if (strcmp($trans_status, "ON") == 0)
		{
			print "<TD width=\"40%\"> ";
			print "<input type=\"checkbox\" class=\"check\" name=transchbox checked>";
			print "</TD>";
			print "<TD width=\"20%\"> ";
			print "<input type=button class=\"button1\" name=trans_status value=\" Save  \" onClick=\"submittransdis();\" > \n";
			print "</TD>";

		}
		else
		{
			print "<TD width=\"40%\"> ";
			print "<input type=\"checkbox\" class=\"check\" name=transchbox >";
			print "</TD>";
			print "<TD width=\"20%\"> ";
			print "<input type=button class=\"button1\" name=trans_status value=\" Save  \" onClick=\"submittransdis();\" > \n";
			print "</TD>";
		}
	}

	close_open_tr();
	print_label("Networks (allowed / denied)","80%","left",2);
	print "<TD width=\"20%\"> ";
	if (strcmp($trans_status, "ON") == 0)
	{
		print "<input type=button class=\"button1\" name=trans_save value=\"  Edit   \" onClick=\"transpage();\">\n";
	}
	else
	{
		print "<input type=button class=\"button1\" name=nontrans_save value=\"  Edit   \" onClick=\"nontranspage();\"> \n";
	}
	print "</TD>";
		
	close_open_tr();
	print_label("Banner Filter","40%");
	print "<TD width=\"40%\">\n";
	if (strcmp($banner_status, "ON") == 0)
	{
		print "<input type=\"checkbox\" name=bannerchbox checked> ";
	}
	else
	{
		print "<input type=\"checkbox\" name=bannerchbox> ";
	}
	print "</TD>";
	print "<TD width=\"20%\"> \n";
	print "<input type=button class=\"button1\" name=banner value=\" Save  \" onClick=\"submitbndis();\">";
	print "</TD>\n";

	close_open_tr();
	print_label("Java Script Filter","40%");
	print "<TD width=\"40%\">\n";
	if (strcmp($js_status, "ON") == 0)
	{
		print "<input type=\"checkbox\" name=javachbox checked>";
	}
	else
	{
		print "<input type=\"checkbox\" name=javachbox>\n";
	}
	print "</TD>";
	print "<TD width=\"20%\"> \n";
	print "<input type=button class=\"button1\" name=javascript value=\" Save  \" onClick=\"submitjsdis();\" >";
	print "</TD>";

	close_open_tr();
	print_label("Cookie Filter","40%");
	print "<TD width=\"40%\">\n";
	if (strcmp($cookie_status, "ON") == 0)
	{
		print "<input type=\"checkbox\" name=cookchbox checked> \n";
	}
	else
	{
		print "<input type=\"checkbox\" name=cookchbox>";
	}
	print "</TD>";
	print "<TD width=\"20%\"> \n";
	print "<input type=button class=\"button1\" name=cookie value=\" Save  \" onClick=\"submitcodis();\">\n";
	print "</TD>";

	end_blank_line();
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";

//right side
close_open_tr();
	
	print_heading("URL Categorization","50%");
        print "<TD class=\"normal\" colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=center valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

	exec("sudo /etc/multiconf/scripts/http SCStatus", $SCStatus, $return);
	if(strcmp($SCStatus[0],"enable")==0)
	{
		exec("sudo /etc/multiconf/scripts/http geturlstatus", $URLStatus, $return);
	
		print_label("URL Filter","40%");
		if(strcmp($URLStatus[0],"ON")==0)
		{
			print "<TD width=\"40%\"> \n";
			print "<input type=\"checkbox\" name=urlchkbox checked> ";
			print "</TD>";
			print "<TD width=\"20%\"> \n";
			print "<input type=button class=\"button1\" name=urlenable value=\" Save  \" onClick=\"submiturlen();\"> ";
			print "</TD>";

			close_open_tr();
			print_label("URL Categories (allowed / filtered)","80%","left",2);
			print "<TD width=\"20%\"> \n";
			print "<input type=button class=\"button1\" name=urlcategories value=\"  Edit   \" onClick=\"submiturlcat();\">\n";
			print "</TD>";

			close_open_tr();
			print_label("Networks / Hosts to bypass URL Filtering","80%","left",2);
			print "<TD width=\"20%\"> \n";
			print "<input type=button class=\"button1\" name=urlcategories value=\"  Edit   \" onClick=\"submitbypass();\" >\n";
			print "</TD>";
		}
		else
		{
			print "<TD width=\"40%\"> \n";
			print "<input type=\"checkbox\" name=urlchkbox>\n"; 
			print "</TD>";
			print "<TD width=\"20%\"> \n";
			print "<input type=button class=\"button1\" name=urlenable value=\" Save  \" onClick=\"submiturlen();\">\n";
			print "</TD>";
		}
	}
	else
	{
		print "<TD width=\"100%\" colspan=3> \n";
		print "<font class=normalblue> URL Filtering is not available. Enter a valid license key for the categorization engine in Administration -> License key page and activate it.</font>";
		print "</TD>";
	}
	
	end_blank_line();
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";

	//	If tran is on, user authentication option is not displayed

	if (strcmp($trans_status, "ON") != 0)
	{
		close_open_tr();
		print_heading("Authentication","50%");
        	print "<TD class=\"normal\" colSpan=2>";
	        open_table_with_tr("100%",1,"#336799");
        	print "<TD align=center valign=\"top\" width=\"100%\">";
	        open_table_with_tr("100%");

        	start_blank_line();

		print_label("User Authentication","40%");
		if (strcmp($auth_status, "ON") == 0)
		{
			print "<TD width=\"40%\">";
			print "<input type=\"checkbox\" name=authchbox checked>\n";
			print "</TD>";
			print "<TD width=\"20%\">";
			print "<input type=button class=\"button1\" name=authentication value=\" Save  \" onClick=\"submitauthen();\" > ";
			print "</TD>";

			//	Calling script to display authentication types
			exec("sudo /etc/multiconf/scripts/dispsquid", $AllauthOutput, $return);
			$i = 0;
			$index = 0;
			while(isset($AllauthOutput[$i]))
			{
				if (strcmp($AllauthOutput[$i], "yes") == 0)
				{
					if ($i == 0)
						$http_used_auth[$index] = "local";
					else if ($i == 1)
						$http_used_auth[$index] = "radius";
					else if ($i == 2)
						$http_used_auth[$index] = "sam";

					$http_used_auth[$i] = chop($http_used_auth[$i]);
					$index++;
				}
				$i++;
			}

			close_open_tr();
			print_label("Authentication Types","40%");
			print "<TD width=\"40%\">";
			print "<select class=\"selectinput\" name=\"http_not_used_auth\">";
			for ($m =1;$m < 4 ;$m++)
			{
				print("<OPTION VALUE=\"$AuthenticationName[$m]\" ");
				if (strcmp($http_used_auth[0], $AuthenticationName[$m]) == 0)
				{
					print("SELECTED");
				}
				print(">{$AuthenticationName[$m]}\n");
			}
			print "</select>";
			print "</TD>";
			print "<TD width=\"20%\">";
			print "<input type=button class=\"button1\" name=add_authentication value= \" Save  \" onClick=\"submitauthadd();\"> ";
			print "</TD>";
//-----------------
//			close_open_tr(30);
			draw_line();
        		print "<TD align=center valign=\"top\" width=\"100%\" colspan=3>";
		        open_table_with_tr("100%");

			print_label_bold("Available Users","35%","right");
			print_label_bold("Action","30%","center");
			print_label_bold("Allowed Users","35%","left");
			
			close_open_tr();
			print "<TD width=\"35%\" align=\"right\">";
			print "<select class=\"selectinput\" name=\"http_not_allowed_users\" size=4>";
			for ($m =0;$m < $total_users;$m++)
			{
				$http_flag = 0;
				for($j = 0; $j < $total_http_users; $j++)
				{
					if (strcmp($user[$m], $httpuser[$j]) == 0)
					{
						$http_flag = 1;
						break;
					}
					else
						$http_flag = 0;
				}
				if ($http_flag == 0)
				{
					print("<OPTION VALUE=\"$user[$m]\" ");
					print(">{$user[$m]}\n");
					$http_flag = 1;
				}
			}
			print "</select>";
			print "</TD>";
			print "<TD width=\"30%\" align=\"center\">";
			print "<input type=button class=\"button1\" name=adduser value=\"   Add >>  \" onClick=\"submitusradd();\" > ";
			print "<BR><BR><input type=button class=\"button1\" name=deleteuser value=\"<< Delete\" onClick=\"submitusrdel();\" > ";
			print "</TD>";

			print "<TD width=\"35%\" align=\"left\">";
			print "<select class=\"selectinput\" name=\"http_users\" size=4>";
			for ($m =0;$m < $total_http_users ;$m++)
			{
				print("<OPTION VALUE=\"$httpuser[$m]\" ");
				print(">{$httpuser[$m]}\n");
			}
			print "</select>";
			print "</TD>";
		        close_table_with_tr();
	        	print "</TD>";
//------------------------------------
			
		}
		else
		{
			print "<TD width=\"40%\">";
			print "<input type=\"checkbox\" name=authchbox>\n";
			print "</TD>";
			print "<TD width=\"20%\">";
			print "<input type=button class=\"button1\" name=authentication value=\" Save  \" onClick=\"submitauthen();\">\n";
			print "</TD>";
		}
		end_blank_line();
	        close_table_with_tr();
        	print "</TD>";
	        close_table_with_tr();
        	print "</TD>";
	}
}
else
{
	print_heading("HTTP Proxy","25%");
        print "<TD class=\"normal\" colSpan=2>";
        open_table_with_tr("100%",1,"#336799");
        print "<TD align=center valign=\"top\" width=\"100%\">";
        open_table_with_tr("100%");

        start_blank_line();

	print_label("Status","40%");
	print "<TD width=\"40%\">";
	print "<input type=\"checkbox\" class=\"check\" name=httpstatchbox>";
       	print "</TD>";
	print "<TD width=\"20%\">";
	print "<input type=button class=\"button1\" name=http_status value=\" Save  \" onClick=\"submitstdis();\">\n";
       	print "</TD>";

	end_blank_line();
        close_table_with_tr();
        print "</TD>";
        close_table_with_tr();
        print "</TD>";
}	

end_table();
print_foot_with_form();

	session_unregister("url_error");
}
/*To enable the abort*/
ignore_user_abort(FALSE);
?>
