
Modem Qualification
===================
Confirms that the make, model, and firmware of the currently connected
device qualifies for the firmware update.


AT+GMM
---------
Match cellular module model.


*Modem:*
```
[0:00:01.001338] [sent] AT+GMM<CR>
[0:00:01.008079] [rcvd] AT+GMM
[0:00:01.016156] [rcvd] <CR>
[0:00:01.016569] [rcvd] <CR><LF>
[0:00:01.016663] [rcvd] SARA-R410M-02B
[0:00:01.016869] [rcvd] <CR><LF>
[0:00:01.016928] [rcvd] <CR><LF>
[0:00:01.016994] [rcvd] OK
[0:00:01.017070] [rcvd] <CR><LF>
```

AT+GMR
------
Match basic firmware revision.


*Modem:*
```
[0:00:02.018621] [sent] AT+GMR<CR>
[0:00:02.019839] [rcvd] AT+GMR
[0:00:02.026616] [rcvd] <CR>
[0:00:02.026931] [rcvd] <CR><LF>
[0:00:02.027049] [rcvd] L0.0.00.00.05.12 [Mar 09 2022 17:00:00]
[0:00:02.027640] [rcvd] <CR><LF>
[0:00:02.027721] [rcvd] <CR><LF>
[0:00:02.027810] [rcvd] OK
[0:00:02.027913] [rcvd] <CR><LF>
```

FOTA FTP Download
=================
Download SARA-R410M-02B firmware delta from FTP server.

**Reference:**

*SARA-R4 series; Size-optimized LTE Cat M1 / NB1 / GPRS modules; AT commands manual; UBX-17003787; R22 28-Jun-2021


AT+UFTP=0
---------
Set FTP IP Address.


*Modem:*
```
[0:00:03.097614] [sent] AT+UFTP=0,"18.222.117.33"<CR>
[0:00:03.123206] [rcvd] AT+UFTP=0,"18.222.117.33"
[0:00:03.130864] [rcvd] <CR>
[0:00:03.131794] [rcvd] <CR><LF>
[0:00:03.131927] [rcvd] OK
[0:00:03.132058] [rcvd] <CR><LF>
```

AT+UFTP=2
---------
Set FTP Username


*Modem:*
```
[0:00:04.133709] [sent] AT+UFTP=2,"ftpuser"<CR>
[0:00:04.152887] [rcvd] AT+UFTP=2,"ftpuser"
[0:00:04.161132] [rcvd] <CR>
[0:00:04.161391] [rcvd] <CR><LF>
[0:00:04.161546] [rcvd] OK
[0:00:04.161687] [rcvd] <CR><LF>
```

AT+UFTP=3
---------
Set FTP Password


*Modem:*
```
[0:00:05.163341] [sent] AT+UFTP=3,"fuertyahghansrsyt6zgs6nba5a"<CR>
[0:00:05.206800] [rcvd] AT+UFTP=3,"fuertyahghansrsyt6zgs6nba5a"
[0:00:05.215045] [rcvd] <CR>
[0:00:05.215356] [rcvd] <CR><LF>
[0:00:05.215468] [rcvd] OK
[0:00:05.215593] [rcvd] <CR><LF>
```

AT+UFTP=5
---------
Set FTP Timeout in seconds.


*Modem:*
```
[0:00:06.217249] [sent] AT+UFTP=5,10<CR>
[0:00:06.230072] [rcvd] AT+UFTP=5,10
[0:00:06.238330] [rcvd] <CR>
[0:00:06.238762] [rcvd] <CR><LF>
[0:00:06.238870] [rcvd] OK
[0:00:06.238996] [rcvd] <CR><LF>
```

AT+UFTP=6
---------
Set FTP mode 0 - Active, 1 - Passive.


*Modem:*
```
[0:00:07.240638] [sent] AT+UFTP=6,1<CR>
[0:00:07.247967] [rcvd] AT+UFTP=6,1
[0:00:07.256188] [rcvd] <CR>
[0:00:07.256490] [rcvd] <CR><LF>
[0:00:07.256599] [rcvd] OK
[0:00:07.256723] [rcvd] <CR><LF>
```

AT+UFTP=7
---------
Set FTP Port.


*Modem:*
```
[0:00:08.257539] [sent] AT+UFTP=7,21<CR>
[0:00:08.270191] [rcvd] AT+UFTP=7,21
[0:00:08.278540] [rcvd] <CR>
[0:00:08.278817] [rcvd] <CR><LF>
[0:00:08.278915] [rcvd] OK
[0:00:08.279026] [rcvd] <CR><LF>
```

AT+UFTP=8
---------
Set FTP to use unencrypted connection.


*Modem:*
```
[0:00:09.280632] [sent] AT+UFTP=8,0<CR>
[0:00:09.288017] [rcvd] AT+UFTP=8,0
[0:00:09.296168] [rcvd] <CR>
[0:00:09.296463] [rcvd] <CR><LF>
[0:00:09.296570] [rcvd] OK
[0:00:09.296695] [rcvd] <CR><LF>
```

AT+UFTPC=1
----------
Connect and log in to FTP server. URC `+UUFTPCR: 1,1` indicates success.


*Modem:*
```
[0:00:10.297641] [sent] AT+UFTPC=1<CR>
[0:00:10.310081] [rcvd] AT+UFTPC=1
[0:00:10.312633] [rcvd] <CR>
[0:00:10.313584] [rcvd] <CR><LF>
[0:00:10.313729] [rcvd] OK
[0:00:10.313866] [rcvd] <CR><LF>
[0:00:10.313958] [rcvd] <CR><LF>
[0:00:11.215693] [rcvd] +UUFTPCR: 1,1
[0:00:11.215805] [rcvd] <CR><LF>
```

AT+UFTPC=100
------------
Download firmware file.


*Modem:*
```
[0:00:12.217244] [sent] AT+UFTPC=100,"delta.1564731429.upd"<CR>
[0:00:12.255034] [rcvd] AT+UFTPC=100,"delta.1564731429.upd"
[0:00:12.263080] [rcvd] <CR>
[0:00:19.267530] [rcvd] <CR><LF>
[0:00:19.267686] [rcvd] OK
[0:00:19.267818] [rcvd] <CR><LF>
```

URC
----
Wait for URC `+UUFTPCR: 100, 1` indicating success.


*Modem:*
```
[0:00:19.268432] [rcvd] <CR><LF>
[0:00:20.366742] [rcvd] +UUFTPCR: 100, 2048 / 6052230
[0:00:20.367259] [rcvd] <CR><LF>
[0:00:20.367346] [rcvd] <CR><LF>
[0:00:26.440735] [rcvd] +UUFTPCR: 100, 67584 / 6052230
[0:00:26.441272] [rcvd] <CR><LF>
[0:00:26.441361] [rcvd] <CR><LF>
[0:00:32.185960] [rcvd] +UUFTPCR: 100, 133120 / 6052230
[0:00:32.186488] [rcvd] <CR><LF>
[0:00:32.186576] [rcvd] <CR><LF>
[0:00:38.597698] [rcvd] +UUFTPCR: 100, 264192 / 6052230
[0:00:38.598254] [rcvd] <CR><LF>
[0:00:38.598367] [rcvd] <CR><LF>
[0:00:42.468204] [rcvd] +UUFTPCR: 100, 329728 / 6052230
[0:00:42.468730] [rcvd] <CR><LF>
[0:00:42.468817] [rcvd] <CR><LF>
[0:00:47.007719] [rcvd] +UUFTPCR: 100, 395264 / 6052230
[0:00:47.008286] [rcvd] <CR><LF>
[0:00:47.008379] [rcvd] <CR><LF>
[0:00:54.812728] [rcvd] +UUFTPCR: 100, 526336 / 6052230
[0:00:54.812964] [rcvd] <CR><LF>
[0:00:54.813004] [rcvd] <CR><LF>
[0:01:00.286770] [rcvd] +UUFTPCR: 100, 591872 / 6052230
[0:01:00.287428] [rcvd] <CR><LF>
[0:01:00.287519] [rcvd] <CR><LF>
[0:01:04.927980] [rcvd] +UUFTPCR: 100, 657408 / 6052230
[0:01:04.928517] [rcvd] <CR><LF>
[0:01:04.928609] [rcvd] <CR><LF>
[0:01:07.794038] [rcvd] +UUFTPCR: 100, 722944 / 6052230
[0:01:07.794576] [rcvd] <CR><LF>
[0:01:07.794667] [rcvd] <CR><LF>
[0:01:12.531340] [rcvd] +UUFTPCR: 100, 788480 / 6052230
[0:01:12.531560] [rcvd] <CR><LF>
[0:01:12.531597] [rcvd] <CR><LF>
[0:01:20.737574] [rcvd] +UUFTPCR: 100, 919552 / 6052230
[0:01:20.737794] [rcvd] <CR><LF>
[0:01:20.737832] [rcvd] <CR><LF>
[0:01:23.704977] [rcvd] +UUFTPCR: 100, 985088 / 6052230
[0:01:23.705544] [rcvd] <CR><LF>
[0:01:23.705641] [rcvd] <CR><LF>
[0:01:27.040777] [rcvd] +UUFTPCR: 100, 1050624 / 6052230
[0:01:27.041327] [rcvd] <CR><LF>
[0:01:27.041423] [rcvd] <CR><LF>
[0:01:32.715456] [rcvd] +UUFTPCR: 100, 1116160 / 6052230
[0:01:32.716021] [rcvd] <CR><LF>
[0:01:32.716109] [rcvd] <CR><LF>
[0:01:37.055957] [rcvd] +UUFTPCR: 100, 1181696 / 6052230
[0:01:37.056512] [rcvd] <CR><LF>
[0:01:37.056604] [rcvd] <CR><LF>
[0:01:40.120011] [rcvd] +UUFTPCR: 100, 1247232 / 6052230
[0:01:40.120564] [rcvd] <CR><LF>
[0:01:40.120657] [rcvd] <CR><LF>
[0:01:46.868835] [rcvd] +UUFTPCR: 100, 1312768 / 6052230
[0:01:46.869401] [rcvd] <CR><LF>
[0:01:46.869530] [rcvd] <CR><LF>
[0:01:50.743059] [rcvd] +UUFTPCR: 100, 1378304 / 6052230
[0:01:50.743621] [rcvd] <CR><LF>
[0:01:50.743712] [rcvd] <CR><LF>
[0:02:02.080771] [rcvd] +UUFTPCR: 100, 1574912 / 6052230
[0:02:02.081328] [rcvd] <CR><LF>
[0:02:02.081420] [rcvd] <CR><LF>
[0:02:06.757095] [rcvd] +UUFTPCR: 100, 1640448 / 6052230
[0:02:06.757695] [rcvd] <CR><LF>
[0:02:06.757788] [rcvd] <CR><LF>
[0:02:18.099973] [rcvd] +UUFTPCR: 100, 1837056 / 6052230
[0:02:18.100538] [rcvd] <CR><LF>
[0:02:18.100633] [rcvd] <CR><LF>
[0:02:20.563760] [rcvd] +UUFTPCR: 100, 1902592 / 6052230
[0:02:20.564294] [rcvd] <CR><LF>
[0:02:20.564425] [rcvd] <CR><LF>
[0:02:25.196983] [rcvd] +UUFTPCR: 100, 1968128 / 6052230
[0:02:25.197577] [rcvd] <CR><LF>
[0:02:25.197670] [rcvd] <CR><LF>
[0:02:29.869897] [rcvd] +UUFTPCR: 100, 2033664 / 6052230
[0:02:29.870444] [rcvd] <CR><LF>
[0:02:29.870566] [rcvd] <CR><LF>
[0:02:36.772677] [rcvd] +UUFTPCR: 100, 2164736 / 6052230
[0:02:36.773219] [rcvd] <CR><LF>
[0:02:36.773308] [rcvd] <CR><LF>
[0:02:41.516019] [rcvd] +UUFTPCR: 100, 2230272 / 6052230
[0:02:41.516555] [rcvd] <CR><LF>
[0:02:41.516641] [rcvd] <CR><LF>
[0:02:45.285772] [rcvd] +UUFTPCR: 100, 2295808 / 6052230
[0:02:45.286305] [rcvd] <CR><LF>
[0:02:45.286394] [rcvd] <CR><LF>
[0:02:58.128816] [rcvd] +UUFTPCR: 100, 2492416 / 6052230
[0:02:58.129354] [rcvd] <CR><LF>
[0:02:58.129502] [rcvd] <CR><LF>
[0:03:01.294111] [rcvd] +UUFTPCR: 100, 2557952 / 6052230
[0:03:01.294667] [rcvd] <CR><LF>
[0:03:01.294755] [rcvd] <CR><LF>
[0:03:13.230565] [rcvd] +UUFTPCR: 100, 2754560 / 6052230
[0:03:13.231085] [rcvd] <CR><LF>
[0:03:13.231177] [rcvd] <CR><LF>
[0:03:16.298684] [rcvd] +UUFTPCR: 100, 2820096 / 6052230
[0:03:16.299222] [rcvd] <CR><LF>
[0:03:16.299343] [rcvd] <CR><LF>
[0:03:19.534836] [rcvd] +UUFTPCR: 100, 2885632 / 6052230
[0:03:19.535377] [rcvd] <CR><LF>
[0:03:19.535467] [rcvd] <CR><LF>
[0:03:30.248119] [rcvd] +UUFTPCR: 100, 3016704 / 6052230
[0:03:30.248662] [rcvd] <CR><LF>
[0:03:30.248751] [rcvd] <CR><LF>
[0:03:35.020078] [rcvd] +UUFTPCR: 100, 3082240 / 6052230
[0:03:35.020609] [rcvd] <CR><LF>
[0:03:35.020700] [rcvd] <CR><LF>
[0:03:39.658063] [rcvd] +UUFTPCR: 100, 3147776 / 6052230
[0:03:39.658628] [rcvd] <CR><LF>
[0:03:39.658718] [rcvd] <CR><LF>
[0:03:45.259936] [rcvd] +UUFTPCR: 100, 3278848 / 6052230
[0:03:45.260472] [rcvd] <CR><LF>
[0:03:45.260563] [rcvd] <CR><LF>
[0:03:53.065880] [rcvd] +UUFTPCR: 100, 3409920 / 6052230
[0:03:53.066404] [rcvd] <CR><LF>
[0:03:53.066492] [rcvd] <CR><LF>
[0:03:55.833395] [rcvd] +UUFTPCR: 100, 3475456 / 6052230
[0:03:55.833989] [rcvd] <CR><LF>
[0:03:55.834111] [rcvd] <CR><LF>
[0:03:58.466806] [rcvd] +UUFTPCR: 100, 3540992 / 6052230
[0:03:58.467025] [rcvd] <CR><LF>
[0:03:58.467062] [rcvd] <CR><LF>
[0:04:02.432771] [rcvd] +UUFTPCR: 100, 3606528 / 6052230
[0:04:02.433305] [rcvd] <CR><LF>
[0:04:02.433396] [rcvd] <CR><LF>
[0:04:06.767470] [rcvd] +UUFTPCR: 100, 3672064 / 6052230
[0:04:06.767689] [rcvd] <CR><LF>
[0:04:06.767725] [rcvd] <CR><LF>
[0:04:11.136132] [rcvd] +UUFTPCR: 100, 3737600 / 6052230
[0:04:11.136700] [rcvd] <CR><LF>
[0:04:11.136791] [rcvd] <CR><LF>
[0:04:26.540992] [rcvd] +UUFTPCR: 100, 3999744 / 6052230
[0:04:26.541577] [rcvd] <CR><LF>
[0:04:26.541675] [rcvd] <CR><LF>
[0:04:38.175213] [rcvd] +UUFTPCR: 100, 4196352 / 6052230
[0:04:38.175768] [rcvd] <CR><LF>
[0:04:38.175856] [rcvd] <CR><LF>
[0:04:54.788898] [rcvd] +UUFTPCR: 100, 4458496 / 6052230
[0:04:54.789440] [rcvd] <CR><LF>
[0:04:54.789601] [rcvd] <CR><LF>
[0:04:57.853043] [rcvd] +UUFTPCR: 100, 4524032 / 6052230
[0:04:57.853620] [rcvd] <CR><LF>
[0:04:57.853710] [rcvd] <CR><LF>
[0:05:07.863947] [rcvd] +UUFTPCR: 100, 4655104 / 6052230
[0:05:07.864465] [rcvd] <CR><LF>
[0:05:07.864554] [rcvd] <CR><LF>
[0:05:12.098808] [rcvd] +UUFTPCR: 100, 4720640 / 6052230
[0:05:12.099069] [rcvd] <CR><LF>
[0:05:12.099114] [rcvd] <CR><LF>
[0:05:14.764631] [rcvd] +UUFTPCR: 100, 4786176 / 6052230
[0:05:14.765191] [rcvd] <CR><LF>
[0:05:14.765284] [rcvd] <CR><LF>
[0:05:22.466755] [rcvd] +UUFTPCR: 100, 4917248 / 6052230
[0:05:22.467279] [rcvd] <CR><LF>
[0:05:22.467365] [rcvd] <CR><LF>
[0:05:36.107862] [rcvd] +UUFTPCR: 100, 5113856 / 6052230
[0:05:36.108398] [rcvd] <CR><LF>
[0:05:36.108513] [rcvd] <CR><LF>
[0:05:40.375778] [rcvd] +UUFTPCR: 100, 5179392 / 6052230
[0:05:40.376101] [rcvd] <CR><LF>
[0:05:40.376155] [rcvd] <CR><LF>
[0:05:44.007284] [rcvd] +UUFTPCR: 100, 5244928 / 6052230
[0:05:44.007819] [rcvd] <CR><LF>
[0:05:44.007908] [rcvd] <CR><LF>
[0:05:47.975889] [rcvd] +UUFTPCR: 100, 5310464 / 6052230
[0:05:47.976435] [rcvd] <CR><LF>
[0:05:47.976522] [rcvd] <CR><LF>
[0:05:51.207915] [rcvd] +UUFTPCR: 100, 5376000 / 6052230
[0:05:51.208448] [rcvd] <CR><LF>
[0:05:51.208534] [rcvd] <CR><LF>
[0:05:53.868417] [rcvd] +UUFTPCR: 100, 5441536 / 6052230
[0:05:53.868654] [rcvd] <CR><LF>
[0:05:53.868706] [rcvd] <CR><LF>
[0:05:58.604382] [rcvd] +UUFTPCR: 100, 5507072 / 6052230
[0:05:58.604913] [rcvd] <CR><LF>
[0:05:58.605033] [rcvd] <CR><LF>
[0:06:05.179954] [rcvd] +UUFTPCR: 100, 5572608 / 6052230
[0:06:05.180501] [rcvd] <CR><LF>
[0:06:05.180591] [rcvd] <CR><LF>
[0:06:15.188672] [rcvd] +UUFTPCR: 100, 5703680 / 6052230
[0:06:15.188916] [rcvd] <CR><LF>
[0:06:15.188958] [rcvd] <CR><LF>
[0:06:20.627089] [rcvd] +UUFTPCR: 100, 5769216 / 6052230
[0:06:20.627631] [rcvd] <CR><LF>
[0:06:20.627720] [rcvd] <CR><LF>
[0:06:28.128920] [rcvd] +UUFTPCR: 100, 5900288 / 6052230
[0:06:28.129435] [rcvd] <CR><LF>
[0:06:28.129564] [rcvd] <CR><LF>
[0:06:39.140911] [rcvd] +UUFTPCR: 100, 6031360 / 6052230
[0:06:39.141453] [rcvd] <CR><LF>
[0:06:39.141580] [rcvd] <CR><LF>
[0:06:40.242496] [rcvd] +UUFTPCR: 100, 1
[0:06:40.242831] [rcvd] <CR><LF>
```

AT+UFTPC=0
----------
Log out and disconnect from FTP server. URC `+UUFTPCR: 0,1` indicates success.


*Modem:*
```
[0:06:41.247492] [sent] AT+UFTPC=0<CR>
[0:06:41.254826] [rcvd] AT+UFTPC=0
[0:06:41.263400] [rcvd] <CR>
[0:06:41.263720] [rcvd] <CR><LF>
[0:06:41.263834] [rcvd] OK
[0:06:41.263960] [rcvd] <CR><LF>
[0:06:41.264046] [rcvd] <CR><LF>
[0:06:41.437716] [rcvd] +UUFTPCR: 0,1
[0:06:41.438012] [rcvd] <CR><LF>
```

Install Firmware Delta (USB)
=======================================
Install delta firmware on USB variant of SARA-R410M-02B.

**Reference:**

*SARA-R4 series; Size-optimized LTE Cat M1 / NB1 / GPRS modules; AT commands manual; UBX-17003787; R22 28-Jun-2021

AT+UFWINSTALL
-------------
Perform firmware update. Do not remove power during update.

*Modem:*
```
[0:06:42.521312] [sent] AT+UFWINSTALL<CR>
[0:06:42.534564] [rcvd] AT+UFWINSTALL
[0:06:42.542643] [rcvd] <CR>
[0:06:42.619545] [rcvd] <CR><LF>
[0:06:42.619616] [rcvd] OK
[0:06:42.619681] [rcvd] <CR><LF>
```

CLOSE
----------------
USB products only. Close the modem device file or COM port immediately
to make sure the OS assigns the same device file or COM port after
modem reboot cycle.


*Modem Function:*
```
[0:06:42.619983] [modem] [close] [close=True]
```

WAIT_EXIST_CYCLE
----------------
USB products only. Wait until device reboot cycle 1 of 1 completes or
time out after 35 minutes.


*Modem Function:*
```
[0:06:42.621144] [modem] [wait_exist_cycle] [wait_exist_cycle=True,timeout_sec=2100]
```

OPEN
----
USB products only. Reopen the modem.


*Modem Function:*
```
[0:28:27.474985] [modem] [open] [open=True]
```
AT
---
Wait 5 seconds and determine if modem still responds to AT.

*Modem:*
```
[0:28:32.482047] [sent] AT<CR>
[0:28:32.482415] [rcvd] AT
[0:28:32.484831] [rcvd] <CR>
[0:28:32.485377] [rcvd] <CR><LF>
[0:28:32.485539] [rcvd] OK
[0:28:32.485680] [rcvd] <CR><LF>
```
