
Modem Qualification
===================
Confirms that the make, model, and firmware of the currently connected
device qualifies for the firmware update.


AT+GMM
---------
Match cellular module model.


*Modem:*
```
[0:00:01.001331] [sent] AT+GMM<CR>
[0:00:01.008197] [rcvd] AT+GMM
[0:00:01.016092] [rcvd] <CR>
[0:00:01.016507] [rcvd] <CR><LF>
[0:00:01.016597] [rcvd] SARA-R410M-02B
[0:00:01.016792] [rcvd] <CR><LF>
[0:00:01.016848] [rcvd] <CR><LF>
[0:00:01.016912] [rcvd] OK
[0:00:01.016984] [rcvd] <CR><LF>
```

AT+GMR
------
Match basic firmware revision.


*Modem:*
```
[0:00:02.018478] [sent] AT+GMR<CR>
[0:00:02.019520] [rcvd] AT+GMR
[0:00:02.027636] [rcvd] <CR>
[0:00:02.027951] [rcvd] <CR><LF>
[0:00:02.028056] [rcvd] L0.0.00.00.05.12 [Oct 08 2020 15:00:01]
[0:00:02.028640] [rcvd] <CR><LF>
[0:00:02.028721] [rcvd] <CR><LF>
[0:00:02.028809] [rcvd] OK
[0:00:02.028907] [rcvd] <CR><LF>
```

FOTA FTP Download
=================
Download SARA-R410M-02B firmware delta from FTP server.

**Reference:**

*SARA-R4 series; Size-optimized LTE Cat M1 / NB1 / GPRS modules; AT commands manual; UBX-17003787; R22 28-Jun-2021


AT+UFTP=0
---------
Set FTP IP Address.


*Modem:*
```
[0:00:03.101665] [sent] AT+UFTP=0,"18.222.117.33"<CR>
[0:00:03.127149] [rcvd] AT+UFTP=0,"18.222.117.33"
[0:00:03.135658] [rcvd] <CR>
[0:00:03.136154] [rcvd] <CR><LF>
[0:00:03.136281] [rcvd] OK
[0:00:03.136412] [rcvd] <CR><LF>
```

AT+UFTP=2
---------
Set FTP Username


*Modem:*
```
[0:00:04.137789] [sent] AT+UFTP=2,"ftpuser"<CR>
[0:00:04.157024] [rcvd] AT+UFTP=2,"ftpuser"
[0:00:04.165242] [rcvd] <CR>
[0:00:04.165551] [rcvd] <CR><LF>
[0:00:04.165716] [rcvd] OK
[0:00:04.165869] [rcvd] <CR><LF>
```

AT+UFTP=3
---------
Set FTP Password


*Modem:*
```
[0:00:05.167557] [sent] AT+UFTP=3,"fuertyahghansrsyt6zgs6nba5a"<CR>
[0:00:05.210909] [rcvd] AT+UFTP=3,"fuertyahghansrsyt6zgs6nba5a"
[0:00:05.219612] [rcvd] <CR>
[0:00:05.219868] [rcvd] <CR><LF>
[0:00:05.219975] [rcvd] OK
[0:00:05.220096] [rcvd] <CR><LF>
```

AT+UFTP=5
---------
Set FTP Timeout in seconds.


*Modem:*
```
[0:00:06.221731] [sent] AT+UFTP=5,10<CR>
[0:00:06.234548] [rcvd] AT+UFTP=5,10
[0:00:06.242760] [rcvd] <CR>
[0:00:06.243218] [rcvd] <CR><LF>
[0:00:06.243330] [rcvd] OK
[0:00:06.243454] [rcvd] <CR><LF>
```

AT+UFTP=6
---------
Set FTP mode 0 - Active, 1 - Passive.


*Modem:*
```
[0:00:07.244415] [sent] AT+UFTP=6,1<CR>
[0:00:07.251918] [rcvd] AT+UFTP=6,1
[0:00:07.259443] [rcvd] <CR>
[0:00:07.259719] [rcvd] <CR><LF>
[0:00:07.259826] [rcvd] OK
[0:00:07.259948] [rcvd] <CR><LF>
```

AT+UFTP=7
---------
Set FTP Port.


*Modem:*
```
[0:00:08.261604] [sent] AT+UFTP=7,21<CR>
[0:00:08.274504] [rcvd] AT+UFTP=7,21
[0:00:08.282353] [rcvd] <CR>
[0:00:08.282631] [rcvd] <CR><LF>
[0:00:08.282739] [rcvd] OK
[0:00:08.282861] [rcvd] <CR><LF>
```

AT+UFTP=8
---------
Set FTP to use unencrypted connection.


*Modem:*
```
[0:00:09.284504] [sent] AT+UFTP=8,0<CR>
[0:00:09.291864] [rcvd] AT+UFTP=8,0
[0:00:09.300037] [rcvd] <CR>
[0:00:09.300361] [rcvd] <CR><LF>
[0:00:09.300473] [rcvd] OK
[0:00:09.300599] [rcvd] <CR><LF>
```

AT+UFTPC=1
----------
Connect and log in to FTP server. URC `+UUFTPCR: 1,1` indicates success.


*Modem:*
```
[0:00:10.302267] [sent] AT+UFTPC=1<CR>
[0:00:10.314737] [rcvd] AT+UFTPC=1
[0:00:10.317598] [rcvd] <CR>
[0:00:10.318641] [rcvd] <CR><LF>
[0:00:10.318774] [rcvd] OK
[0:00:10.318904] [rcvd] <CR><LF>
[0:00:10.318992] [rcvd] <CR><LF>
[0:00:11.216239] [rcvd] +UUFTPCR: 1,1
[0:00:11.216357] [rcvd] <CR><LF>
```

AT+UFTPC=100
------------
Download firmware file.


*Modem:*
```
[0:00:12.217852] [sent] AT+UFTPC=100,"delta.3625671199.upd"<CR>
[0:00:12.255258] [rcvd] AT+UFTPC=100,"delta.3625671199.upd"
[0:00:12.263274] [rcvd] <CR>
[0:00:20.500021] [rcvd] <CR><LF>
[0:00:20.500162] [rcvd] OK
[0:00:20.500293] [rcvd] <CR><LF>
```

URC
----
Wait for URC `+UUFTPCR: 100, 1` indicating success.


*Modem:*
```
[0:00:20.500904] [rcvd] <CR><LF>
[0:00:22.123086] [rcvd] +UUFTPCR: 100, 8192 / 6086792
[0:00:22.123597] [rcvd] <CR><LF>
[0:00:22.123685] [rcvd] <CR><LF>
[0:00:27.989398] [rcvd] +UUFTPCR: 100, 67584 / 6086792
[0:00:27.989619] [rcvd] <CR><LF>
[0:00:27.989659] [rcvd] <CR><LF>
[0:00:35.345369] [rcvd] +UUFTPCR: 100, 133120 / 6086792
[0:00:35.345938] [rcvd] <CR><LF>
[0:00:35.346029] [rcvd] <CR><LF>
[0:00:40.224319] [rcvd] +UUFTPCR: 100, 198656 / 6086792
[0:00:40.224875] [rcvd] <CR><LF>
[0:00:40.224968] [rcvd] <CR><LF>
[0:00:50.651245] [rcvd] +UUFTPCR: 100, 329728 / 6086792
[0:00:50.651779] [rcvd] <CR><LF>
[0:00:50.651873] [rcvd] <CR><LF>
[0:00:54.989005] [rcvd] +UUFTPCR: 100, 395264 / 6086792
[0:00:54.989542] [rcvd] <CR><LF>
[0:00:54.989662] [rcvd] <CR><LF>
[0:00:59.063223] [rcvd] +UUFTPCR: 100, 460800 / 6086792
[0:00:59.063755] [rcvd] <CR><LF>
[0:00:59.063872] [rcvd] <CR><LF>
[0:01:03.910174] [rcvd] +UUFTPCR: 100, 526336 / 6086792
[0:01:03.910831] [rcvd] <CR><LF>
[0:01:03.910922] [rcvd] <CR><LF>
[0:01:07.981056] [rcvd] +UUFTPCR: 100, 591872 / 6086792
[0:01:07.981589] [rcvd] <CR><LF>
[0:01:07.981718] [rcvd] <CR><LF>
[0:01:12.720377] [rcvd] +UUFTPCR: 100, 657408 / 6086792
[0:01:12.720908] [rcvd] <CR><LF>
[0:01:12.720999] [rcvd] <CR><LF>
[0:01:17.697322] [rcvd] +UUFTPCR: 100, 722944 / 6086792
[0:01:17.697880] [rcvd] <CR><LF>
[0:01:17.697974] [rcvd] <CR><LF>
[0:01:39.643118] [rcvd] +UUFTPCR: 100, 985088 / 6086792
[0:01:39.643652] [rcvd] <CR><LF>
[0:01:39.643742] [rcvd] <CR><LF>
[0:01:44.283579] [rcvd] +UUFTPCR: 100, 1050624 / 6086792
[0:01:44.284126] [rcvd] <CR><LF>
[0:01:44.284216] [rcvd] <CR><LF>
[0:01:57.269184] [rcvd] +UUFTPCR: 100, 1247232 / 6086792
[0:01:57.269790] [rcvd] <CR><LF>
[0:01:57.269890] [rcvd] <CR><LF>
[0:02:00.604253] [rcvd] +UUFTPCR: 100, 1312768 / 6086792
[0:02:00.604800] [rcvd] <CR><LF>
[0:02:00.604889] [rcvd] <CR><LF>
[0:02:03.769545] [rcvd] +UUFTPCR: 100, 1378304 / 6086792
[0:02:03.770127] [rcvd] <CR><LF>
[0:02:03.770218] [rcvd] <CR><LF>
[0:02:09.412450] [rcvd] +UUFTPCR: 100, 1443840 / 6086792
[0:02:09.412992] [rcvd] <CR><LF>
[0:02:09.413081] [rcvd] <CR><LF>
[0:02:14.087481] [rcvd] +UUFTPCR: 100, 1509376 / 6086792
[0:02:14.088063] [rcvd] <CR><LF>
[0:02:14.088157] [rcvd] <CR><LF>
[0:02:19.932143] [rcvd] +UUFTPCR: 100, 1574912 / 6086792
[0:02:19.932690] [rcvd] <CR><LF>
[0:02:19.932780] [rcvd] <CR><LF>
[0:02:24.604393] [rcvd] +UUFTPCR: 100, 1640448 / 6086792
[0:02:24.604939] [rcvd] <CR><LF>
[0:02:24.605027] [rcvd] <CR><LF>
[0:02:30.243566] [rcvd] +UUFTPCR: 100, 1705984 / 6086792
[0:02:30.244104] [rcvd] <CR><LF>
[0:02:30.244194] [rcvd] <CR><LF>
[0:02:38.531567] [rcvd] +UUFTPCR: 100, 1771520 / 6086792
[0:02:38.532135] [rcvd] <CR><LF>
[0:02:38.532259] [rcvd] <CR><LF>
[0:02:43.877313] [rcvd] +UUFTPCR: 100, 1837056 / 6086792
[0:02:43.877877] [rcvd] <CR><LF>
[0:02:43.877965] [rcvd] <CR><LF>
[0:02:48.954082] [rcvd] +UUFTPCR: 100, 1902592 / 6086792
[0:02:48.954355] [rcvd] <CR><LF>
[0:02:48.954402] [rcvd] <CR><LF>
[0:02:55.200206] [rcvd] +UUFTPCR: 100, 1968128 / 6086792
[0:02:55.200732] [rcvd] <CR><LF>
[0:02:55.200854] [rcvd] <CR><LF>
[0:02:59.170191] [rcvd] +UUFTPCR: 100, 2033664 / 6086792
[0:02:59.170723] [rcvd] <CR><LF>
[0:02:59.170811] [rcvd] <CR><LF>
[0:03:04.713365] [rcvd] +UUFTPCR: 100, 2099200 / 6086792
[0:03:04.713950] [rcvd] <CR><LF>
[0:03:04.714041] [rcvd] <CR><LF>
[0:03:09.889210] [rcvd] +UUFTPCR: 100, 2164736 / 6086792
[0:03:09.889747] [rcvd] <CR><LF>
[0:03:09.889865] [rcvd] <CR><LF>
[0:03:15.530415] [rcvd] +UUFTPCR: 100, 2230272 / 6086792
[0:03:15.530941] [rcvd] <CR><LF>
[0:03:15.531031] [rcvd] <CR><LF>
[0:03:19.803160] [rcvd] +UUFTPCR: 100, 2295808 / 6086792
[0:03:19.803397] [rcvd] <CR><LF>
[0:03:19.803436] [rcvd] <CR><LF>
[0:03:23.844640] [rcvd] +UUFTPCR: 100, 2361344 / 6086792
[0:03:23.845164] [rcvd] <CR><LF>
[0:03:23.845255] [rcvd] <CR><LF>
[0:03:29.518748] [rcvd] +UUFTPCR: 100, 2426880 / 6086792
[0:03:29.519273] [rcvd] <CR><LF>
[0:03:29.519393] [rcvd] <CR><LF>
[0:03:35.063493] [rcvd] +UUFTPCR: 100, 2492416 / 6086792
[0:03:35.064026] [rcvd] <CR><LF>
[0:03:35.064113] [rcvd] <CR><LF>
[0:03:40.948135] [rcvd] +UUFTPCR: 100, 2557952 / 6086792
[0:03:40.948361] [rcvd] <CR><LF>
[0:03:40.948400] [rcvd] <CR><LF>
[0:03:47.094592] [rcvd] +UUFTPCR: 100, 2623488 / 6086792
[0:03:47.095123] [rcvd] <CR><LF>
[0:03:47.095213] [rcvd] <CR><LF>
[0:03:55.807532] [rcvd] +UUFTPCR: 100, 2754560 / 6086792
[0:03:55.808096] [rcvd] <CR><LF>
[0:03:55.808183] [rcvd] <CR><LF>
[0:04:01.981395] [rcvd] +UUFTPCR: 100, 2820096 / 6086792
[0:04:01.981966] [rcvd] <CR><LF>
[0:04:01.982055] [rcvd] <CR><LF>
[0:04:06.722271] [rcvd] +UUFTPCR: 100, 2885632 / 6086792
[0:04:06.722808] [rcvd] <CR><LF>
[0:04:06.722896] [rcvd] <CR><LF>
[0:04:15.731347] [rcvd] +UUFTPCR: 100, 3016704 / 6086792
[0:04:15.731889] [rcvd] <CR><LF>
[0:04:15.732011] [rcvd] <CR><LF>
[0:04:20.602066] [rcvd] +UUFTPCR: 100, 3082240 / 6086792
[0:04:20.602601] [rcvd] <CR><LF>
[0:04:20.602691] [rcvd] <CR><LF>
[0:04:24.740437] [rcvd] +UUFTPCR: 100, 3147776 / 6086792
[0:04:24.740969] [rcvd] <CR><LF>
[0:04:24.741059] [rcvd] <CR><LF>
[0:04:29.310226] [rcvd] +UUFTPCR: 100, 3213312 / 6086792
[0:04:29.310762] [rcvd] <CR><LF>
[0:04:29.310848] [rcvd] <CR><LF>
[0:04:32.646227] [rcvd] +UUFTPCR: 100, 3278848 / 6086792
[0:04:32.646766] [rcvd] <CR><LF>
[0:04:32.646855] [rcvd] <CR><LF>
[0:04:38.316340] [rcvd] +UUFTPCR: 100, 3344384 / 6086792
[0:04:38.316866] [rcvd] <CR><LF>
[0:04:38.316953] [rcvd] <CR><LF>
[0:04:43.954466] [rcvd] +UUFTPCR: 100, 3409920 / 6086792
[0:04:43.954998] [rcvd] <CR><LF>
[0:04:43.955126] [rcvd] <CR><LF>
[0:04:48.528487] [rcvd] +UUFTPCR: 100, 3475456 / 6086792
[0:04:48.529022] [rcvd] <CR><LF>
[0:04:48.529141] [rcvd] <CR><LF>
[0:04:52.360493] [rcvd] +UUFTPCR: 100, 3540992 / 6086792
[0:04:52.361021] [rcvd] <CR><LF>
[0:04:52.361108] [rcvd] <CR><LF>
[0:04:55.725110] [rcvd] +UUFTPCR: 100, 3606528 / 6086792
[0:04:55.725324] [rcvd] <CR><LF>
[0:04:55.725362] [rcvd] <CR><LF>
[0:05:00.063461] [rcvd] +UUFTPCR: 100, 3672064 / 6086792
[0:05:00.063963] [rcvd] <CR><LF>
[0:05:00.064051] [rcvd] <CR><LF>
[0:05:04.130461] [rcvd] +UUFTPCR: 100, 3737600 / 6086792
[0:05:04.131023] [rcvd] <CR><LF>
[0:05:04.131117] [rcvd] <CR><LF>
[0:05:11.330114] [rcvd] +UUFTPCR: 100, 3868672 / 6086792
[0:05:11.330657] [rcvd] <CR><LF>
[0:05:11.330781] [rcvd] <CR><LF>
[0:05:18.828227] [rcvd] +UUFTPCR: 100, 3999744 / 6086792
[0:05:18.828730] [rcvd] <CR><LF>
[0:05:18.828817] [rcvd] <CR><LF>
[0:05:24.566471] [rcvd] +UUFTPCR: 100, 4065280 / 6086792
[0:05:24.566980] [rcvd] <CR><LF>
[0:05:24.567066] [rcvd] <CR><LF>
[0:05:28.838422] [rcvd] +UUFTPCR: 100, 4130816 / 6086792
[0:05:28.838661] [rcvd] <CR><LF>
[0:05:28.838703] [rcvd] <CR><LF>
[0:05:32.576209] [rcvd] +UUFTPCR: 100, 4196352 / 6086792
[0:05:32.576741] [rcvd] <CR><LF>
[0:05:32.576830] [rcvd] <CR><LF>
[0:05:43.291628] [rcvd] +UUFTPCR: 100, 4327424 / 6086792
[0:05:43.292166] [rcvd] <CR><LF>
[0:05:43.292256] [rcvd] <CR><LF>
[0:05:48.262279] [rcvd] +UUFTPCR: 100, 4392960 / 6086792
[0:05:48.262845] [rcvd] <CR><LF>
[0:05:48.262950] [rcvd] <CR><LF>
[0:05:52.399106] [rcvd] +UUFTPCR: 100, 4458496 / 6086792
[0:05:52.399630] [rcvd] <CR><LF>
[0:05:52.399718] [rcvd] <CR><LF>
[0:05:55.667454] [rcvd] +UUFTPCR: 100, 4524032 / 6086792
[0:05:55.667956] [rcvd] <CR><LF>
[0:05:55.668044] [rcvd] <CR><LF>
[0:06:00.405750] [rcvd] +UUFTPCR: 100, 4589568 / 6086792
[0:06:00.406270] [rcvd] <CR><LF>
[0:06:00.406358] [rcvd] <CR><LF>
[0:06:03.977069] [rcvd] +UUFTPCR: 100, 4655104 / 6086792
[0:06:03.977599] [rcvd] <CR><LF>
[0:06:03.977729] [rcvd] <CR><LF>
[0:06:14.188223] [rcvd] +UUFTPCR: 100, 4786176 / 6086792
[0:06:14.188752] [rcvd] <CR><LF>
[0:06:14.188841] [rcvd] <CR><LF>
[0:06:20.126371] [rcvd] +UUFTPCR: 100, 4851712 / 6086792
[0:06:20.126721] [rcvd] <CR><LF>
[0:06:20.126784] [rcvd] <CR><LF>
[0:06:22.989643] [rcvd] +UUFTPCR: 100, 4917248 / 6086792
[0:06:22.990174] [rcvd] <CR><LF>
[0:06:22.990298] [rcvd] <CR><LF>
[0:06:26.419966] [rcvd] +UUFTPCR: 100, 4982784 / 6086792
[0:06:26.420310] [rcvd] <CR><LF>
[0:06:26.420368] [rcvd] <CR><LF>
[0:06:35.224981] [rcvd] +UUFTPCR: 100, 5113856 / 6086792
[0:06:35.225520] [rcvd] <CR><LF>
[0:06:35.225640] [rcvd] <CR><LF>
[0:06:38.389975] [rcvd] +UUFTPCR: 100, 5179392 / 6086792
[0:06:38.390475] [rcvd] <CR><LF>
[0:06:38.390564] [rcvd] <CR><LF>
[0:06:55.645089] [rcvd] +UUFTPCR: 100, 5376000 / 6086792
[0:06:55.645649] [rcvd] <CR><LF>
[0:06:55.645748] [rcvd] <CR><LF>
[0:06:59.518385] [rcvd] +UUFTPCR: 100, 5441536 / 6086792
[0:06:59.518914] [rcvd] <CR><LF>
[0:06:59.519004] [rcvd] <CR><LF>
[0:07:06.420661] [rcvd] +UUFTPCR: 100, 5572608 / 6086792
[0:07:06.421195] [rcvd] <CR><LF>
[0:07:06.421282] [rcvd] <CR><LF>
[0:07:19.674533] [rcvd] +UUFTPCR: 100, 5769216 / 6086792
[0:07:19.675060] [rcvd] <CR><LF>
[0:07:19.675182] [rcvd] <CR><LF>
[0:07:23.647182] [rcvd] +UUFTPCR: 100, 5834752 / 6086792
[0:07:23.647712] [rcvd] <CR><LF>
[0:07:23.647800] [rcvd] <CR><LF>
[0:07:26.788148] [rcvd] +UUFTPCR: 100, 5900288 / 6086792
[0:07:26.788676] [rcvd] <CR><LF>
[0:07:26.788766] [rcvd] <CR><LF>
[0:07:30.958078] [rcvd] +UUFTPCR: 100, 5965824 / 6086792
[0:07:30.958602] [rcvd] <CR><LF>
[0:07:30.958719] [rcvd] <CR><LF>
[0:07:34.801078] [rcvd] +UUFTPCR: 100, 6031360 / 6086792
[0:07:34.801596] [rcvd] <CR><LF>
[0:07:34.801778] [rcvd] <CR><LF>
[0:07:38.395491] [rcvd] +UUFTPCR: 100, 1
[0:07:38.395837] [rcvd] <CR><LF>
```

AT+UFTPC=0
----------
Log out and disconnect from FTP server. URC `+UUFTPCR: 0,1` indicates success.


*Modem:*
```
[0:07:39.401015] [sent] AT+UFTPC=0<CR>
[0:07:39.408442] [rcvd] AT+UFTPC=0
[0:07:39.415059] [rcvd] <CR>
[0:07:39.415553] [rcvd] <CR><LF>
[0:07:39.415678] [rcvd] OK
[0:07:39.415806] [rcvd] <CR><LF>
[0:07:39.415896] [rcvd] <CR><LF>
[0:07:42.520563] [rcvd] +UUFTPCR: 0,1
[0:07:42.520872] [rcvd] <CR><LF>
```

Install Firmware Delta (USB)
=======================================
Install delta firmware on USB variant of SARA-R410M-02B.

**Reference:**

*SARA-R4 series; Size-optimized LTE Cat M1 / NB1 / GPRS modules; AT commands manual; UBX-17003787; R22 28-Jun-2021

AT+UFWINSTALL
-------------
Perform firmware update. Do not remove power during update.

*Modem:*
```
[0:07:43.611033] [sent] AT+UFWINSTALL<CR>
[0:07:43.624187] [rcvd] AT+UFWINSTALL
[0:07:43.632217] [rcvd] <CR>
[0:07:43.709093] [rcvd] <CR><LF>
[0:07:43.709156] [rcvd] OK
[0:07:43.709209] [rcvd] <CR><LF>
```

CLOSE
----------------
USB products only. Close the modem device file or COM port immediately
to make sure the OS assigns the same device file or COM port after
modem reboot cycle.


*Modem Function:*
```
[0:07:43.709463] [modem] [close] [close=True]
```

WAIT_EXIST_CYCLE
----------------
USB products only. Wait until device reboot cycle 1 of 1 completes or
time out after 35 minutes.


*Modem Function:*
```
[0:07:43.710501] [modem] [wait_exist_cycle] [wait_exist_cycle=True,timeout_sec=2100]
```

OPEN
----
USB products only. Reopen the modem.


*Modem Function:*
```
[0:28:06.948622] [modem] [open] [open=True]
```
AT
---
Wait 5 seconds and determine if modem still responds to AT.

*Modem:*
```
[0:28:11.953694] [sent] AT<CR>
[0:28:11.953894] [rcvd] AT
[0:28:11.956961] [rcvd] <CR>
[0:28:11.957470] [rcvd] <CR><LF>
[0:28:11.957532] [rcvd] OK
[0:28:11.957598] [rcvd] <CR><LF>
```
