SUMMARY = "Linux Bluetooth Stack Userland V5"
PR = "m4"
DESCRIPTION = "Linux Bluetooth stack V5 userland components.  These include a system configurations, daemons, tools and system libraries."
HOMEPAGE = "http://www.bluez.org"
SECTION = "libs"
LICENSE = "GPLv2+ & LGPLv2.1+"
LIC_FILES_CHKSUM = "file://COPYING;md5=12f884d2ae1ff87c09e5b7ccc2c4ca7e \
                    file://COPYING.LIB;md5=fb504b67c50331fc78734fed90fb0e09 \
                    file://src/main.c;beginline=1;endline=24;md5=9bc54b93cd7e17bf03f52513f39f926e"
DEPENDS = "udev libusb dbus-glib glib-2.0 libcheck readline"
RDEPENDS_${PN}-pand += "bash python-dbus python-logging python-syslog python-subprocess python-argparse"
RDEPENDS_${PN}-rfcomm += "bash python-pygobject python-syslog python-logging python-dbus"
PROVIDES += "bluez-hcidump"
RPROVIDES_${PN} += "bluez-hcidump"

RCONFLICTS_${PN} = "bluez4"

PACKAGECONFIG ??= "obex-profiles"
PACKAGECONFIG[obex-profiles] = "--enable-obex,--disable-obex,libical"
PACKAGECONFIG[experimental] = "--enable-experimental,--enable-experimental"

SRC_URI = "\
    ${KERNELORG_MIRROR}/linux/bluetooth/bluez-${PV}.tar.xz \
    file://out-of-tree.patch \
    file://init \
    file://run-ptest \
    ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', '', 'file://0001-Allow-using-obexd-without-systemd-in-the-user-sessio.patch', d)} \
    file://0001-tests-add-a-target-for-building-tests-without-runnin.patch \
    file://default \
    file://main.conf \
    file://bt-pan/init \
    file://bt-pan/default \
    file://bt-pan/bt-pan \
    file://rfcomm/rfcomm.py \
    file://rfcomm/init \
    file://rfcomm/default \
"
S = "${WORKDIR}/bluez-${PV}"

inherit autotools pkgconfig systemd update-rc.d distro_features_check ptest

EXTRA_OECONF = "\
  --enable-tools \
  --disable-cups \
  --enable-test \
  --enable-datafiles \
  ${@bb.utils.contains('DISTRO_FEATURES', 'systemd', '--enable-systemd', '--disable-systemd', d)} \
  --enable-library \
  --enable-deprecated \
  --enable-experimental \
"

# bluez5 builds a large number of useful utilities but does not
# install them.  Specify which ones we want put into ${PN}-noinst-tools.
NOINST_TOOLS_READLINE ??= ""
NOINST_TOOLS_EXPERIMENTAL ??= ""
NOINST_TOOLS = " \
    ${NOINST_TOOLS_READLINE} \
    ${@bb.utils.contains('PACKAGECONFIG', 'experimental', '${NOINST_TOOLS_EXPERIMENTAL}', '', d)} \
"

DBTEXEC = "${D}${libexecdir}/bluetooth/"

do_install_append() {
	install -d ${D}${INIT_D_DIR}
	install -m 0755 ${WORKDIR}/init ${D}${INIT_D_DIR}/bluetooth
	install -m 0755 ${WORKDIR}/bt-pan/init ${D}${INIT_D_DIR}/bt-pan
	install -m 0755 ${WORKDIR}/rfcomm/init ${D}${INIT_D_DIR}/rfcomm
	install -d ${DBTEXEC}
	install -m 0755 ${WORKDIR}/bt-pan/bt-pan ${DBTEXEC}
	install -m 0755 ${WORKDIR}/rfcomm/rfcomm.py ${DBTEXEC}/rfcomm

	install -d ${D}${sysconfdir}/bluetooth/
	if [ -f ${S}/profiles/audio/audio.conf ]; then
	    install -m 0644 ${S}/profiles/audio/audio.conf ${D}/${sysconfdir}/bluetooth/
	fi
	if [ -f ${S}/profiles/network/network.conf ]; then
	    install -m 0644 ${S}/profiles/network/network.conf ${D}/${sysconfdir}/bluetooth/
	fi
	if [ -f ${S}/profiles/input/input.conf ]; then
	    install -m 0644 ${S}/profiles/input/input.conf ${D}/${sysconfdir}/bluetooth/
	fi

        if [ -f ${D}/${sysconfdir}/init.d/bluetooth ]; then
            sed -i -e 's#@LIBEXECDIR@#${libexecdir}#g' ${D}/${sysconfdir}/init.d/bluetooth
        fi

	# Install desired tools that upstream leaves in build area
        for f in ${NOINST_TOOLS} ; do
	    install -m 755 ${B}/$f ${D}/${bindir}
	done

        # Patch python tools to use Python 3; they should be source compatible, but
        # still refer to Python 2 in the shebang
        sed -i -e '1s,#!.*python.*,#!${bindir}/python3,' ${D}${libdir}/bluez/test/*
        
        install -d ${D}${sysconfdir}/default
        install -m 0644 ${WORKDIR}/default ${D}${sysconfdir}/default/bluetooth
        install -m 0644 ${WORKDIR}/bt-pan/default ${D}${sysconfdir}/default/bt-pan
        install -m 0644 ${WORKDIR}/rfcomm/default ${D}${sysconfdir}/default/rfcomm
        install -m 0644 ${WORKDIR}/main.conf ${D}${sysconfdir}/bluetooth/
}

ALLOW_EMPTY_libasound-module-bluez = "1"
PACKAGES =+ "libasound-module-bluez ${PN}-testtools ${PN}-obex ${PN}-noinst-tools ${PN}-pand ${PN}-rfcomm"

FILES_libasound-module-bluez = "${libdir}/alsa-lib/lib*.so ${datadir}/alsa"
FILES_${PN} += "${libdir}/bluetooth/plugins/*.so ${systemd_unitdir}/ ${datadir}/dbus-1"
CONFFILES_${PN} += "${sysconfdir}/default/bluetooth ${sysconfdir}/bluetooth/main.conf ${sysconfdir}/bluetooth/input.conf ${sysconfdir}/bluetooth/network.conf"
FILES_${PN}-dev += "\
  ${libdir}/bluetooth/plugins/*.la \
  ${libdir}/alsa-lib/*.la \
"

FILES_${PN}-obex = "${libexecdir}/bluetooth/obexd \
                    ${exec_prefix}/lib/systemd/user/obex.service \
                    ${datadir}/dbus-1/services/org.bluez.obex.service \
                   "

FILES_${PN}-pand = "${libexecdir}/bluetooth/bt-pan ${sysconfdir}/default/bt-pan ${sysconfdir}/init.d/bt-pan"
FILES_${PN}-rfcomm = "${libexecdir}/bluetooth/bt-pan ${sysconfdir}/default/bt-pan ${sysconfdir}/init.d/bt-pan"
FILES_${PN}-rfcomm =  "${libexecdir}/bluetooth/rfcomm ${sysconfdir}/default/rfcomm ${sysconfdir}/init.d/rfcomm"
CONFFILES_${PN}-pand = "${sysconfdir}/default/bt-pan"
CONFFILES_${PN}-rfcomm = "${sysconfdir}/default/rfcomm"
SYSTEMD_SERVICE_${PN}-obex = "obex.service"

FILES_${PN}-testtools = "${libdir}/bluez/test/*"

def get_noinst_tools_paths (d, bb, tools):
    s = list()
    bindir = d.getVar("bindir", True)
    for bdp in tools.split():
        f = os.path.basename(bdp)
        s.append("%s/%s" % (bindir, f))
    return "\n".join(s)

FILES_${PN}-noinst-tools = "${@get_noinst_tools_paths(d, bb, d.getVar('NOINST_TOOLS', True))}"

RDEPENDS_${PN}-testtools += "python3 python3-dbus python3-pygobject"

SYSTEMD_SERVICE_${PN} = "bluetooth.service"
INITSCRIPT_PACKAGES = "${PN} ${PN}-pand ${PN}-rfcomm"
INITSCRIPT_NAME_${PN} = "bluetooth"
INITSCRIPT_NAME_${PN}-pand = "bt-pan"
INITSCRIPT_NAME_${PN}-rfcomm = "rfcomm"
INITSCRIPT_PARAMS_${PN} = "defaults 20 20"
INITSCRIPT_PARAMS_${PN}-pand = "defaults 22 22"
INITSCRIPT_PARAMS_${PN}-rfcomm = "defaults 22 22"

EXCLUDE_FROM_WORLD = "1"

do_compile_ptest() {
        oe_runmake buildtests
}

do_install_ptest() {
        cp -r ${B}/unit/ ${D}${PTEST_PATH}
        rm -f ${D}${PTEST_PATH}/unit/*.o
}
