require hostap-daemon.inc

HOMEPAGE = "http://hostap.epitest.fi"
SECTION = "kernel/userland"
LICENSE = "BSD-3-Clause"
LIC_FILES_CHKSUM = "file://README;md5=9f542dba9d227d1a51f4405a415cc2b2"
DEPENDS = "libnl openssl sqlite3"
SUMMARY = "User space daemon for extended IEEE 802.11 management"

PR = "r1"
inherit update-rc.d
INITSCRIPT_NAME = "hostapd"


DEFAULT_PREFERENCE = "-1"

SRC_URI += " \
    http://hostap.epitest.fi/releases/hostapd-${PV}.tar.gz \
    file://defconfig \
    file://init \
	file://default \
"

S = "${WORKDIR}/hostapd-${PV}/hostapd"


do_configure() {
    install -m 0644 ${WORKDIR}/defconfig ${S}/.config
}

do_compile() {
    export CFLAGS="-MMD -O2 -Wall -g -I${STAGING_INCDIR}/libnl3"
    make
}

CONFFILES_${PN} += "${sysconfdir}/hostapd.conf ${sysconfdir}/modprobe.d/cfg80211.conf"

SRC_URI[md5sum] = "8d3799f3a3c247cff47d41503698721b"
SRC_URI[sha256sum] = "21b0dda3cc3abe75849437f6b9746da461f88f0ea49dd621216936f87440a141"

do_install_append() {
    mkdir -p ${D}${sysconfdir}/default
	install -m 644 ${WORKDIR}/default ${D}${sysconfdir}/default/hostapd
}
