DESCRIPTION = "LoRa Gateway Geolocation library"
PRIORITY = "optional"
SECTION = "console/utils"
# Semtech license is a modified BSD-style license
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://mlinux4/LICENSE.TXT;md5=86776875df1423114abfcec938f3e565"
DEPENDS = ""
# Source revision
PSR = "r4"
# Recipe revision
PR = "r6"
SRCREV = "v${PV}"

SRC_URI = "http://multitech.net/downloads/lora-packet-forwarder-geolocation_arm926ejste_${PV}-${PSR}.tar.gz \
		   file://config.json \
		   file://config_64ch.json \
		  "

SRC_URI[md5sum] = "542f02198a3258ca2ad4e549524e3ddc"
SRC_URI[sha256sum] = "8176f5f55f96b7a72946cfb51743a8ea4f88a4033e54009e7bcf8f03077d248e"

S = "${WORKDIR}"

CFLAGS += "-Iinc -I."

do_compile() {
}

do_install() {
	install -d ${D}${includedir}/lora
	install -d ${D}${libdir}/lora
	install -m 0644 mlinux4/libsx1301ar/* ${D}${includedir}/lora 	

	install -d ${D}/sbin
        # Set UID to be able to read FPGA revision as non-root.
	install -m 04755 mlinux4/gateway-utils-geo/fpga_flash_loader ${D}/sbin/sem-fpga-loader

	install -d ${D}/opt/lora/
	install -d ${D}/opt/lora/gateway-utils-geo
	install -m 0755 mlinux4/gateway-utils-geo/* ${D}/opt/lora/gateway-utils-geo/
	install -m 0755 ${WORKDIR}/config.json ${D}/opt/lora/gateway-utils-geo/
	install -m 0755 ${WORKDIR}/config_64ch.json ${D}/opt/lora/gateway-utils-geo/
}

PACKAGES += "${PN}-utils ${PN}-utils-dbg"

FILES_${PN} = "${libdir}/lora/lora-gw-geolocation-readme.md ${includedir}/lora /usr/lib/"
FILES_${PN}-utils = "/opt/lora/gateway-utils-geo/* /sbin/sem-fpga-loader"
FILES_${PN}-utils-dbg = "/opt/lora/gateway-utils-geo/.debug "
FILES_${PN}-staticdev = "${libdir}/lora/libsx1301ar.a"

# disable this on purpose for dev purposes
do_rm_work() {
	echo "skipping"
}
