DESCRIPTION = "MultiTech LoRa Network Server"
PRIORITY = "optional"
SECTION = "console/utils"
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://LICENSE;md5=2b9a30a3082ddccd2c695a4dbeeab80d"
DEPENDS = "jsoncpp libmts mosquitto sqlite3 curl gnutls"
RDEPENDS_${PN} += "lora-packet-forwarder logrotate bash lora-logging"
PR = "r0"
CONFFILES_${PN} += "${sysconfdir}/default/lora-network-server ${sysconfdir}/init.d/lora-network-server"

SRC_URI = "http://multitech.net/downloads/lora-network-server_${PV}.tar.gz \
           file://lora-network-server.init \
           file://lora-network-server.default \
          "

SRC_URI[md5sum] = "c8b1589023b413e16fc3939d01a01e35"
SRC_URI[sha256sum] = "70bc0f6e703ec346efa195922ce2392a53f2069aa1a0fa63f2998af8e9a22922"

# binaries are already stripped, so suppress warning
INSANE_SKIP_${PN} = "already-stripped"

S = "${WORKDIR}"

LORA_DIR = "/opt/lora"

do_compile() {
}

inherit update-rc.d

INITSCRIPT_NAME = "lora-network-server"
INITSCRIPT_PARAMS = "defaults 80 30"

do_install() {
    install -d ${D}${LORA_DIR}
    install -m 0755 lora-network-server-mlinux-4 ${D}${LORA_DIR}/lora-network-server
    install -m 0755 lora-v21-keygen ${D}${LORA_DIR}/lora-v21-keygen
    install -m 0644 config/lora-network-server.conf.sample ${D}${LORA_DIR}/lora-network-server.conf.sample
    install -m 0644 config/lora-network-server.conf.full ${D}${LORA_DIR}/lora-network-server.conf.full

    install -d ${D}${sysconfdir}/default
    install -m 0644 ${WORKDIR}/lora-network-server.default ${D}${sysconfdir}/default/lora-network-server
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/lora-network-server.init ${D}${sysconfdir}/init.d/lora-network-server
}

FILES_${PN} += "${LORA_DIR}"
FILES_${PN}-dbg += "${LORA_DIR}/.debug"
