DESCRIPTION = "LoRa Packet Forwarder Geolocation"
PRIORITY = "optional"
SECTION = "console/utils"
# Semtech license is a modified BSD-style license
LICENSE = "Proprietary"
LIC_FILES_CHKSUM = "file://mlinux4/LICENSE.TXT;md5=86776875df1423114abfcec938f3e565"
DEPENDS ?= "lora-gateway-geolocation logrotate lora-logging"
RDEPENDS_${PN} += "bash"
# Source revision
PSR = "r4"
# Recipe revision
PR = "r6"

SRCREV = "v${PV}"

SRC_URI = "http://multitech.net/downloads/lora-packet-forwarder-geolocation_arm926ejste_${PV}-${PSR}.tar.gz \
           file://global_conf.json.MTAC_LORA_2_1_loc_dual_antenna_8ch_full_diversity_EU868 \            
           file://global_conf.json.MTAC_LORA_2_1_loc_dual_antenna_8ch_full_diversity_JP920 \
           file://global_conf.json.MTAC_LORA_2_1_loc_dual_antenna_8ch_partial_diversity_EU868 \
           file://global_conf.json.MTAC_LORA_2_1_loc_single_antenna_16ch_EU868 \
           file://global_conf.json.MTAC_LORA_2_1_loc_single_antenna_16ch_US915 \
           file://global_conf.json.MTAC_LORA_2_1_loc_single_antenna_64ch_US915 \
           file://global_conf.json.MTAC_LORA_2_1_loc_single_antenna_full_duplex_64ch_US915 \
           file://global_conf.json.MTAC_LORA_2_1_test_dual_antenna_56ch_partial_diversity_EU868 \
           file://global_conf.json.MTAC_LORA_2_1_test_single_antenna_16ch_16x1_EU868 \
           file://global_conf.json.MTAC_LORA_2_1_test_single_antenna_64ch_64x1_EU868 \
           file://global_conf.json.MTAC_LORA_2_1_test_single_antenna_64ch_8x8_EU868 \
"
SRC_URI[md5sum] = "542f02198a3258ca2ad4e549524e3ddc"
SRC_URI[sha256sum] = "8176f5f55f96b7a72946cfb51743a8ea4f88a4033e54009e7bcf8f03077d248e"

S = "${WORKDIR}"
B = "${S}"

LORA_DIR = "/opt/lora"

export LGW_PATH = "${STAGING_LIBDIR}/lora"
export LGW_INC = "${STAGING_INCDIR}/lora"

do_compile() {
}

do_install() {
  install -d ${D}${LORA_DIR}
  install -m 755 mlinux4/pkt_forwarder ${D}${LORA_DIR}/
  install -m 755 ${WORKDIR}/global_conf.json.MTAC_LORA_2_1* ${D}${LORA_DIR}/
  install -d ${D}${LORA_DIR}/forwarder-utils-geo
  install -m 755 mlinux4/forwarder-utils-geo/* ${D}${LORA_DIR}/forwarder-utils-geo/
}


FILES_${PN} += "${LORA_DIR}"
FILES_${PN}-dbg += "${LORA_DIR}/.debug ${LORA_DIR}/forwarder-utils-geo/.debug"

# disable this on purpose for dev purposes
do_rm_work() {
  echo "skipping"
}
