# This recipe was a merger of the Multitech Daisy 3.5 Recipe with the
# reciped found at:
# http://git.yoctoproject.org/cgit/cgit.cgi/meta-intel-iot-middleware/plain/recipes-connectivity/mosquitto/mosquitto_1.4.10.bb
inherit autotools-brokensep
SUMMARY = "Open source MQTT v3.5 implemention"
DESCRIPTION = "Mosquitto is an open source (BSD licensed) message broker that implements the MQ Telemetry Transport protocol version 3.5. MQTT provides a lightweight method of carrying out messaging using a publish/subscribe model. "
HOMEPAGE = "http://mosquitto.org/"
SECTION = "console/network"
LICENSE = "EPL-1.0 & EDL-1.0"
LIC_FILES_CHKSUM = "file://LICENSE.txt;md5=62ddc846179e908dc0c8efec4a42ef20"

# util-linux is needed to provide libuuid dependancy
DEPENDS = "c-ares openssl util-linux"

PR = "r3"

SRC_URI = "http://mosquitto.org/files/source/${PN}-${PV}.tar.gz \
           file://mosquitto.init \
           file://mosquitto.conf \
           file://mosquitto.default \
           file://mosquitto.logrotate.conf \
           file://nostrip.patch \
           file://config_mk.patch \
           "

SRC_URI[md5sum] = "67943e2c5afebf7329628616eb2c41c5"
SRC_URI[sha256sum] = "1df3ae07de40b80a74cd37a7b026895c544cdd3b42c9e0719ae91623aa98c58b"

export LIB_SUFFIX="${@d.getVar('baselib', True).replace('lib', '')}"
inherit autotools update-rc.d

INITSCRIPT_NAME = "mosquitto"
INITSCRIPT_PARAMS = "defaults 70 30"
do_compile() {
    oe_runmake PREFIX=/usr
}
do_install() {
    # oe_runmake DESTDIR=${D} prefix=/usr install
	oe_runmake install DESTDIR=${D}
	install -m 0755 -d ${D}/usr/lib
    install -m 0644 lib/libmosquitto.a ${D}${libdir}/

    install -d ${D}${sysconfdir}/init.d
    install -d ${D}${sysconfdir}/default
    install -m 0755 ${WORKDIR}/mosquitto.init ${D}${sysconfdir}/init.d/mosquitto
    install -m 0644 ${WORKDIR}/mosquitto.conf ${D}${sysconfdir}/mosquitto/
    install -m 0644 ${WORKDIR}/mosquitto.default ${D}${sysconfdir}/default/mosquitto

    install -d ${D}${sysconfdir}/logrotate.d
    install -m 0644 ${WORKDIR}/mosquitto.logrotate.conf ${D}${sysconfdir}/logrotate.d/mosquitto.conf
}

PACKAGES += "libmosquitto1 libmosquittopp1 ${PN}-clients ${PN}-python"

CONFFILES_${PN} = "${sysconfdir}/mosquitto.conf ${sysconfdir}/default/mosquitto"
FILES_${PN} = "${sbindir}/mosquitto \
               ${bindir}/mosquitto_passwd \
               ${sysconfdir}/mosquitto \
               ${systemd_unitdir}/system/mosquitto.service \
               ${sysconfdir}/ \
"

FILES_libmosquitto1 = "${libdir}/libmosquitto.so.1"

FILES_libmosquittopp1 = "${libdir}/libmosquittopp.so.1"

FILES_${PN}-clients = "${bindir}/mosquitto_pub \
                       ${bindir}/mosquitto_sub \
"

FILES_${PN}-staticdev += "${libdir}/libmosquitto.a"

FILES_${PN}-python = "/usr/lib/python2.7/site-packages"

inherit systemd

SYSTEMD_SERVICE_${PN} = "mosquitto.service"
