DESCRIPTION = "Provides the Multi-Tech MDM client"
SECTION = "remote-management"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"
PROVIDES = "annex-client-from-src"
DEPENDS = "jsoncpp curl protobuf cyrus-sasl protobuf-native annex-proto mts-io"

# IMPORTANT: if you change PR, you'll also want to change the url in annex-client.bb
PR = "r1"
SRCREV = "b954c83e155f95ecd68c14a890f9455331e19878"

SRC_URI = "git://git@${MTS_INTERNAL_GIT}/multitech/annex-client.git;protocol=ssh;branch=master"

S = "${WORKDIR}/git"

do_compile() {
    echo "directory: `pwd`"
    mkdir -p annex_pb
    cp ${STAGING_DIR_NATIVE}/annex.proto annex_pb/
    make all CFLAGS+="-DMLINUX_BUILD"
}

# IMPORTANT NOTE:
# this recipe is only used for the annex-client Jenkin's job to build IPK.
# annex-client.bb is used to install the binary in an image
do_install() {
    oe_runmake install DESTDIR=${D} SUBDIRS="src"
}
