DESCRIPTION = "Provides the Multi-Tech MDM client"
SECTION = "remote-management"
LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"
PROVIDES = "annex-client"

# NOTE: annex-client binary is built with Jenkin's job using annex-client-from-src.bb
# To update this, manually copy ipk from Jenkin's job to .net/downloads/
PR = "r3"
ANNEX_PR = "r1"
SRC_URI = "http://multitech.net/downloads/annex-client-from-src_1.0-${ANNEX_PR}.0_${TUNE_PKGARCH}.ipk \
          file://annex-client.init \
          file://monitor-annexcd \
          file://call_home \
          file://call_home.init \
          file://config.json.sample \
          file://push_api_mdm_connected \
          file://push_api_mdm_status \
"

SRC_URI[md5sum] = "e180f4e569fbba2f5b9d524b5a9e944e"
SRC_URI[sha256sum] = "1e93c65005c630cf211615dc143eb64f177591efcdbed6952142c7bac0e95988"

#inherit update-rc.d
#
#INITSCRIPT_NAME = "annex-client"
#INITSCRIPT_PARAMS = "defaults 95 1"
S = "${WORKDIR}"

DHQ_DIR="/opt/devicehq"

do_install() {
    install -d ${D}${sbindir}
    install -m 755 sbin/annexcd ${D}${sbindir}

    install -d ${D}/etc/ssl/certs
    install -m 644 etc/ssl/certs/rootCA.pem ${D}/etc/ssl/certs

    install -d ${D}${base_sbindir}
    install -m 755 ${WORKDIR}/monitor-annexcd ${D}${base_sbindir}
    install -m 755 ${WORKDIR}/call_home ${D}${base_sbindir}
    install -m 755 ${WORKDIR}/push_api_mdm_connected ${D}${base_sbindir}
    install -m 755 ${WORKDIR}/push_api_mdm_status ${D}${base_sbindir}

    install -d ${D}${sysconfdir}/init.d
    install -m 755 ${WORKDIR}/annex-client.init ${D}${sysconfdir}/init.d/annex-client
    install -m 755 ${WORKDIR}/call_home.init ${D}${sysconfdir}/init.d/call_home

    install -d ${D}${DHQ_DIR}
    install -m 644 ${WORKDIR}/config.json.sample ${D}${DHQ_DIR}
}

FILES_${PN} += "${DHQ_DIR}"
