DESCRIPTION = "Turn off ifplugd"
LICENSE = "GPLv2"
PACKAGE_ARCH = "all"

RDEPENDS_ifplugd-disable = "busybox-ifplugd"
ALLOW_EMPTY_ifplugd-disable = "1"

PR = "r2"


# Mount root rw  to disable/enable ifplugd.
# Mount root ro when we are done.
# This makes the Yocto Police happy.
pkg_prerm_${PN}() {
ro=0
if [ -z "$D" ] ; then
    if egrep -q '[[:space:]]/[[:space:]].*[[:space:]]ro,' /proc/mounts ; then
        ro=1
	mount -o remount,rw /
    fi
fi
sed -i 's/^ENABLED="no"/ENABLED="yes"/i' $D${sysconfdir}/default/ifplugd
if [ $ro -eq 1 ] ; then
    mount -o remount,ro /
fi
}

pkg_postinst_${PN}() {
ro=0
if [ -z "$D" ] ; then
    if egrep -q '[[:space:]]/[[:space:]].*[[:space:]]ro,' /proc/mounts ; then
        ro=1
	mount -o remount,rw /
    fi
fi
sed -i 's/^ENABLED="yes"/ENABLED="no"/i' $D${sysconfdir}/default/ifplugd
if [ -f $D/var/config/default/ifplugd ]; then
    sed -i 's/^ENABLED="yes"/ENABLED="no"/i' $D/var/config/default/ifplugd
else
    cp $D${sysconfdir}/default/ifplugd $D/var/config/default/ifplugd
fi
if [ $ro -eq 1 ] ; then
    mount -o remount,ro /
fi
}
