DESCRIPTION = "Provides MultiTech DHQ Client"

LICENSE = "MIT"
LIC_FILES_CHKSUM = "file://${COMMON_LICENSE_DIR}/MIT;md5=0835ade698e0bcf8506ecda2f7b4f302"

PR = "r2"
PROVIDES = "dhq-client"

DEPENDS = "python-setuptools-native"
RDEPENDS_${PN} += "bash python python-misc python-netclient python-subprocess python-shell python-argparse python-pkgutil python-json"

SRCREV = "a24be6c65a751598a6b1b4d4ffd506ec726d8213"

SRC_URI = "git://git@gitlab.multitech.net/devicehq/mAPI-dhq-client.git;protocol=ssh;nobranch=1 \
           file://config.json.sample \
           file://dhqclient.init \
           file://dhqclient \
"

S = "${WORKDIR}/git"

inherit setuptools

#inherit update-rc.d

#INITSCRIPT_NAME = "dhqclient"
#INITSCRIPT_PARAMS = "defaults 95 1"

DHQ_CLIENT_DIR="/opt/dhq_client"

do_install_append() {
    install -d ${D}${DHQ_CLIENT_DIR}
    install -m 0644 ${WORKDIR}/config.json.sample        ${D}${DHQ_CLIENT_DIR}
    install -d ${D}${bindir}
    install -m 0755 ${WORKDIR}/dhqclient                 ${D}${bindir}
    install -d ${D}${sysconfdir}/init.d
    install -m 0755 ${WORKDIR}/dhqclient.init            ${D}${sysconfdir}/init.d/dhqclient
}

FILES_${PN} += "${DHQ_CLIENT_DIR}"
FILES_${PN} += "${bindir}/*"
FILES_${PN} += "${sysconfdir}/init.d/*"
