# Conduit 0.0 or 0.1 without RS9113
DESCRIPTION = "mLinux base image"
LICENSE = "MIT"

require mlinux-minimal-image.bb

FILESYSTEM_FEATURES = "dosfstools \
                 cifs-utils \
				 lsof \
                 "

NETWORKING_FEATURES += "bridge-utils \
                       inetutils-ftp \
                       openssl \
                       rsync \
                       iperf \
                       lldpd \
					   mii-diag \
					   tcpdump \
					   netcat \
					   wget \
					   strongswan \
					   busybox-ifplugd \
                       "

WIFI_FEATURES = " \
                libnl \
                wpa-supplicant \
                wireless-tools \
                iw \
                hostap-daemon hostap-utils \
                "

BLUETOOTH_FEATURES = "bluez5"

# Add all timezones available
# ntpdate will sync time every 30 min by default via cron
TIME_FEATURES = "tzdata tzdata-africa tzdata-americas tzdata-antarctica tzdata-arctic \
				 tzdata-asia tzdata-atlantic tzdata-australia tzdata-europe tzdata-pacific \
				 tzdata-misc \
				 cronie \
                 ntpdate \
                 "

# u-boot-linux-utils: U-Boot environment access from Linux
# mlinux-scripts: sample scripts for setting up Conduit for various tasks
# reset-handler: default reset button handler
# radio-cmd: supports cellular radio activation and other configuration commands
# radio-query: queries cellular radio for common info (IMEI, RSSI, etc)
# jsparser: command line tool to parse JSON files
MULTITECH_FEATURES += " \
                     u-boot-linux-utils \
                     mlinux-scripts \
					 reset-handler \
					 radio-cmd radio-query \
					 jsparser \
                     "

MULTITECH_FEATURES_append_mt100eocg = "  \
dhq-client \
mlinux-scripts-eocg \
"

MISC_FEATURES = "minicom lrzsz nano"

# Extra stuff to install
IMAGE_INSTALL += " \
                kernel-modules \
		${WIFI_FEATURES} \
		${BLUETOOTH_FEATURES} \
		${FILESYSTEM_FEATURES} \
                ${TIME_FEATURES} \
                ${MISC_FEATURES} \
                "
