DESCRIPTION = "mLinux Conduit Access Point image"

require mlinux-minimal-image.bb
require mtcap-modules.inc

# For now we don't put this in MTR or AEP
# Password restrictions library from Redhat
IMAGE_INSTALL += "libpwquality"

FILESYSTEM_FEATURES = "dosfstools \
                       cifs-utils \
                       lsof \
                       "

NETWORKING_FEATURES += "bridge-utils \
                       inetutils-ftp \
                       openssl \
                       rsync \
                       iperf \
                       mii-diag \
                       tcpdump \
                       netcat \
                       wget \
                       strongswan \
                       busybox-ifplugd \
                       "

# No accessory cards for MTAC
MULTITECH_MTAC = ""

TIME_FEATURES = "tzdata tzdata-africa tzdata-americas tzdata-antarctica tzdata-arctic \
                 tzdata-asia tzdata-atlantic tzdata-australia tzdata-europe tzdata-pacific \
                 tzdata-misc \
                 cronie \
                 ntpdate \
                 "

WIFI_FEATURES = "libnl \
                wpa-supplicant \
                wireless-tools \
                iw \
                hostap-daemon hostap-utils \
                wilc1000 \
                "

MULTITECH_FEATURES += " \
                 u-boot-linux-utils \
                 mlinux-scripts \
                 reset-handler \
                 radio-cmd radio-query \
                 cell-radio-carrierswitch \
                 jsparser \
                 protobuf \
                 annex-client \
                 "

IMAGE_INSTALL += "lora-gateway-utils \
                  lora-query \
                  lora-packet-forwarder \
                  lora-network-server \
                  logrotate \
                  mosquitto mosquitto-clients \
                 "

MISC_FEATURES = "minicom lrzsz nano lxfp"

# Extra stuff to install
#   Someday add wifi features
#               ${WIFI_FEATURES}
#
IMAGE_INSTALL += " \
                ${FILESYSTEM_FEATURES} \
                ${TIME_FEATURES} \
                ${MISC_FEATURES} \
                "

# Multi-Tech SMS Utility (see http://git.multitech.net)
IMAGE_INSTALL += "sms-utils"
